/*
	tss_publ.h

	This file contains the part of the TSS library that is exported in the BDB-API
	All other stuff should be in tssproto.h or tss.h
*/


#ifndef _TSS_PUBL_H
#define _TSS_PUBL_H

typedef enum {
	DEFAULT_ORDER=0,	/*  0: Default Order			*/
	MSB_ORDER=1,		/*  1: Most Significant Byte Order	*/
	LSB_ORDER=2		/*  2: Least Significant Byte Order	*/
} byte_order;

#define TSS_FATAL	1
#define TSS_WARNING	2
#define TSS_PARSE	4

typedef	void	(*TssErrorHandler)	( int type, char *buf );

#ifdef __cplusplus
extern "C" {
#endif

void    TSSdontreadunicode      ( void);

int	TSSinitialize		( TssErrorHandler	error_handler );

int	TSSsetlocale		( char		*name,
				  TssErrorHandler	error_handler );

int	TSSextmbs_n2tssmbs_n	( UCHAR	*tgt,
				  UCHAR	*src,
				  int	srcsize,
				  int	tgtsize,
				  int	ignore_errors );

int	TSStssmbs_n2extmbs_n	( UCHAR	*extmbs,
				  UCHAR	*tssmbs,
				  int	srcsize, 
				  int	tgtsize );

int	TSSunicode_n2tssmbs_n	( UCHAR		*tssmbs,
				  USHORT	*unicode,
				  int     	tgtsize,
				  int		srcsize,
				  byte_order	sb_flag  );

int	TSStssmbs_n2unicode_n  	( USHORT	*unicode,
				  UCHAR		*tssmbs,
				  int		tgtsize,
				  int     	srcsize,
				  byte_order	sb_flag  );

#ifdef __cplusplus
}
#endif

#endif /* _TSS_PUBL_H */

