/* Datadescription related to database table ttexa100
   It contains:
   - ttexa100 recordtype in application
   - one instance of that recordtype
   - one datadictionary binding to that instance
   - a reference to be directed to a BDB workarea containing
     extended DD-information and the former relation.
*/
#define NrChar2 32

typedef struct	{
	long	Code;                /* Product code */
	char	Descr[NrChar2 + 1];  /* Product description */
	double	Price;               /* Product price */

	/* Implementation attributes: */
        int     Refcntd;
        int     Refcntu;
        int     _dlock;
        int     _compnr;
} ProductType;

ProductType Product;
extern  BDB_ADR_LINK    Product_Link[];

BDB_U_ABIND *Product_Bind;

int	bind_idx(char *column_name);
