char *Version = "@(#)(B2 ) Version     : cameo3 version 10-1994/R1";
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "bdb_api.h"

#include "products.h"

/* Definitions within custom.c */
extern BDB_MAIN_CURSOR *cursor;           /* main cursor */
extern DD_TABLE *dd_table;     /* data dictionary table */

BDB_U_ABIND *dd2bind(char *tname, BDB_ADR_LINK *user_link,int *nr_attr);

void	init_dbc(char *progname, int progmode, char *userid);
void	customize_sql();

/* The purpose of this program is to show the retry point related functions.
   The number of fetches are incremented independently from retry point
   effects, so that the latter effects can be revealed.
*/

main (int argc, char **argv)
{
   int ret = 0;                /* return value */
   bu4 trxn;                   /* transaction ID */
   init_dbc (argv[0],01|02,"AnyUserID");
   trxn = bdb_start_session ("AnySessionID");
   {
      int idx;                 /* indexes */
      int company = 0;         /* company number */
      char query[150];         /* query with Dynamic SQL */
      SqlId handle;            /* queryhandle */
      char ex_tname[15];       /* external tablename */
      long command;            /* command code */
      int arg;                 /* command argument */
      int nr_attr;             /* number of attibutes */
      int nr_fetch;            /* number of table fetches */

      customize_sql();
      strcpy (ex_tname,"ttexa100");
      dd_table = ddtable (ex_tname);
      Product_Bind = dd2bind (ex_tname,Product_Link,&nr_attr);
      ret = bdb_open (&cursor, ex_tname,company,Product_Bind,
                      nr_attr,trxn);
      if ( ret == -1 )  {
           fprintf(stderr, "Error %d: Can't open table %s in company %d\n",
               bdb_errno, ex_tname, company);
           bdb_stop_session (trxn);
           bdb_logoff();
           exit(1);
      }

      /* Construct query */
      query[0] = (char )0;
      strcat (query,"select for update ");
      strcat (query,"       code:code1, descr:dscr, price:prc ");
      strcat (query,"from ttexa100 ");
      strcat (query,"where price < 100.0 ");
      handle = sql_parse (query,trxn,0);

      /* Show effect of extending query with retry point */
      printf ("Query with retry ? %d\n", 
               sql_query_with_rpoint(handle));
      ret = sql_close (handle);

      /* Extend query with retry point definition */
      strcat (query," order by code with retry");
      handle = sql_parse (query,trxn,0);
      printf ("Query with retry ? %d\n", 
               sql_query_with_rpoint(handle));
   

      /* Bind all variables */
      idx = bind_idx ("ttexa100.code");
      ret = sql_sel_bind (handle,"code1",(char *)&Product_Bind[idx]);
      idx = bind_idx ("ttexa100.descr");
      ret = sql_sel_bind (handle,"dscr",(char *)&Product_Bind[idx]);
      idx = bind_idx ("ttexa100.price");
      ret = sql_sel_bind (handle,"prc",(char *)&Product_Bind[idx]);
      if ((ret = sql_exec (handle,company)) == -1) {
        printf("Error %d\n", bdb_errno);
        bdb_stop_session (trxn);
        bdb_logoff ();
        exit(3);
      }


      nr_fetch = 0;
      while (!(ret = sql_fetch (handle))) {
         nr_fetch++;
         /* Show row return mechanism by binding */
         printf ("Code : %d, Description : %s, Price : %f\n",
                  Product.Code,Product.Descr,Product.Price);

         Product.Price += .01*Product.Price; /*raise lowers*/
         command = DB_UPDATE_51; arg = DB_RETURN_DUPL;
         ret = bdb_exec_row (cursor,command,arg,company);
         switch (nr_fetch) {
         case  3 :
                 printf ("Retry query:\n");
                 ret = sql_retry (handle);
                 /* Fetches start from first row on now */
                 break;
         case  6 :
                 printf ("Retry before saved retrypoints:\n");
                 ret = sql_retry (handle);
                 ret = sql_save_rpoint (handle);
                 /* Fetches start from first row on now */
                 break;
         case 11 :
                 printf ("Retry after saved retrypoints:\n");
                 ret = sql_save_rpoint (handle);
                 ret = sql_retry (handle);
                 /* Fetches start from row with saved retrypoint on now */
                 break;
         }
      }
      ret = sql_break (handle);
      bdb_exec_db (COMMIT_TRANSACTION,trxn);
      ret = sql_close (handle);
   }
   bdb_stop_session (trxn);
   bdb_logoff ();
   return 0;
}
