char *Version = "@(#)(B2 ) Version     : cameo1 version 10-1998/R2";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "bdb_api.h"

#include "products.h"

#define MAXLINE 80

BDB_U_ABIND *dd2bind(char *tname, BDB_ADR_LINK *user_link,int *nr_attr);

void	init_dbc(char *progname, int progmode, char *userid);
void	customize_sql();

int file2table(BDB_MAIN_CURSOR *cursor, char *ex_tname, int company,
		char *file);

/* 
    The purpose of this program is to elucidate the major part of
    functions from the library libdbc.a. The vehicle that is used
    for this is a program that clears a table, imports an ASCII-
    file into it, and finally removes this table again. Returnvalues
    are displayed extensively. You should particularly pay attention to:
    - The use of the function arguments in the INSERT command.
      You should activate either one of these arguments to show
      their effect on the returnvalue.
    - The interpretation of error codes is only revealed in conjugation
      with the use of the DROP_TABLE command in a timely context.
      You can remove this DROP_TABLE fragment at will, to reveal the real
      content of the recent imported ASCII-file by a TRITON Tools
      application.
    - You might change the content of the ASCII-file, especially
      to inflict a reaction on duplicates or outer-domain values.
*/
int main (int argc, char **argv)
{
bu4 trxn;              /* transaction ID */
init_dbc (argv[0],01|02,"AnyUserID"); /* Refer to custom.c */
trxn = bdb_start_session ("AnySessionID");
  {
  int ret = 0;         /* return value of functions */
  BDB_MAIN_CURSOR *cursor;  /* main cursor */
  char ex_tname[15];   /* external tablename */
  int company = 0;     /* company number */
  int nr_attr;         /* number of row attributes */

  strcpy (ex_tname,"ttexa100");

  /* Fetch external data dictionary description into bind structure */
  Product_Bind = dd2bind(ex_tname,Product_Link,&nr_attr);

  /* Open a main cursor */
  ret = bdb_open (&cursor,ex_tname,company,Product_Bind,
                  nr_attr,trxn);
  if ( ret == -1 )  {
     fprintf(stderr, "Error %d: Can't open table %s in company %d\n",
        bdb_errno, ex_tname, company);
     bdb_stop_session (trxn);
     bdb_logoff ();
     exit (1);
  }

  printf ("company# from cursor : %d\n",
	   bdb_compnr_from_cursor (cursor));

     {
     long command;            /* command code */
     ULONG arg;               /* command argument */
     char *file = "products"; /* input filename */

     /* Perform a table command */
     command = DB_CLEAR_TABLE; arg = CLEAR_NO_ROLLBACK;
     if ((ret = bdb_exec_table (cursor,command,&arg,company)) == -1) {
       if (bdb_errno != E_BDB_NO_TABLE) {
         printf("Error %d\n", bdb_errno);
         bdb_stop_session (trxn);
         bdb_logoff ();
         exit(3);
       }
     }
     printf ("Command : %s (rc = %d)\n",
	      bdb_table_action (command),ret);

     /* Interpret error codes */
     if (bdb_errno == E_BDB_NO_TABLE) {
        command = DB_CREATE_TABLE; arg = CRT_NORMAL;
        ret = bdb_exec_table (cursor,command,&arg,company);
        printf ("Command : %s (rc = %d)\n",
                 bdb_table_action (command),ret);
     }

     /* Number of rows before insert */
     ret = bdb_exec_table (cursor,DB_NR_ROWS,&arg,company);
     printf ("Number of rows : %d\n",arg);

     /* Import ASCII file into ttexa100 table */
     if (file2table (cursor,ex_tname,company,file) != 0) {
	fprintf(stderr, "Open failed for file \'%s\'. errno = %d\n",
                         file, errno);
        bdb_stop_session (trxn);
        bdb_logoff ();
 	exit(1);
     }


     /* Perform a database command */
     command = COMMIT_TRANSACTION;
     ret = bdb_exec_db (command,trxn);
     printf ("Command : %s (rc = %d)\n",
	      bdb_db_action (command),ret);

     /* Number of rows after insert */
     ret = bdb_exec_table (cursor,DB_NR_ROWS,&arg,company);
     printf ("Number of rows : %d\n",arg);

     /* Table action after a commit
     command = DB_DROP_TABLE; arg = DROP_WITH_BACKUP;
     ret = bdb_exec_table (cursor,command,&arg,company);
     printf ("Command : %s (rc = %d)\n",
	      bdb_table_action (command),ret);
     FORMER UNTIL START COMMENT IS NOT ACTIVE NOW
     */
     }

   bdb_close (cursor);
   }

   bdb_stop_session (trxn);
   bdb_logoff ();
   
   return 0;
}

/***********************************************************/
int file2table (BDB_MAIN_CURSOR *cursor, char *ex_tname, int company,
		char *file )
{
   int ret = 0;             /* return value of functions */
   long command;            /* command code */
   int arg;                 /* command argument */
   int cond1, cond2;        /* condition folders */
   int field;               /* field number */
   FILE *fp;                /* I/O types */
   UCHAR *row, buffer[100]; /* converted row */
   char inputline[MAXLINE]; /* input line */
   char *line, *match;      /* input line pointers */

   DD_TABLE *dd_table = ddtable (ex_tname); 
   DD_COLUMN *column = (DD_COLUMN *)0; 

   if ((fp = fopen(file,"r")) == NULL) {             /* open for input */
	return(-1);
   }
   while (fgets(inputline,MAXLINE,fp)) {
       line = &inputline[0];

       /* Fill the row with data */
       for (field=0;field<3;field++) {
          match = strchr (line,'|'); /* locate separator */
          if (match) *match = '\0';  /* replace with terminator */
          switch (field) {

             /* Transfer inputfields to table record */
             case 0: Product.Code = atoi(line) ;break;
             case 1: strcpy(Product.Descr,line);break;
             case 2: Product.Price = atof(line);break;

          }
          line = match;     /* shift within line to terminator */
          line++;           /* shift within line to next field */
       }

       reset_bdb_msg ();

       /* Conversion of row needed for testfunctions */
       row = bdb_bind_to_buf (cursor,buffer);

       /* Validate row contents and permission before insertion */
       cond1 = (bdb_domain_check (dd_table,row) == (char *)0);
       cond2 = (bdb_permission (cursor,company,column,row) >=
                PERM_WRITE);
       if (cond1 && cond2) {

           /* Perform a row command */
           command = DB_INSERT_51; 

           /* Activate either one of these argument values */
           arg = DB_RETURN_DUPL;
           arg = DB_SKIP_DUPL;

           ret = bdb_exec_row (cursor,command,arg,company);
           printf ("Command : %s (rc = %d)\n",
                    bdb_row_action (command),ret);

       } else {
           printf ("Wrong row to insert (%s)\n", get_bdb_msg ());
       }
   }
   return(0);
}
