/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbDatabase;
import com.baan.jbdb.JbdbRow;
import com.baan.jbdb.JbdbSession;
import com.baan.jbdb.SQLCommand;
import com.baan.jbdb.datatypes.JbdbType;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class JbdbStatement
implements SQLCommand.EntryPoint {
    private JbdbSession _session = null;
    private JbdbConnection _connection = null;
    private final int _id;
    private boolean _isPrepared = false;
    private int _nr;
    private int _timeOut = -1;
    private final List _fetchedRows = new LinkedList();
    private boolean _allRowsFetched = false;
    private final Map _parameterValues = new HashMap();
    private SQLException _error = null;
    private Metadata _metadata = null;

    public JbdbStatement(JbdbConnection jbdbConnection, int n) {
        this._connection = jbdbConnection;
        this._id = n;
    }

    public void jbdb1SetSession(JbdbSession jbdbSession) {
        this._session = jbdbSession;
    }

    public JbdbStatement(JbdbSession jbdbSession, int n) {
        this._session = jbdbSession;
        this._connection = jbdbSession.getConnection();
        this._id = n;
    }

    public void prepare(String string) throws SQLException, IOException {
        this.close();
        this._connection.sendRequestName('P');
        this._connection.sendInt(this._session.getNr());
        this._connection.sendComma();
        this._connection.sendString(string);
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('P');
        if (this._connection.receiveSQLException() == null) {
            this.markPrepared(this._connection.receiveTypedInt());
        }
        this._connection.receiveEndOfResponse();
    }

    public void markPrepared(int n) {
        this._isPrepared = true;
        this._nr = n;
    }

    public int getId() {
        return this._id;
    }

    public JbdbSession getSession() {
        return this._session;
    }

    public void execute(int n) throws SQLException, IOException {
        this.checkPrepared();
        this._connection.sendRequestName('E');
        this._connection.sendInt(this._nr);
        this._connection.sendComma();
        Iterator iterator = this._parameterValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n2 = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            this._connection.sendListItem();
            this._connection.sendInt(n2);
            this._connection.sendComma();
            if (string != null) {
                this._connection.sendByte('+');
                this._connection.sendString(string);
                continue;
            }
            this._connection.sendByte('-');
        }
        this._connection.sendEmptyList();
        this._connection.sendComma();
        if (n >= 0) {
            this._connection.sendByte('+');
            this._connection.sendInt(n);
        } else {
            this._connection.sendByte('-');
        }
        this._connection.sendComma();
        if (this._timeOut >= 0) {
            this._connection.sendByte('+');
            this._connection.sendInt(this._timeOut);
        } else {
            this._connection.sendByte('-');
        }
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('E');
        if (this._connection.receiveSQLException() == null) {
            // empty if block
        }
        this._connection.receiveEndOfResponse();
    }

    public Object getSynchronizationObject() {
        return this._connection;
    }

    public void close() throws SQLException, IOException {
        if (this._connection != null && this._isPrepared) {
            this._connection.sendRequestName('C');
            this._connection.sendInt(this._nr);
            this._connection.sendEndOfRequest();
            this._connection.flush();
            this._connection.receiveCheckByte('C');
            if (this._connection.receiveSQLException() == null) {
                // empty if block
            }
            this._connection.receiveEndOfResponse();
            this._isPrepared = false;
        }
    }

    public void destroy() throws SQLException, IOException {
        JbdbDatabase.getSingleton().unlinkJbdbObject(this._id);
        if (this._session != null) {
            this._session.unlinkStatement(this._id);
        }
        this.close();
    }

    public void setTimeOut(int n) {
        this._timeOut = n;
    }

    public boolean fetch() throws SQLException, IOException {
        if (!this._fetchedRows.isEmpty()) {
            this._fetchedRows.remove(0);
        }
        if (this._fetchedRows.isEmpty() && !this._allRowsFetched) {
            this.fetchToBuffer();
        }
        if (this._fetchedRows.isEmpty()) {
            if (this._error != null) {
                SQLException sQLException = this._error;
                this._error = null;
                throw sQLException;
            }
            return false;
        }
        return true;
    }

    private void fetchToBuffer() throws SQLException, IOException {
        this.checkPrepared();
        this._connection.sendRequestName('F');
        this._connection.sendInt(this._nr);
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('F');
        while (this._connection.receiveListPart()) {
            JbdbRow jbdbRow = new JbdbRow();
            while (this._connection.receiveListPart()) {
                jbdbRow.add(this._connection.receiveAny());
            }
            this._fetchedRows.add(jbdbRow);
        }
        this._connection.receiveCheckComma();
        this._allRowsFetched = this._connection.receiveSQLException() == null ? this._connection.receiveTypedBoolean() : false;
        try {
            this._connection.receiveEndOfResponse();
        }
        catch (SQLException sQLException) {
            this._error = sQLException;
        }
    }

    private void checkPrepared() throws SQLException {
        if (!this._isPrepared) {
            throw new SQLException("function sequence error, statement not prepared", "HY010", 0);
        }
    }

    public JbdbRow getCurrentRow() throws SQLException {
        if (this._fetchedRows.isEmpty()) {
            throw new SQLException("no current row");
        }
        return (JbdbRow)this._fetchedRows.get(0);
    }

    public String getEntryPointDescription() {
        return "statement id " + this._id;
    }

    public void breek() throws IOException, SQLException {
        this.checkPrepared();
        this._allRowsFetched = false;
        this._fetchedRows.clear();
        this._metadata = null;
        this._connection.sendRequestName('B');
        this._connection.sendInt(this._nr);
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('B');
        if (this._connection.receiveSQLException() == null) {
            // empty if block
        }
        this._connection.receiveEndOfResponse();
    }

    public int getNumParameters() throws IOException, SQLException {
        return this.getMetadata().getNumParameters();
    }

    public Metadata getMetadata() throws IOException, SQLException {
        if (this._metadata == null) {
            this._metadata = new Metadata();
            this._metadata.fill();
        }
        return this._metadata;
    }

    public void bindParameter(int n, String string) {
        this._parameterValues.put(new Integer(n), string);
    }

    class Metadata {
        private List _columns = new ArrayList();
        private List _parameters = new ArrayList();

        private void fill() throws SQLException, IOException {
            JbdbStatement.this.checkPrepared();
            JbdbStatement.this._connection.sendRequestName('D');
            JbdbStatement.this._connection.sendInt(JbdbStatement.this._nr);
            JbdbStatement.this._connection.sendEndOfRequest();
            JbdbStatement.this._connection.flush();
            JbdbStatement.this._connection.receiveCheckByte('D');
            if (JbdbStatement.this._connection.receiveSQLException() == null) {
                while (JbdbStatement.this._connection.receiveListPart()) {
                    String string = JbdbStatement.this._connection.receiveTypedString();
                    JbdbStatement.this._connection.receiveCheckComma();
                    JbdbType jbdbType = JbdbStatement.this._connection.receiveTypeName();
                    JbdbStatement.this._connection.receiveCheckComma();
                    int n = 2;
                    if (JbdbStatement.this._connection.receiveOptional()) {
                        n = JbdbStatement.this._connection.receiveTypedBoolean() ? 1 : 0;
                    }
                    this._columns.add(new Column(string, jbdbType, n));
                }
                JbdbStatement.this._connection.receiveCheckComma();
                while (JbdbStatement.this._connection.receiveListPart()) {
                    this._parameters.add(new Parameter(JbdbStatement.this._connection.receiveTypeName()));
                }
            }
            JbdbStatement.this._connection.receiveEndOfResponse();
        }

        public int getNumParameters() {
            return this._parameters.size();
        }

        public Parameter getParameter(int n) {
            return (Parameter)this._parameters.get(n);
        }

        public int getNumResultColumns() {
            return this._columns.size();
        }

        public Column getColumn(int n) {
            return (Column)this._columns.get(n);
        }
    }

    static class Parameter {
        private final JbdbType _type;

        public Parameter(JbdbType jbdbType) {
            this._type = jbdbType;
        }

        public JbdbType getType() {
            return this._type;
        }
    }

    public class Column {
        public static final int NULLABLE_FALSE = 0;
        public static final int NULLABLE_TRUE = 1;
        public static final int NULLABLE_UNKNOWN = 2;
        private final String _name;
        private final JbdbType _type;
        private final int _nullable;

        public Column(String string, JbdbType jbdbType, int n) {
            this._name = string;
            this._type = jbdbType;
            this._nullable = n;
        }

        public int getDepth() {
            return this._type.getDepth();
        }

        public String getName() {
            return this._name;
        }

        public JbdbType getType() {
            return this._type;
        }

        public int isNullable() {
            return this._nullable;
        }
    }
}

