/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbDatabase;
import com.baan.jbdb.JbdbSession;
import com.baan.jbdb.JbdbTable;
import com.baan.jbdb.SQLCommand;
import com.baan.jbdb.Util;
import com.baan.jbdb.datatypes.JbdbArray;
import com.baan.jbdb.datatypes.JbdbBoolean;
import com.baan.jbdb.datatypes.JbdbDate;
import com.baan.jbdb.datatypes.JbdbInteger;
import com.baan.jbdb.datatypes.JbdbInterval;
import com.baan.jbdb.datatypes.JbdbLong;
import com.baan.jbdb.datatypes.JbdbNull;
import com.baan.jbdb.datatypes.JbdbRaw;
import com.baan.jbdb.datatypes.JbdbReal;
import com.baan.jbdb.datatypes.JbdbString;
import com.baan.jbdb.datatypes.JbdbTimestamp;
import com.baan.jbdb.datatypes.JbdbType;
import com.baan.jbdb.datatypes.JbdbValue;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public abstract class JbdbConnection
implements SQLCommand.EntryPoint {
    static int _NrGobblers;
    private final int _protocolVersion = 2;
    private final Map _sessions = new HashMap();
    private DataOutputStream _stdin = null;
    private DataInputStream _stdout = null;
    private DataInputStream _stderr = null;
    private char _language;
    private String _portingSetVersion = null;
    private String _packageCombination = null;
    private boolean _hasExited = false;
    private SQLException _exception = null;
    private final int _id;
    private SQLException _sqlException = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForGobblersForTest() {
        while (true) {
            Class clazz = class$com$baan$jbdb$JbdbConnection == null ? JbdbConnection.class$("com.baan.jbdb.JbdbConnection") : class$com$baan$jbdb$JbdbConnection;
            synchronized (clazz) {
                if (_NrGobblers == 0) {
                    break;
                }
            }
        }
    }

    public JbdbConnection(int n) {
        this._id = n;
    }

    public int getId() {
        return this._id;
    }

    public final void printObjectTree() {
        Iterator<Object> iterator = this._sessions.keySet().iterator();
        TreeSet treeSet = new TreeSet();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            JbdbSession jbdbSession = (JbdbSession)this._sessions.get((Integer)iterator.next());
            System.out.println("    session id: " + jbdbSession.getId());
            jbdbSession.printObjectTree();
        }
    }

    public Object getSynchronizationObject() {
        return this;
    }

    public String getEntryPointDescription() {
        return "connection id " + this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException, IOException {
        this._stdin = new DataOutputStream(this.getOutputStream());
        this._stdout = new DataInputStream(this.getInputStream());
        this._stderr = new DataInputStream(this.getErrorStream());
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Class clazz;
                block16: {
                    block14: {
                        try {
                            try {
                                try {
                                    String string;
                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(JbdbConnection.this._stderr));
                                    while ((string = bufferedReader.readLine()) != null) {
                                        JbdbDatabase.getSingleton().getLogger().logError("CONN_ID '" + JbdbConnection.this._id + "', " + string);
                                    }
                                }
                                finally {
                                    JbdbConnection.this._stderr.close();
                                }
                                Object var5_5 = null;
                                if (class$com$baan$jbdb$JbdbConnection != null) break block14;
                            }
                            catch (IOException iOException) {
                                JbdbDatabase.getSingleton().getLogger().logError("I/O problem while communicating with subprocess, " + iOException.getMessage());
                                Object var5_6 = null;
                                Class clazz3 = class$com$baan$jbdb$JbdbConnection == null ? (class$com$baan$jbdb$JbdbConnection = JbdbConnection.class$("com.baan.jbdb.JbdbConnection")) : class$com$baan$jbdb$JbdbConnection;
                                synchronized (clazz3) {
                                    --_NrGobblers;
                                    return;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            Class clazz2 = class$com$baan$jbdb$JbdbConnection == null ? (class$com$baan$jbdb$JbdbConnection = JbdbConnection.class$("com.baan.jbdb.JbdbConnection")) : class$com$baan$jbdb$JbdbConnection;
                            synchronized (clazz2) {
                                --_NrGobblers;
                                throw throwable;
                            }
                        }
                        clazz = class$com$baan$jbdb$JbdbConnection = JbdbConnection.class$("com.baan.jbdb.JbdbConnection");
                        break block16;
                    }
                    clazz = class$com$baan$jbdb$JbdbConnection;
                }
                Class clazz2 = clazz;
                synchronized (clazz) {
                    --_NrGobblers;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return;
                }
            }
        };
        thread.setDaemon(true);
        Class clazz = JbdbConnection.class;
        synchronized (clazz) {
            ++_NrGobblers;
        }
        thread.start();
    }

    public void init(String string) throws SQLException {
        try {
            this.sendRequestName('I');
            this.sendInt(2);
            this.sendComma();
            this.sendString(string);
            this.sendEndOfRequest();
            this.flush();
            this.receiveCheckByte('I');
            if (this.receiveSQLException() == null) {
                this._portingSetVersion = this.receiveTypedString();
                this.receiveCheckComma();
                this._language = this.receiveTypedString().charAt(0);
                this.receiveCheckComma();
                this._packageCombination = this.receiveTypedString();
            }
            this.receiveEndOfResponse();
        }
        catch (IOException iOException) {
            throw Util.ToSQLException("could not initialize connection", iOException);
        }
    }

    public int createSession(String string, String string2) throws SQLException, IOException {
        int n = JbdbDatabase.getSingleton().getNextId();
        JbdbSession jbdbSession = new JbdbSession(n, this, string, string2);
        this._sessions.put(new Integer(n), jbdbSession);
        JbdbDatabase.getSingleton().addJbdbObject(n, jbdbSession);
        return n;
    }

    public void unlinkSession(int n) {
        this._sessions.remove(new Integer(n));
    }

    public void receiveCheckByte(char c) throws IOException {
        byte by = this.stdoutReadByte();
        if (by != c) {
            throw new JbdbProtocolException("check character '" + c + "'", by);
        }
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract InputStream getErrorStream() throws IOException;

    public abstract int waitFor() throws IOException, InterruptedException;

    private void sendCharacters(String string) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this._stdin.writeChars(string);
    }

    public void sendRequestName(char c) throws IOException {
        this.sendByte(c);
    }

    public void sendByte(char c) throws IOException {
        this._stdin.writeByte((byte)c);
    }

    public void sendString(String string) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.sendByte('s');
        this.sendInt(string.length());
        this.sendCharacters(string);
    }

    public void sendInt(int n) throws IOException {
        this.sendByte('i');
        this._stdin.writeInt(n);
    }

    public int receiveTypedInt() throws IOException {
        return this.receiveAny().getInteger();
    }

    private long receiveTypedLong() throws IOException {
        return this.receiveAny().getLong();
    }

    public SQLException receiveSQLException() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 33: {
                return null;
            }
            case 63: {
                String string = this.receiveTypedString();
                String string2 = this.receiveTypedString();
                int n = this.receiveTypedInt();
                this._exception = new SQLException(string, string2, n);
                return this._exception;
            }
        }
        throw new JbdbProtocolException("error-or-correct", by);
    }

    public String receiveTypedString() throws IOException {
        return this.receiveAny().getString();
    }

    public void sendEmptyList() throws IOException {
        this.sendByte('.');
    }

    public boolean receiveListPart() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 58: {
                return true;
            }
            case 46: {
                return false;
            }
        }
        throw new JbdbProtocolException("a list element or end-of-list", by);
    }

    public boolean receiveTypedBoolean() throws IOException {
        return this.receiveAny().getBoolean();
    }

    public void receiveEndOfResponse() throws SQLException, IOException {
        this.receiveCheckByte(';');
        if (this._exception != null) {
            SQLException sQLException = this._exception;
            this._exception = null;
            throw sQLException;
        }
    }

    public void sendEndOfRequest() throws IOException {
        this.sendByte(';');
    }

    public void sendComma() throws IOException {
        this.sendByte(',');
    }

    public void receiveCheckComma() throws IOException {
        this.receiveCheckByte(',');
    }

    public char getLanguage() {
        return this._language;
    }

    public String getPackageCombination() {
        return this._packageCombination;
    }

    public JbdbValue receiveAny() throws IOException {
        JbdbValue jbdbValue = this.receiveAnyUntraced();
        return jbdbValue;
    }

    public JbdbValue receiveAnyUntraced() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 98: {
                return this.receiveBoolean();
            }
            case 105: {
                return this.receiveInteger();
            }
            case 108: {
                return this.receiveLong();
            }
            case 115: {
                return this.receiveString();
            }
            case 114: {
                return this.receiveReal();
            }
            case 117: {
                return this.receiveTimestamp();
            }
            case 119: {
                return this.receiveByteArray();
            }
            case 116: {
                return this.receiveInterval();
            }
            case 100: {
                return this.receiveDate();
            }
            case 97: {
                return this.receiveArray();
            }
            case 45: {
                return JbdbNull.INSTANCE;
            }
        }
        throw new JbdbProtocolException("start of a typed value", by);
    }

    private byte stdoutReadByte() throws IOException {
        byte by = this._stdout.readByte();
        return by;
    }

    private JbdbValue receiveDate() throws IOException {
        return new JbdbDate(this.receiveTypedInt(), this.receiveTypedInt(), this.receiveTypedInt());
    }

    private JbdbValue receiveInterval() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 100: {
                return JbdbInterval.createDays(this.receiveTypedInt());
            }
            case 115: {
                return JbdbInterval.createSeconds(this.receiveTypedLong());
            }
        }
        throw new JbdbProtocolException("interval value", by);
    }

    private JbdbValue receiveByteArray() throws IOException {
        int n = this.receiveTypedInt();
        byte[] byArray = new byte[n];
        this.stdoutRead(n, byArray);
        return new JbdbRaw(byArray);
    }

    private void stdoutRead(int n, byte[] byArray) throws IOException {
        this._stdout.read(byArray, 0, n);
    }

    private JbdbValue receiveTimestamp() throws IOException {
        return new JbdbTimestamp(this.receiveTypedLong());
    }

    private JbdbValue receiveArray() throws IOException {
        JbdbArray jbdbArray = new JbdbArray();
        while (this.receiveListPart()) {
            jbdbArray.add(this.receiveAny());
        }
        return jbdbArray;
    }

    private JbdbValue receiveReal() throws IOException {
        return new JbdbReal(this.stdoutReadDouble());
    }

    private double stdoutReadDouble() throws IOException {
        double d = this._stdout.readDouble();
        return d;
    }

    private JbdbValue receiveString() throws IOException {
        int n = this.receiveTypedInt();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.stdoutReadChar());
        }
        return new JbdbString(stringBuffer.toString());
    }

    private char stdoutReadChar() throws IOException {
        char c = this._stdout.readChar();
        return c;
    }

    private JbdbValue receiveInteger() throws IOException {
        return new JbdbInteger(this.stdoutReadInt());
    }

    private int stdoutReadInt() throws IOException {
        int n = this._stdout.readInt();
        return n;
    }

    private JbdbValue receiveLong() throws IOException {
        return new JbdbLong(this.stdoutReadLong());
    }

    private long stdoutReadLong() throws IOException {
        long l = this._stdout.readLong();
        return l;
    }

    private JbdbValue receiveBoolean() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 116: {
                return JbdbBoolean.TRUE;
            }
            case 102: {
                return JbdbBoolean.FALSE;
            }
        }
        throw new JbdbProtocolException("boolean value", by);
    }

    public void exit() throws SQLException, IOException, InterruptedException {
        if (!this._hasExited) {
            int n;
            Object[] objectArray = this._sessions.values().toArray();
            for (n = 0; n < objectArray.length; ++n) {
                JbdbSession jbdbSession = (JbdbSession)objectArray[n];
                try {
                    jbdbSession.stop();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sendRequestName('X');
            this.sendEndOfRequest();
            this.flush();
            this.receiveCheckByte('X');
            if (this.receiveSQLException() == null) {
                // empty if block
            }
            this.receiveEndOfResponse();
            this._hasExited = true;
            n = this.waitFor();
            if (n != 0) {
                JbdbDatabase.getSingleton().getLogger().logConnectionLine(this._id, "Exit code of process was " + n);
                System.err.println("Exit code of process was " + n);
            }
        }
    }

    public void flush() throws IOException {
        this._stdin.flush();
    }

    public boolean receiveOptional() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 43: {
                return true;
            }
            case 45: {
                return false;
            }
        }
        throw new JbdbProtocolException("optional value indicator", by);
    }

    public JbdbType receiveTypeName() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 105: {
                return JbdbType.IntegerType.INSTANCE;
            }
            case 115: {
                if (this.receiveOptional()) {
                    return new JbdbType.StringType(this.receiveTypedInt());
                }
                return new JbdbType.StringType(0);
            }
            case 119: {
                if (this.receiveOptional()) {
                    return new JbdbType.RawType(this.receiveTypedInt());
                }
                return new JbdbType.RawType(0);
            }
            case 114: {
                return JbdbType.RealType.INSTANCE;
            }
            case 117: {
                return JbdbType.TimestampType.INSTANCE;
            }
            case 100: {
                return JbdbType.DateType.INSTANCE;
            }
            case 116: {
                return this.receiveIntervalSubTypeName();
            }
            case 97: {
                int n = this.receiveTypedInt();
                JbdbType jbdbType = this.receiveTypeName();
                return new JbdbType.ArrayType(jbdbType, n);
            }
        }
        throw new JbdbProtocolException("start of a type name", by);
    }

    private JbdbType receiveIntervalSubTypeName() throws IOException {
        byte by = this.stdoutReadByte();
        switch (by) {
            case 100: {
                return JbdbType.IntervalType.DAYS;
            }
            case 115: {
                return JbdbType.IntervalType.SECONDS;
            }
        }
        throw new JbdbProtocolException("an interval type", by);
    }

    public void sendListItem() throws IOException {
        this.sendByte(':');
    }

    public JbdbTable getTable(String string) throws SQLException, IOException {
        JbdbTable jbdbTable = new JbdbTable(this, string);
        return jbdbTable;
    }

    public String getPortingSetVersion() throws SQLException, IOException {
        if (this._portingSetVersion == null) {
            this.sendRequestName('V');
            this.sendInt(2);
            this.sendEndOfRequest();
            this.flush();
            this.receiveCheckByte('V');
            if (this.receiveSQLException() == null) {
                this._portingSetVersion = this.receiveTypedString();
            }
            this.receiveEndOfResponse();
        }
        return this._portingSetVersion;
    }

    public void throwSQLException(String string) throws SQLException {
        this._sqlException = new SQLException(string);
        throw this._sqlException;
    }

    static {
        $assertionsDisabled = !JbdbConnection.class.desiredAssertionStatus();
        _NrGobblers = 0;
    }

    public static class JbdbProtocolException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JbdbProtocolException(String string, byte by) {
            this("expected " + string + " but got byte '" + (char)by + "' (0x" + Integer.toHexString(by) + ")");
        }

        public JbdbProtocolException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public JbdbProtocolException(String string) {
            this(string, null);
        }
    }
}

