REM **************************************************************************
REM * File	: istructV7.sql
REM * Purpose	: show index structure and statistics
REM * Author	: Peter Romeijn, Baan International b.v.
REM * Date	: Sept 1993
REM **************************************************************************

set verify off;
set timing off;
set pagesize 30;
set feedback off;

column index_name  	format A17 		heading "index";
column segment_name	format A17 		heading "index";
column name		format A17		heading "index"
column column_name 	format A12		heading "column";
column initial_extent	format 99999990 	heading "initial";
column next_extent	format 99999990		heading "next";
column pct_increase 	format 990		heading "%incr";
column pct_free 	format 990		heading "%free";
column pct_used 	format 990		heading "%used";
column tablespace_name	format A10		heading "tablespace";
column uniqueness				heading "unique";
column ini_trans	format 990		heading "initrans";
column extents					heading "#extents";
column blocks					heading "#blocks";
column bytes					heading "#bytes";
column extent_id				heading "extent";

accept INDEX char prompt   'Enter index: ';

validate index &INDEX;

set heading off;
column user noprint new_value owner;
select user from dual;
set heading on;

spool index.def

ttitle col 25 'Index &INDEX of ' owner skip 2 -
       col 25 'Comprised columns in index' skip 2;
break on index_name;
select index_name, column_name from user_ind_columns
where index_name like upper('&INDEX');
clear breaks;

ttitle col 25 'Current index definition' skip 2;
REM
REM 	ATTENTION: column pct_free is not in the dictionary view user_indexes 
REM	of ORACLE version 6.0.30.2.1, but it is in version 6.0.31.0
REM
REM select index_name, uniqueness, tablespace_name, ini_trans,
REM 		initial_extent, next_extent, pct_increase
select index_name, uniqueness, tablespace_name, pct_free, ini_trans, 
		initial_extent, next_extent, pct_increase
from user_indexes
where index_name = upper('&INDEX');

ttitle col 25 'Current allocated space' skip 2;
select segment_name, extents, blocks, bytes
from user_segments
where segment_name = upper('&INDEX');

ttitle col 25 'Current index space in use (estimation)' skip 2;
select br_blks*(br_blk_len+113) + lf_blks*(lf_blk_len+113)
"Used space (bytes)",
(br_blks*(br_blk_len+113) + lf_blks*(lf_blk_len+113)) /
(blocks * 2048) * 100 pct_used
from index_stats;

break on report on segment_name;
compute sum of blocks on report;
compute sum of bytes on report;
ttitle col 25 'Index extent information' skip 2;
select  segment_name, extent_id, blocks, bytes 
from user_extents
where segment_name = upper('&INDEX');
clear breaks;

ttitle col 25 'Index statistics' skip 2;
select name, height, blocks, blks_gets_per_access
from index_stats
where name = upper('&INDEX');

spool off;

clear columns;
ttitle off;
exit;
