#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bdb_api.h"

#include "products.h"

/* Definitions within custom.c */
extern BDB_MAIN_CURSOR *cursor;           /* main cursor */
extern DD_TABLE *dd_table;     /* data dictionary table */
extern SqlVal limit;           /* bound limit value within query */

BDB_U_ABIND *dd2bind(char *tname, BDB_ADR_LINK *user_link,int *nr_attr);

void	init_dbc(char *progname, int progmode, char *userid);
void	customize_sql();

/* The purpose of this program is to show some functions of the library
   libqpc.a. It shows the effect of customization, the binding of query
   variables and that locking is functioning.
*/
main (int argc, char **argv)
{
   int ret = 0;                /* return value */
   bu4 trxn;                   /* transaction ID */
   init_dbc (argv[0],01|02,"AnyUserID");
   trxn = bdb_start_session ("AnySessionID");
   {
      int i, idx;              /* indexes */
      int err_nr;              /* error number */
      int size;                /* size of a type */
      int company = 0;         /* company number */
      double limits[2];
      char query[150];         /* query in Dynamic SQL */
      SqlId handle;            /* query handle */
      char *err_msg;           /* error message */
      char ex_tname[15];       /* external tablename */
      int nr_attr;             /* number of attributes */

      customize_sql();         /* Refer to custom.c */
      strcpy (ex_tname,"ttexa100");
      dd_table = ddtable (ex_tname);
      /* Refer to custom.c */
      Product_Bind = dd2bind (ex_tname,Product_Link,&nr_attr);
      ret = bdb_open (&cursor,ex_tname,company,Product_Bind,
                      nr_attr,trxn);

      /* Construct query */
      query[0] = (char )0;
      strcat (query,"select for update ");
      strcat (query,"       code:code1, descr:dscr, price:prc1 ");
      strcat (query,"from ttexa100 ");
      strcat (query,"where price < :prc2 ");
      handle = sql_parse (query,trxn,0);
   
      /* Bind one variable, make deliberate failure to show effect
	 of error functions */
      idx = bind_idx ("ttexa100.code");
      ret = sql_sel_bind (handle,"code1",(char *)&Product_Bind[idx]);
      
      if ((ret = sql_exec (handle,company)) == -1) {
        printf("Error %d\n", bdb_errno);
        bdb_stop_session (trxn);
        bdb_logoff ();
        exit(3);
      }
      sql_get_error (handle,&err_nr,&err_msg);
      printf(err_msg,err_nr);

      /* Bind the remainding SELECT-variables */
      idx = bind_idx ("ttexa100.descr");
      ret = sql_sel_bind (handle,"dscr",(char *)&Product_Bind[idx]);
      idx = bind_idx ("ttexa100.price");
      ret = sql_sel_bind (handle,"prc1",(char *)&Product_Bind[idx]);

      limits[0] = 100.0;
      limits[1] = 120.0;
      for (i=0;i<=1;i++) {
         size = sizeof (double);
	 limit.d = limits[i];
         ret = sql_wh_bind (handle,"prc2",BDB_DOUBLE,size,&limit);
         ret = sql_exec (handle,company);
         while (!(ret = sql_fetch (handle)))
         {
            long command;      /* command code */
            int arg;           /* command argument */
	    /* Show row return mechanism by binding */
            printf ("Code : %d, Description : %s, Price : %f\n",
                    Product.Code,Product.Descr,Product.Price);

            Product.Price += .05*Product.Price; /*raise lowers*/
            command = DB_UPDATE_51; arg = DB_RETURN_DUPL;
            ret = bdb_exec_row (cursor,command,arg,company);
            printf ("Command : %s (rc = %d)\n",
                     bdb_row_action (command),ret);
         }
         ret = sql_break (handle);
      }
      bdb_exec_db (COMMIT_TRANSACTION,trxn);
      ret = sql_close (handle);
   }
   bdb_stop_session (trxn);
   bdb_logoff ();
   return 0;
}
