/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb.datatypes;

public abstract class JbdbType {
    public abstract int toJbdbType();

    public int getDepth() {
        return 1;
    }

    public int getMaxLength() {
        return 0;
    }

    public static class RawType
    extends JbdbType {
        private final int _maxLength;

        public RawType(int n) {
            this._maxLength = n;
        }

        public int toJbdbType() {
            return 8;
        }

        public int getMaxLength() {
            return this._maxLength;
        }
    }

    public static class StringType
    extends JbdbType {
        private final int _maxLength;

        public StringType(int n) {
            this._maxLength = n;
        }

        public int toJbdbType() {
            return 7;
        }

        public int getMaxLength() {
            return this._maxLength;
        }
    }

    public static class IntervalType
    extends JbdbType {
        public static final JbdbType DAYS = new IntervalType(5);
        public static final JbdbType SECONDS = new IntervalType(6);
        public final int _nr;

        private IntervalType(int n) {
            this._nr = n;
        }

        public int toJbdbType() {
            return this._nr;
        }
    }

    public static class RealType
    extends JbdbType {
        public static final JbdbType INSTANCE = new RealType();

        public int toJbdbType() {
            return 2;
        }
    }

    public static class DateType
    extends JbdbType {
        public static final JbdbType INSTANCE = new DateType();

        public int toJbdbType() {
            return 3;
        }
    }

    public static class TimestampType
    extends JbdbType {
        public static final JbdbType INSTANCE = new TimestampType();

        public int toJbdbType() {
            return 4;
        }
    }

    public static class IntegerType
    extends JbdbType {
        public static final JbdbType INSTANCE = new IntegerType();

        public int toJbdbType() {
            return 1;
        }
    }

    public static class ArrayType
    extends JbdbType {
        private final JbdbType _type;
        private final int _depth;

        public ArrayType(JbdbType jbdbType, int n) {
            this._type = jbdbType;
            this._depth = n;
        }

        public int toJbdbType() {
            return this._type.toJbdbType();
        }

        public int getDepth() {
            return this._depth;
        }

        public int getMaxLength() {
            return this._type.getMaxLength();
        }
    }
}

