/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbProcessFactory;
import com.baan.jbdb.OSProcess;
import com.baan.jbdb.Util;
import java.io.File;
import java.io.IOException;

class OSProcessFactory
implements JbdbProcessFactory {
    private static final String SLASH = File.separator;
    private String _jbdbHome;
    private String[] _jbdbCommandLine;

    OSProcessFactory() {
    }

    public void setHomeDirectory(String string) {
        this._jbdbHome = string;
    }

    public JbdbConnection exec(int n) throws IOException {
        return new OSProcess(n, this.getJbdbCommandLine());
    }

    private String[] getJbdbCommandLine() throws IOException {
        if (this._jbdbCommandLine == null) {
            String[] stringArray;
            String string = "jbdb" + (SLASH.equals("\\") ? ".exe" : "6.1");
            String string2 = this.findJbdbBinDirectory();
            String string3 = string2 + SLASH + string;
            if (this._jbdbHome == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string3;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = string3;
                stringArray3[1] = "-h";
                stringArray = stringArray3;
                stringArray3[2] = this._jbdbHome;
            }
            this._jbdbCommandLine = stringArray;
        }
        return this._jbdbCommandLine;
    }

    private String findJbdbBinDirectory() throws IOException {
        if (this._jbdbHome != null) {
            return this._jbdbHome + SLASH + "bin";
        }
        String string = Util.getenv("BSE_BIN");
        if (string != null && string.length() != 0) {
            return string;
        }
        String string2 = Util.getenv("BSE");
        if (string2 != null && string2.length() != 0) {
            return string2 + SLASH + "bin";
        }
        throw new IOException("Don't know where to find jbdb binary: BSE not set");
    }
}

