/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jbdb;

import com.baan.jbdb.JbdbColumn;
import com.baan.jbdb.JbdbConnection;
import com.baan.jbdb.JbdbDatabase;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JbdbTable {
    private final JbdbConnection _connection;
    private final String _name;
    private final List _columnList = new ArrayList();
    private final JbdbColumn[] _columnArray;
    private int _nrIndexes;
    static final /* synthetic */ boolean $assertionsDisabled;

    JbdbTable(JbdbConnection jbdbConnection, String string) throws SQLException, IOException {
        this._connection = jbdbConnection;
        this._name = string;
        this._connection.sendRequestName('R');
        this._connection.sendRequestName('T');
        this._connection.sendString(this.getName());
        this._connection.sendEndOfRequest();
        this._connection.flush();
        this._connection.receiveCheckByte('R');
        this._connection.receiveCheckByte('T');
        if (this._connection.receiveSQLException() == null) {
            int n;
            Object object;
            while (this._connection.receiveListPart()) {
                object = this._connection.receiveTypedString();
                this._connection.receiveCheckComma();
                int n2 = this._connection.receiveTypedInt();
                this._connection.receiveCheckComma();
                n = this._connection.receiveTypedBoolean();
                this.addColumn((String)object, n2, n != 0);
            }
            this._columnArray = new JbdbColumn[this._columnList.size()];
            this._nrIndexes = 0;
            object = this._columnList.iterator();
            while (object.hasNext()) {
                JbdbColumn jbdbColumn = (JbdbColumn)object.next();
                n = jbdbColumn.getIndexNr();
                if (n <= 0) continue;
                ++this._nrIndexes;
                this._columnArray[n - 1] = jbdbColumn;
            }
            int n3 = this._nrIndexes;
            Iterator iterator = this._columnList.iterator();
            while (iterator.hasNext()) {
                JbdbColumn jbdbColumn = (JbdbColumn)iterator.next();
                if (jbdbColumn.isIndex()) continue;
                if (!$assertionsDisabled && this._columnArray[n3] != null) {
                    throw new AssertionError();
                }
                this._columnArray[n3++] = jbdbColumn;
            }
        } else {
            this._columnArray = null;
        }
        this._connection.receiveEndOfResponse();
    }

    public String getName() {
        return this._name;
    }

    public JbdbColumn[] getColumns() throws SQLException {
        return this._columnArray;
    }

    public JbdbColumn getColumn(String string) throws SQLException {
        for (int i = 0; i < this._columnArray.length; ++i) {
            JbdbColumn jbdbColumn = this._columnArray[i];
            if (!jbdbColumn.getBaseName().equals(string)) continue;
            return jbdbColumn;
        }
        this._connection.throwSQLException("Table '" + this._name + "' does not have a column named '" + string + "'");
        return null;
    }

    int getNumberOfColumns() {
        return this._columnArray.length;
    }

    JbdbColumn getJbdb1Column(int n) {
        if (5 <= n && n <= 4 + this.getNumberOfColumns()) {
            return this._columnArray[n - 5];
        }
        JbdbDatabase.apiError("incorrect column number " + n);
        return null;
    }

    private void addColumn(String string, int n, boolean bl) {
        this._columnList.add(new JbdbColumn(this, string, n, bl));
    }

    public int getNumberOfIndexes() throws SQLException {
        return this._nrIndexes;
    }

    JbdbConnection getConnection() {
        return this._connection;
    }

    static {
        $assertionsDisabled = !JbdbTable.class.desiredAssertionStatus();
    }
}

