/* version.h */

#ifndef _VERSION_H
#define _VERSION_H

#include <stdio.h>	/* required for FILE */

/* defines for get_version() function */
#define PORT_NO		 0
#define PORT_DATE	 1
#define UNAME		 2
#define MACHINE_ID	 3
#define OS_RELEASE	 4
#define IDENT_CFLAGS	 5
#define IDENT_LOADFLAGS	 6
#define ISAM_RELEASE	 7
#define PORT_SET	 8
#define TARGET_VERSION	 9
#define COPYRIGHT	10
#define PRODUCTNAME	11
#define COMP_VERSION	12
#define PROD_VERSION	13

/* flags used for print_version_ex() */
#define PRINT_GENERIC_STUFF	1 << 0
#define PRINT_DBMS_VERSION	1 << 1

#ifdef  __cplusplus
extern "C" {
#endif /* __cplusplus */

/* prototypes */
const 	char *get_version(int nr);
void	print_version(int do_not_print_dbms_version);
void	print_version_ex(int items, const char **ident);
void	print_configspec(const char **ident);
void	print_configspec_ex(FILE *fp, const char **ident);
void	print_lib_version(const char **lib_ident);
void	print_lib_configspec(const char **configspec_ident);

/* implementation only available if compiled with BAAN_SHLIB */
void	set_port_ident(const char **p_port_ident);
void	set_cs_ident(const char **p_cs_ident);

#ifdef  __cplusplus
}
#endif /* __cplusplus */

#endif /* _VERSION_H */
