/*
 * Data Dictionary definitions
 * Copyright 1990-1997 Baan Development BV
 */

#ifndef	DATADICT_H
#define	DATADICT_H	1

#include "system.h"

/*
	Defines for DD_COLUMN->type:
*/

typedef	UCHAR	BDB_TYPE;

#define	BDB_CHAR	((BDB_TYPE) 000001)
#define	BDB_SHORT	((BDB_TYPE) 000002)
#define	BDB_LONG	((BDB_TYPE) 000003)
#define	BDB_FLOAT	((BDB_TYPE) 000004)
#define	BDB_DOUBLE	((BDB_TYPE) 000005)
#define	BDB_STRING	((BDB_TYPE) 000006)

#define	BDB_DATE	((BDB_TYPE) 000007)
#define	BDB_TIME	((BDB_TYPE) 000010)
#define	BDB_TEXT	((BDB_TYPE) 000011)
#define	BDB_MAIL	((BDB_TYPE) 000012)
#define	BDB_ENUM	((BDB_TYPE) 000013)
#define	BDB_BITSET	((BDB_TYPE) 000014)
#define	BDB_COMBINED	((BDB_TYPE) 000015)
#define	BDB_TSS_STRING	((BDB_TYPE) 000016)
#define	BDB_TYPE_LAST	((BDB_TYPE) 000016)	/* Must have highest value */

#ifdef BDB_ALLOC_SIZE_TBL
UCHAR	bdb_size_tbl[] = {
	0,
	sizeof(char),		/* BDB_CHAR */
	sizeof(short),		/* BDB_SHORT */
	sizeof(bs4),		/* BDB_LONG */
	sizeof(float),		/* BDB_FLOAT */
	sizeof(double),		/* BDB_DOUBLE */
	sizeof(char),		/* BDB_STRING */
	sizeof(bs4),		/* BDB_DATE */
	sizeof(bs4),		/* BDB_TIME */
	sizeof(bs4),		/* BDB_TEXT */
	sizeof(bs4),		/* BDB_MAIL */
	sizeof(char),		/* BDB_ENUM */
	sizeof(bs4),		/* BDB_BITSET */
	0,			/* BDB_COMBINED */
	sizeof(char),		/* BDB_TSS_STRING */
	0
};
#else
extern UCHAR	bdb_size_tbl[];
#endif

/*
	End of defines for DD_COLUMN->type:
*/

/*
	Defines for DD_COLUMN->flag:
*/

typedef	UCHAR	BDB_FLAG;

#define	BDB_ARRAY		((BDB_FLAG) 000001)
#define	BDB_MUST_FILLED		((BDB_FLAG) 000002)
#define	BDB_IS_CHILD		((BDB_FLAG) 000004)
#define	BDB_IS_REF_TO		((BDB_FLAG) 000010)
#define	BDB_PAR_IS_REF_TO	((BDB_FLAG) 000020)
#define	BDB_NOT_ACTIV		((BDB_FLAG) 000040)
#define	BDB_INDEX_COL		((BDB_FLAG) 000100)
#define	BDB_IS_AUDITED		((BDB_FLAG) 000200)
/*
	Reserved for level 2 in the driver only. Beware not changing this one
	without not changing driver's side flag (DB_ARRAY_COMPRESS) ! Peter.
#define BDB_ARRAY_COMPRESS	((BDB_FLAG) 000400)
*/

/*
	End of defines for DD_COLUMN->flag:
*/

/*
	Defines for DD_TABLE->flag:
*/
/*
	This two values should be equal as the values of DD_NEW_MODE and
	DD_CUR_MODE
	of dd_info.mode in localdict.h:
*/
#define	BDB_NEW_TABLE	0004
#define	BDB_CUR_TABLE	0010
/*
	End of defines for DD_TABLE->flag
*/

/*
	Defines for DD_DOMAIN_LIST->flag:
*/
/*
	This two values should be equal as the values of DD_NEW_MODE and
	DD_CUR_MODE
	of dd_info.mode in localdict.h:
*/
#define	BDB_NEW_DOMAIN	0004
#define	BDB_CUR_DOMAIN	0010
/*
	End of defines for DD_DOMAIN_LIST->flag
*/

#define PACKAGE_NAME_LEN	2	/* all without \0 delimiter! */
#define MODULE_NAME_LEN		5
#define COLUMN_NAME_LEN		17
#define DOMAIN_NAME_LEN		14
#define TABLE_NAME_LEN		8
#define REF_ERROR_LEN		14
#define LOGON_NAME_LEN		8
#define MAX_COLUMNS_BY_TABLE	1024
#define MAX_COLUMNS_BY_INDEX	32
#ifdef DEC_OSF_ALPHA
#define MAX_ROW_SIZE		(5 * 1024)	/* long are longer */
#else
#define MAX_ROW_SIZE		(3 * 1024)
#endif

#if (!defined(REL4_3) && !defined(REL5_0))
					/*
					 * The maximum keysize for bisam
					 * is now 255
					 */
#define MAX_KEYSIZE		(255-8)	/* -MJW- */
#else
#define MAX_KEYSIZE		120
#endif

#define MAX_INDEX_BY_TABLE	64
#define MAX_CHILDS		32	/* added Peter 07-02-92 */
#define ROWID_LEN		32
#define	SESSION_NAME_LEN	15
/*
	mode for read DD:
*/

#define	DD_NORMAL	1
#define	DD_OLD		2
#define	DD_NEW		3
#define	DD_READ_RELATED	4

/*
	define for references:
*/

/*
	Defines for DD_REF_NODE->flag:
*/

#define	BDB_REF_COMP		(1)	/* Compulsory */
#define	BDB_REF_COMP_UE		(2)	/*  "  " unless empty */
#define	BDB_REF_NOT_COMP	(3)	/* Not Compulsory */

#define	BDB_REF_RESTRICTED	(1)	/* Restricted */
#define	BDB_REF_CASCADE		(2)	/* Cascade */
#define	BDB_REF_NULLIFY		(3)	/* Nullify */
#define	BDB_REF_CHK_RUNTIME	(4)	/* Check at RunTime */
#define	BDB_REF_NOP		(5)	/* No Operation */

#define	BDB_REF_MODE(X)		((X) & 03)	    /* Bits 0 & 1 */
#define	BDB_REF_UPDATE(X)	((X>>2) & 07)	    /* bits 2 & 3 & 4 */
#define	BDB_REF_DELETE(X)	((X>>5) & 07)	    /* bits 5 & 6 & 7 */
#define	BDB_REF_IGNORED(X)	(((X)>>8) & 01)     /* bit 8 */

#define MAX_REF_DEPTH		20
#define	DFLT_REF_DEPTH		3

#define	TOP_LEVEL		01000  /* bit 9 : for internal use in server
						 only
				      */
#define BOTTOM_LEVEL		02000 /* bit 10 : internal use only */
#define	ORIGINAL_NOT_IGNORED	0400  /* bit 11 : internal use only */

#define BDB_FLAG_REF_PHYSICAL   010000  /* bit 12: physical reference: the reference refers to the (referred) table 
                                                in the physical company of the referring table instead of the same company */

#define BDB_SET_REF_PHYSICAL(X) ((X) = ((X)|BDB_FLAG_REF_PHYSICAL))     /* set bit 12 */ 
#define BDB_CLR_REF_PHYSICAL(X) ((X) = ((X) & ~BDB_FLAG_REF_PHYSICAL))  /* clear bit 12 */
#define BDB_IS_REF_PHYSICAL(X)  ((X) & BDB_FLAG_REF_PHYSICAL)           /* test bit 12 */

#define	BDB_SET_REF_MODE(X,Y)	(X = ((X) & ~03)|(Y))
#define	BDB_SET_REF_UPDATE(X,Y)	(X = ((X) & ~(07<<2))|(Y<<2))
#define	BDB_SET_REF_DELETE(X,Y)	(X = ((X) & ~(07<<5))|(Y<<5))

#define	BDB_SET_REF_IGNORED(X)	(X = ((X)|(01<<8)))

#define BDB_SET_REF_ACTIVE(X)	(X &= 0177377) /* set bit 8 to 0 */
/*
	End of defines for DD_REF_NODE->flag:
*/

typedef	struct {
	char		*keyword,
			*descr;
	ULONG		cnst;
}	DD_ENUM_VAL;

typedef struct _dd_enum_def {
	struct _dd_enum_def	*next;
	DD_ENUM_VAL		*enum_val;
	UCHAR			maxl,
				count;
	char			language;
}	DD_ENUM_DEF;

typedef struct	_audit_update	{
	short	offset,
		size;
} AUDIT_UPDATE;

typedef struct	{
	union	{
		long		divf;		/* divide faktor */
		DD_ENUM_DEF	*enum_def;
		char		convert;	/* convert karakter */
	} DETAIL;
	char			*range,		/* range */
				*attributes;	/* attributes */
	short			clen;		/* current lengte (voor strings)
						   voor andere types staat er de
						   sizeof(type) in */
	char			adjust,		/* adjust karakter */
				_name[(DOMAIN_NAME_LEN - PACKAGE_NAME_LEN) + 1];
						/* domain name */
	BDB_TYPE		type;		/* type of domain */
	UCHAR			digv,		/* digits voor de komma */
				diga,		/* digits achter de komma */
				rndo;		/* afrondigs kode */
	short			plen;		/* Fixed Display lengte */
}	DD_DOMAIN;

typedef	struct _dd_domain_list	{
	char			package[PACKAGE_NAME_LEN + 1];
	DD_DOMAIN		*domains;
	USHORT			no_dd_domains;
	UCHAR			flag;
}	DD_DOMAIN_LIST;

/*	File dd informatie	*/
typedef	struct _dd_column	{
	union	{
		struct	_dd_column	**childs;	/* table of childs */
		DD_DOMAIN		*domain;
	} detail;
	USHORT		offset,			/* start positie in record */
			size;			/* veldlengte in bytes	*/
	UCHAR		dept;			/* diepte voor array's */
	BDB_TYPE	type;			/* type of column */
	BDB_FLAG	flag;			/* flags of column */
	char		name[COLUMN_NAME_LEN + 1];
}	DD_COLUMN;

typedef struct _dd_key_desc	{
	DD_COLUMN		**parts;
	char			nr,
				active,
				dupl;
}	DD_KEY_DESC;

typedef	struct _dd_table	{
	DD_COLUMN		*columns,	/* table of columns */
				*prim;		/* primairy key field */
	DD_KEY_DESC		*keys;		/* table of key descriptions */
	USHORT			*relations;	/* list of relations
						   format: see below	*/
	DD_COLUMN		*refcnt_upd,	/* ref counter update */
				*refcnt_del;	/* ref counter delete */
	AUDIT_UPDATE		*audit_update;
	char			refmess_upd[REF_ERROR_LEN],
						/* ref mess for restr. update */
				refmess_del[REF_ERROR_LEN];
						/* ref mess for restr. delete */
	char			*def_rec;	/* pointer to default record */
	struct	_dd_ref_node	*refs;		/* table of DD_REF_NODES */
	struct	_dd_to_list	*to_list;	/* table of DD_TO_REFS	*/
	char	name[TABLE_NAME_LEN + 1];
	short	real_len,			/* length on disk */
		int_len,			/* length of internal buf */
		no_dd_columns,			/* no of dd_columns in
						   columns table	*/
		no_dd_refs;			/* no of dd_refs in
						   from_refs table	*/
	short	no_to_list;			/* no of to_list	*/
	UCHAR	no_keys,			/* no of key_desc's in
						   keys table		*/
		flag;				/* flags of tables	*/
}	DD_TABLE;

typedef	struct	{
	char	*lechar,	/* legale karakters */
		*ilchar,	/* ilegale karakters */
		*oformat,	/* output format */
		*iformat,	/* intern format */
		*dom_err;	/* errorcode */
}	DD_DOMAIN_ATTRIBUTES;

typedef	struct	_dd_ref_node	{
	DD_COLUMN	*f_fld;				/* from dd_column */
	DD_TABLE	*f_table;			/* from dd_table */
	char		f_name[COLUMN_NAME_LEN + 1],	/* from dd_columnname */
			t_name[COLUMN_NAME_LEN + 1],	/* to dd_columnname */
			ref_err[REF_ERROR_LEN];		/* ref error code */
	USHORT		flag;				/* ref mode */
}	DD_REF_NODE;

typedef struct	{
	DD_TABLE	*table;
	DD_DOMAIN_LIST	**list;				/* Closed with zero */
	char		*next;
}	DD_TABLE_UNIQ;

typedef struct	_dd_to_list	{
	char		f_name[COLUMN_NAME_LEN + 1];
	USHORT		flag;				/* ref mode */
}	DD_TO_LIST;

typedef	struct _bdb_permission	{
	struct _bdb_permission	*next;
	DD_COLUMN		*col;
	char			permission,
				level;
	char			*condition;
	int			compnr;
}	BDB_PERMISSION;

typedef struct	{
	DD_TABLE	*table;
	char		*hash_next;
	DD_REF_NODE	**to_ref;
	BDB_PERMISSION	*permission;
} DD_TABLE_LOCAL;

typedef struct	{
	DD_DOMAIN_LIST	*list;
	char		*hash_next;
} DD_DOMAIN_LOCAL;

/*
	Structure indicates the columns that need to be converted to and from
	network independant format.
*/
typedef struct	{
	BDB_TYPE	type;
	USHORT		offset;
} CONV_COLUMN;

#define	COUNT_NAME	"Refcnt" /* internal col name for ref counter */
#define UPDATE_SUFFIX	'u'
#define DELETE_SUFFIX	'd'

#define	DOM_DLOCK	"Dom.dlock"
#define	DOM_COMPNR	"Dom.compnr"

#define	NAME_DLOCK	"_dlock"
#define	NAME_COMPNR	"_compnr"
#define	NAME_INDEX	"_index"

/*
	Position of extra columns in bind table.
*/
#define BIND_OFFSET_FROM_LAST_COMPNR	0	/* last in bind_tbl */
#define BIND_OFFSET_FROM_LAST_DLOCK	1	/* (last - 1) in bind_tbl */
/*
	Offset of extra columns after real_len.
*/
#define PSEUDO_OFFSET_DLOCK		0
#define PSEUDO_OFFSET_COMPNR		4

/*
	Usage of dictionary functions:

	There are two initialisation functions
	1.	init_local_dd:
		This one can called in two ways. (for normal use)
		1.	init_local_dd((char *)0, (char *)0, (char *)0);
			Can always used. But isn't using shared dictionaries.
		2.	init_local_dd(
				bshellptrs[FILE_ADRS],
				bshellptrs[DOMAIN_ADRS],
				bshellptrs[REFS_ADRS]);
			In this way you use the shared dictionaries if the
			are read in.
	2.	init_global_dd:
		for special use, only when you want to build shared
		dictionaries.
		(shm_brk is the shared memory allocation function).
		init_global_dd(shm_brk,
			bshellptrs[FILE_ADRS],
			bshellptrs[DOMAIN_ADRS],
			bshellptrs[REFS_ADRS]);

		ret_global_dd_adres(&(bshellptrs[FILE_ADRS]),
			&(bshellptrs[DOMAIN_ADRS]),
			&(bshellptrs[REFS_ADRS]));
		With this routine returns the global dictionary adres
		pointers to the shared memory region.

	ex 1.1:
		#include "datadict.h"

		init_local_dd((char *)0, (char *)0, (char *)0);

		actions
		.......

		exit();

	ex 1.2:
		#include "datadict.h"
		#include "shm.h"

		if (link_shm())	{
			error("shared memory error errno %d shm_errno %d",
				errno, shm_errno);
			exit();
		}
		init_local_dd(
				bshellptrs[FILE_ADRS],
				bshellptrs[DOMAIN_ADRS],
				bshellptrs[REFS_ADRS]);

		actions
		.......

		unlink_shm();
		exit();

	ex 2:
		#include "datadict.h"
		#include "shm.h"

		if (link_shm())	{
			error("shared memory error errno %d shm_errno %d",
				errno, shm_errno);
			exit();
		}

		init_global_dd(shm_brk,
			bshellptrs[FILE_ADRS],
			bshellptrs[DOMAIN_ADRS],
			bshellptrs[REFS_ADRS]);

		actions
		.......

		ret_global_dd_adres(&(bshellptrs[FILE_ADRS]),
			&(bshellptrs[DOMAIN_ADRS]),
			&(bshellptrs[REFS_ADRS]));

		unlink_shm();
		exit();

	Other functions:
		void	set_dd_mode(new_mode)
		int	new_mode

			Sets the static variable read_dd_mode to new_mode
			read_dd_mode is used in ddtable and read_ddtable 
			to specify a .new, .old or normal DD file
			( Internal name format:
				normal:	 aaa000
				new   :  Aaa000
				old   :	 aAa000 )
			
		DD_TABLE	*ddtable(table_name);
		char	*table_name;

			Looks for an DD_TABLE with name = table_name;

		DD_TABLE	*ddtable_from_columnname(column_name);
		char	*column_name;

			Looks for an DD_TABLE with
			name = table_name from column_name

		DD_TABLE	*read_ddtable(table_name);
		char	*table_name;

			Read dictionary description of table_name and
			returns DD_TABLE.
			ex. dd_table = read_ddtable("sys099");

		DD_DOMAIN_LIST	*dddomain_list(module);
		char	*module;

			Looks for an DD_DOMAIN_LIST with name = module;

		DD_DOMAIN_LIST	*read_domain_list(module);
		char	*module;

			Read domain description of module and
			returns DD_DOMAIN_LIST.
			ex. dd_domain_list = read_domain_list("");

		DD_COLUMN	*ddcolumn(column_name);
		char	*column_name;

			Looks for an DD_COLUMN with name = column_name;

		int	check_syntax_column_name(name)
		char	*name;

			Checks if syntax of name according to
			mmmnnn.xxxxxxxx (mmm: module, nnn: table number,
					xxxxxxxx: name (at most 8 alphanum)
			return 1 when correct, otherwise 0

		DD_COLUMN	**search_key_parts(table, key_nr);
		DD_TABLE	*table;
		int	key_nr;

			Return's the table of DD_COLUMN's from DD_TABLE
			where KEY_DESC->nr = key_nr;

		DD_DOMAIN		*dddomain(domain_name);
		char	*domain_name;

			Looks for an DD_DOMAIN with name = domain_name;

		void		read_doma(module);
		char	*module;

			Read's the domain's from module.

			ex. read_doma("sys");
			read's file dsys.pd.

			ex. read_doma("sysgen");
			read's file dsysgen.pd. For overall domain's.

		DD_KEY_DESC	*key_desc(table, key_nr);
		DD_TABLE	*table;
		int	key_nr;

			Return's DD_KEY_DESC from DD_TABLE
			where DD_KEY_DESC->nr = key_nr;

		int		is_key_part(parts, dd_column);
		DD_COLUMN	**parts,
				*dd_column;

			Boolean function; if dd_column is part of
			parts -> true else false;

		void		bdb_extract_cols(cols, rec, parts)
		UCHAR		*key,
				*rec;
		DD_COLUMN	**parts;

			With the description of parts the correct
			column-value is copied from rec to cols. (Only the
			column values.) The maximum size of a key is
			BDB_ROW_SIZE)

		void		bdb_extract_key(key, rec, key_desc)
		UCHAR		*key,
				*rec;
		DD_KEY_DESC	*key_desc;

			With the description of key_desc the correct
			key-value is copied from rec to key. (Only the
			key values.) The maximum size of a key is
			BDB_MAXKEYSIZE.

		void		bdb_fill_cols(rec, cols, parts)
		UCHAR		*rec,
				*cols;
		DD_COLUMN	**parts;

			With the description of parts the correct
			column value is copied from cols to rec. (Only the
			column values.) The maximum size of a key is
			BDB_ROW_SIZE.

		void		bdb_fill_key(rec, key, key_desc)
		UCHAR		*rec,
				*key;
		DD_KEY_DESC	*key_desc;

			With the description of key_desc the correct
			key-value is copied from key to rec. (Only the
			key values.) The maximum size of a key is
			BDB_MAXKEYSIZE.

		int		bdb_compare_cols(cols1, cols2, parts)
		UCHAR		*cols1,
				*cols2;
		DD_KEY_DESC	*parts;

			Compares cols1 and cols2. Return -1, 1 or 0.

		int		bdb_compare_key(key1, key2, key_desc)
		UCHAR		*key1,
				*key2;
		DD_KEY_DESC	*key_desc;

			Compares key1 and key2. Return -1, 1 or 0.

if ( dict5_0 )	{
		int	ref_route(f_file, to, ref_path, result);
		DD_TABLE	*f_file;
		DD_COLUMN	*to, **ref_path;
		DD_REF_NODE	**result;

			This routine find the shortest route between
			'f_file' table or 'ref_path' to 'to' column,
			using references.
			'result' will be filled, number of nodes are
			returned.
			ex.

			DD_REF_NODE	*result[20];
			DD_COLUMN	**ref_path, *to;
			DD_TABLE	*f_file;
			int		dept;

			ref_path[0] = column1;
			ref_path[1] = column2;
			ref_path[2] = 0;
			or
			replace ref_path by (DD_COLUMN **)0 then
			ref_route search a link between d_file to 'to'-column.

			if ( (dept = ref_route(f_file, to, ref_path, result)) )
				^* found *^
			else
				^* not found *^
} else	{
		int	ref_route(f_file, to, from, result);
		DD_TABLE	*f_file;
		DD_COLUMN	*to, *from;
		DD_REF_NODE	**result;


			This routine find the shortest route between
			'f_file' table or 'from' column to 'to' column,
			using references.
			'result' will be filled, number of nodes are
			returned.

			ex.
			DD_REF_NODE	*result[20];
			DD_COLUMN	*from, *to;
			DD_TABLE	*f_file;
			int		dept;
			if ( (dept = ref_route(f_file, to, from, result)) )
				^* found *^
			else
				^* not found *^
}

		int	get_enum_descr(dom, cnst, language, buffer)
		DD_DOMAIN	*dom;
		ULONG		cnst;
		int		language;
		char		buffer;

			This routine write's the descriptions in 'buffer'
			of the matching constants. For a BITSET the are
			seperated by a '/'. If language is '-1' then
			the system language is chosen (user_info.language).

		ULONG	get_enum_const(dom, descr)
		DD_DOMAIN	*dom;
		char		*descr;

			This routine find the constant which is
			related to 'descr'. Use for a BITSET a
			string with seperater a '/'.
			Used always the system language (user_info.language).

		DD_ENUM_DEF	*get_enum_def(dom, language)
		DD_DOMAIN	*dom;
		int		language;

			Return's the DD_ENUM_DEF of the specified
			dd_domain and language.

		ULONG	get_keyw_const(dom, keyword)
		DD_DOMAIN	*dom;
		char		*keyword;

			This routine find the constant which is
			related to 'keyword'.
			Used always the system language (user_info.language).

		DD_DOMAIN	*dddomain_from_enum_keyw(keyword, const);
		char		*keyword;
		ULONG		*const;

			This routine return's the dd_domain pointer
			of the specified enum constant.
			If 'const' points to specified adres then
			the constant value of 'enum keyword'.

		DD_COLUMN	**sort_columns_by_offset(dd_table, column_table)
		DD_TABLE	*dd_table;
		DD_COLUMN	**column_table;

			This routine return's an array of DD_COLUMN pointers,
			sorted by offset.
			When column_table is 0 then an an array is
			allocated with calloc. You have to free it by your own.
			List is closed with zero pointer.

		DD_COLUMN	**list_index_columns(dd_table,idx,column_table)
		DD_TABLE	*dd_table;
		int		idx;
		DD_COLUMN	**column_table;

			This routine return's an array of DD_COLUMN pointers,
			defining index idx. 

			When column_table is 0 then an an array is allocated
			with calloc. You have to free it by your own.
			List is closed with zero pointer.
*/

/*	Info on storage of relations:
	In DD_RELATION:
		columns: list of the DD_COLUMNS used in any relation
		relations:
			array of USHORTs with the following format (p.e.):

		|nr_rela|nr_cols|col1|col2|col3|nr_cols|col1|col2|
		         \____ relation 1 ____/ \__ relation 2 _/

		Each field is a USHORT:
		nr_rela is total number of relations;
		nr_cols specifies the number of cols for one relation;
		col1, col2, .. specifies the column (the value
		of col1, col2, .. is used as index in field columns)
*/
#endif
