/*
 * Database errors
 * Copyright 1990-1997 Baan Development BV
 */

#ifndef BDBERRNO_H
#define BDBERRNO_H 1

extern	int	bdb_errno;

#define	E_BDB_DUPL		100
#define	E_BDB_NOTOPEN		101
#define	E_BDB_BADARG		102
#define	E_BDB_BADKEY		103
#define	E_BDB_NOTEXCL		106
#define	E_BDB_LOCKED		107
#define	E_BDB_KEXISTS		108
#define	E_BDB_NO_KEY		109
#define	E_BDB_ENDFILE		110
#define	E_BDB_NOREC		111
#define	E_BDB_NOCURR		112
#define	E_BDB_FLOCKED		113
#define	E_BDB_CRT_IDX		114

#define	E_BDB_ROW_CHANGED	201
#define E_BDB_DB_LOCKED		202
#define	E_BDB_TRANSACTION_IS_ON	203
#define	E_BDB_IS_READONLY	204
#define	E_BDB_NOT_IN_RANGE	205
#define	E_BDB_NOT_LOCKED	206
#define	E_BDB_AUDIT		207
#define	E_BDB_NO_PERMISSION	208
#define	E_BDB_MIRROR		209
#define	E_BDB_MLOCKED		210	/* row was locked in one of the mirror
					   databases -> deadlock possible */
#define	E_BDB_TRANSACTION_OPEN	213	/* transaction is started, but no upd
					   (internal error only) */
#define	E_BDB_UNALLOWED_COMPNR	214	/* unallowed operation for compnr
					   mapping (drop/clear table) */
#define E_BDB_ILLEGAL		215	/* illegal state which should never
					   occur */
#define E_BDB_MISSING_ROLE	216
#define E_BDB_CORRUPT_ROLE 	217

#define	E_AUD_SETUP		251	/* Incorrect Audit Setup	*/
#define	E_AUD_CORRUPT		252	/* Audit file corrupt		*/
#define	E_AUD_LOCKED		253	/* Audit file locked		*/
#define	E_AUD_ABORT		254	/* Abort from audit server	*/

#define	E_SQL_QUERY		301
#define	E_SQL_SYNTAX		302
#define	E_SQL_REFER		303
#define	E_SQL_UNDEFINED		304
#define	E_SQL_WRONG_ROW		305
#define	E_SQL_DIV_BY_ZERO	306
#define	E_SQL_STRING_TRUNCATION	307
#define	E_SQL_INDEX_OUT_OF_DIMS	308
#define	E_SQL_SUBSTRING_ERROR	309
#define	E_SQL_CARDINALITY_VIOLATION	310
#define	E_SQL_FILEIO	311
#define	E_SQL_INVALID_PARAMETER_TYPE 312
#define	E_SQL_TIMEOUT	313
#define E_SQL_INVALID_SQLID	314
#define E_SQL_STRING_LENGTH_MISMATCH 315
#define E_SQL_ZERO_LENGTH_RAW_BOUND 316
#define	E_SQL_TRIM_ERROR	317
#define	E_SQL_INVALID_FUNCTION_ARGUMENT_VALUE 318

#define E_SQL_INVALID_ESC_CHAR	319	/* Ansi 22 019 */
#define E_SQL_INVALID_ESC_SEQ	325	/* Ansi 22 015 */

#define E_SQL_FOLD_ERROR        330

#define E_BDB_BAD_FILE_FMT	401  /* Bad info. file formats like ora_users */
#define E_BDB_CONFIG		402  /* Configuration error */


#define	E_BDB_MEMORY		501
#define	E_BDB_ON		502
#define	E_BDB_BAD_ADRS		503
#define	E_BDB_BAD_FLD		504
#define	E_BDB_NO_SERVER		505
#define	E_BDB_NO_TABLE		506
#define	E_BDB_TABLE_EXIST	507
#define	E_BDB_NOT_ON		508
#define	E_BDB_BAD_CURSOR	509
#define	E_BDB_DB_NOT_ON		510
#define	E_BDB_WRONG_VERSION	511
#define	E_BDB_DD_CORRUPT	512
#define	E_BDB_NO_DD		513
#define	E_BDB_SECURITY		514
#define E_BDB_LICENCE_ERROR	515
#define E_BDB_UPD_SEGM		516
#define E_BDB_DELAYED		517	/* general error for delayed locking */
#define E_BDB_NO_SESSION	518	/* invalid session id specified */
#define E_BDB_NO_COMPNR		519	/* no compnr specified */
#define E_BDB_BUF_UPD		520	/* error during buffered updates */
#define E_BDB_NO_SHM		521	/* Shared Memory Not  Up	*/
#define E_BDB_DB_CONNECTION_LOST 522	/* connection between driver and database lost.	*/
#define	E_BDB_DB_FULL		523	/* Database full, unable to extend database */
#define E_BDB_BUF_ARRAY_INS     524 	/* Error in buffered array inserts */

#define E_BDB_NO_RESOURCE	525

#define E_BDB_DB_LOGON_DENIED	540	/* Database is on, but user can not logon */

#define	E_BDB_REFERENCE_START	600

#define	E_BDB_REFERENCE		600
#define	E_BDB_REF_LOCKED	601
#define	E_BDB_UNDEF_REF		602
#define	E_BDB_REF_UPDATE	604
#define	E_BDB_REF_EXISTS	605
#define	E_BDB_REF_NOT_EXISTS	606 
#define	E_BDB_NO_REFTBL		607
#define	E_BDB_NO_REFCNT		608
#define	E_BDB_UPD_REFCNT	609

#define	E_BDB_REFERENCE_END	649

#define E_BDB_SET_LOCALE	700

#define E_BDB_FATAL_START	850

#define	E_BDB_ABORT		850	/* Current Transaction is aborted */

#define E_BDB_FATAL_END		899

#endif /* BDBERRNO_H */
