/***********************************************************************
* File: ddc.h
* 
* This file declares all structures for use by the ddc devices
* 
* (All menu pointers to struct are pointers to dynamic arrays of struct)
*
***********************************************************************/

/* One of the following message identifications should be contained
   in the text delivered to the UNIX driver.
	DDC_ACK 
	DDC_END
	DDC_END_REQ
	DDC_EXECUTE 
	DDC_FUNCTION 
	DDC_INIT
	DDC_LICENCE
	DDC_LIST_ELEM 
	DDC_LIST_END 
	DDC_LIST_START 
	DDC_MENU 
	DDC_NUMBER
	DDC_REPLY 
	DDC_REQUEST 
	DDC_OFFLINE 
	DDC_COMB_FIELD
	DDC_LIST_REPEAT
*/

#define MENU_GI         1   /* Field numbers in the DDC_MENU message	*/
#define MENU_ME         2   /* from ddc.server to ddc.driver!		*/
#define MENU_II         3
#define MENU_IN         4
#define MENU_IT         5
#define MENU_PI         6
#define MENU_FS		7
#define MENU_FN         8

			/* Field numbers in the DDC_FUNCTION message*/
#define FUNC_GI         1   /* Group Ident			*/
#define FUNC_FU         2   /* FUnction, message type		*/
#define FUNC_FN         3   /* Function Name			*/
#define FUNC_FS         4   /* Function Server name		*/
#define FUNC_TP		5   /* Transaction prefix		*/
#define FUNC_PNU        6   /* Parameter Number			*/
#define FUNC_PR         7   /* PRompt				*/
#define FUNC_FP         8   /* Field prefix			*/
#define FUNC_PVT        9   /* Parameter Value Type		*/
#define FUNC_BM 	10  /* Bitmask				*/
#define FUNC_TMP        11  /* Template				*/
#define FUNC_UM         12  /* Update mode			*/ 
#define FUNC_PV         13  /* Parameter Value			*/
#define FUNC_PT         14  /* Parameter Type			*/
#define FUNC_PL         15  /* Parameter Length			*/
#define FUNC_ND         16  /* Number of Digits = Par. Dec. len	*/
#define FUNC_ZF         17  /* Zero Filled			*/
#define	FUNC_JU		18  /* JUstification			*/
#define	FUNC_IFS	19  /* Inquiry Function Server name	*/
#define	FUNC_IFN	20  /* Inquiry Function Name		*/
#define	FUNC_LI		21  /* List Id				*/
#define	FUNC_OEM	22  /* Offline Error Message		*/
#define	FUNC_OTF	23  /* One Time Field			*/
#define FUNC_TO		24  /* Front end timeout		*/
#define FUNC_MR		25  /* Max. retries			*/

#define REQU_ID         1   /* Field numbers in the DDC_REQUEST message	 */
#define REQU_RE         2   /* from ddc.driver to ddc.server!		 */
#define REQU_RS         3   /* Request state				 */
#define REQU_DC         4   /* DDC Controller time			 */
#define REQU_DT         5   /* DDC Device time				 */
#define REQU_TK         6   /* Transaction key				 */
#define REQU_TV         7   /* Transaction value			 */
#define REQU_R1         8   /* Reserved for future use			 */ 
#define REQU_R2         9   /* Reserved for future use			 */ 
#define REQU_R3         10  /* Reserved for future use			 */ 
#define REQU_DM         11  /* Function server code			 */
#define REQU_FS         12  /* Function name				 */
#define REQU_FN         13  /* Transaction prefix			 */
#define REQU_FP         14  /* 14 and higher are for function parameters */

#define REPL_ID         1   /* Field numbers in the DDC_REPLY message	*/
#define REPL_RE         2   /* from ddc.server to ddc.driver!		*/
#define REPL_ST         3
#define REPL_EN         4
#define REPL_EP         5
#define REPL_TK         6
#define REPL_TV         7   /* Transaction value 			*/ 
#define REPL_R1         8   /* Reserved for future use			*/ 
#define REPL_R2         9   /* Reserved for future use			*/ 
#define REPL_R3         10   /* Reserved for future use			*/ 
#define REPL_FS		11
#define REPL_FN		12
#define REPL_TP         13
#define REPL_EM         14

#define NUMB_GI         1   /* Field numbers in the DDC_NUMBER message	*/
#define NUMB_NU         2   /* from ddc.server to ddc.driver!		*/
#define NUMB_MT         3
#define NUMB_NR         4

#define LSTA_ID         1   /* Field numbers in the DDC_LIST_START msg	*/ 
#define LSTA_LS         2
#define LSTA_LI		3
#define LSTA_LT		4
#define LSTA_LO		5  
#define LSTA_ST		6

#define ELEM_ID         1   /* Field numbers in the DDC_LIST_ELEM msg	*/ 
#define ELEM_EL         2
#define ELEM_LI         3
#define ELEM_AC		4
#define ELEM_LE		5

#define LEND_ID         1   /* Field numbers in the DDC_LIST_END msg	*/ 
#define LEND_LE         2   /* DDC_LIST_END				*/
#define LEND_LI		3   /* List id					*/
#define LEND_TL		4   /* Total number of records			*/
#define LEND_DT		5   /* Download type - 0 full, 1 net change	*/
#define LEND_ST		6   /* List status - 0 complete, 1 aborted	*/

#define INIT_ID         1   /* Field numbers in the DDC_INIT message	*/
#define INIT_IN         2
#define INIT_FN         3   
#define INIT_MN         4   

#define LSTR_ID         1   /* Field numbers in the DDC_LIST_REPEAT msg	*/ 
#define LSTR_LS         2   /* List repeat text				*/
#define LSTR_LI		3   /* List id					*/
#define LSTR_DO		4   /* Download Type - 0 = Full, 1 = Net change */
#define LSTR_DT		5  

#define COMB_ID		1   /* DDC Combined Field Driver Id		*/
#define COMB_IT		2   /* DDC Combined Field text			*/ 
#define COMB_FI		3   /* DDC Combined Field Identification	*/ 
#define COMB_FN		4   /* Function name				*/
#define COMB_FS		5   /* Function server				*/
#define COMB_TP		6   /* Transaction prefix			*/
#define COMB_SN		7   /* Field sequence number			*/

#define LICE_ID         1   /* Field numbers in the DDC_LICENCE msg	*/ 
#define LICE_LI         2
#define LICE_AC         3
#define LICE_NU		4
#define LICE_AN		5

#define DDC_NOWAIT	0
#define DDC_WAIT	1

				/* Variable length defines		*/
#define ID_LEN		14+1	/* Length of a ddc_id			*/
#define	_MNAME		14+1
#define	_LVFNAME	8+1
#define	_IDENT		40+1
#define	_DESCR		40+1
#define _FPREFIX	4+1
#define	_FSERV		14+1
#define	_FNAME		40+1
#define	_GRP_ID		14+1
#define _LISTID		8+1
#define	_PROMPT		32+1
#define	_PVALUE		16+1
#define	_RECLEN		128+1
#define _TEMPLATE	40+1	
#define _DDCTIME	14+1
#define _TRANSKEY	12+1
#define _TRANPREFIX	4+1

				/* Data structure value defines */
#define	STRING_PTYPE	'S'	/* Values for FORM_FIELD->ptype */
#define	DATE_PTYPE	'D'	/* String, date, or numeric	*/
#define	NUM_PTYPE	'N'	
				/* Value for FORM_FIELD justify */
#define	JUS_NONE	0
#define	JUS_LEFT	1	
#define	JUS_RIGHT	2	
#define	JUS_CENTER	3	
				/* Value for FORM_FIELD zerofilled */
#define	ZERO_LEAD	0
#define	ZERO_NOLEAD	1	
				/* Value for FORM_FIELD parvtype */
#define	PVT_INPUT	0
#define	PVT_FIXED	1	
#define	PVT_DEFAULT	2	

				/* Values for REQUEST_FORM request state,
				also used on REPLY_FORM and elsewhere */	
#define STATE_ERROR	-1
#define OFFLINE		0	
#define ONLINE		1		
#define QUERY		2		
#define OFFLINEERROR	3	/* Offline error and resubmit */	

				/* Values for LVF_HEADER storage loc */
#define DDC_DEVICE	0	/* On handheld 			*/
#define DDC_CONTROL	1	/* Managed by controller 	*/
				/* Values for LVF_HEADER downlaod type */
#define DLOAD_FULL	0	/* Full downlaod 		*/
#define DLOAD_CHNG	1	/* Net change 			*/


typedef struct _COMB_FIELD	{
	char 	*field_id,		/* Combined field identifier	*/
		*trans_prefix;		/* Transaction prefix		*/
	int	seqno;			/* Display field number		*/
	struct	_COMB_FIELD	*lnext;	/* Pointer to next comb. field */
}	COMB_FIELD;

typedef struct _FORM_FIELD	{ 
	char	*prompt;		/* Prompt to be displayed (Name)*/
	char	ptype;			/* Parameter type: 
						's'=String,
					   	'd'=Date,
						'n'=Numeric		*/
	char	*pvalue;		/* Parameter value		*/
	int	pseqnr;			/* DDC par. seq. nr.		*/
	int	plen;			/* Total parameter length, incl.
					   decimals			*/
	int	pdlen;			/* Number of decimals for par.	*/
        int	justify;		/* 	0=none,
						1=left,
						2=right,
					   	3=center		*/
	int	zero_filled;		/* 	0=leading zeros,
						1= no leading zeros	*/
	int	par_vtype;		/* Par. value type, 
						0=Input,
					   	1=Fixed Value, 
						2=Default		*/
	char	*listid,		/* List id for lookup table	*/
        	*inqfserv,              /* Name of inq. func. server[14]*/
		*inqfname,              /* Name of inquiry function [40]*/
		*err_msg;		/* Error Message for offline
					   mode				*/
	int	one_time_f;		/* One time field, 
						0=not a 1 time field,
					   	1..12= identification	*/
	char	*field_pre,		/* Field prefix			*/
		*bitmask,		/* Bitmask			*/
		*template;		/* Template			*/
	int	fe_timeout;		/* Front end timeout		*/ 
	int	max_retry;		/* Maximum number of retries	*/ 
	struct	_FORM_FIELD	*lnext;	/* Pointer to next FORM_FIELD	*/
}	FORM_FIELD;

typedef struct {
	char	*fserv,			/* Name of function server [14]	*/
		*fname,			/* Name of function itself [40]	*/
		*trans_pre;		/* Transaction prefix[4]	*/
	int	update_mode,		/* Update mode			
						1 - Online only,
						2 - Offline only,
						3 - Offline or online	*/
		nrpars;			/* The number of parameters 
					   = nr of FORM_FIELDs	    	*/
	FORM_FIELD		*fline;	/* Parameter(s) in FORM	    	*/
	COMB_FIELD		*cfield;/* Pointer to COMB_FIELD information */
}	FORM_HEADER;


typedef struct _MENU_LINE	{
	char	*ident;			/* Identification (e.g. linenr)	*/
	char	*description;		/* Or: description[40]		*/
	struct	_MENU_HEADER	*mhead;	/* menuline is a MENU,		*/
	FORM_HEADER		*fhead;	/* or a FUNCTION.		*/
	struct	_MENU_LINE	*lnext;
}	MENU_LINE;


typedef struct _MENU_HEADER {
	char	*mname;			/* Menu name [14]		*/
	MENU_LINE		*mline;	/* Lines in MENU 		*/
	int	nrlines;		/* Number of menu lines		*/
}	MENU_HEADER;

typedef	struct _MENU_LIST {
	char	*grpident;		/* ddc_group_id, max. char[14]	*/
	MENU_HEADER		*mhead;	/* pointer to menu of group	*/
	struct _MENU_LIST	*lnext;	/* pointer to next group & menu	*/
}	MENU_LIST;


typedef struct _GROUPLIST {
	char	grpident[_GRP_ID];	/* ddc_group_id, max. char[14]	*/
	struct	_GROUPLIST	*lnext;	/* Pointer to next group in list*/
}	GROUPLIST;


typedef struct _TERMINALS {
	char	term_id[ID_LEN];	/* list, max. char[ID_LEN]	*/
	struct	_TERMINALS	*lnext;	/* Pointer to next terminal in	*/
}	TERMINALS;


typedef struct {
	char	*ddc_id;		/* Id. of sending DDC Device	*/
	int	state,			/* 	'0' for offline, 
					   	'1' for online, 
					   	'2' for query		*/
		nr_of_fpars;		/* Number of function parameters*/
	char	*dname,			/* Name of Triton DLL that 
						contains the function
						(Server name)		*/
		*fname,			/* Function to be called	*/
		*device_date,		/* Date/time: yyyymmddhhmmss	*/
		*contr_date,		/* Date/time: yyyymmddhhmmss	*/
		*trans_key,		/* Transaction key		*/
		*trans_prefix,		/* Transaction prefix		*/
		*trans_value,		/* Key reserved for 3rd party use
					    will be filled with same data 
					    as passed in REQUEST_FORM 
					    12 chars in length*/
		*reserved1,		/* Reserved for use by Baan */
		*reserved2,		/* Reserved for use by Baan */	
		*reserved3;		/* Reserved for use by Baan */	
	char	**fpars;		/* NULL terminated list of
					   function parameters		*/
}	REQUEST_FORM;


typedef struct	_REPLY_FORM {
	char	*ddc_id;		/* Id. of receiving DDC Device	*/
	int	state,			/* 	'0' for offline, 
					   	'1' for online, 
					   	'2' for query		*/
		err_no,			/* Returned error number	*/
		err_par;		/* Number of the parameter that
						caused the error	*/
	char	*fserv,			/* Name of function server	*/
		*fname,			/* Name of function itself	*/
		*trans_key,		/* Transaction key		*/
		*trans_prefix,		/* Transaction prefix		*/
		*trans_value,		/* Key reserved for 3rd party use */
		*reserved1,		/* Reserved for use by Baan	*/	
		*reserved2,		/* Reserved for use by Baan	*/
		*reserved3,		/* Reserved for use by Baan	*/
		*err_mess;		/* Error message to print	*/
}	REPLY_FORM;

typedef	struct	_LVF_HEADER	{
	char	*LVFname,		/* Name of the LVF/ listid	*/
		*stime;			/* Start time of download	*/ 
	int	listnum,		/* List number			*/	
		storage_loc;		/* Where to store LVF data
					   0 = DDC Device, 1 DDC Controller */
}	LVF_HEADER;

typedef struct _LVF_REPEAT_FORM	{
	char	*ddc_id,		/* Driver id 			*/
		*LVFname,		/* List id			*/ 
		*dtime;			/* Download time		*/
	int	dtype;			/* Download type		*/
}	LVF_REPEAT_FORM;

#ifdef SGI_MIPS
/* avoid redefinition, semun is already in <sys/sem.h> */
typedef union semun USEMUN;
#else
typedef union semun {
	int		val;
	struct semid_ds	*buf;
	unsigned short	*array;
}	USEMUN;
#endif

typedef struct _QUE_INFO
{
	int		id_in, 
			id_out, 
			id_LVF;
}  QUE_INFO;
	
/* DDC functions written by Baan: */
extern	int		ddc_connect (char *, char *, char *);
extern  int     	ddc_set_separation (char *);
extern	int		ddc_free_menu_memory (MENU_LIST *);
extern	int		ddc_free_REPLY_memory (REPLY_FORM *);
extern	FORM_HEADER	*ddc_get_form (MENU_LINE *);
extern	FORM_FIELD	*ddc_get_form_field (FORM_HEADER *, int);
extern  int		ddc_get_LVFrecord (char *, char *, int, int *, char *);
extern	MENU_HEADER	*ddc_get_mainmenu_entry (char *);
extern	MENU_LINE	*ddc_get_menu_line (MENU_HEADER *, int);
extern  MENU_LIST       *ddc_get_menu_list (void);
extern  int		ddc_get_menus_functions (void);
extern  int		ddc_get_reply (REPLY_FORM **, LVF_HEADER **, LVF_HEADER **, int);
extern	MENU_HEADER	*ddc_get_submenu (MENU_LINE *);
extern	int		ddc_group_selection (GROUPLIST *);
extern	int		ddc_initialise (char *, char *, char *, char *, GROUPLIST *);
extern	int		ddc_is_line_a_function (MENU_LINE *);
extern	int		ddc_is_line_a_submenu (MENU_LINE *);
extern	int		ddc_licence_number_action (int, int);
extern	int		ddc_ready_to_stop (void);
extern	int		ddc_send_request (REQUEST_FORM *);
extern	int		ddc_start_communications (void);
extern	int		ddc_stop_server (void);
extern	int		ddc_terminal_list (TERMINALS *);
extern	int             ddc_get_LVFs_pending (void);
extern	int     	ddc_free_LVF_HEADER_memory (LVF_HEADER *);
extern	int		ddc_send_LVF_repeat (LVF_REPEAT_FORM *);
extern	int 		ddc_free_REQUEST_memory (REQUEST_FORM *);
extern  int     	ddc_free_LVF_REPEAT_memory (LVF_REPEAT_FORM *);
extern 	int		ddc_start_server (char *, char *, char *, char *, char *, char *, char *);
extern 	int		ddc_start_bshell (char *, char *, char *, char *, char *, char *);
extern	int		ddc_create_driver_queues ( char *, char *);
extern	int		ddc_open_server_queue ( char *, int);
extern	int		ddc_init_mem (void);
extern	int		ddc_create_server_queue ( char * );
extern	QUE_INFO	*ddc_open_driver_queues ( char *, char *, int);

#ifdef BDB_API
char *       getvar                  ( char  *name );
#endif

