REM **************************************************************************
REM * File	: spaceV7.sql
REM * Purpose	: show the contents of a specified tablespace
REM * Author	: Peter Romeijn, Baan International b.v.
REM * Date	: Sept 1993
REM **************************************************************************

set verify	off;
set feedback	off;
set pagesize	30;

column segment_name 	format A20;
column segment_type 	format A10	heading "TYPE";
column tablespace_name 	format A10;
column owner		format A10;

accept TABLESPACE prompt 'Enter tablespace: ';

break on owner;
compute sum of BLOCKS on owner;

select owner, segment_name, segment_type, tablespace_name, blocks from sys.dba_segments
where tablespace_name = upper('&TABLESPACE')
order by owner, segment_name;

clear columns;
exit;
