
/*
 * User definitions
 * Copyright Baan Development BV
 */

#ifndef	_USER_H
#define	_USER_H

/*
	Defines for User Dependent Formats (UDF)
*/

#define	UDF_START		0
#define	UDF_COMPANY_DEF		1
#define	UDF_CUR_COMPANY_DEF	2
#define	UDF_CURRENCY		3
#define	UDF_CUR_CURRENCY	4
#define	UDF_DATE		5
#define	UDF_CUR_DATE		6
#define	UDF_TIME		7
#define	UDF_CUR_TIME		8
#define	UDF_TOTAL		9

/*
	Defines for Executes Permissions (exec_perms)
*/

#define EP_OS_SHELL		001	/* '<' optie */
#define EP_SESSION_SHELL	002	/* '<' optie */
#define EP_SESSION_FROM_MENU	004	/* 'P' optie */
#define EP_SESSION_FROM_HELP	010

#define USER_NAME_LEN	8
#define GROUP_NAME_LEN	8

typedef	struct	_USER_INFO	{
	char	user_type;
	UCHAR	exec_perms;
#ifdef __WIN32__
	UCHAR	tss_is_on;	/* Will be removed when Al-merge is complete */
#else
	UCHAR	overbodig__not_used;
#endif
	char	locale[15];
	char	language,
		yes_char,
		no_char,
		datesign,
		timesign,
		duiz_sign,
		decsign,
		time_his,
		first_day_of_week,
		startmenu[17],
		dateformat[7],
		c_dateformat[9],		/* date format incl eeuw */
		formatted_date[9],
		c_formatted_date[11],		/* formatted date format
							incl eeuw */
		user_name[USER_NAME_LEN + 1],
		group_name[GROUP_NAME_LEN + 1],
#ifdef BUG_FIX
		passwd[CRYPT_LEN + 1],
#else
		passwd[32],
#endif
		caut[128],
		p_device[15],
		company[31],
		tty[16];
	char	std_program[17];		/* OBJECT_NAME_LEN + 1 */
	short	compnr,
		btime,
		etime,
		wait_sec;
	char	*appl_server,
		*unix_user_name,
		package_combination[9],
		*format_data[UDF_TOTAL],
		default_date_input_sequence[4],
		default_time_input_sequence[4];
	char	shell_cmd[21];
	UCHAR	max_main_windows;
	short	bdb_check_domain;

	char	overflow_char,
		hide_char,
		noref_char,
		datainput_char;
	short	timer_sec;
	char	**vrc_path;
	short	n_vrc_path;
	short	taut;
	short	dummy;		/* keep colleages friendly */
	UCHAR	ghoststart,	/* ghosts character for data.input	*/
		ghostend;
	int	bidi;		/* Bidirectional true/false		*/
	char	*startprogram;
	char	*startprogram_gui;
	char	*system_shell;	/* UNIX system shell command		*/
}	USER_INFO;

extern	USER_INFO	user_info;

#define OVERFLOW_CHAR (user_info.overflow_char ? user_info.overflow_char : '!')
#define HIDE_CHAR     (user_info.hide_char ? user_info.hide_char : '+')
#define NOREF_CHAR    (user_info.noref_char ? user_info.noref_char : '*')
#define DINP_CHAR     (user_info.datainput_char ? \
				user_info.datainput_char : '.')

/*
	int	init_user() 

	Description:
		Reads in the user file and fill's the USER_INFO structure.
	Return:
		0: Oke
		1: User file not found in $BSE/lib/user
		2: Permission error

	int	init_bshell_user()

	Description:
		See above, but checks also the user type

	int	get_default_currency_code(currency_code)
	char	*currency_code;

	Description:
		fill's the string buffer currency_code
	Return:
		0: Oke
		1: Error not found

	int	get_default_date_code(date_code)
	char	*date_code;

	Description:
		fill's the string buffer date_code
	Return:
		0: Oke
		1: Error not found

	int	get_default_time_code(time_code)
	char	*time_code;

	Description:
		fill's the string buffer time_code
	Return:
		0: Oke
		1: Error not found

	int	get_currency_format(currency_code, no, symbol, format)
	char	*currency_code;
	int	no;
	char	*symbol,
		*format;

	Description:
		Search for currency_code and format number (no) and fill's
		the string buffer symbol and format. If destination adres
		is zero then skip fill action.
	Return:
		0: Oke
		1: Error not found

	int	get_date_format(date_code, no, inputpattern, format)
	char	*currency_code;
	int	no;
	char	*inputpattern,
		*format;

	Description:
		Search for date_code and format number (no) and fill's
		the string buffer inputpattern and format.
		possible values of inputpattern are: DMY (day month and year)
		and DWY (daynumber weeknumber and year) or any combination. If
		destination adres is zero then skip fill action.
	Return:
		0: Oke
		1: Error not found

	int	get_time_format(time_code, no, inputpattern, format)
	char	*time_code;
	int	no;
	char	*inputpattern,
		*format;

	Description:
		Future use.
		If destination adres is zero then skip fill action.
	Return:
		0: Oke
		1: Error not found
*/

/* Function prototypes are in al_proto.h */

#endif
