/************************************************
 * File:   al_msltapi.h				
 * Author: Fritz Berzales			
 *         Chun Zhang				
 *						
 * Date:   01-10-1998					  
 *						
 * Description: Baan Client Phase 2			
 ************************************************/

#ifndef __MSLTAPI_H
#define __MSLTAPI_H
#endif


/* Standard C includes */
#include <stdio.h>
#include <stddef.h>
#include <errno.h>
#include <sys/types.h>
#ifdef _WIN32
#include <windows.h>
#else
#include <sys/ipc.h>
#include <sys/msg.h>
#endif
#include <signal.h>


#ifdef _WIN32
# undef	 getuid
# define getuid() 0
#endif

#ifdef _WIN32
typedef unsigned char   BOOLEAN;
#else
typedef int             BOOLEAN;
#endif

#define __BOOLEAN

#ifndef TRUE
# define TRUE           1
#endif

#ifndef FALSE
# define FALSE           0
#endif

#define OSUSERNAME_SIZE	256
#define PATHNAME_SIZE	1024


/* Api operating modes */
#define COMMUNICATION 0
#define TERMINATION	  1  

#define MAXMSGINQ     244     /* Max. # of msg in queue     */
#define MSGNRS        128     /* Number of messagetypes		*/

#define API_LEVEL	  2		  /* bms comm level				*/
#define PROJ_ID       1		  /* ftok project ID.   		*/

#define MAXMSGLEN     1024    /* Max. length of msg         */
#define HEADERSIZE       5    /* Size of message header 	*/

#define SEPARATION_CHAR '~'	 /* Char. used to seperate data fields */
#define SEPARATION_STR  "~"	 /* Char. used to seperate data fields */

/* Message actions */
#define MSG_BIND  	  	1
#define MSG_INVOKE    	  	2
#define MSG_RELEASE  	  	3
#define MSG_SESSION_EXIT	6
#define MSG_ERROR_API 	  	4	

/* API error codes */
#define FUNCTION_NOT_FOUND	-8

/* Baan Error Offset */
#define	BAAN_ERROR_OFFSET	100

/* String sizes */
#define	STR512	512
#define	STR1K	1024
#define	STR4K	4096

/* API error codes */
#define MESSAGE_OUT_OF_SYNC -1

/* Define Generic log message */
#define APILOGSTART		"******** START of Log message ********"
#define APILOGEND		"********  END of Log message  ********"
#define APIQUEOPEN		"FATAL ERROR - API process failed to open queues."
#define APIINITMSG		"FATAL ERROR - API process passed invalid init. message"
#define APISTART		"API process started for user "
#define APIEXIT 		"API process exited by user "
#define APIFATAL		"FATAL ERROR - API fatal error occurred for user "
#define APINORMAL		"API process received terminate message "
#define APIACTION		"API process received bad action message " 
#define APISESSIONEXIT  "API process recieved SESSION_EXIT message"
#define APIQUESEND		"FATAL ERROR - API queue closed, send failed "
#define APIERROR		"FATAL ERROR - API error occurred for user "
#define APIEMPTY		"      "
#define INITAPINOTSET   "FATAL ERROR - function cs_init_api() not set"
#define TERMNOTSET		"FATAL ERROR - function cs_terminate_api() not set"
#define ARGSNOTSET		"FATAL ERROR - function cs_process_args() not set"
#define ACTNOTSET		"FATAL ERROR - function cs_process_action_message() not set"
#define APISTARS		"*****************************************"


/* Message handling and protocol handling data types and globals */

typedef struct msqid_ds mq_struct;


/**
 * The following for marshalling and
 * unamrshalling data. Users can redefine
 * this to serve their purpose
 */

typedef struct			/* Message header info           	*/ 
{
	int actionType;		/* INIT, ACTION, ...             	*/
	int pid;			/* process id of 3GL session	 	*/
	int objectID;		/* id of this external application	*/
	int numParams;		/* number of parameters		      	*/
	int level;			/* BMS message level for 3GL com    */
}       MSGINFO;		/* Message structure                */

/* Error handling variables and structures */
typedef struct {
        long error_no;              
        char etext[128];
}       EFORM;		/* Error structure */


/* Function pointers for calls into user code */
typedef int  (*INIT_API)();
typedef void (*TERMINATE_API)();
typedef void (*PROCESS_ARGS)(int, char**);
typedef int  (*PROCESS_ACTION_MESSAGE)(char*, int, int);



/****************************************************************
 * Function ProtoTypes
 ****************************************************************/
int     cs_send_params(int, int, int, char*, ...);
void 	cs_start_api(int, char**);
void    cs_api_log_write(char*, char*, int);
int		cs_get_next_field(char*);
void	cs_set_user_funcs(INIT_API, TERMINATE_API, PROCESS_ARGS,
						  PROCESS_ACTION_MESSAGE);

/****************************************************************
 * DLL wrapper prototypes when building on NT
 ****************************************************************/
#ifdef _WIN32
int     csmqdll_send_params(int, int, int, char*, ...);
void 	csmqdll_start_api(int, char**);
void    csmqdll_api_log_write(char*, char*, int);
int		csmqdll_get_next_field(char*);
void	csmqdll_set_user_funcs(INIT_API, TERMINATE_API, PROCESS_ARGS,
								PROCESS_ACTION_MESSAGE);
#endif

