REM **************************************************************************
REM * File	: memV7.sql
REM * Purpose	: show usage of the database files of all tablespaces
REM * Author	: Peter Romeijn, Baan International b.v.
REM * Date	: Sept 1993
REM **************************************************************************

set 	pagesize	30

column file_name 	format a45
column tablespace_name 	format a10
column pct_free 	format 990.99		heading "%free"
column pct_used 	format 990.99		heading "%used"
column total		format 99990.999 	heading "Total Mb"
column free_bytes	format 99990.999 	heading "Free Mb"
column used_bytes	format 99990.999 	heading "Used Mb"

ttitle center 'Database files in use' skip 2
select file_id, tablespace_name, file_name from sys.dba_data_files
order by tablespace_name;

REM *** Comment in if more database files within one tablespace ***
REM break on tablespace_name skip 1;
REM compute sum of total on tablespace_name;
REM compute sum of free_bytes on tablespace_name;
REM compute sum of used_bytes on tablespace_name;

ttitle center 'Free space in database files' skip 2
select d.file_id, d.tablespace_name, d.bytes / 1000000 total, 
        NVL(f.free_bytes,0) / 1000000 free_bytes,
        (d.bytes - NVL(f.free_bytes,0)) / 1000000 used_bytes,
        (NVL(f.free_bytes,0) / d.bytes) * 100 pct_free,
        ((d.bytes - NVL(f.free_bytes,0)) / d.bytes) * 100 pct_used
from	sys.dba_data_files d,
	( select file_id, SUM(bytes) free_bytes from sys.dba_free_space group by file_id ) f
where	d.file_id = f.file_id(+)
order by d.tablespace_name;

ttitle off
clear columns
exit;
