/* 
 * Database commands
 * Copyright 1990-1997 Baan Development BV
 */

#ifndef DBC_BDB_H
#define	DBC_BDB_H	1

#include "system.h"
#include "bdberrno.h"
#include "datadict.h"

/* 
	Commands witch has to be executed bij the server
	Row commands:
*/
#define	DB_FIRST		1
#define	DB_FIRST_U		2
#define	DB_LAST			3
#define	DB_LAST_U		4
#define	DB_NEXT			5
#define	DB_NEXT_U		6
#define	DB_PREV			7
#define	DB_PREV_U		8
#define	DB_GT			9
#define	DB_GT_U			10
#define	DB_GE			11
#define	DB_GE_U			12
#define	DB_EQ			13
#define	DB_EQ_U			14
#define	DB_CURR			15
#define	DB_CURR_U		16
#define	DB_LT			17
#define	DB_LT_U			18
#define	DB_LE			19
#define	DB_LE_U			20
#define	DB_DELETE		21
#define	DB_INSERT		22
#define	DB_UPDATE		23
#define	DB_UPDATE		23
#define	DB_READ			25

#define DB_LOCK_REF		24

#if OPTIM_DELAY
#define DB_PRIM_UPD		25
#define DB_PRIM_DEL		26
#define MAX_ROW_ACTION		26
#else
#define MAX_ROW_ACTION		24
#endif


#define CLIENT_FUNC_OFFSET	30	/* > highest comcode used before */

#define DB_FIRST_D		(CLIENT_FUNC_OFFSET + 1)
#define DB_LAST_D		(CLIENT_FUNC_OFFSET + 2)
#define DB_NEXT_D		(CLIENT_FUNC_OFFSET + 3)
#define DB_PREV_D		(CLIENT_FUNC_OFFSET + 4)
#define DB_GT_D			(CLIENT_FUNC_OFFSET + 5)
#define DB_GE_D			(CLIENT_FUNC_OFFSET + 6)
#define DB_EQ_D			(CLIENT_FUNC_OFFSET + 7)
#define DB_CURR_D		(CLIENT_FUNC_OFFSET + 8)
#define DB_LT_D			(CLIENT_FUNC_OFFSET + 9)
#define DB_LE_D			(CLIENT_FUNC_OFFSET + 10)
#define DB_DELETE_D		(CLIENT_FUNC_OFFSET + 11)
#define DB_UPDATE_D		(CLIENT_FUNC_OFFSET + 12)
#define DB_ROW_CHANGED		(CLIENT_FUNC_OFFSET + 13)

#define FUNC_51_OFFSET		50	/* > highest comcode used before */

#define DB_FIRST_51		(FUNC_51_OFFSET + 1)
#define DB_LAST_51		(FUNC_51_OFFSET + 2)
#define DB_NEXT_51		(FUNC_51_OFFSET + 3)
#define DB_PREV_51		(FUNC_51_OFFSET + 4)
#define DB_GT_51		(FUNC_51_OFFSET + 5)
#define DB_GE_51		(FUNC_51_OFFSET + 6)
#define DB_EQ_51		(FUNC_51_OFFSET + 7)
#define DB_CURR_51		(FUNC_51_OFFSET + 8)
#define DB_LT_51		(FUNC_51_OFFSET + 9)
#define DB_LE_51		(FUNC_51_OFFSET + 10)
#define	DB_DELETE_51		(FUNC_51_OFFSET + 11)
#define	DB_INSERT_51		(FUNC_51_OFFSET + 12)
#define	DB_UPDATE_51		(FUNC_51_OFFSET + 13)
#define	DB_REFCNT_51		(FUNC_51_OFFSET + 14)

#define	DB_U_LOCK		1
#define	DB_D_LOCK		2
#define	DB_FL_LOCK		3



#define BDB_DEFAULT_COMPNR		-1


/*
	Defines for type of commu:
*/
#define	GET_COM_CODE(X)		((X) & 0377)
/*
	Client Get record From Server
*/
#define	BDB_CGFS	(0001<<8)

/*
	Client Send record To Server
*/
#define	BDB_CSTS	(0002<<8)

/*
	Currend record Is Needed
*/
#define	BDB_CIN		(0004<<8)

/*
	Currend record Is Set
*/
#define	BDB_CIS		(0010<<8)

/*
	Currend record Is Locked
*/
#define	BDB_CIL		(0020<<8)

/*
	Set Transaction On
*/
#define	BDB_STO		(0040<<8)

/*
	Not only Allowed in Readonly Mode
*/
#define	BDB_NARM	(0100<<8)

/*
	Not Allowed in Transaction
*/
#define	BDB_NAT		(0200<<8)

/*
	CHecK if record value is according to DD 
*/

#define	BDB_CHK		(00400<<8)

/*
	CHecK if record value is according to DD 
*/

#define	BDB_INS		(01000<<8)

/*
	CHecK if record value is according to DD 
*/

#define	BDB_UPD		(02000<<8)

/*
	CHecK if record value is according to DD 
*/
#define	BDB_DEL		(04000<<8)

/*
	Sequence OPeration
*/
#define	BDB_SIN		(010000<<8)

/*
	Defines for bdb_server_handling:
*/

#define	BDB_CREAT_SERVER_TREE	001
#define	BDB_DROP_SERVER_TREE	002

extern	int	bdb_errno;

/*
	definitions for refer_func options
*/
#define	BDB_CHK_REFER		1
#define	BDB_REC_DEL		2	/* lock */
#define	BDB_REC_UPD		3	/* lock */
#define	BDB_LOCK_REC		4	/* lock */
#define	BDB_PRINT_ROW		5

long	type_commu_row_action ( long command );

#ifndef BDB_H 
/* in general/headers/bdb.h the same struct is defined, so skip this one */

typedef	struct	{
	char		*user_adres;	/* memory user side */
	USHORT		size_entry,	/* number of bytes per entry */
			no_entry;	/* number of entrys */
	char		ext_name[COLUMN_NAME_LEN + 1];
	BDB_TYPE	ext_type;	/* type user side */
	UCHAR		diga,
			rndo;
}	BDB_U_ABIND;

#endif /* BDB_H */
#endif
