/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.tomcat;

import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.tomcat.InstallTomcatAction;
import com.infor.install.tomcat.TomcatProperties;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallableUnits;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.InstallerXML;
import com.infor.install.utils.LogFile;
import com.infor.install.webserver.BaseAdapterAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class TomcatAdapterAction
extends BaseAdapterAction {
    protected String m_TomcatVersion = "";
    private static final String PARAM_NAME = "Parameter";

    protected abstract String getRedirection();

    public boolean skip() {
        return false;
    }

    public void init() throws Exception {
        this.m_DestinationDirectory = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        FindExistingIUs.readExistingIUs((InstallerSupport)this.m_support, (String)this.m_DestinationDirectory);
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)"Tomcat");
        if (installableUnit != null) {
            int n = installableUnit.getVersion().split("\\.").length;
            this.m_TomcatVersion = n < 3 ? "apache-tomcat-" + installableUnit.getVersion() + "." + installableUnit.getBuild() : "apache-tomcat-" + installableUnit.getVersion();
        } else {
            String string = "Tomcat not found";
            LogFile.Log((String)string, (int)10);
            Exception exception = new Exception(string);
            throw exception;
        }
        this.m_iconFile = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/webapps/ROOT/favicon.ico"));
        super.init();
    }

    protected String getPortNumber(String string) {
        String string2 = "";
        String string3 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/conf/server.xml"));
        if (string.equals("WEBSERVER_AJP_PORT")) {
            string2 = InstallTomcatAction.getPortNumber(string3, InstallTomcatAction.WebserverPorts.AJP_PORT);
        } else if (string.equals("WEBSERVER_HTTP_PORT")) {
            string2 = InstallTomcatAction.getPortNumber(string3, InstallTomcatAction.WebserverPorts.HTTP_PORT);
        }
        return string2;
    }

    protected void stopServer() throws Exception {
        InstallableUnits installableUnits = FindExistingIUs.getExistingIUs();
        InstallableUnit installableUnit = installableUnits.containsValue("Key", "Tomcat");
        if (installableUnit == null) {
            return;
        }
        InstallableUnit installableUnit2 = this.m_support.getCurrentIU();
        this.m_support.setCurrentIU(installableUnit);
        TomcatProperties tomcatProperties = new TomcatProperties();
        tomcatProperties.setSupport(this.m_support);
        tomcatProperties.install();
        this.m_support.setCurrentIU(installableUnit2);
        String string = "";
        if (GeneralUtils.isWindows()) {
            String string2;
            string = this.getCorrectServiceName(installableUnit, "SERVICE_NAME");
            if (!string.isEmpty()) {
                this.m_support.setVariable("TOMCAT_SERVICE_NAME", string);
            }
            if (!(string2 = this.getCorrectServiceName(installableUnit, "SERVICE_DISPLAYNAME")).isEmpty()) {
                this.m_support.setVariable("TOMCAT_SERVICE_DISPLAYNAME", string2);
            }
        }
        string = this.m_support.substitute("TOMCAT_SERVICE_NAME");
        InstallTomcatAction.stopTomcat(this.m_DestinationDirectory, this.m_TomcatVersion, string, "", this.m_support);
    }

    protected void postInstall() throws Exception {
        int n = m_InstalledFiles.size();
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        this.createXMLConfigFile();
        if (n != 0 && !this.m_BackupDir.equals("")) {
            this.createBackupXMLForTomcat(installableUnit, this.m_BackupDir);
        }
        String string = this.getRedirection();
        this.setRedirection(this.m_DestinationDirectory, this.m_TomcatVersion, string);
    }

    protected void removeAll() throws Exception {
        String string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_REMOVING_ADAPTER", (String)this.m_iu.getExtendedDesc());
        this.m_support.setProgressStatusText(string);
        String string2 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        Thread.sleep(1000L);
        GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string2), (boolean)false);
        String string3 = this.m_DestinationDirectory + File.separatorChar + this.m_TomcatVersion + File.separatorChar + "work/Catalina/localhost" + File.separatorChar + this.m_iu.getKey();
        GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string3), (boolean)false);
        String string4 = this.getXMLConfigFileName();
        String string5 = this.m_DestinationDirectory + File.separatorChar + this.m_TomcatVersion + File.separatorChar + "conf/Catalina/localhost" + File.separatorChar + string4 + ".xml";
        GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string5), (boolean)false);
    }

    protected String getWebDir() {
        String string = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        return string + File.separator + "web";
    }

    protected void createBackupXMLForTomcat() {
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        if (installableUnit == null) {
            this.createBackupXMLForTomcat(installableUnit, this.m_BackupDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBackupXMLForTomcat(InstallableUnit installableUnit, String string) {
        String string2 = this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/";
        String string3 = this.getXMLConfigFileName();
        String string4 = string3.toLowerCase() + "_" + installableUnit.getVersion() + "_" + installableUnit.getBuild() + "_" + this.m_support.substitute("INSTALLER_PRODUCT_VERSION_NUMBER") + "_" + this.m_support.substitute("INSTALLER_PRODUCT_BUILD_NUMBER");
        String string5 = GeneralUtils.fixFileName((String)(string2 + string3.toLowerCase() + ".xml"));
        String string6 = GeneralUtils.fixFileName((String)(string2 + string4 + ".xm_"));
        String string7 = this.m_DestinationDirectory + File.separator + installableUnit.getKey();
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            GeneralUtils.copyFile((String)string5, (String)string6, (boolean)true);
            bufferedReader = new BufferedReader(new FileReader(string6));
            StringBuffer stringBuffer = new StringBuffer();
            String string8 = "";
            while ((string8 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string8 + GeneralUtils.endLine());
            }
            bufferedReader.close();
            String string9 = stringBuffer.toString();
            string9 = GeneralUtils.replaceAllOccInString((String)string9, (String)string7, (String)string);
            outputStreamWriter = new FileWriter(string6);
            outputStreamWriter.write(string9);
            outputStreamWriter.close();
            LogFile.Log((String)(string6 + " created"), (int)0);
            String string10 = string + File.separator + "UninstallBackup.txt";
            outputStreamWriter = new FileWriter(string10);
            outputStreamWriter.write(string6 + GeneralUtils.endLine());
            outputStreamWriter.write(GeneralUtils.fixFileName((String)(string2 + string4 + ".xml")));
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            LogFile.Log((String)iOException.getMessage(), (int)30);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                LogFile.Log((String)iOException.getMessage(), (int)20, (StackTraceElement[])iOException.getStackTrace());
            }
        }
    }

    protected String getXMLConfigFileName() {
        return this.m_iu.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCorrectServiceName(InstallableUnit installableUnit, String string) throws IOException {
        String string2 = "";
        String string3 = installableUnit.getDir();
        String string4 = string3 + File.separator + "bin" + File.separator + "installTomcatService.bat";
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new FileReader(string4));
            String string5 = bufferedReader.readLine();
            while (string5 != null) {
                String string6 = string5.toLowerCase();
                if (string6.startsWith("set " + string.toLowerCase())) {
                    string2 = GeneralUtils.getPropertyValueFromLine((String)string, (String)string5);
                    break;
                }
                string5 = bufferedReader.readLine();
            }
        }
        return string2;
    }

    private void setRedirection(String string, String string2, String string3) {
        if (string3.equals("")) {
            return;
        }
        String string4 = GeneralUtils.fixFileName((String)(string + "/" + string2));
        String string5 = GeneralUtils.fixFileName((String)(string4 + "/webapps/ROOT/index.html"));
        File file = new File(string5);
        if (this.m_iu.getKey().equals("Webtop") || this.m_iu.getKey().equals("lnui")) {
            String string6 = "<html>" + GeneralUtils.endLine();
            string6 = string6 + "<head>" + GeneralUtils.endLine();
            string6 = string6 + "<meta http-equiv=\"Refresh\" content=\"0; url=/" + string3 + "\" />" + GeneralUtils.endLine();
            string6 = string6 + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">" + GeneralUtils.endLine();
            string6 = string6 + "<title>" + this.m_iu.getExtendedDesc() + "</title>" + GeneralUtils.endLine();
            string6 = string6 + "</head>" + GeneralUtils.endLine();
            string6 = string6 + "<body>" + GeneralUtils.endLine();
            String string7 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_REDIRECT", (String)this.m_iu.getName());
            string6 = string6 + string7 + "<br>" + GeneralUtils.endLine();
            String string8 = "<a href=\"/" + string3 + "\">";
            String string9 = "</a>";
            String string10 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)"M_CLICKHERE", (String[])new String[]{string8, string9});
            string6 = string6 + string10 + GeneralUtils.endLine();
            string6 = string6 + "</body>" + GeneralUtils.endLine();
            string6 = string6 + "</html>" + GeneralUtils.endLine();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string6);
                fileWriter.close();
            }
            catch (IOException iOException) {
                LogFile.Log((String)iOException.getMessage(), (int)20, (StackTraceElement[])iOException.getStackTrace());
            }
        }
    }

    protected void createXMLConfigFile() throws Exception {
        String string = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/"));
        GeneralUtils.createDirectory((String)string);
        try {
            String string2;
            File file;
            long l = 0L;
            String string3 = this.getXMLConfigFileContent();
            String string4 = this.getXMLConfigFileName().toLowerCase() + ".xml";
            int n = string3.lastIndexOf(File.separator);
            if (n >= 0) {
                string4 = string3.substring(n + 1);
            }
            if ((file = new File(string2 = string + string4)).exists()) {
                l = file.lastModified();
            }
            GeneralUtils.copyFile((String)string3, (String)string2, (boolean)true);
            LogFile.Log((String)("File: " + string3), (int)0);
            GeneralUtils.addToVectorIfNotExists((Vector)m_InstalledFiles, (String)string3);
            if (l != 0L) {
                file.setLastModified(l);
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20);
            throw exception;
        }
    }

    public static String getContextParam(InstallerSupport installerSupport, String string) throws Exception {
        String string2 = installerSupport.substitute("INSTALLER_USER_INSTALL_DIR");
        FindExistingIUs.readExistingIUs((InstallerSupport)installerSupport, (String)string2);
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)installerSupport, (String)"Tomcat");
        String string3 = "";
        if (installableUnit == null) {
            String string4 = "Tomcat not found";
            LogFile.Log((String)string4, (int)0);
            return "";
        }
        Object object = installableUnit.getDir();
        string3 = (String)object + File.separator + "conf" + File.separator + "Catalina" + File.separator + "localhost" + File.separator + installerSupport.getCurrentIU().getKey() + ".xml";
        object = new File(string3);
        if (!((File)object).exists()) {
            String string5 = "Xml file : " + string3 + " not found";
            LogFile.Log((String)string5, (int)0);
            return "";
        }
        String string6 = "";
        InstallerXML installerXML = new InstallerXML();
        try {
            Document document = installerXML.readDocument(string3);
            document.getDocumentElement().normalize();
            Element element = document.getDocumentElement();
            boolean bl = false;
            NodeList nodeList = element.getElementsByTagName(PARAM_NAME);
            for (int i = 0; i < nodeList.getLength() && !bl; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string7 = element2.getAttribute("name");
                if (string7 == null || !string7.equals(string)) continue;
                string6 = element2.getAttribute("value");
                LogFile.Log((String)(string + " in " + string3 + " = " + string6), (int)0);
                bl = true;
            }
            if (!bl) {
                LogFile.Log((String)(string + " in " + string3 + " = not found"), (int)30);
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20);
            throw exception;
        }
        return string6;
    }
}

