/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.tomcat;

import com.infor.install.InstallerAction;
import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.actions.FindIUs;
import com.infor.install.tomcat.TomcatProperties;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallableUnits;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.InstallerXML;
import com.infor.install.utils.LogFile;
import com.infor.install.utils.Unpack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstallTomcatAction
extends InstallerAction {
    private static final int TOMCAT6 = 6;
    private static final String MAX_HTTP_HEADER = "maxHttpHeaderSize";
    private static final String KEEP_ALIVE_TIMEOUT = "keepAliveTimeout";
    private static final int KEEP_ALIVE_TIMEOUT_SIZE = 100000;
    private static final int MAX_HTTP_HEADER_SIZE = 16384;
    private static final String COMPRESSION = "compression";
    private static final String COMPRESSIONVALUE = "on";
    private static final String USESENDFILE = "useSendfile";
    private static final String USESENDFILEVALUE = "false";
    private static final String REDIRECTPORT = "redirectPort";
    private static final String PROTOCOL = "protocol";
    private static final String ENABLELOOKUPS = "enableLookups";
    private static final String CONNECTOR = "Connector";
    private String m_TomcatZipFile;
    private String m_TomcatVersion;
    private String m_OldTomcatVersion = "";
    private int m_mainVersion = 0;
    private String m_DestinationDirectory = "";
    private String m_BackupDir = "";
    private String m_HTTP_Port = "";
    private String m_AJP_Port = "";
    private String m_ShutDown_Port = "";
    private String m_Redirect_Port = "";
    private String m_ShortCutDir = "";
    private String m_JDK_Home = "";
    private String m_JRE_Home = "";
    private String m_Java_Home = "";
    private String m_ProductKey = "";
    protected String m_iconFile = "";
    protected String m_TomcatService = "";
    protected String m_TomcatDir = "";
    protected String m_OldTomcatDir = "";
    private static Vector<String> m_InstalledFiles = new Vector();
    private Node m_oldServerSSLConnectionNode = null;

    public boolean skip() {
        return false;
    }

    private void init() {
        File file;
        this.m_DestinationDirectory = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        this.m_TomcatVersion = this.m_support.substitute("TOMCAT_TOMCATVERSION");
        int n = this.m_TomcatVersion.lastIndexOf("-") + 1;
        int n2 = this.m_TomcatVersion.indexOf(".", n);
        this.m_mainVersion = new Integer(this.m_TomcatVersion.substring(n, n2));
        this.m_TomcatDir = this.m_DestinationDirectory + File.separator + this.m_TomcatVersion;
        this.m_HTTP_Port = this.m_support.substitute("TOMCAT_U_HTTP_PORT");
        this.m_ShutDown_Port = this.m_support.substitute("TOMCAT_U_SHUTDOWN_PORT");
        this.m_AJP_Port = this.m_support.substitute("TOMCAT_U_AJP_PORT");
        this.m_ShortCutDir = this.m_support.substitute("INSTALLER_USER_SHORTCUTS");
        this.m_ProductKey = this.m_support.substitute("INSTALLER_PRODUCT_KEY");
        this.m_Java_Home = this.m_support.substitute("INSTALLER_JAVA_HOME");
        String string = this.m_Java_Home + File.separator + "jre";
        String string2 = string + File.separator + "bin" + File.separator + "java";
        if (GeneralUtils.isWindows()) {
            string2 = string2 + ".exe";
        }
        if ((file = new File(string2)).exists() || string2.contains("Bundled_JRE_")) {
            this.m_JDK_Home = this.m_Java_Home;
            this.m_JRE_Home = string;
        } else {
            this.m_JRE_Home = this.m_support.substitute("INSTALLER_JRE_HOME");
        }
        this.m_iconFile = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/webapps/ROOT/favicon.ico"));
    }

    public void install() throws Exception {
        try {
            String string;
            String string2;
            String[] stringArray;
            int n;
            LogFile.Log((String)"Init tomcat installation", (int)0);
            this.init();
            LogFile.Log((String)("Java home: " + this.m_Java_Home), (int)0);
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_READ_INSTALLED_FILES"));
            String string3 = this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "InstalledFiles";
            InstallableUnits installableUnits = FindExistingIUs.getExistingIUs();
            InstallableUnit installableUnit = null;
            if (installableUnits != null) {
                installableUnit = installableUnits.containsValue("Key", "Tomcat");
            }
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_READ_INSTALLED_FILES"));
            if (installableUnit != null) {
                n = installableUnit.getVersion().split("\\.").length;
                this.m_OldTomcatVersion = n < 3 ? "apache-tomcat-" + installableUnit.getVersion() + "." + installableUnit.getBuild() : "apache-tomcat-" + installableUnit.getVersion();
                this.m_OldTomcatDir = this.m_DestinationDirectory + File.separator + this.m_OldTomcatVersion;
                stringArray = InstallTomcatAction.getServiceNames(this.m_support, this.m_OldTomcatDir);
                this.m_TomcatService = stringArray[0];
                string2 = this.m_OldTomcatDir + File.separator + "InstalledFiles";
                InstallerUtils.readInstalledFiles((String)string2, m_InstalledFiles);
                string = this.m_OldTomcatDir + File.separator + "conf" + File.separator + "server.xml";
                this.checkPorts(string);
            } else {
                this.m_TomcatService = this.m_support.substitute("TOMCAT_SERVICE_NAME");
                InstallerUtils.readInstalledFiles((String)string3, m_InstalledFiles);
            }
            n = m_InstalledFiles.size();
            LogFile.Log((String)("Number of existing installed files: " + n), (int)0);
            this.m_support.setProgressStatusText("");
            stringArray = FindIUs.getIUs();
            string2 = stringArray.getPropertyValueForKeyValue("Tomcat", "Dir");
            InstallerUtils.installLanguage((InstallerSupport)this.m_support, (String)string2, (String)this.m_TomcatDir);
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_STOP_WEBSERVER"));
            if (installableUnit != null) {
                LogFile.Log((String)"Remove old Tomcat service", (int)0);
                InstallTomcatAction.removeTomcatService(this.m_DestinationDirectory, this.m_OldTomcatVersion, this.m_TomcatService, "", this.m_support);
            } else if (installableUnits.size() > 0) {
                LogFile.Log((String)"Remove Tomcat service", (int)0);
                InstallTomcatAction.removeTomcatService(this.m_DestinationDirectory, this.m_TomcatVersion, this.m_TomcatService, "", this.m_support);
            }
            this.m_support.setProgressStatusText("");
            if (n != 0) {
                string = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_OldTomcatVersion + File.separator + "conf/server.xml"));
                this.m_oldServerSSLConnectionNode = this.getOldSSLConnectionSettings(string);
                this.m_BackupDir = this.m_DestinationDirectory + File.separator + "Backups" + File.separator + this.m_OldTomcatVersion + "_" + this.m_support.substitute("INSTALLER_PRODUCT_VERSION_NUMBER") + "_" + this.m_support.substitute("INSTALLER_PRODUCT_BUILD_NUMBER");
                this.createBackup();
            }
            InstallerUtils.copyFilesFromCopyList((InstallerSupport)this.m_support, (String)string2, (String)this.m_TomcatDir, m_InstalledFiles);
            LogFile.Log((String)("Number of existing installed files: " + n), (int)0);
            this.updateBatchFiles();
            LogFile.Log((String)"Batch files updated", (int)0);
            this.unzipTomcatFiles();
            string = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/server.xml"));
            this.updateServerXML(string);
            string = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/tomcat-users.xml"));
            this.createTomcatUsersFile(string);
            InstallerUtils.saveInstalledFiles((String)string3, m_InstalledFiles);
            this.createShortcuts();
            InstallTomcatAction.updatePropertiesFile(this.m_support, this.m_DestinationDirectory, this.m_support.getCurrentIU());
            if (this.m_OldTomcatVersion != "" && !this.m_OldTomcatVersion.equals(this.m_TomcatVersion)) {
                this.copyCatalinaConf();
                String string4 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_OldTomcatVersion + "_backup"));
                File file = new File(string4);
                if (file.exists()) {
                    String string5 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_OLD_TOMCAT_BACKUP");
                    this.m_support.setProgressStatusText(string5);
                    GeneralUtils.removeAllFilesAndFolders((String)string4, (boolean)false);
                }
                LogFile.Log((String)("Old shortcut names written to " + this.m_BackupDir + File.separator + "UninstallBackup.txt"), (int)0);
                this.removeShortcuts(this.m_OldTomcatVersion);
                this.m_support.setProgressStatusText("");
            }
            LogFile.Log((String)"Tomcat installed successfully", (int)0);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void uninstall() throws Exception {
        try {
            Object object;
            this.init();
            LogFile.Log((String)"Init tomcat uninstall", (int)0);
            LogFile.Log((String)("Java home: " + this.m_Java_Home), (int)0);
            String string = this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "InstalledFiles";
            File file = new File(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "bin" + File.separator + "bootstrap.jar");
            if (!file.exists()) {
                return;
            }
            String[] stringArray = InstallTomcatAction.getServiceNames(this.m_support, this.m_TomcatDir);
            this.m_TomcatService = stringArray[0];
            String string2 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/conf/server.xml"));
            this.checkPorts(string2);
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_TOMCAT_SERVICE"));
            InstallTomcatAction.removeTomcatService(this.m_DestinationDirectory, this.m_TomcatVersion, this.m_TomcatService, "", this.m_support);
            this.m_support.setProgressStatusText("");
            String string3 = this.m_support.substitute("INSTALLER_U_UNINST_ALL");
            String string4 = this.m_DestinationDirectory + File.separatorChar + this.m_TomcatVersion;
            if (string3.equals("1")) {
                object = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"M_REMOVING_ALL");
                this.m_support.setProgressStatusText((String)object);
                GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string4), (boolean)false);
                this.m_support.setProgressStatusText("");
            } else {
                this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_READ_INSTALLED_FILES"));
                InstallerUtils.readInstalledFiles((String)string, m_InstalledFiles);
                object = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"M_REMOVING_ALL");
                this.m_support.setProgressStatusText((String)object);
                InstallerUtils.removeInstalledFiles(m_InstalledFiles, (String)this.m_ProductKey, (boolean)true);
                m_InstalledFiles = null;
                file = new File(string);
                if (file.exists() && !file.delete()) {
                    LogFile.Log((String)("Cannot delete " + string), (int)30);
                }
            }
            object = new File(this.m_DestinationDirectory);
            class BackupFilter
            implements FilenameFilter {
                BackupFilter() {
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.startsWith("apache-tomcat-") && string.endsWith("_backup");
                }
            }
            BackupFilter backupFilter = new BackupFilter();
            String[] stringArray2 = ((File)object).list(backupFilter);
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_BACKUP"));
            for (int i = 0; i < stringArray2.length; ++i) {
                String string5 = this.m_DestinationDirectory + File.separator + stringArray2[i];
                GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string5), (boolean)false);
            }
            GeneralUtils.removeAllEmptyFolders((String)this.m_TomcatDir, (boolean)false);
            this.m_support.setProgressStatusText("");
            this.removeShortcuts(this.m_TomcatVersion);
            LogFile.Log((String)"Tomcat uninstalled successfully", (int)0);
        }
        catch (Exception exception) {
            String string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_UNINSTALL", (String)"Tomcat");
            LogFile.Log((String)"Error uninstalling Tomcat", (int)20);
            InstallerUtils.abort((InstallerSupport)this.m_support, (String)(string + "; " + exception.getMessage()), (Exception)exception);
        }
    }

    public static void stopTomcat(String string, String string2, String string3, String string4, InstallerSupport installerSupport) throws Exception {
        try {
            if (GeneralUtils.isWindows()) {
                InstallTomcatAction.stopTomcatWindows(string, string2, string3, "Stop", installerSupport);
            } else {
                String string5 = string + File.separator + string2 + File.separator + "bin" + File.separator + "shutdown.sh";
                File file = new File(string5);
                if (file.exists()) {
                    String string6 = string5;
                    LogFile.Log((String)("Stop Tomcat. Command: " + string6), (int)0);
                    InstallTomcatAction.stopTomcat(string6, true, installerSupport);
                }
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20);
            throw exception;
        }
    }

    protected static void updatePropertiesFile(InstallerSupport installerSupport, String string, InstallableUnit installableUnit) throws Exception {
        String string2 = "Properties.txt";
        String string3 = installerSupport.substitute("TOMCAT_TOMCATVERSION");
        String string4 = string + File.separator + string3;
        Properties properties = InstallTomcatAction.getProperties(installerSupport);
        if (properties != null) {
            InstallerUtils.updatePropertiesFile((String)string2, (String)string4, (String)string4, (Properties)properties);
        }
    }

    private static Properties getProperties(InstallerSupport installerSupport) throws Exception {
        Properties properties = TomcatProperties.defineUserPropertiesMap();
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            String string3 = installerSupport.substitute(string2);
            properties2.put(string, string3);
        }
        return properties2;
    }

    public static void removeTomcatService(String string, String string2, String string3, String string4, InstallerSupport installerSupport) throws Exception {
        block4: {
            try {
                if (GeneralUtils.isWindows()) {
                    InstallTomcatAction.stopTomcatWindows(string, string2, string3, "uninstallTomcat", installerSupport);
                    break block4;
                }
                String string5 = string + File.separator + string2 + File.separator + "bin" + File.separator + "shutdown.sh";
                File file = new File(string5);
                if (file.exists()) {
                    InstallTomcatAction.stopTomcat(string5, true, installerSupport);
                    break block4;
                }
                String string6 = string5 + " not found.";
                throw new Exception(string6);
            }
            catch (Exception exception) {
                LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
                throw exception;
            }
        }
    }

    private Node getOldSSLConnectionSettings(String string) {
        InstallerXML installerXML = new InstallerXML();
        try {
            Document document = installerXML.readDocument(string);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName(CONNECTOR);
            NamedNodeMap namedNodeMap = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem(PROTOCOL);
                Node node3 = namedNodeMap.getNamedItem("SSLEnabled");
                if (node2 == null || node3 == null || !node3.getTextContent().toLowerCase().contains("true")) continue;
                return node;
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
        }
        return null;
    }

    public static String getPortNumber(String string, WebserverPorts webserverPorts) {
        String string2 = "";
        InstallerXML installerXML = new InstallerXML();
        try {
            Document document = installerXML.readDocument(string);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Server");
            NamedNodeMap namedNodeMap = null;
            Element element = null;
            NodeList nodeList2 = null;
            Node node = null;
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                switch (webserverPorts) {
                    case SHUTDOWN_PORT: {
                        namedNodeMap = node2.getAttributes();
                        Node node3 = namedNodeMap.getNamedItem("shutdown");
                        if (node3 == null) break;
                        node = namedNodeMap.getNamedItem("port");
                        bl = true;
                        break;
                    }
                    case HTTP_PORT: {
                        Node node4;
                        Node node5;
                        Node node6;
                        int n;
                        element = (Element)node2;
                        nodeList2 = element.getElementsByTagName(CONNECTOR);
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node6 = nodeList2.item(n);
                            namedNodeMap = node6.getAttributes();
                            node5 = namedNodeMap.getNamedItem(PROTOCOL);
                            node4 = namedNodeMap.getNamedItem("SSLEnabled");
                            if (node5 != null) {
                                if (node4 != null && node4.getTextContent().toLowerCase().contains("true") || !node5.getTextContent().toLowerCase().contains("http")) continue;
                                node = namedNodeMap.getNamedItem("port");
                                bl = true;
                                continue;
                            }
                            if (!string.contains("5.5.23")) continue;
                            node = namedNodeMap.getNamedItem("port");
                            bl = true;
                        }
                        break;
                    }
                    case REDIRECT_PORT: {
                        Node node4;
                        Node node5;
                        Node node6;
                        int n;
                        element = (Element)node2;
                        nodeList2 = element.getElementsByTagName(CONNECTOR);
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node6 = nodeList2.item(n);
                            namedNodeMap = node6.getAttributes();
                            node5 = namedNodeMap.getNamedItem(PROTOCOL);
                            node4 = namedNodeMap.getNamedItem("SSLEnabled");
                            if (node5 != null) {
                                if (node4 != null && node4.getTextContent().toLowerCase().contains("true") || !node5.getTextContent().toLowerCase().contains("http")) continue;
                                node = namedNodeMap.getNamedItem(REDIRECTPORT);
                                bl = true;
                                continue;
                            }
                            if (!string.contains("5.5.23")) continue;
                            node = namedNodeMap.getNamedItem(REDIRECTPORT);
                            bl = true;
                        }
                        break;
                    }
                    case AJP_PORT: {
                        Node node5;
                        Node node6;
                        int n;
                        element = (Element)node2;
                        nodeList2 = element.getElementsByTagName(CONNECTOR);
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node6 = nodeList2.item(n);
                            namedNodeMap = node6.getAttributes();
                            node5 = namedNodeMap.getNamedItem(PROTOCOL);
                            if (node5 == null || !node5.getTextContent().contains("AJP")) continue;
                            node = namedNodeMap.getNamedItem("port");
                            bl = true;
                        }
                        break;
                    }
                }
                if (bl) break;
            }
            if (node != null) {
                string2 = node.getTextContent();
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
        }
        return string2;
    }

    protected void checkPorts(String string) throws Exception {
        this.m_ShutDown_Port = InstallTomcatAction.getPortNumber(string, WebserverPorts.SHUTDOWN_PORT);
        if (this.m_ShutDown_Port.equals("")) {
            String string2 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)"E_TOMCAT_PORT", (String[])new String[]{"Shutdown", string});
            throw new Exception(string2);
        }
        this.m_AJP_Port = InstallTomcatAction.getPortNumber(string, WebserverPorts.AJP_PORT);
        if (this.m_AJP_Port.equals("")) {
            String string3 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)"E_TOMCAT_PORT", (String[])new String[]{"AJP", string});
            throw new Exception(string3);
        }
        this.m_HTTP_Port = InstallTomcatAction.getPortNumber(string, WebserverPorts.HTTP_PORT);
        if (this.m_HTTP_Port.equals("")) {
            String string4 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)"E_TOMCAT_PORT", (String[])new String[]{"HTTP", string});
            throw new Exception(string4);
        }
        this.m_Redirect_Port = InstallTomcatAction.getPortNumber(string, WebserverPorts.REDIRECT_PORT);
    }

    public static String[] getServiceNames(InstallerSupport installerSupport, String string) throws Exception {
        String string2 = string + File.separator + "bin" + File.separator + "installTomcatService.bat";
        String string3 = "";
        File file = new File(string2);
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    int n;
                    if (string4.contains("SERVICE_NAME=")) {
                        n = string4.indexOf("=") + 1;
                        string3 = string4.substring(n).trim();
                    }
                    if (string4.contains("SERVICE_DISPLAYNAME=")) {
                        n = string4.indexOf("=") + 1;
                        string3 = string3 + "," + string4.substring(n).trim();
                    }
                    string4 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                LogFile.Log((String)iOException.getMessage(), (int)20, (StackTraceElement[])iOException.getStackTrace());
                throw iOException;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    LogFile.Log((String)("Cannot close " + string2), (int)30);
                }
            }
        }
        return string3.split(",");
    }

    private void unzipTomcatFiles() throws Exception {
        InstallableUnits installableUnits = FindIUs.getIUs();
        String string = installableUnits.getPropertyValueForKeyValue("Tomcat", "Dir");
        LogFile.Log((String)("Tomcat directory: " + string), (int)0);
        this.m_TomcatZipFile = this.m_TomcatVersion + ".zip";
        if (GeneralUtils.isWindows()) {
            this.m_TomcatZipFile = this.m_TomcatVersion + "-windows-x64.zip";
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(GeneralUtils.fixFileName((String)(this.m_TomcatVersion + "/LICENSE")), "1");
        hashtable.put(GeneralUtils.fixFileName((String)(this.m_TomcatVersion + "/NOTICE")), "1");
        hashtable.put(GeneralUtils.fixFileName((String)(this.m_TomcatVersion + "/RELEASE-NOTES")), "1");
        hashtable.put(GeneralUtils.fixFileName((String)(this.m_TomcatVersion + "/webapps/ROOT/favicon.ico")), "1");
        this.m_support.setProgressStatusText(InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"L_INSTALLING", (String)this.m_TomcatZipFile));
        String string2 = this.m_TomcatDir + File.separator + this.m_TomcatZipFile;
        LogFile.Log((String)("Extracting " + string2 + " to " + this.m_DestinationDirectory), (int)0);
        try {
            Unpack unpack = new Unpack(this.m_support, string2, m_InstalledFiles);
            unpack.deflate(this.m_support, this.m_DestinationDirectory, hashtable, this.m_ProductKey);
            unpack.closeArchiveFile();
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        string2 = this.m_TomcatDir + File.separator + this.m_TomcatVersion + ".zip";
        this.removeZipFile(string2);
        string2 = this.m_TomcatDir + File.separator + this.m_TomcatVersion + "-windows-x64.zip";
        this.removeZipFile(string2);
        LogFile.Log((String)"Extraction succeeded", (int)0);
        LogFile.Log((String)GeneralUtils.endLine(), (int)0);
    }

    private void removeZipFile(String string) {
        File file = new File(string);
        if (file.isFile()) {
            String string2 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_DELETING", (String)string);
            this.m_support.setProgressStatusText(string2);
            if (!file.delete()) {
                LogFile.Log((String)("Zip file cannot be deleted: " + string), (int)0);
            }
        } else {
            LogFile.Log((String)("Zip file is no file: " + string), (int)0);
        }
    }

    protected static boolean checkServerRunning(InstallerSupport installerSupport, String string) throws Exception {
        Object object;
        String string2;
        int n = 0;
        String string3 = "";
        ArrayList arrayList = new ArrayList();
        String string4 = "";
        try {
            CharSequence charSequence;
            string3 = string + File.separator + "bin";
            string2 = "checkrunning.bat";
            if (!GeneralUtils.isWindows()) {
                string2 = "checkrunning.sh";
                object = string3 + File.separator + string2;
                charSequence = new StringBuffer();
                FileWriter fileWriter = new FileWriter((String)object);
                ((StringBuffer)charSequence).append("#!/bin/sh").append(GeneralUtils.endLine());
                ((StringBuffer)charSequence).append("ps -ef | grep " + string + "/bin | grep -server | awk '{print $2}'").append(GeneralUtils.endLine());
                fileWriter.write(((StringBuffer)charSequence).toString());
                fileWriter.close();
                LogFile.Log((String)("File created: " + (String)object), (int)0);
                string4 = "ksh " + (String)object;
            } else {
                object = new StringBuffer();
                charSequence = string3 + File.separator + string2;
                FileWriter fileWriter = new FileWriter((String)charSequence);
                ((StringBuffer)object).append("@echo off").append(GeneralUtils.endLine());
                ((StringBuffer)object).append("cd ").append(string3).append(GeneralUtils.endLine());
                ((StringBuffer)object).append("WMIC process where (Name = \"java.exe\" AND CommandLine LIKE \"%%" + InstallTomcatAction.doubleBackslash(string) + "\\\\bin%%\" ) get ProcessId /VALUE").append(GeneralUtils.endLine());
                fileWriter.write(((StringBuffer)object).toString());
                fileWriter.close();
                LogFile.Log((String)("File created: " + (String)charSequence), (int)0);
                string4 = "cmd /c " + string2;
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        try {
            n = GeneralUtils.executeCmd((String)string4, null, (File)new File(string3), (boolean)true, (long)300000L, arrayList);
            if (n == -10001) {
                string2 = "Waited more than 300 seconds for command to complete. " + string4;
                object = new Exception(string2);
                LogFile.Log((String)string2, (int)20, (StackTraceElement[])((Throwable)object).getStackTrace());
                throw object;
            }
            if (n != 0) {
                if (((String)arrayList.get(1)).isEmpty()) {
                    return false;
                }
                string2 = "Error executing " + string4;
                object = new Exception(string2);
                LogFile.Log((String)string2, (int)20, (StackTraceElement[])((Throwable)object).getStackTrace());
                throw object;
            }
            string2 = "0";
            if (GeneralUtils.isWindows()) {
                object = "ProcessId=";
                int n2 = ((String)arrayList.get(0)).indexOf((String)object);
                if (n2 > 0) {
                    string2 = ((String)arrayList.get(0)).substring(n2 += ((String)object).length()).trim();
                }
            } else if (!((String)arrayList.get(0)).isEmpty()) {
                string2 = ((String)arrayList.get(0)).trim();
            }
            if (Integer.parseInt(string2) > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)("Check for running Tomcat failed: " + exception.getMessage()), (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        return false;
    }

    private static void stopTomcatWindows(String string, String string2, String string3, String string4, InstallerSupport installerSupport) throws Exception {
        block8: {
            try {
                File file;
                String string5 = string + File.separator + string2 + File.separator + "bin";
                File file2 = new File(string5);
                if (!file2.exists()) break block8;
                if (GeneralUtils.serviceExists((String)string3, (InstallerSupport)installerSupport)) {
                    InstallerUtils.handleService((InstallerSupport)installerSupport, (String)string5, (String)string3, (String)string4);
                    break block8;
                }
                String string6 = string + File.separator + string2;
                if (!InstallTomcatAction.checkServerRunning(installerSupport, string6) || !(file = new File((string5 = string + File.separator + string2 + File.separator + "bin") + File.separator + "shutdownTomcat.bat")).exists()) break block8;
                File file3 = new File(string5);
                file3.mkdirs();
                String string7 = string5 + File.separator + "shutdown1.bat";
                FileWriter fileWriter = new FileWriter(string7);
                String string8 = "cd " + string5 + GeneralUtils.endLine();
                string8 = string8 + "call shutdownTomcat.bat" + GeneralUtils.endLine();
                string8 = string8 + "exit" + GeneralUtils.endLine();
                fileWriter.write(string8);
                fileWriter.close();
                file2 = new File(string7);
                if (!file2.exists()) break block8;
                String string9 = "\"" + string7 + "\"";
                try {
                    InstallTomcatAction.stopTomcat(string9, true, installerSupport);
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    file2.delete();
                }
            }
            catch (Exception exception) {
                LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
                throw exception;
            }
        }
    }

    private static void stopTomcat(String string, boolean bl, InstallerSupport installerSupport) throws Exception {
        LogFile.Log((String)("Stop Tomcat. Command: " + string), (int)0);
        ArrayList arrayList = new ArrayList();
        int n = GeneralUtils.executeCmd((String)string, null, null, (boolean)bl, (long)300000L, arrayList);
        if (n == -10001) {
            String string2 = "Waited more than 300 seconds for command to complete. " + string;
            Exception exception = new Exception(string2);
            LogFile.Log((String)string2, (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        if (n != 0) {
            String string3 = "Error in command " + string;
            Exception exception = new Exception(string3);
            LogFile.Log((String)string3, (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
    }

    private void updateServerXML(String string) throws Exception {
        try {
            Object object;
            Node node;
            Node node2;
            int n;
            File file = new File(string);
            long l = file.lastModified();
            InstallerXML installerXML = new InstallerXML();
            Document document = installerXML.readDocument(string);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Server");
            NamedNodeMap namedNodeMap = null;
            String string2 = "";
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = nodeList.item(n);
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem("shutdown");
                if (node == null) continue;
                Node node3 = namedNodeMap.getNamedItem("port");
                node3.setTextContent(this.m_ShutDown_Port);
                string2 = "Shutdown";
                object = string2 + " portnumber set to " + this.m_ShutDown_Port + " in " + string;
                LogFile.Log((String)object, (int)0);
            }
            nodeList = document.getElementsByTagName("Service");
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node4;
                node2 = nodeList.item(n);
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem("name");
                if (!node.getTextContent().equals("Catalina")) continue;
                boolean bl = false;
                object = (Element)node2;
                NodeList nodeList2 = object.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    String string3;
                    Node node5 = nodeList2.item(i);
                    if (node5.getNodeType() == 1) {
                        if (!node5.getNodeName().equals(CONNECTOR)) continue;
                        this.handleConnection(document, node5, string);
                        continue;
                    }
                    if (node5.getNodeType() != 8 || !this.isSSLNode(string3 = node5.getTextContent()) || bl) continue;
                    Node node6 = this.addHttpsConnector(string, document, namedNodeMap);
                    if (node6 != null) {
                        Node node7 = nodeList2.item(i + 1);
                        node2.insertBefore(node6, node7);
                    }
                    bl = true;
                }
                if (bl || (node4 = this.addHttpsConnector(string, document, namedNodeMap)) == null) continue;
                node2.appendChild(node4);
            }
            installerXML.writeXMLtoFile(document, file);
            file.setLastModified(l);
            LogFile.Log((String)"Webserver ports updated", (int)0);
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
        }
    }

    private boolean isSSLNode(String string) {
        return string.contains("SSLEnabled=\"true\"") && string.contains("protocol=\"org.apache.coyote.http11.Http11NioProtocol\"");
    }

    private void handleConnection(Document document, Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        Node node3 = namedNodeMap.getNamedItem(PROTOCOL);
        Node node4 = namedNodeMap.getNamedItem("SSLEnabled");
        if (node3 != null) {
            if (node3.getTextContent().toLowerCase().contains("http") && (node4 == null || !node4.getTextContent().toLowerCase().contains("true"))) {
                string3 = this.m_HTTP_Port;
                string2 = "HTTP";
                bl = true;
            }
            if (node3.getTextContent().contains("AJP")) {
                string3 = this.m_AJP_Port;
                string2 = "AJP";
            }
        } else if (string.contains("5.5.23")) {
            string3 = this.m_HTTP_Port;
            string2 = "HTTP";
        }
        if ((node2 = namedNodeMap.getNamedItem("port")) != null && !string3.isEmpty()) {
            node2.setTextContent(string3);
            String string4 = string2 + " portnumber set to " + string3 + " in " + string;
            LogFile.Log((String)string4, (int)0);
            Node node5 = namedNodeMap.getNamedItem(REDIRECTPORT);
            if (node5 != null) {
                node5.setTextContent(this.m_Redirect_Port);
                string4 = "redirectPort set to " + this.m_Redirect_Port + " in " + string;
                LogFile.Log((String)string4, (int)0);
            }
        }
        if (bl) {
            this.handleHttpConnector(string, node, namedNodeMap);
        }
    }

    private void handleHttpConnector(String string, Node node, NamedNodeMap namedNodeMap) {
        String string2;
        if (namedNodeMap.getNamedItem(MAX_HTTP_HEADER) == null) {
            ((Element)node).setAttribute(MAX_HTTP_HEADER, String.valueOf(16384));
            string2 = "maxHttpHeaderSize set to 16384 in " + string;
            LogFile.Log((String)string2, (int)0);
        }
        if (namedNodeMap.getNamedItem(KEEP_ALIVE_TIMEOUT) == null) {
            ((Element)node).setAttribute(KEEP_ALIVE_TIMEOUT, String.valueOf(100000));
            string2 = "keepAliveTimeout set to 100000 in " + string;
            LogFile.Log((String)string2, (int)0);
        }
        if (namedNodeMap.getNamedItem(ENABLELOOKUPS) == null) {
            ((Element)node).setAttribute(ENABLELOOKUPS, USESENDFILEVALUE);
            string2 = "enableLookups set to true in " + string;
            LogFile.Log((String)string2, (int)0);
        }
        this.addCompressionData(namedNodeMap, node);
    }

    private Node addHttpsConnector(String string, Document document, NamedNodeMap namedNodeMap) {
        Element element = null;
        if (this.m_oldServerSSLConnectionNode == null) {
            return null;
        }
        NamedNodeMap namedNodeMap2 = this.m_oldServerSSLConnectionNode.getAttributes();
        Node node = this.m_oldServerSSLConnectionNode.getFirstChild();
        if (node == null) {
            Map.Entry entry2;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("SSLEnabled");
            arrayList.add(COMPRESSION);
            arrayList.add(ENABLELOOKUPS);
            arrayList.add(KEEP_ALIVE_TIMEOUT);
            arrayList.add(MAX_HTTP_HEADER);
            arrayList.add("maxThreads");
            arrayList.add("port");
            arrayList.add("scheme");
            arrayList.add("secure");
            arrayList.add(USESENDFILE);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("certificateVerification", USESENDFILEVALUE);
            hashtable.put("honorCipherOrder", "true");
            hashtable.put("protocols", "TLSv1.2+TLSv1.1");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("ciphers", "ciphers");
            hashtable2.put("sslProtocol", "sslProtocol");
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put("keystoreFile", "certificateKeystoreFile");
            hashtable3.put("keystorePass", "certificateKeystorePassword");
            element = document.createElement(CONNECTOR);
            element.setAttribute(PROTOCOL, "org.apache.coyote.http11.Http11NioProtocol");
            for (String iterator : arrayList) {
                entry2 = namedNodeMap2.getNamedItem(iterator);
                if (iterator.equals("port")) {
                    if (!this.m_Redirect_Port.isEmpty()) {
                        element.setAttribute(iterator, this.m_Redirect_Port);
                        continue;
                    }
                    if (entry2 != null) {
                        element.setAttribute(iterator, entry2.getNodeValue());
                        LogFile.Log((String)("Connector attribute " + iterator + " set to " + entry2.getNodeValue()), (int)0);
                        continue;
                    }
                    LogFile.Log((String)("Connector attribute " + iterator + " not found."), (int)0);
                    continue;
                }
                if (entry2 == null) continue;
                element.setAttribute(iterator, entry2.getNodeValue());
                LogFile.Log((String)("Connector attribute " + iterator + " set to " + entry2.getNodeValue()), (int)0);
            }
            Element element2 = document.createElement("SSLHostConfig");
            element.appendChild(element2);
            for (Map.Entry entry2 : hashtable.entrySet()) {
                element2.setAttribute((String)entry2.getKey(), (String)entry2.getValue());
                LogFile.Log((String)("Host config attribute " + (String)entry2.getKey() + " added and set to " + (String)entry2.getValue()), (int)0);
            }
            for (Map.Entry entry2 : hashtable2.entrySet()) {
                Map.Entry entry3 = namedNodeMap2.getNamedItem((String)entry2.getKey());
                if (entry3 != null) {
                    element2.setAttribute((String)entry2.getValue(), entry3.getNodeValue());
                    LogFile.Log((String)("Host config attribute " + (String)entry2.getKey() + " set to " + (String)entry2.getValue()), (int)0);
                    continue;
                }
                LogFile.Log((String)("Host config attribute " + (String)entry2.getKey() + " not found"), (int)0);
            }
            entry2 = document.createElement("Certificate");
            element2.appendChild((Node)((Object)entry2));
            for (Map.Entry entry3 : hashtable3.entrySet()) {
                Node node2 = namedNodeMap2.getNamedItem((String)entry3.getKey());
                if (node2 != null) {
                    entry2.setAttribute((String)entry3.getValue(), node2.getNodeValue());
                    LogFile.Log((String)("Certificate attribute " + (String)entry3.getValue() + " set to " + namedNodeMap2.getNamedItem((String)entry3.getKey()).getNodeValue()), (int)0);
                    continue;
                }
                LogFile.Log((String)("Certificate attribute " + (String)entry3.getKey() + " not found"), (int)0);
            }
        } else {
            element = (Element)document.adoptNode(this.m_oldServerSSLConnectionNode.cloneNode(true));
        }
        return element;
    }

    private void addCompressionData(NamedNodeMap namedNodeMap, Node node) {
        Node node2 = namedNodeMap.getNamedItem(COMPRESSION);
        if (node2 == null) {
            ((Element)node).setAttribute(COMPRESSION, COMPRESSIONVALUE);
            String string = "compression set to on";
            LogFile.Log((String)string, (int)0);
            ((Element)node).setAttribute(USESENDFILE, USESENDFILEVALUE);
            string = "useSendfile set to false";
            LogFile.Log((String)string, (int)0);
        }
    }

    private void createTomcatUsersFile(String string) throws Exception {
        String string2 = this.m_BackupDir + File.separator + "conf" + File.separator + "tomcat-users.xml";
        GeneralUtils.copyFile((String)string2, (String)string, (boolean)true);
        LogFile.Log((String)("Copied " + string2 + " to " + string), (int)0);
        try {
            int n;
            Object object;
            Node node;
            Object object2;
            Node node2;
            Object object3;
            String string3 = "Adding user \"manager\" in " + string;
            String string4 = "lntomcat";
            String string5 = "lnmanager";
            NamedNodeMap namedNodeMap = null;
            LogFile.Log((String)string3, (int)0);
            File file = new File(string);
            long l = file.lastModified();
            InstallerXML installerXML = new InstallerXML();
            Document document = installerXML.readDocument(string);
            Element element = document.getDocumentElement();
            NodeList nodeList = document.getElementsByTagName("user");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object3 = nodeList.item(i);
                if (object3.getNodeType() != 1 || (node2 = (namedNodeMap = object3.getAttributes()).getNamedItem("username")) == null || !((String)(object2 = node2.getTextContent())).equals("tomcat") && !((String)object2).equals("manager")) continue;
                element.removeChild((Node)object3);
                --i;
            }
            Node node3 = null;
            if (nodeList.getLength() > 0) {
                node3 = nodeList.item(0);
            }
            object3 = document.getElementsByTagName("role");
            if (this.m_mainVersion == 6) {
                string4 = "tomcat";
                string5 = "manager";
            } else {
                string4 = "admin-gui";
                string5 = "manager-gui";
            }
            if (object3.getLength() == 0) {
                node2 = document.createElement("role");
                node2.setAttribute("rolename", string4);
                element.insertBefore(node2, node3);
                object2 = document.createElement("role");
                object2.setAttribute("rolename", string5);
                element.insertBefore((Node)object2, node3);
            } else {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < object3.getLength(); ++i) {
                    node = object3.item(i);
                    namedNodeMap = node.getAttributes();
                    object = namedNodeMap.getNamedItem("rolename");
                    if (object == null) continue;
                    if (object.getTextContent().equals(string4)) {
                        bl = true;
                    }
                    if (!object.getTextContent().equals(string5)) continue;
                    bl2 = true;
                }
                if (!bl) {
                    Element element2 = document.createElement("role");
                    element2.setAttribute("rolename", string4);
                    element.insertBefore(element2, node3);
                }
                if (!bl2) {
                    Element element3 = document.createElement("role");
                    element3.setAttribute("rolename", string5);
                    element.insertBefore(element3, node3);
                }
            }
            boolean bl = false;
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node4 = nodeList.item(n);
                namedNodeMap = node4.getAttributes();
                node = namedNodeMap.getNamedItem("username");
                if (node != null && node.getTextContent().equals("lnmanager")) {
                    bl = true;
                    break;
                }
                object = namedNodeMap.getNamedItem("name");
                if (object == null || !object.getTextContent().equals("lnmanager")) continue;
                bl = true;
                break;
            }
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node5 = nodeList.item(n);
                if (node5.getNodeType() != 1 || (node = (namedNodeMap = node5.getAttributes()).getNamedItem("name")) == null) continue;
                if (!bl) {
                    object = node5.getParentNode();
                    object.removeChild(node5);
                    --n;
                    continue;
                }
                object = (Element)node5;
                object.setAttribute("username", node.getTextContent());
                object.removeAttribute("name");
            }
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node6 = nodeList.item(n);
                if (node6.getNodeType() != 1 || (node = (namedNodeMap = node6.getAttributes()).getNamedItem("username")) == null) continue;
                object = node.getTextContent();
                Element element4 = (Element)node6;
                if (((String)object).equals("lntomcat")) {
                    element4.setAttribute("roles", string4);
                }
                if (!((String)object).equals("lnmanager")) continue;
                element4.setAttribute("roles", string5);
            }
            if (!bl) {
                Element element5 = document.createElement("user");
                element5.setAttribute("username", "lnmanager");
                element5.setAttribute("password", "lnuitje");
                element.appendChild(element5);
                Element element6 = document.createElement("user");
                element6.setAttribute("username", "lntomcat");
                element6.setAttribute("password", "lnuitje");
                element.appendChild(element6);
                if (this.m_mainVersion == 6) {
                    element5.setAttribute("roles", "manager");
                    element6.setAttribute("roles", "manager,tomcat");
                } else {
                    element5.setAttribute("roles", "manager-gui");
                    element6.setAttribute("roles", "admin-gui");
                }
            }
            installerXML.writeXMLtoFile(document, file);
            file.setLastModified(l);
            LogFile.Log((String)"User \"manager\" added successfully", (int)0);
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
    }

    private void createBackup() throws Exception {
        String string;
        String string2;
        File file = new File(this.m_BackupDir);
        if (!file.exists()) {
            file.mkdir();
        }
        if ((file = new File(string2 = this.m_OldTomcatVersion + "_backup")).exists()) {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_BACKUP");
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Remove old backup in " + string2), (int)0);
            GeneralUtils.removeAllFilesAndFolders((String)string2, (boolean)false);
        }
        if ((file = new File(this.m_BackupDir)).exists()) {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_BACKUP");
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Remove old backup in " + this.m_BackupDir), (int)0);
            GeneralUtils.removeAllFilesAndFolders((String)this.m_BackupDir, (boolean)false);
        }
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_CREATE_BACKUP");
        this.m_support.setProgressStatusText(string);
        LogFile.Log((String)("Create backup in " + this.m_BackupDir), (int)0);
        InstallerUtils.copyAllFilesAndFolders((InstallerSupport)this.m_support, (String)this.m_OldTomcatDir, (String)this.m_BackupDir, (boolean)true);
        if (!this.m_OldTomcatDir.equals(this.m_TomcatDir)) {
            GeneralUtils.removeAllFilesAndFolders((String)this.m_OldTomcatDir, (boolean)false);
            m_InstalledFiles = new Vector();
        }
        this.m_support.setProgressStatusText("");
    }

    private void updateBatchFiles() throws Exception {
        String[] stringArray = new String[]{"startupTomcat.bat", "shutdownTomcat.bat", "installTomcatService.bat", "uninstallTomcatService.bat", "startService.bat", "stopService.bat", "setenv.bat", "setenv.sh"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = this.m_TomcatDir + File.separator + "bin" + File.separator + stringArray[i];
            File file = new File(string);
            if (!file.exists()) continue;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = bufferedReader.readLine();
                String string3 = "";
                while (string2 != null) {
                    int n2;
                    if (string2.contains("CATALINA_HOME=")) {
                        n2 = string2.indexOf("=") + 1;
                        string3 = string3 + string2.substring(0, n2);
                        string3 = string3 + this.m_TomcatDir;
                        string3 = string3 + GeneralUtils.endLine();
                    } else if (string2.contains("JAVA_HOME=")) {
                        if (!this.m_JDK_Home.equals("")) {
                            n2 = string2.indexOf("=") + 1;
                            string3 = string3 + string2.substring(0, n2);
                            string3 = string3 + this.m_JDK_Home;
                            string3 = string3 + GeneralUtils.endLine();
                        } else if (!stringArray[i].equals("setenv.bat") && !stringArray[i].equals("setenv.sh")) {
                            n2 = string2.indexOf("=") + 1;
                            string3 = string3 + string2.substring(0, n2);
                            string3 = string3 + this.m_JRE_Home;
                            string3 = string3 + GeneralUtils.endLine();
                        } else {
                            string3 = string3 + string2;
                            string3 = string3 + GeneralUtils.endLine();
                        }
                    } else if (string2.contains("JRE_HOME=")) {
                        if (!this.m_JRE_Home.equals("")) {
                            n2 = string2.indexOf("=") + 1;
                            string3 = string3 + string2.substring(0, n2);
                            string3 = string3 + this.m_JRE_Home;
                            string3 = string3 + GeneralUtils.endLine();
                        } else {
                            string3 = string3 + string2;
                            string3 = string3 + GeneralUtils.endLine();
                        }
                    } else if (string2.contains("SERVICE_NAME=")) {
                        n2 = string2.indexOf("=") + 1;
                        string3 = string3 + string2.substring(0, n2);
                        string3 = string3 + this.m_support.substitute("TOMCAT_SERVICE_NAME");
                        string3 = string3 + GeneralUtils.endLine();
                    } else if (string2.contains("TOMCATVERSION=")) {
                        n2 = string2.indexOf("=") + 1;
                        string3 = string3 + string2.substring(0, n2);
                        String string4 = this.m_support.substitute("TOMCAT_TOMCATVERSION");
                        int n3 = string4.lastIndexOf("-");
                        int n4 = string4.indexOf(".", n3);
                        String string5 = string4.substring(n3 + 1, n4);
                        string3 = string3 + string5;
                        string3 = string3 + GeneralUtils.endLine();
                    } else if (string2.contains("SERVICE_DISPLAYNAME=")) {
                        n2 = string2.indexOf("=") + 1;
                        string3 = string3 + string2.substring(0, n2);
                        string3 = string3 + this.m_support.substitute("TOMCAT_SERVICE_DISPLAYNAME");
                        string3 = string3 + GeneralUtils.endLine();
                    } else if (string2.contains("SERVICE_DESCRIPTION=")) {
                        n2 = string2.indexOf("=") + 1;
                        string3 = string3 + string2.substring(0, n2);
                        string3 = string3 + this.m_support.substitute("TOMCAT_SERVICE_DESCRIPTION");
                        string3 = string3 + GeneralUtils.endLine();
                    } else {
                        string3 = string3 + string2;
                        string3 = string3 + GeneralUtils.endLine();
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
                FileWriter fileWriter = new FileWriter(string);
                fileWriter.write(string3);
                fileWriter.close();
                GeneralUtils.addToVectorIfNotExists(m_InstalledFiles, (String)string);
                continue;
            }
            catch (IOException iOException) {
                LogFile.Log((String)iOException.getMessage(), (int)20, (StackTraceElement[])iOException.getStackTrace());
                throw iOException;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    LogFile.Log((String)("Cannot close " + string), (int)30);
                }
            }
        }
    }

    private void createShortcuts() {
        Object object;
        String string;
        this.removeShortcuts(this.m_OldTomcatVersion);
        String string2 = GeneralUtils.fixFileName((String)(this.m_ShortCutDir + File.separator + this.m_TomcatVersion));
        String string3 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_TOMCAT_MANAGER") + " (on port " + this.m_HTTP_Port + ")";
        if (!GeneralUtils.isWindows()) {
            string = GeneralUtils.fixFileName((String)(string2 + File.separator + string3));
            object = new File(string + ".lnk");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            string3 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_TOMCAT_MANAGER") + "_(on_port_" + this.m_HTTP_Port + ")";
        }
        string = "http://localhost:" + this.m_HTTP_Port + "/manager/html";
        object = "Create shortcut: " + string2 + " to " + string;
        LogFile.Log((String)object, (int)0);
        File file = new File(string2);
        file.mkdirs();
        this.removeOldStyleShortcut(string2, InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_TOMCAT_MANAGER"), true);
        GeneralUtils.CreateInternetShortcut((String)(string2 + File.separator + string3), (String)string, (String)this.m_iconFile);
        String string4 = this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "bin";
        Hashtable<String, String> hashtable = GeneralUtils.isWindows() ? this.getShortcutFiles() : this.getLinkFiles();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = enumeration.nextElement();
            String string6 = hashtable.get(string5);
            string3 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)string6) + " (on port " + this.m_HTTP_Port + ")";
            this.removeOldStyleShortcut(string2, InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)string6), false);
            String string7 = string4 + File.separator + string5;
            GeneralUtils.deleteFile((File)new File(string2 + File.separator + string3 + ".url"), (boolean)false);
            String string8 = string2 + File.separator + string3 + ".lnk";
            String string9 = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
            String string10 = this.m_support.substitute("INSTALLER_PRODUCT_KEY");
            String string11 = string9 + File.separator + "Uninstall_" + string10 + File.separator + "resources";
            GeneralUtils.CreateShortcut((String)string11, (String)string8, (String)"C", (String)string7, (String)string4, (String)"1", (String)this.m_iconFile, null, null, null);
        }
    }

    private void removeOldStyleShortcut(String string, String string2, boolean bl) {
        String string3 = GeneralUtils.fixFileName((String)(string + File.separator + string2));
        if (GeneralUtils.isWindows() && bl) {
            String string4 = string3 + ".url";
            File file = new File(string4);
            String string5 = GeneralUtils.getURLFromInternetShortcut((File)file);
            if (string5.contains(":" + this.m_HTTP_Port)) {
                file.delete();
            }
        } else {
            String string6 = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
            File file = new File(string3 + ".lnk");
            String string7 = GeneralUtils.getTargetDirFromShortcut((File)file);
            if (string7.startsWith(string6)) {
                file.delete();
            }
        }
    }

    private Hashtable<String, String> getShortcutFiles() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_INSTALL_SERVICE");
        hashtable.put("installTomcatService.bat", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_UNINSTALL_SERVICE");
        hashtable.put("uninstallTomcatService.bat", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_START_SERVICE");
        hashtable.put("startService.bat", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_STOP_SERVICE");
        hashtable.put("stopService.bat", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_STARTUP_TOMCAT");
        hashtable.put("startupTomcat.bat", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_SHUTDOWN_TOMCAT");
        hashtable.put("shutdownTomcat.bat", string);
        return hashtable;
    }

    private Hashtable<String, String> getLinkFiles() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_STARTUP");
        hashtable.put("startup.sh", string);
        string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_SHUTDOWN");
        hashtable.put("shutdown.sh", string);
        return hashtable;
    }

    private boolean removeShortcuts(String string) {
        Object object;
        String string2;
        String string3 = this.m_ShortCutDir + File.separator + string;
        boolean bl = true;
        Hashtable<String, String> hashtable = GeneralUtils.isWindows() ? this.getShortcutFiles() : this.getLinkFiles();
        Object object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            string2 = object2.nextElement();
            object = hashtable.get(string2);
            this.removeOldStyleShortcut(string3, (String)object, false);
            String string4 = string3 + File.separator + (String)object + " (on port " + this.m_HTTP_Port + ")";
            string4 = string4 + ".lnk";
            LogFile.Log((String)("Remove shortcut: " + string4), (int)0);
            File file = new File(string4);
            if (!file.exists() || GeneralUtils.deleteFile((File)file, (boolean)false)) continue;
            LogFile.Log((String)("Cannot delete " + string4), (int)30);
            bl = false;
        }
        object2 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_TOMCAT_MANAGER");
        this.removeOldStyleShortcut(string3, (String)object2, true);
        string2 = string3 + File.separator + (String)object2 + " (on port " + this.m_HTTP_Port + ")";
        string2 = GeneralUtils.isWindows() ? string2 + ".url" : string2 + ".lnk";
        object = new File(string2);
        LogFile.Log((String)("Remove shortcut: " + string2), (int)0);
        if (((File)object).exists() && !GeneralUtils.deleteFile((File)object, (boolean)false)) {
            LogFile.Log((String)("Cannot delete " + string2), (int)30);
            bl = false;
        }
        if (!GeneralUtils.removeAllEmptyFolders((String)string3, (boolean)false)) {
            bl = false;
        }
        return bl;
    }

    private static String doubleBackslash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void handleException(Exception exception) throws Exception {
        String string = "";
        LogFile.Log((String)exception.getMessage(), (int)10);
        if (this.m_support == null) {
            string = "Support instance is null";
            LogFile.Log((String)string, (int)10);
        } else if (this.m_DestinationDirectory == null || this.m_DestinationDirectory.equals("")) {
            string = "Destination directorty not set";
            LogFile.Log((String)string, (int)10);
        } else if (this.m_TomcatVersion == null || this.m_TomcatVersion.equals("")) {
            string = "Tomcat version not set";
            LogFile.Log((String)string, (int)10);
        } else {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"E_TOMCAT_INSTALL_ERROR");
        }
        InstallerUtils.abort((InstallerSupport)this.m_support, (String)(string + "; " + exception.getMessage()), (Exception)exception);
    }

    private void copyCatalinaConf() {
        block3: {
            String string = this.m_BackupDir + File.separator + "conf" + File.separator + "Catalina";
            String string2 = this.m_TomcatDir + File.separator + "conf" + File.separator + "Catalina";
            InstallableUnits installableUnits = FindExistingIUs.getExistingIUs();
            String string3 = "";
            String string4 = "";
            try {
                InstallerUtils.copyAllFilesAndFolders((InstallerSupport)this.m_support, (String)string, (String)string2, (boolean)true);
                for (int i = 0; i < installableUnits.size(); ++i) {
                    InstallableUnit installableUnit = (InstallableUnit)installableUnits.elementAt(i);
                    if (!installableUnit.getType().equals("adapter")) continue;
                    string3 = GeneralUtils.fixFileName((String)(string + File.separator + "localhost" + File.separator + installableUnit.getName().toLowerCase() + ".xml"));
                    string4 = GeneralUtils.fixFileName((String)(string2 + File.separator + "localhost" + File.separator + installableUnit.getName().toLowerCase() + ".xml"));
                    GeneralUtils.copyFile((String)string3, (String)string4, (boolean)true);
                    GeneralUtils.addToVectorIfNotExists(m_InstalledFiles, (String)string4);
                    LogFile.Log((String)(string3 + " copied to " + string4), (int)0);
                }
            }
            catch (Exception exception) {
                String string5 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)"E_COPY_FROM_TO", (String[])new String[]{string3, string4});
                LogFile.Log((String)("Error copying from " + string3 + " to " + string4), (int)20, (StackTraceElement[])exception.getStackTrace());
                if (this.m_support == null) break block3;
                String string6 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_ERROR");
                InstallerUtils.ShowMessage((InstallerSupport)this.m_support, (String)string6, (String)string5);
            }
        }
    }

    protected void backupOldShortcuts() {
    }

    public static enum WebserverPorts {
        HTTP_PORT,
        AJP_PORT,
        SHUTDOWN_PORT,
        REDIRECT_PORT;

    }
}

