/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.webserver;

import com.infor.install.InstallerAction;
import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.LogFile;
import com.infor.install.utils.Unpack;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class BaseAdapterAction
extends InstallerAction {
    protected String m_DestinationDirectory = "";
    protected String m_BackupDir = "";
    protected String m_ProductKey = "";
    protected String m_AJP_Port = "";
    protected String m_configDir = "";
    protected String m_HTTP_PortNo = "";
    protected String m_ShortcutDir = "";
    protected static Vector<String> m_InstalledFiles = null;
    protected String m_iconFile = "";
    protected InstallableUnit m_iu = null;
    protected boolean m_rollback = false;
    protected int m_orgNumInstalledFiles = 0;

    protected abstract void addPathToBackupFilter(String var1, Vector<String> var2) throws Exception;

    protected abstract void preInstall() throws Exception;

    protected abstract void postInstall() throws Exception;

    protected abstract void preUninstall() throws Exception;

    protected abstract void postUninstall() throws Exception;

    protected abstract String getXMLConfigFileContent() throws Exception;

    protected abstract Hashtable<String, String> getIgnoreTable() throws Exception;

    @Deprecated
    protected abstract void preRollback() throws Exception;

    @Deprecated
    protected abstract void postRollback() throws Exception;

    protected abstract String onError() throws Exception;

    protected abstract String getPortNumber(String var1);

    protected abstract void stopServer() throws Exception;

    protected abstract void removeAll() throws Exception;

    protected abstract String getWebDir();

    protected abstract String getLoginURL(InstallableUnit var1);

    protected abstract String getSelectedDependency();

    protected abstract boolean doBackup();

    public boolean skip() {
        return false;
    }

    public void init() throws Exception {
        this.m_iu = this.m_support.getCurrentIU();
        this.m_DestinationDirectory = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        FindExistingIUs.readExistingIUs((InstallerSupport)this.m_support, (String)this.m_DestinationDirectory);
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        if (installableUnit != null) {
            this.m_BackupDir = this.m_DestinationDirectory + File.separator + "Backups" + File.separator + this.m_iu.getKey() + "_" + installableUnit.getVersion() + "_" + installableUnit.getBuild() + "_" + this.m_support.substitute("INSTALLER_PRODUCT_VERSION_NUMBER") + "_" + this.m_support.substitute("INSTALLER_PRODUCT_BUILD_NUMBER");
        }
        this.m_ProductKey = this.m_support.substitute("INSTALLER_PRODUCT_KEY");
        this.m_AJP_Port = this.getPortNumber("WEBSERVER_AJP_PORT");
        this.m_HTTP_PortNo = this.getPortNumber("WEBSERVER_HTTP_PORT");
        this.m_ShortcutDir = this.m_support.substitute("INSTALLER_USER_SHORTCUTS");
        m_InstalledFiles = new Vector();
    }

    public void install() throws Exception {
        try {
            this.init();
            LogFile.Log((String)"------", (int)0);
            String string = "Start Adapter installation";
            LogFile.Log((String)string, (int)0);
            string = "Init adapter install: " + this.m_iu.getExtendedDesc();
            LogFile.Log((String)string, (int)0);
            string = "Short name Adapter: " + this.m_iu.getKey();
            LogFile.Log((String)string, (int)0);
            string = "Type adapter: " + this.m_iu.getType();
            LogFile.Log((String)string, (int)0);
            string = "Adapter dir: " + this.m_iu.getDir();
            LogFile.Log((String)string, (int)0);
            String string2 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + File.separator + "InstalledFiles";
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_READ_INSTALLED_FILES"));
            InstallerUtils.readInstalledFiles((String)string2, m_InstalledFiles);
            this.m_orgNumInstalledFiles = m_InstalledFiles.size();
            this.m_support.setProgressStatusText("");
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_STOP_WEBSERVER"));
            this.stopServer();
            this.preInstall();
            if (this.m_orgNumInstalledFiles != 0 && !this.m_BackupDir.equals("")) {
                if (this.doBackup()) {
                    this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_CREATE_BACKUP"));
                    this.createBackup();
                }
                this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_WEBDIR"));
                this.removeWebDir();
                this.m_support.setProgressStatusText("");
            }
            this.m_rollback = true;
            String string3 = this.m_iu.getDir();
            String string4 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
            string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"L_COPY_FROMCOPYLIST", (String)this.m_iu.getExtendedDesc());
            this.m_support.setProgressStatusText(string);
            InstallerUtils.copyFilesFromCopyList((InstallerSupport)this.m_support, (String)string3, (String)string4, m_InstalledFiles);
            InstallerUtils.installLanguage((InstallerSupport)this.m_support, (String)string3, (String)string4);
            this.RemoveMultipleDependencies();
            string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_INSTALLING", (String)this.m_iu.getExtendedDesc());
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Installing: " + this.m_iu.getExtendedDesc()), (int)0);
            this.deployWARFile();
            this.m_rollback = false;
            this.m_configDir = this.createConfigDir();
            this.postInstall();
            this.createAdapterShortcut();
            this.m_support.setProgressStatusText(InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_LIST_INSTALLED_FILES"));
            InstallerUtils.saveInstalledFiles((String)string2, m_InstalledFiles);
            this.m_support.setProgressStatusText("");
            string = this.m_iu.getExtendedDesc() + " installed successfully.";
            LogFile.Log((String)string, (int)0);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void uninstall() throws Exception {
        try {
            this.init();
            this.stopServer();
            String string = "Init adapter uninstall: " + this.m_iu.getExtendedDesc();
            LogFile.Log((String)string, (int)0);
            this.preUninstall();
            this.removeOldStyleShortcut();
            this.removeSmartLinks();
            String string2 = this.m_support.substitute("INSTALLER_U_UNINST_ALL");
            if (string2.equals("1")) {
                this.removeAll();
            } else {
                this.removeInstalledFiles();
            }
            String string3 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + "_backup";
            GeneralUtils.removeAllFilesAndFolders((String)GeneralUtils.fixFileName((String)string3), (boolean)false);
            String string4 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
            GeneralUtils.removeAllEmptyFolders((String)string4, (boolean)false);
            this.postUninstall();
            string = this.m_iu.getExtendedDesc() + " uninstalled successfully";
            LogFile.Log((String)string, (int)0);
        }
        catch (Exception exception) {
            String string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_UNINSTALL", (String)this.m_iu.getExtendedDesc());
            LogFile.Log((String)("Error uninstalling " + this.m_iu.getExtendedDesc()), (int)10);
            InstallerUtils.abort((InstallerSupport)this.m_support, (String)(string + "; " + exception.getMessage()), (Exception)exception);
        }
    }

    protected void removeInstalledFiles() throws IOException {
        String string = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + File.separator + "InstalledFiles";
        String string2 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"M_READ_INSTALLED_FILES");
        this.m_support.setProgressStatusText(string2);
        InstallerUtils.readInstalledFiles((String)string, m_InstalledFiles);
        this.m_support.setProgressStatusText("");
        string2 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_REMOVING_ADAPTER", (String)this.m_iu.getExtendedDesc());
        this.m_support.setProgressStatusText(string2);
        String string3 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + File.separator + "config";
        int n = m_InstalledFiles.size();
        Vector vector = (Vector)m_InstalledFiles.clone();
        for (int i = 0; i < n; ++i) {
            String string4 = (String)vector.elementAt(i);
            if (!string4.contains(string3)) continue;
            vector.removeElementAt(i);
            --i;
            --n;
        }
        InstallerUtils.removeInstalledFiles((Vector)vector, (String)this.m_ProductKey, (boolean)true);
        m_InstalledFiles = null;
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            LogFile.Log((String)("Cannot remove " + string), (int)30);
        }
    }

    public void deployWARFile() throws Exception {
        String string = this.createAdapterDir();
        String string2 = this.getWebDir();
        File file = new File(string2);
        file.mkdirs();
        String string3 = GeneralUtils.fixFileName((String)(string + File.separatorChar + this.m_iu.getKey().toLowerCase() + ".war"));
        String string4 = "Deploying " + string3 + " to adapterDir";
        LogFile.Log((String)string4, (int)0);
        Unpack unpack = new Unpack(this.m_support, string3, m_InstalledFiles);
        Hashtable<String, String> hashtable = this.getIgnoreTable();
        unpack.deflate(this.m_support, string2, hashtable, this.m_ProductKey);
        unpack.closeArchiveFile();
        File file2 = new File(string3);
        if (file2.isFile()) {
            string4 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"M_DELETING", (String)string3);
            this.m_support.setProgressStatusText(string4);
            if (!file2.delete()) {
                string4 = "War file cannot be deleted: " + string3;
                LogFile.Log((String)string4, (int)0);
            }
            this.m_support.setProgressStatusText("");
        } else {
            string4 = "War file is no file: " + string3;
            LogFile.Log((String)string4, (int)0);
        }
        LogFile.Log((String)"Deployment succeeded", (int)0);
    }

    protected void createAdapterShortcut() {
        Object object;
        Object object2;
        this.removeOldStyleShortcut();
        String string = "";
        String string2 = ".url";
        if (!GeneralUtils.isWindows()) {
            object2 = GeneralUtils.fixFileName((String)(this.m_ShortcutDir + File.separator + this.m_iu.getName() + " (on port " + this.m_HTTP_PortNo + ")"));
            object = new File((String)object2 + ".lnk");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            string = GeneralUtils.fixFileName((String)(this.m_ShortcutDir + File.separator + this.m_iu.getName() + "_(on_port_" + this.m_HTTP_PortNo + ")"));
            string2 = ".lnk";
        } else {
            string = GeneralUtils.fixFileName((String)(this.m_ShortcutDir + File.separator + this.m_iu.getName() + " (on port " + this.m_HTTP_PortNo + ")"));
        }
        object2 = new File(string + string2);
        if (((File)object2).exists()) {
            ((File)object2).delete();
        }
        object = this.getLoginURL(this.m_iu);
        String string3 = "Create shortcut: " + string + " to " + (String)object;
        LogFile.Log((String)string3, (int)0);
        GeneralUtils.createDirectory((String)string);
        GeneralUtils.CreateInternetShortcut((String)string, (String)object, (String)this.m_iconFile);
    }

    protected void removeOldStyleShortcut() {
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        if (installableUnit != null) {
            String string = GeneralUtils.fixFileName((String)(this.m_ShortcutDir + File.separator + installableUnit.getName()));
            if (GeneralUtils.isWindows()) {
                String string2 = string + ".url";
                File file = new File(string2);
                String string3 = GeneralUtils.getURLFromInternetShortcut((File)file);
                if (string3.contains(":" + this.m_HTTP_PortNo)) {
                    file.delete();
                }
            } else {
                File file = new File(string + ".lnk");
                if (file.exists()) {
                    file.delete();
                }
            }
        }
    }

    protected void RemoveMultipleDependencies() {
        Object object2;
        boolean bl = true;
        String string = "";
        Vector vector = this.m_iu.getDependencyList();
        String string2 = this.getSelectedDependency();
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        for (Object object2 : vector) {
            boolean bl2 = false;
            if (!((InstallableUnit.Depend)object2).required) {
                bl = false;
                if (((InstallableUnit.Depend)object2).key.startsWith(string2)) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            string = string + ((InstallableUnit.Depend)object2).key + ":" + ((InstallableUnit.Depend)object2).version + ":" + ((InstallableUnit.Depend)object2).build + ":" + ((InstallableUnit.Depend)object2).iubuild + ";";
        }
        if (bl) {
            return;
        }
        string = " " + string.substring(0, string.length() - 1);
        String string3 = "InstallableUnit.info";
        object2 = new Properties();
        ((Properties)object2).put("Depends", string);
        String string4 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        try {
            InstallerUtils.updatePropertiesFile((String)string3, (String)string4, (String)string4, (Properties)object2);
        }
        catch (Exception exception) {
            LogFile.Log((String)("Error updating of dependencies in " + string4 + File.separator + (String)string3), (int)30, (StackTraceElement[])exception.getStackTrace());
        }
    }

    private String createAdapterDir() {
        String string = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    private String createConfigDir() {
        String string = this.m_DestinationDirectory + File.separatorChar + this.m_iu.getKey() + File.separatorChar + "config";
        File file = new File(string + File.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        int n = string.length() - 1;
        String string2 = "";
        if (n >= 0) {
            string2 = string2 + string.charAt(n);
        }
        if (string2 != File.separator) {
            string = string + File.separator;
        }
        return string;
    }

    private boolean removeSmartLinks() {
        String string = "";
        string = GeneralUtils.isWindows() ? this.m_ShortcutDir + File.separator + this.m_iu.getName().toLowerCase() + " (on port " + this.m_HTTP_PortNo + ")" + ".url" : this.m_ShortcutDir + File.separator + this.m_iu.getName().toLowerCase() + " (on port " + this.m_HTTP_PortNo + ")" + ".lnk";
        String string2 = "Remove shortcut: " + string;
        LogFile.Log((String)string2, (int)0);
        return GeneralUtils.deleteFile((File)new File(string), (boolean)false);
    }

    private void createBackup() throws Exception {
        String string;
        String string2 = this.m_DestinationDirectory + File.separator + "Backups";
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        String string3 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        String string4 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + "_backup";
        file = new File(string4);
        if (file.exists()) {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_BACKUP");
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Remove backup in " + string4), (int)0);
            GeneralUtils.removeAllFilesAndFolders((String)string4, (boolean)false);
        }
        if ((file = new File(this.m_BackupDir)).exists()) {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_REMOVE_BACKUP");
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Remove backup in " + this.m_BackupDir), (int)0);
            GeneralUtils.removeAllFilesAndFolders((String)this.m_BackupDir, (boolean)false);
        }
        if (!this.m_BackupDir.equals("")) {
            string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_CREATE_BACKUP");
            this.m_support.setProgressStatusText(string);
            LogFile.Log((String)("Create backup in " + this.m_BackupDir), (int)0);
            Vector<String> vector = new Vector<String>();
            this.addPathToBackupFilter(string3, vector);
            long l = InstallerUtils.getNumFilesInPath((String)string3);
            InstallerUtils.copyAllFilesAndFoldersWithFilterAndProgress((InstallerSupport)this.m_support, (String)string3, (String)this.m_BackupDir, vector, (boolean)true, (long)l, (long)0L);
        }
    }

    private void removeWebDir() {
        String string = this.getWebDir();
        GeneralUtils.removeAllFilesAndFolders((String)string, (boolean)false);
    }

    private void handleException(Exception exception) throws Exception {
        String string = "";
        LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
        try {
            if (this.m_support == null) {
                LogFile.Log((String)"support instance is null", (int)10);
            } else if (this.m_DestinationDirectory == null || this.m_DestinationDirectory.equals("")) {
                LogFile.Log((String)"destination directorty not set", (int)10);
            } else if (this.m_iu == null || this.m_iu.getKey().equals("")) {
                LogFile.Log((String)"IU not set", (int)10);
            } else {
                string = this.onError();
                LogFile.Log((String)("Error installing " + this.m_iu.getKey()), (int)10);
            }
        }
        catch (Exception exception2) {
            LogFile.Log((String)("Rollback error" + exception2.getMessage()), (int)10, (StackTraceElement[])exception2.getStackTrace());
            string = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_ADAPTER_INSTALL_ERROR", (String)"");
        }
        InstallerUtils.abort((InstallerSupport)this.m_support, (String)(string + "; " + exception.getMessage()), (Exception)exception);
    }

    protected String getXMLConfigFileName() {
        return this.m_iu.getName();
    }
}

