/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.webtop;

import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.crypto.SE;
import com.infor.install.tomcat.TomcatAdapterAction;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallableUnits;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.InstallerXML;
import com.infor.install.utils.LogFile;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstallWebtopAction
extends TomcatAdapterAction {
    protected String getXMLConfigFileContent() throws Exception {
        String string = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        String string2 = "Webtop";
        String string3 = GeneralUtils.fixFileName((String)(string + "/" + this.m_iu.getKey()));
        String string4 = GeneralUtils.fixFileName((String)(string3 + "/config"));
        String string5 = GeneralUtils.fixFileName((String)(string4 + "/" + this.getXMLConfigFileName().toLowerCase() + ".xml"));
        String string6 = GeneralUtils.fixFileName((String)(string4 + "/" + this.m_iu.getKey().toLowerCase() + ".tpl"));
        LogFile.Log((String)("Configuring " + string5), (int)0);
        File file = new File(string5);
        File file2 = new File(string6);
        long l = file2.lastModified();
        try {
            InstallerXML installerXML = new InstallerXML();
            Document document = installerXML.readDocument(string6);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Context");
            NamedNodeMap namedNodeMap = null;
            InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2 = nodeList.item(i);
                Element element = (Element)node2;
                namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("path");
                if (node3 != null) {
                    element.removeAttribute(node3.getNodeName());
                }
                if ((node = namedNodeMap.getNamedItem("docBase")) != null) {
                    node.setTextContent(string3 + File.separator + "web");
                }
                NodeList nodeList2 = element.getElementsByTagName("Parameter");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node4;
                    Element element2 = (Element)nodeList2.item(j);
                    namedNodeMap = element2.getAttributes();
                    Node node5 = namedNodeMap.getNamedItem("name");
                    if (node5 == null) continue;
                    if (node5.getNodeValue().equals("WebtopAdminPassword")) {
                        node4 = namedNodeMap.getNamedItem("value");
                        if (installableUnit == null) {
                            node4.setTextContent(string2);
                        }
                    }
                    if (!node5.getNodeValue().equals("WebtopConfigPath")) continue;
                    node4 = namedNodeMap.getNamedItem("value");
                    node4.setTextContent(string4);
                }
            }
            if (file.exists()) {
                String string7 = new Long(file.lastModified()).toString();
                GeneralUtils.copyFile((String)string5, (String)(string5 + "_" + string7), (boolean)true);
            }
            file = new File(string5);
            installerXML.writeXMLtoFile(document, file);
            GeneralUtils.addToVectorIfNotExists((Vector)m_InstalledFiles, (String)string5);
            LogFile.Log((String)(string5 + " created"), (int)0);
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        if (l != 0L) {
            file.setLastModified(l);
        }
        return string5;
    }

    protected void postInstall() throws Exception {
        String string;
        super.postInstall();
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        if (installableUnit == null) {
            this.setWebtopProperties();
        } else {
            string = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
            this.renameWebtopXML();
            this.updateWebtopProperties(string);
            this.updateWebUIxml(string);
        }
        this.removeTplFiles();
        this.removeShortcuts();
        string = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/webapps/ROOT/favicon.ico"));
        String string2 = "Admin (on port " + this.m_HTTP_PortNo + ")";
        if (!GeneralUtils.isWindows()) {
            string2 = string2.replace(' ', '_');
        }
        String string3 = this.m_ShortcutDir + File.separator + this.m_iu.getName() + string2;
        String string4 = "http://localhost:" + this.m_HTTP_PortNo + "/" + this.m_iu.getName().toLowerCase() + "/servlet/admin";
        LogFile.Log((String)("Create shortcut: " + string3 + "URL: " + string4 + "Icon file: " + string), (int)0);
        GeneralUtils.CreateInternetShortcut((String)string3, (String)string4, (String)string);
        string2 = "Help (on port " + this.m_HTTP_PortNo + ")";
        if (!GeneralUtils.isWindows()) {
            string2 = string2.replace(' ', '_');
        }
        string3 = this.m_ShortcutDir + File.separator + this.m_iu.getName() + string2;
        string4 = "http://localhost:" + this.m_HTTP_PortNo + "/" + this.m_iu.getName().toLowerCase() + "/servlet/webhelp";
        LogFile.Log((String)("Create shortcut: " + string3 + "URL: " + string4 + "Icon file: " + string), (int)0);
        GeneralUtils.CreateInternetShortcut((String)string3, (String)string4, (String)string);
        this.renameWebtopXML();
        this.copyHelpDirFromBackup("/web/help");
        this.copyDirFromBackup("/web/applets/com/ssaglobal/homepages/client/language");
        this.copyDirFromBackup("/web/images/ssa/header");
    }

    private void renameWebtopXML() throws Exception {
        String string = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        String string2 = GeneralUtils.fixFileName((String)(string + "/" + this.m_iu.getKey() + "/config"));
        String string3 = GeneralUtils.fixFileName((String)(string2 + "/" + this.m_iu.getKey().toLowerCase() + ".xml"));
        String string4 = GeneralUtils.fixFileName((String)(string2 + "/" + this.getXMLConfigFileName().toLowerCase() + ".xml"));
        InstallerUtils.renameFile((InstallerSupport)this.m_support, (String)string3, (String)string4);
        LogFile.Log((String)(string3 + "renamed to " + string4), (int)0);
        string3 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/" + this.m_iu.getKey().toLowerCase() + ".xml"));
        string4 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/" + this.getXMLConfigFileName().toLowerCase() + ".xml"));
        InstallerUtils.renameFile((InstallerSupport)this.m_support, (String)string3, (String)string4);
        LogFile.Log((String)(string3 + "renamed to " + string4), (int)0);
    }

    protected void postUninstall() throws Exception {
        this.removeShortcuts();
    }

    private void removeShortcuts() {
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)this.m_iu.getKey());
        String string = "";
        if (installableUnit != null) {
            string = installableUnit.getName() + "Admin";
            this.removeWebtopShortcut(string);
            string = string + " (on port " + this.m_HTTP_PortNo + ")";
            this.removeWebtopShortcut(string);
            string = installableUnit.getName() + "Help";
            this.removeWebtopShortcut(string);
            string = string + " (on port " + this.m_HTTP_PortNo + ")";
            this.removeWebtopShortcut(string);
            this.removeWebtopShortcut("Webtop");
            this.removeWebtopShortcut("WebtopAdmin");
            this.removeWebtopShortcut("WebtopHelp");
        }
    }

    private void removeWebtopShortcut(String string) {
        String string2 = "";
        string2 = GeneralUtils.isWindows() ? this.m_ShortcutDir + File.separator + string + ".url" : this.m_ShortcutDir + File.separator + string + ".lnk";
        File file = new File(string2);
        if (file.exists()) {
            boolean bl = file.delete();
            if (bl) {
                LogFile.Log((String)(string2 + " deleted"), (int)0);
            } else {
                LogFile.Log((String)(string2 + " not deleted"), (int)0);
            }
        }
    }

    private void setWebtopProperties() {
        String string = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        String string2 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_HOST");
        String string3 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_ERPVERSION");
        String string4 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_BSE");
        String string5 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_PROTOCOL");
        String string6 = "";
        if (string5.equals("Infor SSO")) {
            string6 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_PROTOCOL_URL");
            string5 = "jca.baanlogin.sso";
        }
        if (string5.equals("Federation Services")) {
            string5 = "jca.baanlogin.ssl";
        }
        String string7 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_PORT");
        String string8 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_BSHELL");
        String string9 = this.m_support.substitute("WEBTOP_U_ERPBACKEND_COMMAND");
        if (string9 == null || string9.equals("")) {
            string9 = " ";
        }
        String string10 = "";
        String string11 = "";
        if (string2 != null && string2.length() > 0 && string4 != null && string4.length() > 0 && string8 != null && string8.length() > 0) {
            string10 = "ds.connection." + string2;
            string11 = string2 + "," + string4 + "," + string5 + "," + string7 + "," + string8 + "," + string9 + "," + string3 + ",enabled,60,";
        }
        try {
            this.createWebtopProperties(string, string10, string11, string6);
        }
        catch (Exception exception) {
            LogFile.Log((String)("WebtopProperties.xml not updated " + exception.getMessage()), (int)20, (StackTraceElement[])exception.getStackTrace());
        }
    }

    private void createWebtopProperties(String string, String string2, String string3, String string4) throws Exception {
        Object object;
        String string5 = GeneralUtils.fixFileName((String)(string + "/" + this.m_iu.getKey()));
        String string6 = GeneralUtils.fixFileName((String)(string5 + "/config/forms"));
        String string7 = GeneralUtils.fixFileName((String)(string5 + "/config/XFEdumps"));
        String string8 = GeneralUtils.fixFileName((String)(string5 + "/config/formcache"));
        String string9 = GeneralUtils.fixFileName((String)(string5 + "/config/WebtopProperties.xml"));
        String string10 = GeneralUtils.fixFileName((String)(string5 + "/config/WebtopProperties.tpl"));
        LogFile.Log((String)("Modifying " + string10), (int)0);
        File file = new File(string10);
        long l = file.lastModified();
        InstallerXML installerXML = new InstallerXML();
        Document document = installerXML.readDocument(string10);
        NodeList nodeList = document.getElementsByTagName("CATEGORY");
        NamedNodeMap namedNodeMap = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            int n;
            Object object2;
            object = nodeList.item(i);
            namedNodeMap = object.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("NAME");
            if (node2.getTextContent().equals("Login")) {
                object2 = ((Element)object).getElementsByTagName("PROPERTY");
                for (n = 0; n < object2.getLength(); ++n) {
                    node = object2.item(n);
                    namedNodeMap = node.getAttributes();
                    node2 = namedNodeMap.getNamedItem("NAME");
                    if (!node2.getTextContent().equals("infor.sso.url")) continue;
                    node.setTextContent(string4);
                    LogFile.Log((String)("Changed infor.sso.url to " + string4), (int)0);
                }
                continue;
            }
            if (node2.getTextContent().equals("BaanERP")) {
                object2 = ((Element)object).getElementsByTagName("PROPERTY");
                for (n = 0; n < object2.getLength(); ++n) {
                    node = object2.item(n);
                    namedNodeMap = node.getAttributes();
                    node2 = namedNodeMap.getNamedItem("NAME");
                    if (node2.getTextContent().equals("java.forms.dir")) {
                        node.setTextContent(string6);
                        LogFile.Log((String)("Changed java.forms.dir to " + string6), (int)0);
                        continue;
                    }
                    if (node2.getTextContent().equals("form.source.dir")) {
                        node.setTextContent(string7);
                        LogFile.Log((String)("Changed form.source.dir to " + string7), (int)0);
                        continue;
                    }
                    if (node2.getTextContent().equals("form.temp.dir")) {
                        node.setTextContent(string8);
                        LogFile.Log((String)("Changed form.temp.dir to " + string8), (int)0);
                        continue;
                    }
                    if (!node2.getTextContent().equals("DS_NAME") || string2.equals("")) continue;
                    node2.setTextContent(string2);
                    node.setTextContent(string3);
                    LogFile.Log((String)("Changed DS_NAME: " + string2 + " to " + string3), (int)0);
                }
                continue;
            }
            if (node2.getTextContent().equals("General")) {
                object2 = ((Element)object).getElementsByTagName("PROPERTY");
                for (n = 0; n < object2.getLength(); ++n) {
                    node = object2.item(n);
                    namedNodeMap = node.getAttributes();
                    node2 = namedNodeMap.getNamedItem("NAME");
                    if (!node2.getTextContent().equals("webtop.admin.password")) continue;
                    String string11 = this.getEncyptedPassword();
                    node.setTextContent(string11);
                    LogFile.Log((String)"Changed adminPassword", (int)0);
                }
                continue;
            }
            object2 = "Corrupt file: " + string10;
            Exception exception = new Exception((String)object2);
            LogFile.Log((String)object2, (int)20, (StackTraceElement[])exception.getStackTrace());
            throw exception;
        }
        File file2 = new File(string9);
        if (file2.exists()) {
            object = new Long(file2.lastModified()).toString();
            GeneralUtils.copyFile((String)string9, (String)(string9 + "_" + (String)object), (boolean)true);
        }
        installerXML.writeXMLtoFile(document, file2);
        file2.setLastModified(l);
        GeneralUtils.addToVectorIfNotExists((Vector)m_InstalledFiles, (String)string9);
        LogFile.Log((String)("WebtopProperties.xml modified successfully" + GeneralUtils.endLine()), (int)0);
    }

    protected void updateWebtopProperties(String string) throws Exception {
        String string2 = GeneralUtils.fixFileName((String)(string + "/" + this.m_iu.getKey()));
        String string3 = GeneralUtils.fixFileName((String)(string2 + "/config/WebtopProperties.xml"));
        LogFile.Log((String)("Modifying " + string3), (int)0);
        File file = new File(string3);
        long l = file.lastModified();
        InstallerXML installerXML = new InstallerXML();
        Document document = installerXML.readDocument(string3);
        NodeList nodeList = document.getElementsByTagName("CATEGORY");
        NamedNodeMap namedNodeMap = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("NAME");
            if (!node2.getTextContent().equals("General")) continue;
            NodeList nodeList2 = ((Element)node).getElementsByTagName("PROPERTY");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                namedNodeMap = node3.getAttributes();
                node2 = namedNodeMap.getNamedItem("NAME");
                if (!node2.getTextContent().equals("webtop.admin.password")) continue;
                String string4 = this.getEncyptedPassword();
                node3.setTextContent(string4);
                LogFile.Log((String)"Changed adminPassword", (int)0);
            }
        }
        if (file.exists()) {
            String string5 = new Long(file.lastModified()).toString();
            GeneralUtils.copyFile((String)string3, (String)(string3 + "_" + string5), (boolean)true);
        }
        installerXML.writeXMLtoFile(document, file);
        file = new File(string3);
        file.setLastModified(l);
        LogFile.Log((String)("WebtopProperties.xml modified successfully" + GeneralUtils.endLine()), (int)0);
    }

    protected void updateWebUIxml(String string) throws Exception {
        Object object;
        String string2 = GeneralUtils.fixFileName((String)(string + "/Webtop/config/webui.xml"));
        String string3 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + "/" + this.m_TomcatVersion + "/conf/Catalina/localhost/webui.xml"));
        File file = new File(string2);
        long l = file.lastModified();
        InstallerXML installerXML = new InstallerXML();
        Document document = installerXML.readDocument(string2);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("Context");
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            Element element = (Element)object;
            Attr attr = document.createAttribute("useHttpOnly");
            attr.setTextContent("false");
            element.setAttributeNode(attr);
            bl = true;
        }
        if (!bl) {
            String string4 = "Context section not found";
            object = new Exception(string4);
            LogFile.Log((String)string4, (int)20, (StackTraceElement[])((Throwable)object).getStackTrace());
            throw object;
        }
        file = new File(string2);
        installerXML.writeXMLtoFile(document, file);
        file.setLastModified(l);
        LogFile.Log((String)"Context updated with useHttpOnly=\"true\"", (int)0);
        GeneralUtils.copyFile((String)string2, (String)string3, (boolean)true);
    }

    protected Hashtable<String, String> getIgnoreTable() throws Exception {
        InstallableUnit installableUnit;
        Hashtable<String, String> hashtable = null;
        InstallableUnits installableUnits = FindExistingIUs.getExistingIUs();
        if (installableUnits != null && (installableUnit = installableUnits.containsValue("Key", this.m_iu.getKey())) != null) {
            LogFile.Log((String)"creating hashtable...", (int)0);
            hashtable = new Hashtable<String, String>();
            String string = GeneralUtils.fixFileName((String)"images\\ssa\\header\\companylogo.gif");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\corporate\\header\\companylogo.gif");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\ms\\header\\companylogo.gif");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\purple\\header\\companylogo.gif");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\ssa\\header\\erphomebackground.jpg");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\purple\\webback.jpg");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\corporate\\webback.jpg");
            hashtable.put(string, "1");
            string = GeneralUtils.fixFileName((String)"images\\ms\\webback.jpg");
            hashtable.put(string, "1");
            LogFile.Log((String)"The following files are ignored: ", (int)0);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                LogFile.Log((String)string2, (int)0);
            }
        }
        return hashtable;
    }

    protected void preInstall() throws Exception {
    }

    protected String getRedirection() {
        String string = this.getXMLConfigFileName().toLowerCase() + "/defaultlogin.html";
        LogFile.Log((String)("Redirection: " + string), (int)0);
        return string;
    }

    private void removeTplFiles() {
        String string;
        String string2 = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        String string3 = GeneralUtils.fixFileName((String)(string2 + "/" + this.m_iu.getKey()));
        String string4 = GeneralUtils.fixFileName((String)(string3 + "/config"));
        String string5 = GeneralUtils.fixFileName((String)(string4 + "/" + this.m_iu.getKey().toLowerCase() + ".tpl"));
        File file = new File(string5);
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(string = GeneralUtils.fixFileName((String)(string3 + "/config/WebtopProperties.tpl")))).exists()) {
            file.delete();
        }
    }

    protected void preUninstall() throws Exception {
    }

    protected String onError() throws Exception {
        String string = this.m_DestinationDirectory + File.separator + this.m_iu.getKey();
        if (this.m_rollback) {
            InstallerUtils.rollback((String)string, (String)this.m_BackupDir, (Vector)m_InstalledFiles);
        }
        FindExistingIUs.readExistingIUs((InstallerSupport)this.m_support, (String)this.m_DestinationDirectory);
        InstallableUnit installableUnit = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)"Webtop");
        if (installableUnit != null && installableUnit.getVersion().contains("8.6")) {
            String string2 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/" + this.getXMLConfigFileName().toLowerCase() + ".xml"));
            String string3 = GeneralUtils.fixFileName((String)(this.m_DestinationDirectory + File.separator + this.m_TomcatVersion + File.separator + "conf/Catalina/localhost/" + this.m_iu.getKey().toLowerCase() + ".xml"));
            InstallerUtils.renameFile((InstallerSupport)this.m_support, (String)string2, (String)string3);
            LogFile.Log((String)(string2 + "renamed to " + string3), (int)0);
        }
        return InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_ADAPTER_INSTALL_ERROR", (String)this.m_iu.getKey());
    }

    protected String getXMLConfigFileName() {
        return this.m_iu.getName();
    }

    private String getEncyptedPassword() {
        String string = this.m_support.substitute("WEBTOP_U_PASSWORD");
        String string2 = SE.getInstance().es(string);
        return string2;
    }

    private void copyDirFromBackup(String string) {
        String string2 = this.m_BackupDir + string;
        String string3 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + string;
        try {
            InstallerUtils.copyAllFilesAndFolders((InstallerSupport)this.m_support, (String)string2, (String)string3, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copyHelpDirFromBackup(String string) {
        String string2 = this.m_BackupDir + string;
        String string3 = this.m_DestinationDirectory + File.separator + this.m_iu.getKey() + string;
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        try {
            for (File file2 : fileArray) {
                String string4 = file2.getName();
                if (string4.equals("webtop")) continue;
                InstallerUtils.copyAllFilesAndFolders((InstallerSupport)this.m_support, (String)file2.getCanonicalPath(), (String)(string3 + File.separator + string4), (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getLoginURL(InstallableUnit installableUnit) {
        return "http://localhost:" + this.m_HTTP_PortNo + "/" + installableUnit.getName().toLowerCase();
    }

    protected String getSelectedDependency() {
        return "";
    }

    protected boolean doBackup() {
        return true;
    }

    protected void addPathToBackupFilter(String string, Vector<String> vector) throws Exception {
    }

    @Deprecated
    protected void preRollback() throws Exception {
    }

    @Deprecated
    protected void postRollback() throws Exception {
    }
}

