/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.webtop;

import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.actions.SilentAction;
import com.infor.install.base.BaseCustomPanel;
import com.infor.install.base.BaseTextPanel;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.LogFile;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ERPBackendPanel
extends BaseCustomPanel
implements ItemListener {
    static final long serialVersionUID = 59L;
    private Properties m_properties = new Properties();
    private String m_NA;
    private static final String m_rexec = "rexec";
    private static final String m_baanLogin = "BaanLogin";
    public static final String m_inforSSO = "Infor SSO";
    public static final String m_federationServices = "Federation Services";
    private String[] m_protocols = new String[]{"rexec", "BaanLogin", "Infor SSO", "Federation Services"};
    private static final String m_baanERPDesc = "BaanERP/ERPLN";
    private static final String m_baanERP = "BaanERP";
    private static final String m_baanIV = "BaanIV";
    private String[] m_versionTexts = new String[]{"BaanERP/ERPLN", "BaanIV"};
    private static final int EB_SELECT_DEFAULT = 0;
    private static final int EB_SELECT_CURRENT = 1;
    private static int m_selection = 0;

    public boolean skip() {
        InstallableUnit installableUnit = this.m_support.getCurrentIU();
        InstallableUnit installableUnit2 = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)installableUnit.getKey());
        return installableUnit2 != null;
    }

    public boolean setupUI() throws Exception {
        this.m_NA = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_NOT_AVAILABLE");
        for (Props props : Props.values()) {
            this.m_properties.put(props.name(), "");
        }
        boolean bl = super.setupUI();
        if (bl) {
            this.addButton("L_SELECT_DEFAULT");
            this.addButton("L_SELECT_CURRENT");
            GeneralUtils.makeButtonsSameSize((JPanel)this.getEastPane(), (boolean)true, (boolean)false);
        }
        return bl;
    }

    protected String[] getLabels() {
        String[] stringArray = new String[8];
        int n = 0;
        for (Props props : Props.values()) {
            stringArray[n++] = this.getLabelHtml("L_ERPBACKEND_" + (Object)((Object)props), BaseTextPanel.getDefaultFontColor(), InstallerUtils.NORMAL);
        }
        return stringArray;
    }

    protected Vector<Object> getComps() {
        Vector<Object> vector = new Vector<Object>();
        JTextField jTextField = null;
        this.initValues();
        String string = (String)this.m_properties.get(Props.HOST.name());
        jTextField = new JTextField(string);
        vector.addElement(jTextField);
        JComboBox<String> jComboBox = new JComboBox<String>(this.m_versionTexts);
        jComboBox.setEditable(false);
        string = (String)this.m_properties.get(Props.ERPVERSION.name());
        if (string.equals("")) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
        vector.addElement(jComboBox);
        string = (String)this.m_properties.get(Props.BSE.name());
        jTextField = new JTextField(string);
        vector.addElement(jTextField);
        JComboBox<String> jComboBox2 = new JComboBox<String>(this.m_protocols);
        jComboBox2.setEditable(false);
        jComboBox2.addItemListener(this);
        string = (String)this.m_properties.get(Props.PROTOCOL.name());
        if (string.equals("")) {
            jComboBox2.setSelectedIndex(0);
        } else {
            jComboBox2.setSelectedItem(string);
        }
        vector.addElement(jComboBox2);
        if (string.equals(m_inforSSO)) {
            string = (String)this.m_properties.get(Props.PROTOCOL_URL.name());
            jTextField = new JTextField(string);
            jTextField.setBackground(this.getBackground());
            jTextField.setEnabled(true);
        } else {
            jTextField = new JTextField(this.m_NA);
            jTextField.setBackground(this.getBackground());
            jTextField.setEnabled(false);
        }
        vector.addElement(jTextField);
        String string2 = (String)this.m_properties.get(Props.PROTOCOL.name());
        string = (String)this.m_properties.get(Props.PORT.name());
        jTextField = new JTextField();
        if (string.equals("")) {
            string = string2.equals(m_rexec) ? "512" : "7150";
        }
        jTextField.setText(string);
        vector.addElement(jTextField);
        jTextField = new JTextField(string);
        string = (String)this.m_properties.get(Props.BSHELL.name());
        if (string.equals("")) {
            string = "bshell";
        }
        jTextField = new JTextField(string);
        vector.addElement(jTextField);
        string = (String)this.m_properties.get(Props.COMMAND.name());
        jTextField = new JTextField(string);
        vector.addElement(jTextField);
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof JTextField) || !(jTextField = (JTextField)vector.elementAt(i)).getText().equals("")) continue;
            jTextField.requestFocus();
            break;
        }
        return vector;
    }

    protected String getTopPanelText() {
        String string = this.getHeaderHtml("L_ERPBACKEND_HEADER", BaseTextPanel.getDefaultFontColor(), InstallerUtils.LARGE);
        return string;
    }

    protected String getBottomPanelText() {
        return "";
    }

    public boolean okToContinue() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        boolean bl = false;
        for (Props props : Props.values()) {
            Object object;
            int n = props.ordinal();
            if (this.m_comps.elementAt(n) instanceof JTextField) {
                object = ((JTextField)this.m_comps.elementAt(n)).getText().trim();
                if (!props.name().equals(Props.PROTOCOL_URL.name()) || bl) {
                    this.m_support.setVariable("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), (String)object);
                    hashtable.put("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), object);
                }
            }
            if (!(this.m_comps.elementAt(n) instanceof JComboBox)) continue;
            object = (JComboBox)this.m_comps.elementAt(n);
            String string = (String)((JComboBox)object).getSelectedItem();
            if (props.name().equals(Props.ERPVERSION.name())) {
                string = string.equals(m_baanERPDesc) ? m_baanERP : m_baanIV;
                this.m_support.setVariable("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), string);
                hashtable.put("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), string);
                continue;
            }
            if (!props.name().equals(Props.PROTOCOL.name())) continue;
            this.m_support.setVariable("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), string);
            hashtable.put("WEBTOP_U_ERPBACKEND_" + (Object)((Object)props), string);
            if (!string.equals(m_inforSSO)) continue;
            bl = true;
        }
        SilentAction.writeSilentProperties((InstallerSupport)this.m_support, hashtable);
        m_selection = 1;
        return true;
    }

    public boolean okToGoPrevious() {
        return true;
    }

    public String getTitle() {
        return InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_ERPBACKEND_TITLE");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            int n = Props.PROTOCOL_URL.ordinal();
            JTextField jTextField = (JTextField)this.m_comps.elementAt(n);
            if (string.equals(m_inforSSO)) {
                String string2 = (String)this.m_properties.get(Props.PROTOCOL_URL.name());
                jTextField.setText(string2);
                jTextField.setEnabled(true);
            } else {
                jTextField.setText(this.m_NA);
                jTextField.setEnabled(false);
            }
            n = Props.PORT.ordinal();
            jTextField = (JTextField)this.m_comps.elementAt(n);
            if (string.equals(m_rexec)) {
                jTextField.setText("512");
            } else {
                jTextField.setText("7150");
            }
        }
    }

    private void initValues() {
        this.m_properties.clear();
        if (m_selection == 1) {
            for (Props iOException : Props.values()) {
                String string = this.m_support.substitute("WEBTOP_U_ERPBACKEND_" + (Object)((Object)iOException));
                String string2 = iOException.name();
                if (string2.equals(Props.ERPVERSION.name()) && string.equals(m_baanERP)) {
                    string = m_baanERPDesc;
                }
                this.m_properties.put(string2, string);
            }
        }
        if (m_selection == 0) {
            String string = this.m_support.getCurrentIU().getDir();
            Properties properties = new Properties();
            properties.put("ERPBackend_erpversion", Props.ERPVERSION.name());
            properties.put("ERPBackend_protocol", Props.PROTOCOL.name());
            properties.put("ERPBackend_port", Props.PORT.name());
            properties.put("ERPBackend_bshell", Props.BSHELL.name());
            properties.put("ERPBackend_host", Props.HOST.name());
            properties.put("ERPBackend_bse", Props.BSE.name());
            properties.put("ERPBackend_protocol_URL", Props.PROTOCOL_URL.name());
            properties.put("ERPBackend_command", Props.COMMAND.name());
            String string3 = string + File.separator + "Properties.txt";
            try {
                GeneralUtils.readPropertiesFromFile((Properties)this.m_properties, (String)string3, (Properties)properties);
            }
            catch (IOException iOException) {
                LogFile.Log((String)iOException.getMessage(), (int)20, (StackTraceElement[])iOException.getStackTrace());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("L_SELECT_DEFAULT")) {
            m_selection = 0;
            this.update();
        } else if (actionEvent.getActionCommand().equals("L_SELECT_CURRENT")) {
            m_selection = 1;
            this.update();
        }
    }

    private void update() {
        this.initValues();
        for (Props props : Props.values()) {
            JComponent jComponent;
            String string = this.m_properties.getProperty(props.name());
            int n = props.ordinal();
            if (this.m_comps.elementAt(n) instanceof JTextField) {
                jComponent = (JTextField)this.m_comps.elementAt(n);
                ((JTextComponent)jComponent).setText(string);
            }
            if (!(this.m_comps.elementAt(n) instanceof JComboBox)) continue;
            jComponent = (JComboBox)this.m_comps.elementAt(n);
            if (string.equals("")) {
                ((JComboBox)jComponent).setSelectedIndex(0);
                continue;
            }
            ((JComboBox)jComponent).setSelectedItem(string);
        }
    }

    private static enum Props {
        HOST,
        ERPVERSION,
        BSE,
        PROTOCOL,
        PROTOCOL_URL,
        PORT,
        BSHELL,
        COMMAND;

    }
}

