/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.tomcat;

import at.jta.RegistryErrorException;
import at.jta.Regor;
import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.actions.SilentAction;
import com.infor.install.base.BaseEditPanel;
import com.infor.install.base.BaseTextPanel;
import com.infor.install.tomcat.InstallTomcatAction;
import com.infor.install.utils.ChoiceDialog;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnit;
import com.infor.install.utils.InstallableUnits;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.LogFile;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TomcatPortsPanel
extends BaseEditPanel {
    private static final long serialVersionUID = 58L;
    private static final int SERVICENAME = 3;
    private static final int SERVICEDISPNAME = 4;
    protected String[] m_labels = null;
    protected String[] m_dirs = null;
    protected String[] m_texts = new String[5];
    protected String m_configFile = "";

    public boolean skip() {
        boolean bl = false;
        String string = InstallerUtils.getInstalldirsFromReg((InstallerSupport)this.m_support);
        this.m_dirs = string.split(",");
        InstallableUnit installableUnit = this.m_support.getCurrentIU();
        InstallableUnit installableUnit2 = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)installableUnit.getKey());
        String string2 = this.m_support.substitute("INSTALLER_CHOSENINSTALLSET");
        this.m_texts = this.getTexts();
        this.getLabels();
        if (installableUnit2 != null) {
            bl = true;
        } else if (!string2.equals("Custom")) {
            bl = true;
            this.m_support.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < InstallTomcatAction.WebserverPorts.values().length; ++i) {
                if (this.checkValue(i, this.m_texts[i])) continue;
                bl = false;
                break;
            }
            this.m_support.getFrame().setCursor(Cursor.getDefaultCursor());
            if (bl) {
                bl = this.checkServiceNames(3);
            }
        }
        if (bl) {
            this.writeData();
        }
        return bl;
    }

    public boolean setupUI() throws Exception {
        boolean bl = super.setupUI();
        if (bl) {
            this.addButton("L_SELECT_DEFAULT");
            this.addButton("L_SELECT_CURRENT");
            GeneralUtils.makeButtonsSameSize((JPanel)this.getEastPane(), (boolean)true, (boolean)false);
        }
        return bl;
    }

    public boolean okToContinue() {
        this.m_texts = new String[this.m_tf.length];
        try {
            int n;
            this.m_support.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            for (n = 0; n < InstallTomcatAction.WebserverPorts.values().length; ++n) {
                if (!this.checkValue(n)) {
                    this.m_tf[n].requestFocus();
                    this.getRootPane().setCursor(Cursor.getDefaultCursor());
                    return false;
                }
                this.m_texts[n] = this.m_tf[n].getText().trim();
            }
            if (GeneralUtils.isWindows()) {
                while (n <= 4) {
                    this.m_texts[n] = this.m_tf[n].getText().trim();
                    ++n;
                }
                if (!this.checkServiceNames(3)) {
                    this.m_support.getFrame().setCursor(Cursor.getDefaultCursor());
                    return false;
                }
            }
            this.m_support.getFrame().setCursor(Cursor.getDefaultCursor());
            this.writeData();
        }
        catch (Exception exception) {
            this.m_support.getFrame().setCursor(Cursor.getDefaultCursor());
            return false;
        }
        return true;
    }

    protected void writeData() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
            String string = webserverPorts.toString();
            this.m_support.setVariable("TOMCAT_U_" + string, this.m_texts[n]);
            hashtable.put("TOMCAT_U_" + string, this.m_texts[n]);
            ++n;
        }
        if (GeneralUtils.isWindows()) {
            this.m_support.setVariable("TOMCAT_SERVICE_NAME", this.m_texts[3]);
            hashtable.put("TOMCAT_SERVICE_NAME", this.m_texts[3]);
            this.m_support.setVariable("TOMCAT_SERVICE_DISPLAYNAME", this.m_texts[4]);
            hashtable.put("TOMCAT_SERVICE_DISPLAYNAME", this.m_texts[4]);
        }
        SilentAction.writeSilentProperties((InstallerSupport)this.m_support, hashtable);
    }

    public boolean okToGoPrevious() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            block3: {
                if (!actionEvent.getActionCommand().equals("L_SELECT_DEFAULT")) break block3;
                for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
                    int n = webserverPorts.ordinal();
                    String string = webserverPorts.toString();
                    JTextField jTextField = this.m_tf[n];
                    jTextField.setText(this.m_support.substitute("TOMCAT_" + string));
                }
                break block4;
            }
            if (!actionEvent.getActionCommand().equals("L_SELECT_CURRENT")) break block4;
            for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
                int n = webserverPorts.ordinal();
                String string = webserverPorts.toString();
                JTextField jTextField = this.m_tf[n];
                String string2 = this.m_support.substitute("TOMCAT_U_" + string);
                if (string2.isEmpty()) {
                    string2 = this.m_support.substitute("TOMCAT_" + string);
                }
                jTextField.setText(string2);
            }
        }
    }

    public String getTitle() {
        return InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_WEBSERVERPORTS_TITLE");
    }

    protected String[] getTexts() {
        block11: {
            InstallableUnits installableUnits = FindExistingIUs.getExistingIUs();
            InstallableUnit installableUnit = installableUnits.containsValue("Key", "Tomcat");
            if (installableUnit != null) {
                String string = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
                String string2 = this.m_support.substitute("TOMCAT_TOMCATVERSION");
                String string3 = string + File.separator + string2;
                String string4 = "";
                int n = installableUnit.getVersion().split("\\.").length;
                string4 = n < 3 ? "apache-tomcat-" + installableUnit.getVersion() + "." + installableUnit.getBuild() : "apache-tomcat-" + installableUnit.getVersion();
                this.m_configFile = GeneralUtils.fixFileName((String)(string3 + "/conf/server.xml"));
                if (!string2.equals(string4)) {
                    this.m_configFile = GeneralUtils.fixFileName((String)(string + "/" + string4 + "/conf/server.xml"));
                }
                int n2 = 0;
                for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
                    this.m_texts[n2] = InstallTomcatAction.getPortNumber(this.m_configFile, webserverPorts);
                    ++n2;
                }
                if (GeneralUtils.isWindows()) {
                    try {
                        String exception = string + File.separator + string4;
                        String[] string5 = InstallTomcatAction.getServiceNames(this.m_support, exception);
                        this.m_texts[3] = string5[0];
                        if (string5.length > 1) {
                            this.m_texts[4] = string5[1];
                            break block11;
                        }
                        this.m_texts[4] = this.m_support.substitute("TOMCAT_SERVICE_DISPLAYNAME");
                        this.checkDispName(this.m_texts[4], 0);
                    }
                    catch (Exception exception) {
                        String string5 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"ERROR");
                        String string6 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_SERVICE_NAME", (String)(installableUnit.getDir() + "\\bin\\installTomcatService.bat"));
                        InstallerUtils.ShowMessage((InstallerSupport)this.m_support, (String)string5, (String)string6);
                    }
                }
            } else {
                int n = 0;
                for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
                    String string = webserverPorts.toString();
                    this.m_texts[n] = this.m_support.substitute("TOMCAT_U_" + string);
                    if (this.m_texts[n].isEmpty()) {
                        this.m_texts[n] = this.m_support.substitute("TOMCAT_" + string);
                    }
                    ++n;
                }
                if (GeneralUtils.isWindows()) {
                    this.m_texts[3] = this.m_support.substitute("TOMCAT_SERVICE_NAME");
                    this.m_texts[4] = this.m_support.substitute("TOMCAT_SERVICE_DISPLAYNAME");
                }
            }
        }
        return this.m_texts;
    }

    protected void checkDispName(String string, int n) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_texts.length > 1) {
            bl = this.checkServiceNameInReg(this.m_texts[4]);
            if (!bl) {
                bl2 = this.checkServiceNameInOtherTomcats(this.m_texts[4], 1);
            }
            if (bl || bl2) {
                this.m_texts[4] = string + " " + ++n;
                this.checkDispName(this.m_texts[4], n);
            }
        }
    }

    protected String[] getLabels() {
        int n = 3;
        if (GeneralUtils.isWindows()) {
            n = 5;
        }
        this.m_labels = new String[n];
        String[] stringArray = new String[n];
        String string = BaseTextPanel.getDefaultFontColor();
        int n2 = 0;
        for (InstallTomcatAction.WebserverPorts webserverPorts : InstallTomcatAction.WebserverPorts.values()) {
            String string2 = webserverPorts.toString();
            stringArray[n2] = this.getLabelHtml("L_WEBSERVERPORTS_" + string2, string, InstallerUtils.NORMAL);
            this.m_labels[n2] = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)("L_WEBSERVERPORTS_" + string2));
            ++n2;
        }
        if (GeneralUtils.isWindows()) {
            stringArray[3] = this.getLabelHtml("L_WEBSERVERPORTS_SERVICE_NAME", string, InstallerUtils.NORMAL);
            this.m_labels[3] = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_WEBSERVERPORTS_SERVICE_NAME");
            stringArray[4] = this.getLabelHtml("L_WEBSERVERPORTS_SERVICE_DISPLAY_NAME", string, InstallerUtils.NORMAL);
            this.m_labels[4] = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_WEBSERVERPORTS_SERVICE_DISPLAY_NAME");
        }
        return stringArray;
    }

    protected boolean isPasswordField(int n) {
        return false;
    }

    protected String[] getButtonTexts() {
        String[] stringArray = new String[5];
        return stringArray;
    }

    protected String getDefaultText(int n) {
        return "";
    }

    protected String getTopPanelText() {
        return this.getHeaderHtml("L_WEBSERVERPORTS_HEADER", BaseTextPanel.getDefaultFontColor(), InstallerUtils.LARGE);
    }

    protected String getBottomPanelText() {
        return "";
    }

    protected void setFocus() {
    }

    protected boolean checkValue(int n) {
        if (n < 3) {
            String string = this.m_tf[n].getText().trim();
            return this.checkValue(n, string);
        }
        return true;
    }

    protected boolean checkValue(int n, String string) {
        String string2 = this.m_labels[n];
        try {
            Integer n2 = new Integer(string);
            if (n2 != 0) {
                if (n2 < 1025 || n2 > 65537) {
                    this.showError("E_PORT_RANGE", string2, new String[0]);
                    return false;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = GeneralUtils.checkPort((int)n2);
                boolean bl2 = this.checkPortInOtherTomcats(string);
                this.setCursor(Cursor.getDefaultCursor());
                if (!bl || !bl2) {
                    String string3 = InstallerUtils.getLabel1((InstallerSupport)this.m_support, (String)"E_PORT_ERROR", (String)string);
                    ChoiceDialog choiceDialog = new ChoiceDialog();
                    String string4 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_YES");
                    String string5 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_NO");
                    Vector<String> vector = new Vector<String>();
                    vector.add(string4);
                    vector.add(string5);
                    int n3 = string2.length();
                    string2 = string2.substring(0, n3 - 2);
                    choiceDialog.create(string2, string3, vector);
                    String string6 = choiceDialog.getAnswer();
                    if (string6.equals(string5)) {
                        return false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.showError("E_SOCKET_ERROR", string2, new String[0]);
            return false;
        }
        catch (SecurityException securityException) {
            this.showError("E_PORT_NOT_ALLOWED", string2, new String[0]);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            this.showError("E_PORT_RANGE", string2, new String[0]);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    protected void showError(String string, String string2, String ... stringArray) {
        int n = string2.length();
        String string3 = string2.substring(0, n - 2);
        String string4 = InstallerUtils.getLabeln((InstallerSupport)this.m_support, (String)string, (String[])stringArray);
        InstallerUtils.ShowMessage((InstallerSupport)this.m_support, (String)string3, (String)string4);
    }

    protected boolean checkPortInOtherTomcats(String string) {
        String string2 = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        for (String string3 : this.m_dirs) {
            File[] fileArray;
            File file = new File(string3);
            if (!file.exists() || string3.equals(string2)) continue;
            for (File file2 : fileArray = file.listFiles()) {
                String string4;
                File file3;
                String string5 = file2.getName();
                if (!string5.startsWith("apache-tomcat-") || !(file3 = new File(string4 = GeneralUtils.fixFileName((String)(string3 + "/" + string5 + "/conf/server.xml")))).exists()) continue;
                String string6 = InstallTomcatAction.getPortNumber(string4, InstallTomcatAction.WebserverPorts.HTTP_PORT);
                if (string6.equals(string)) {
                    return false;
                }
                string6 = InstallTomcatAction.getPortNumber(string4, InstallTomcatAction.WebserverPorts.AJP_PORT);
                if (string6.equals(string)) {
                    return false;
                }
                string6 = InstallTomcatAction.getPortNumber(string4, InstallTomcatAction.WebserverPorts.SHUTDOWN_PORT);
                if (!string6.equals(string)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkServiceNameInReg(String var1_1) {
        if (!GeneralUtils.isWindows()) {
            return false;
        }
        var2_2 = null;
        var3_3 = null;
        try {
            var2_2 = new Regor();
            var4_4 = "SYSTEM\\CurrentControlSet\\services\\";
            var3_3 = var2_2.openKey(Regor.HKEY_LOCAL_MACHINE, var4_4);
            if (var3_3 == null) ** GOTO lbl42
            var5_8 = var2_2.listKeys(var3_3);
            var6_9 = 0;
lbl12:
            // 2 sources

            while (var6_9 < var5_8.size()) {
                var7_10 = (String)var5_8.get(var6_9);
                if (!var7_10.equals(var1_1)) ** GOTO lbl-1000
                var8_11 = true;
                if (var3_3 == null) return var8_11;
                ** GOTO lbl33
            }
            ** GOTO lbl42
        }
        catch (Exception var4_6) {
            try {
                LogFile.Log((String)var4_6.getMessage(), (int)20, (StackTraceElement[])var4_6.getStackTrace());
                if (var3_3 == null) return false;
            }
            catch (Throwable var10_13) {
                if (var3_3 == null) throw var10_13;
                try {
                    var2_2.closeKey(var3_3);
                    throw var10_13;
                }
                catch (RegistryErrorException var11_14) {
                    // empty catch block
                }
                throw var10_13;
            }
lbl33:
            // 1 sources

            try {
                var2_2.closeKey(var3_3);
                return var8_11;
            }
            catch (RegistryErrorException var9_12) {
                // empty catch block
            }
            return var8_11;
lbl-1000:
            // 1 sources

            {
                ++var6_9;
                ** GOTO lbl12
            }
lbl42:
            // 2 sources

            if (var3_3 == null) return false;
            try {
                var2_2.closeKey(var3_3);
                return false;
            }
            catch (RegistryErrorException var4_5) {
                return false;
            }
            try {
                var2_2.closeKey(var3_3);
                return false;
            }
            catch (RegistryErrorException var4_7) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkServiceDispNameInReg(String var1_1, int var2_2) {
        if (!GeneralUtils.isWindows()) {
            return false;
        }
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        try {
            var3_3 = new Regor();
            var6_6 = "SYSTEM\\CurrentControlSet\\services\\";
            var4_4 = var3_3.openKey(Regor.HKEY_LOCAL_MACHINE, var6_6);
            if (var4_4 == null) ** GOTO lbl54
            var7_10 = var3_3.listKeys(var4_4);
            var8_11 = 0;
lbl13:
            // 2 sources

            while (var8_11 < var7_10.size()) {
                var9_12 = (String)var7_10.get(var8_11);
                var5_5 = var3_3.openKey(Regor.HKEY_LOCAL_MACHINE, var6_6 + "\\" + var9_12);
                if (var5_5 == null) ** GOTO lbl52
                var10_13 = var3_3.readValue(var5_5, "DisplayName");
                if (var10_13 == null || var10_13.length == 0 || (var11_14 = Regor.parseValue((byte[])var10_13)) == null || !var11_14.equals(var1_1)) ** GOTO lbl-1000
                var12_15 = true;
                ** GOTO lbl38
            }
            ** GOTO lbl54
        }
        catch (Exception var6_8) {
            try {
                LogFile.Log((String)var6_8.getMessage(), (int)20, (StackTraceElement[])var6_8.getStackTrace());
            }
            catch (Throwable var14_17) {
                try {
                    if (var5_5 != null) {
                        var3_3.closeKey(var5_5);
                    }
                    if (var4_4 == null) throw var14_17;
                    var3_3.closeKey(var4_4);
                    throw var14_17;
                }
                catch (Exception var15_18) {
                    // empty catch block
                }
                throw var14_17;
            }
lbl38:
            // 1 sources

            try {
                if (var5_5 != null) {
                    var3_3.closeKey(var5_5);
                }
                if (var4_4 == null) return var12_15;
                var3_3.closeKey(var4_4);
                return var12_15;
            }
            catch (Exception var13_16) {
                // empty catch block
            }
            return var12_15;
lbl-1000:
            // 1 sources

            {
                var3_3.closeKey(var5_5);
                var5_5 = null;
lbl52:
                // 2 sources

                ++var8_11;
                ** GOTO lbl13
            }
lbl54:
            // 2 sources

            try {
                if (var5_5 != null) {
                    var3_3.closeKey(var5_5);
                }
                if (var4_4 == null) return false;
                var3_3.closeKey(var4_4);
                return false;
            }
            catch (Exception var6_7) {
                return false;
            }
            try {
                if (var5_5 != null) {
                    var3_3.closeKey(var5_5);
                }
                if (var4_4 == null) return false;
                var3_3.closeKey(var4_4);
                return false;
            }
            catch (Exception var6_9) {
                return false;
            }
        }
    }

    protected boolean checkServiceNameInOtherTomcats(String string, int n) throws Exception {
        if (!GeneralUtils.isWindows()) {
            return false;
        }
        String string2 = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
        String[] stringArray = null;
        for (String string3 : this.m_dirs) {
            File[] fileArray;
            File file = new File(string3);
            if (!file.exists() || string3.equals(string2)) continue;
            for (File file2 : fileArray = file.listFiles()) {
                String string4;
                String string5;
                String string6 = file2.getName();
                if (!string6.startsWith("apache-tomcat-") || !string.equals(string5 = (stringArray = InstallTomcatAction.getServiceNames(this.m_support, string4 = GeneralUtils.fixFileName((String)(string3 + "/" + string6))))[n])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkServiceNames(int n) {
        if (!GeneralUtils.isWindows()) {
            return true;
        }
        int n2 = n;
        n2 = 0;
        try {
            if (this.m_texts[3].equals("")) {
                this.showError("E_VALID_NAME", this.m_labels[3], this.m_texts[3]);
                return false;
            }
            if (this.m_texts[4].equals("")) {
                this.showError("E_VALID_NAME", this.m_labels[4], this.m_texts[4]);
                return false;
            }
            if (this.checkServiceNameInReg(this.m_texts[3])) {
                this.showError("E_SERVICE_NAME_EXIST", this.m_labels[n2], this.m_texts[n2]);
                return false;
            }
            if (this.checkServiceNameInOtherTomcats(this.m_texts[3], 0)) {
                this.showError("E_SERVICE_NAME_EXIST", this.m_labels[n2], this.m_texts[n2]);
                return false;
            }
        }
        catch (Exception exception) {
            String string = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"L_ERROR");
            this.showError("E_SERVICE_READ_ERROR", string, this.m_texts[3], this.m_texts[4]);
            return false;
        }
        return true;
    }

    @Deprecated
    protected String getButtonText() {
        return null;
    }
}

