/*
 * Decompiled with CFR 0.152.
 */
package com.infor.install.tomcat;

import com.infor.install.IFinalAction;
import com.infor.install.InstallerAction;
import com.infor.install.InstallerSupport;
import com.infor.install.actions.FindExistingIUs;
import com.infor.install.tomcat.InstallTomcatAction;
import com.infor.install.utils.ESCommand;
import com.infor.install.utils.GeneralUtils;
import com.infor.install.utils.InstallableUnits;
import com.infor.install.utils.InstallerUtils;
import com.infor.install.utils.LogFile;
import java.io.File;
import java.util.Vector;

public class StartTomcatManagerAction
extends InstallerAction
implements IFinalAction {
    public boolean skip() {
        return !this.showFinalAction();
    }

    public void install() throws Exception {
        if (GeneralUtils.isWindows()) {
            this.startTomcatManager();
        }
    }

    public void uninstall() {
    }

    public String getFinalActionName() {
        return "TOMCAT_U_STARTOPTIONS_TOMCATMANAGER";
    }

    public String getFinalActionDesc() {
        return "L_STARTOPTIONS_TOMCATMANAGER";
    }

    public boolean showFinalAction() {
        if (GeneralUtils.isWindows()) {
            InstallableUnits installableUnits;
            String string = this.m_support.substitute("INSTALLER_CHOSEN_INSTALL_FEATURE_LIST");
            String[] stringArray = string.split(",");
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!"Tomcat".equals(string2)) continue;
                bl = true;
                break;
            }
            if ((installableUnits = FindExistingIUs.getExistingIUs()).containsValue("Key", "Tomcat") != null) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private void startTomcatManager() {
        try {
            String string = this.m_support.substitute("TOMCAT_U_STARTOPTIONS_TOMCATMANAGER");
            if (string.equals("1") && GeneralUtils.isWindows()) {
                Object object;
                String string2 = this.m_support.substitute("TOMCAT_TOMCATVERSION");
                if (string2.equals("") && (object = FindExistingIUs.getExistingIU((InstallerSupport)this.m_support, (String)"Tomcat")) != null) {
                    string2 = "apache-tomcat-" + object.getVersion();
                }
                object = this.m_support.substitute("INSTALLER_USER_INSTALL_DIR");
                String string3 = this.m_support.substitute("INSTALLER_USER_SHORTCUTS");
                String string4 = GeneralUtils.fixFileName((String)((String)object + "/" + string2 + "/conf/server.xml"));
                String string5 = InstallTomcatAction.getPortNumber(string4, InstallTomcatAction.WebserverPorts.HTTP_PORT);
                String string6 = InstallerUtils.getLabel((InstallerSupport)this.m_support, (String)"S_TOMCAT_MANAGER") + " (on port " + string5 + ")";
                String string7 = "";
                String string8 = string3 + File.separator + string2 + File.separator + string6 + ".url";
                string7 = "cmd /c \"" + string8 + "\"";
                Vector vector = this.m_support.getDelayedCommands();
                LogFile.Log((String)("Delayed command: " + string7), (int)0);
                ESCommand eSCommand = new ESCommand(string7, null, null, true, 0L);
                vector.add(eSCommand);
            }
        }
        catch (Exception exception) {
            LogFile.Log((String)exception.getMessage(), (int)20, (StackTraceElement[])exception.getStackTrace());
        }
    }
}

