/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.shared.resources;

import static com.infor.component.client.utils.StringUtils.convertMessage;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.infor.ln.workbench.shared.resources.AbstractLNMessages;
import com.infor.ln.workbench.shared.resources.LNMessage;

/**
 *
 */
@XmlRootElement(name = "messages")
@XmlAccessorType(XmlAccessType.FIELD)
public class CommonLNMessages extends AbstractLNMessages {
    private static final long serialVersionUID = 1L;

    /** %1$s (%2$s) via %3$s (%4$s) */
    protected LNMessage mReferenceViaReference;

    @Override
    public void init() {
        mReferenceViaReference          = new LNMessage("ttpersrep0045");
    }

    /**
     * @return the "%1$s (%2$s) via %3$s (%4$s)" message
     */
    public LNMessage getReferenceViaReference() {
        return mReferenceViaReference;
    }

    /**
     * @param toDescription the description of the to-table
     * @param toCode the code of the to-table
     * @param fromDescription the description of the from-field
     * @param fromCode the code of the from-field
     * @return the "%1$s (%2$s) via %3$s (%4$s)" message, formatted with the given values.
     */
    public String getReferenceViaReference(String toDescription, String toCode,
            String fromDescription, String fromCode) {
        return convertMessage(mReferenceViaReference.getMessage(), toDescription, toCode, fromDescription, fromCode);
    }
}
