/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.shared.resources;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.infor.ln.workbench.shared.resources.AbstractLNLabels;
import com.infor.ln.workbench.shared.resources.LNLabel;
import com.infor.ln.workbench.shared.resources.LNLabel.LNLabelContext;

/**
 *
 */
@XmlRootElement(name = "labels")
@XmlAccessorType(XmlAccessType.FIELD)
public class CommonLNLabels extends AbstractLNLabels {
    private static final long serialVersionUID = 1L;

    /** Field. */
    protected LNLabel mField;
    /** Description. */
    protected LNLabel mDescription;
    /** Element. */
    protected LNLabel mElement;
    /** Selected. */
    protected LNLabel mSelected;
    /** By Name. */
    protected LNLabel mByName;
    /** By Description. */
    protected LNLabel mByDescription;
    /** Refers to. */
    protected LNLabel mRefersTo;
    /** Referred by. */
    protected LNLabel mReferredBy;
    /** Loading References. */
    protected LNLabel mLoadingReferences;

    @Override
    public void init() {
        mField                          = new LNLabel("ttstppersrep0106", LNLabelContext.GENERAL);
        mDescription                    = new LNLabel("ttdesc", LNLabelContext.GENERAL);
        mElement                        = new LNLabel("ttextm0048", LNLabelContext.GENERAL);
        mSelected                       = new LNLabel("ttadvchosen", LNLabelContext.GENERAL);
        mByName                         = new LNLabel("ttstppersrep0046", LNLabelContext.GENERAL);
        mByDescription                  = new LNLabel("ttstppersrep0047", LNLabelContext.GENERAL);
        mRefersTo                       = new LNLabel("ttstppersrep0197", LNLabelContext.GENERAL);
        mReferredBy                     = new LNLabel("ttstppersrep0198", LNLabelContext.GENERAL);
        mLoadingReferences              = new LNLabel("ttstppersrep0199", LNLabelContext.GENERAL);
    }

    /**
     * Get the "Field" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getField() {
        return mField;
    }

    /**
     * Get the "Description" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getDescription() {
        return mDescription;
    }

    /**
     * Get the "Element" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getElement() {
        return mElement;
    }

    /**
     * Get the "Selected" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getSelected() {
        return mSelected;
    }

    /**
     * Get the "By Name" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getByName() {
        return mByName;
    }

    /**
     * Get the "By Description" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getByDescription() {
        return mByDescription;
    }

    /**
     * Get the "Refers to" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getRefersTo() {
        return mRefersTo;
    }

    /**
     * Get the "Referred by" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getReferredBy() {
        return mReferredBy;
    }

    /**
     * Get the "Loading references" label.
     * @return an {@link LNLabel}.
     */
    public LNLabel getLoadingReferences() {
        return mLoadingReferences;
    }
}
