package com.infor.ln.wb.common.server;
/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2016 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */


import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

/**
 * Represents a request to be performed on the backend.
 */
@XmlRootElement(name = "request")
public class RequestInput {
    @XmlAttribute(name = "action")
    private String action;
    @XmlElement(name = "param")
    private final List<Param> params = new LinkedList<>();

    /**
     * Constructs an empty RequestInput.
     */
    public RequestInput() {
        // No-arg constructor required for JAXB
    }

    /**
     * Construct an empty RequestInput for the given action.
     * @param action the action to be performed by the backend.
     */
    public RequestInput(final String action) {
        this.action = action;
    }

    /**
     * Sets the parameters of the request to the given arguments.
     * @param params name-value pairs of parameters.
     */
    public void setParams(final String[] params) {
        assert params.length % 2 == 0;
        for (int i = 0; i < params.length; i += 2) {
            this.params.add(new Param(params[i], params[i + 1]));
        }
    }

    /**
     * Add a new parameter to the request.
     * @param name the name of the parameter
     * @param value the value of the paramater.
     */
    public void addParam(String name, String value) {
        this.params.add(new Param(name, value));
    }

    /**
     *
     */
    public static class Param {
        /**
         * The name of the parameter.
         */
        @XmlAttribute
        public String name;
        /**
         * The value of the parameter.
         */
        @XmlValue
        public String value;

        @SuppressWarnings("unused") // called by JAXB
        private Param() {
        }

        /**
         * Construct a new parameter with the given name and value.
         * @param name the name of the parameter
         * @param value the value of the parameter
         */
        public Param(final String name, final String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(final Object obj) {
            if (obj instanceof Param) {
                return ((Param) obj).name.equals(this.name) &&
                        ((Param) obj).value.equals(this.value);
            }
            return false;
        }
    }
}
