/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2016 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.utils;

import com.infor.component.client.utils.RtlUtils;


/**
 * BiDi support methods.
 */
public final class WBRtlUtils extends RtlUtils {
    // BiDi control characters
    // See http://unicode.org/reports/tr9/#Explicit_Directional_Overrides
    // Left-to-Right Embedded; force the following (neutral) characters to be considered embedded left-to-right.
    private static final String BIDI_LRE = "\u202A";
    // Pop Directional Formatting; terminates the scope of the last LRE, RLE, LRO, or RLO.
    private static final String BIDI_PDF = "\u202C";

    private WBRtlUtils() { }

    /**
     * Makes sure that the text is printed left-to-right, even in right-to-left locale.
     * @param text the text print
     * @return the text including the control characters
     */
    public static String forceLeftToRight(String text) {
        return BIDI_LRE + text + BIDI_PDF;
    }

    /**
     * Remove marks previously inserted by {@link #forceLeftToRight(String)}.
     * @param in the string possibly containing the LRE or PDF markers.
     * @return the same string without markers.
     */
    public static String stripMarks(String in) {
        return in.replace(BIDI_LRE, "").replace(BIDI_PDF, "");
    }
}
