/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.web.bindery.event.shared.Event;
import com.infor.ln.wb.common.shared.model.LNTable.Field;

/**
 * This event is fired when a {@link Field} is marked as selected or de-selected.
 */
public class TableFieldSelectionChangeEvent extends Event<TableFieldSelectionChangeEvent.Handler> {
    /**
     * Handler interface for {@link TableFieldSelectionChangeEvent}.
     */
    public interface Handler extends EventHandler {
        /**
         * Called when a field is added to or removed from a dataset.
         * @param fieldName the name of the field that was added or removed.
         * @param element the element number of the field.
         * @param selected indicates whether the field is now selected or not.
         */
        void onFieldSelectionChanged(String fieldName, int element, boolean selected);
    }

    /**
     * Event type for field selection change events.
     */
    public static final Type<Handler> TYPE = new Type<>();

    private final String mFieldName;
    private final int mElement;
    private final boolean mSelected;

    /**
     * Instantiate a new {@link TableFieldSelectionChangeEvent}.
     * @param fieldName the name of the field that was added or removed.
     * @param element the element number of the field
     * @param selected indicates whether the field is now selected or not.
     */
    public TableFieldSelectionChangeEvent(String fieldName, int element, boolean selected) {
        mFieldName = fieldName;
        mElement = element;
        mSelected = selected;
    }

    @Override
    public Type<Handler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(Handler handler) {
        handler.onFieldSelectionChanged(mFieldName, mElement, mSelected);
    }
}
