/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util.encryption;

import com.infor.erpln.util.encryption.HexString;
import com.infor.erpln.util.encryption.Twofish_Algorithm;
import java.security.InvalidKeyException;

public class BlockEncryption {
    private static Twofish_Algorithm tfalg = new Twofish_Algorithm();
    public static final int BLOCKSIZE = 16;
    private static final int NUMBERLOOPS = 16;
    public static final int HEX_STRING_KEY_LENGTH = 64;

    public static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static void blockCopy(byte[] to, byte[] from, int blockToCopy, int direction) {
        int numberBlocks = (from.length - 1) / 16 + 1;
        int SizeToCopy = from.length % 16;
        if (blockToCopy + 1 == numberBlocks) {
            if (SizeToCopy == 0 && from.length != 0) {
                SizeToCopy = 16;
            }
        } else {
            SizeToCopy = 16;
        }
        if (direction == 0) {
            int i;
            for (i = 0; i < SizeToCopy; ++i) {
                to[i] = from[blockToCopy * 16 + i];
            }
            for (i = SizeToCopy; i < 16; ++i) {
                to[i] = 0;
            }
        } else {
            int i;
            for (i = 0; i < SizeToCopy; ++i) {
                to[blockToCopy * 16 + i] = from[i];
            }
            for (i = SizeToCopy; i < 16; ++i) {
                to[blockToCopy * 16 + i] = 0;
            }
        }
    }

    public static byte[] DecryptToByteArray(String cipheredHexString, String hexKey) {
        Object key;
        if (hexKey.length() != 64) {
            return null;
        }
        try {
            key = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(hexKey));
        }
        catch (InvalidKeyException ex) {
            return null;
        }
        byte[] cipheredByteArray = HexString.hexString2ByteArray(cipheredHexString);
        int length = cipheredByteArray.length;
        byte[] plainByteArr = new byte[length];
        byte[] plain = new byte[16];
        byte[] ciphered = new byte[16];
        int numberBlocks = (length - 1) / 16 + 1;
        for (int block = 0; block < numberBlocks; ++block) {
            BlockEncryption.blockCopy(ciphered, cipheredByteArray, block, 0);
            for (int c = 0; c < 16; ++c) {
                plain = Twofish_Algorithm.blockDecrypt(ciphered, 0, key);
                BlockEncryption.blockCopy(ciphered, plain, 0, 0);
            }
            BlockEncryption.blockCopy(plainByteArr, plain, block, 1);
        }
        return plainByteArr;
    }

    public static String DecryptToString(String cipheredHexString, String hexKey) {
        Object key;
        if (hexKey.length() != 64) {
            return null;
        }
        try {
            key = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(hexKey));
        }
        catch (InvalidKeyException ex) {
            return null;
        }
        byte[] cipheredByteArray = HexString.hexString2ByteArray(cipheredHexString);
        int length = cipheredByteArray.length;
        byte[] plainByteArr = new byte[length];
        byte[] plain = new byte[16];
        byte[] ciphered = new byte[16];
        int numberBlocks = (length - 1) / 16 + 1;
        for (int block = 0; block < numberBlocks; ++block) {
            BlockEncryption.blockCopy(ciphered, cipheredByteArray, block, 0);
            for (int c = 0; c < 16; ++c) {
                plain = Twofish_Algorithm.blockDecrypt(ciphered, 0, key);
                BlockEncryption.blockCopy(ciphered, plain, 0, 0);
            }
            BlockEncryption.blockCopy(plainByteArr, plain, block, 1);
        }
        String _s = new String(plainByteArr);
        return _s.trim();
    }

    public static String Encrypt(byte[] plainByteArray, String hexKey) {
        Object key;
        if (hexKey.length() != 64) {
            return null;
        }
        try {
            key = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(hexKey));
        }
        catch (InvalidKeyException ex) {
            return null;
        }
        int length = plainByteArray.length;
        byte[] plain = new byte[16];
        byte[] ciphered = new byte[16];
        int numberBlocks = (length - 1) / 16 + 1;
        byte[] cipheredByteArray = new byte[numberBlocks * 16];
        for (int block = 0; block < numberBlocks; ++block) {
            BlockEncryption.blockCopy(plain, plainByteArray, block, 0);
            for (int c = 0; c < 16; ++c) {
                ciphered = Twofish_Algorithm.blockEncrypt(plain, 0, key);
                BlockEncryption.blockCopy(plain, ciphered, 0, 0);
            }
            BlockEncryption.blockCopy(cipheredByteArray, ciphered, block, 1);
        }
        return HexString.byteArray2HexString(cipheredByteArray);
    }

    public static String Encrypt(String plainString, String hexKey) {
        Object key;
        byte[] plainByteArray = plainString.getBytes();
        if (hexKey.length() != 64) {
            return "";
        }
        try {
            key = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(hexKey));
        }
        catch (InvalidKeyException ex) {
            return null;
        }
        int length = plainByteArray.length;
        byte[] plain = new byte[16];
        byte[] ciphered = new byte[16];
        int numberBlocks = (length - 1) / 16 + 1;
        byte[] cipheredByteArray = new byte[numberBlocks * 16];
        for (int block = 0; block < numberBlocks; ++block) {
            BlockEncryption.blockCopy(plain, plainByteArray, block, 0);
            for (int c = 0; c < 16; ++c) {
                ciphered = Twofish_Algorithm.blockEncrypt(plain, 0, key);
                BlockEncryption.blockCopy(plain, ciphered, 0, 0);
            }
            BlockEncryption.blockCopy(cipheredByteArray, ciphered, block, 1);
        }
        return HexString.byteArray2HexString(cipheredByteArray);
    }
}

