/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NiceW3CDOMWriter {
    private static final String s_encoding = "UTF8";
    private OutputStreamWriter writer;
    private OutputStream output;
    private Node root;
    private int initialLevel = 0;
    private int initialIndent = 4;
    private static String lineSeperator = System.getProperty("line.separator");
    boolean needsNewLine = true;
    protected static final String COMMENT_START = "<!--";
    protected static final String COMMENT_END = "-->";
    protected static final String HEADER = "<?xml version=\"1.0\"?>";
    protected static final String PI_START = "<?";
    protected static final String PI_END = "?>";
    protected static final char WHITESPACE = ' ';
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char START_TAG = '<';
    protected static final char END_TAG = '>';
    protected static final char SLASH = '/';
    protected static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    protected static final char[] LT = new char[]{'&', 'l', 't', ';'};
    protected static final char[] GT = new char[]{'&', 'g', 't', ';'};
    protected static final char[] QUOTE_ENTITY = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected static final char[] APOS_ENTITY = new char[]{'&', 'a', 'p', 'o', 's', ';'};

    public NiceW3CDOMWriter() {
    }

    public String writeNode(Node node, int indent) {
        return NiceW3CDOMWriter.getPrettyXml(node, indent);
    }

    public NiceW3CDOMWriter(Node node) {
        this(node, new ByteArrayOutputStream(), 0, 4);
    }

    public NiceW3CDOMWriter(Node node, int level, int indent) {
        this(node, new ByteArrayOutputStream(), level, indent);
    }

    public NiceW3CDOMWriter(Node node, OutputStream target, int level, int indent) {
        this.root = node;
        this.output = target;
        this.initialLevel = level;
        this.initialIndent = indent;
    }

    public static String getPrettyXml(Node node, int indent) {
        String retString;
        NiceW3CDOMWriter domWriter = new NiceW3CDOMWriter(node, 0, indent);
        try {
            domWriter.serialize();
            retString = domWriter.toString();
        }
        catch (IOException ioe) {
            retString = "Could not serialize node";
        }
        return retString;
    }

    private void serialize() throws IOException {
        try {
            this.writer = new OutputStreamWriter(this.output, s_encoding);
            this.write(this.root, this.initialLevel, this.initialIndent);
            this.writer.flush();
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    public void flush() {
        try {
            if (this.output != null) {
                this.serialize();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                return ((ByteArrayOutputStream)this.output).toString(s_encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return super.toString();
    }

    public byte[] getBytes() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                this.serialize();
                return ((ByteArrayOutputStream)this.output).toByteArray();
            }
            catch (IOException ioe) {
                return super.toString().getBytes();
            }
        }
        return super.toString().getBytes();
    }

    protected void write(Node node, int level, int indent) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                this.writer.write(HEADER);
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.write(child, level, indent);
                }
                if (!this.needsNewLine) break;
                this.newLine();
                this.indent(level, indent);
                break;
            }
            case 1: {
                Node firstChild;
                NamedNodeMap attributes;
                this.newLine();
                this.indent(level, indent);
                this.writer.write(60);
                String name = node.getNodeName();
                if (name != null) {
                    this.writer.write(name);
                }
                if ((attributes = node.getAttributes()) != null) {
                    int numAttribs = attributes.getLength();
                    for (int i = 0; i < numAttribs; ++i) {
                        this.write(attributes.item(i), level + 1, indent);
                    }
                }
                if ((firstChild = node.getFirstChild()) == null) {
                    this.writer.write(47);
                    this.writer.write(62);
                    break;
                }
                this.writer.write(62);
                while (firstChild != null) {
                    this.write(firstChild, level + 1, indent);
                    firstChild = firstChild.getNextSibling();
                }
                if (this.needsNewLine) {
                    this.newLine();
                    this.indent(level, indent);
                }
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(name);
                this.writer.write(62);
                this.needsNewLine = true;
                break;
            }
            case 3: {
                String data = node.getNodeValue();
                if (this.isSpace(data)) {
                    this.needsNewLine = true;
                    break;
                }
                this.needsNewLine = false;
                int length = data.length();
                for (int i = 0; i < length; ++i) {
                    char ch = data.charAt(i);
                    if (ch == '<') {
                        this.writer.write(LT);
                        continue;
                    }
                    if (ch == '&') {
                        this.writer.write(AMP);
                        continue;
                    }
                    if (ch == '>') {
                        this.writer.write(GT);
                        continue;
                    }
                    this.writer.write(ch);
                }
                break;
            }
            case 2: {
                this.writer.write(32);
                this.writer.write(node.getNodeName());
                this.writer.write(61);
                this.writer.write(34);
                String data = node.getNodeValue();
                if (data != null) {
                    for (int i = 0; i < data.length(); ++i) {
                        char ch = data.charAt(i);
                        if (ch == '\"') {
                            this.writer.write(QUOTE_ENTITY);
                            continue;
                        }
                        if (ch == '\'') {
                            this.writer.write(APOS_ENTITY);
                            continue;
                        }
                        if (ch == '<') {
                            this.writer.write(LT);
                            continue;
                        }
                        if (ch == '&') {
                            this.writer.write(AMP);
                            continue;
                        }
                        this.writer.write(ch);
                    }
                }
                this.writer.write(34);
                break;
            }
            case 4: {
                this.writeCDATA(node);
                break;
            }
            case 8: {
                this.newLine();
                this.indent(level, indent);
                this.writer.write(COMMENT_START);
                this.writer.write(node.getNodeValue());
                this.writer.write(COMMENT_END);
                break;
            }
            case 11: {
                this.writeDocumentFragment(node);
                break;
            }
            case 10: {
                this.writeDTD(node);
                break;
            }
            case 6: {
                this.writeEntity(node);
                break;
            }
            case 5: {
                this.writeEntityReference(node);
                break;
            }
            case 12: {
                this.writeNotation(node);
                break;
            }
            case 7: {
                this.newLine();
                this.indent(level, indent);
                this.writer.write(PI_START);
                this.writer.write(node.getNodeName());
                this.writer.write(32);
                this.writer.write(node.getNodeValue());
                this.writer.write(PI_END);
            }
        }
    }

    protected void newLine() throws IOException {
        this.writer.write(lineSeperator);
    }

    void indent(int level, int indent) throws IOException {
        for (int i = 0; i < level; ++i) {
            for (int j = 0; j < indent; ++j) {
                this.writer.write(32);
            }
        }
    }

    protected void writeCDATA(Node node) throws IOException {
    }

    protected void writeNotation(Node node) throws IOException {
    }

    protected void writeEntityReference(Node node) throws IOException {
    }

    protected void writeEntity(Node node) throws IOException {
    }

    protected void writeDocumentFragment(Node node) throws IOException {
    }

    protected void writeDTD(Node node) throws IOException {
    }

    boolean isSpace(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

