/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import com.infor.erpln.util.ConnectionPointActivation;
import java.io.Serializable;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConnectionPointActivation mActivation;
    private String mName;
    private String mHostName;
    private int mPort;
    private int mTimerDelay = 0;
    private int mMaxConnections;
    private int mMaxReferences;
    private int mMaxThreads;
    private boolean mForceCleanup = true;
    private String mLinkTo;
    private int mBdeManagerCompany = -1;
    private static final Logger LOG = ESAPI.getLogger(ConnectionPoint.class);

    public ConnectionPointActivation createActivation() {
        this.mActivation = new ConnectionPointActivation();
        return this.mActivation;
    }

    public ConnectionPointActivation getActivation() {
        return this.mActivation;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String iName) {
        this.mName = iName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHostName(String iHostName) {
        this.mHostName = iHostName;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setPort(String iPort) {
        Integer port = new Integer(iPort);
        this.mPort = port;
    }

    public int getTimerDelay() {
        if (this.mTimerDelay == 0) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Using a default timer delay for the ConnectionPool of 0 secs (no timer)");
        }
        return this.mTimerDelay;
    }

    public void setTimerDelay(String iTimerDelay) {
        Integer timer = new Integer(iTimerDelay);
        this.mTimerDelay = timer;
    }

    public String getLinkTo() {
        return this.mLinkTo;
    }

    public void setLinkTo(String iLinkTo) {
        this.mLinkTo = iLinkTo;
    }

    public boolean isAlias() {
        return this.mLinkTo != null;
    }

    public int getMaxConnections() {
        return this.mMaxConnections;
    }

    public void setMaxConnections(String pMaxConnections) {
        this.mMaxConnections = Integer.parseInt(pMaxConnections);
    }

    public int getMaxReferences() {
        return this.mMaxReferences;
    }

    public void setMaxReferences(String pMaxReferences) {
        this.mMaxReferences = Integer.parseInt(pMaxReferences);
    }

    public int getMaxThreads() {
        return this.mMaxThreads;
    }

    public void setMaxThreads(String pMaxThreads) {
        this.mMaxThreads = Integer.parseInt(pMaxThreads);
    }

    public boolean getForceCleanup() {
        return this.mForceCleanup;
    }

    public void setForceCleanup(boolean iValue) {
        this.mForceCleanup = iValue;
    }

    public int getBdeManagerCompany() {
        return this.mBdeManagerCompany;
    }

    public void setBdeManagerCompany(String pBdeManCompany) {
        this.mBdeManagerCompany = Integer.parseInt(pBdeManCompany);
    }
}

