/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.NetReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public final class SockNetReader
implements NetReader {
    private static final Logger LOG = ESAPI.getLogger(SockNetReader.class);
    private DataInputStream m_is;

    public SockNetReader(DataInputStream is) {
        this.m_is = is;
    }

    @Override
    public DsMessage readMessage() throws IOException {
        DsMessage dsMes = null;
        int indicator = this.m_is.readInt();
        switch (indicator) {
            case 15: {
                dsMes = this.readInitRepFrame();
                break;
            }
            case 17: {
                dsMes = this.readBdeOpenAckFrame();
                break;
            }
            case 4: {
                dsMes = this.readFileOpenAckFrame();
                break;
            }
            case 6: {
                dsMes = this.readFileReadAckFrame();
                break;
            }
            case 8: {
                dsMes = this.readFileWriteAckFrame();
                break;
            }
            case 10: {
                dsMes = this.readFileCloseAckFrame();
                break;
            }
            case 19: {
                dsMes = this.readBdeDispAckFrame();
                break;
            }
            case 29: {
                dsMes = this.readBodDispAckFrame();
                break;
            }
            case 49: {
                dsMes = this.readRestDispAckFrame();
                break;
            }
            case 2: {
                dsMes = this.readExecDllAckFrame();
                break;
            }
            case 31: {
                dsMes = this.readExecSqlAckFrame();
                break;
            }
            case 21: {
                dsMes = this.readBdeLocStartAck();
                break;
            }
            case 23: {
                dsMes = this.readBdeLocAbortAck();
                break;
            }
            case 25: {
                dsMes = this.readBdeLocCommitAck();
                break;
            }
            case 27: {
                dsMes = this.readBdeCloseAck();
                break;
            }
            case 32: {
                dsMes = this.readPubInitReq();
                break;
            }
            case 34: {
                dsMes = this.readPubBdeReq();
                break;
            }
            case 36: {
                dsMes = this.readPubBodReq();
                break;
            }
            default: {
                throw new IOException("Unexpected message indicator: " + indicator);
            }
        }
        DsAttribute dsAttr = new DsAttribute(353);
        dsAttr.setValue(indicator);
        dsMes.addAttribute(dsAttr);
        dsMes.setType(24);
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, dsMes.toString());
        }
        return dsMes;
    }

    private DsMessage readInitRepFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(1);
        this.readAttribute(223, dsMes, 1);
        int serverProtocolVersion = dsMes.getAttribute(223).getValueInt();
        this.readAttribute(200, dsMes, 3);
        this.readAttribute(62, dsMes, 3);
        this.readAttribute(15, dsMes, 3);
        this.readAttribute(52, dsMes, 1);
        if (serverProtocolVersion >= 6) {
            this.readAttribute(274, dsMes, 3);
        }
        return dsMes;
    }

    private DsMessage readFileOpenAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(1);
        this.readAttribute(349, dsMes, 1);
        return dsMes;
    }

    private DsMessage readFileReadAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(1);
        this.readAttribute(349, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readFileWriteAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(1);
        this.readAttribute(349, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readFileCloseAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(1);
        this.readAttribute(349, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readBdeOpenAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        return dsMes;
    }

    private DsMessage readBdeDispAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readBodDispAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readRestDispAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        this.readAttribute(33, dsMes, 4);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readExecDllAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readExecSqlAckFrame() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readBdeLocStartAck() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readBdeLocAbortAck() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readBdeLocCommitAck() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readBdeCloseAck() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(2);
        this.readAttribute(8, dsMes, 1);
        this.readAttribute(52, dsMes, 1);
        return dsMes;
    }

    private DsMessage readPubInitReq() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(3);
        this.readAttribute(223, dsMes, 1);
        return dsMes;
    }

    private DsMessage readPubBdeReq() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(3);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private DsMessage readPubBodReq() throws IOException {
        DsMessage dsMes = new DsMessage();
        dsMes.setFamily(3);
        this.readAttribute(33, dsMes, 4);
        this.readAttribute(215, dsMes, 4);
        return dsMes;
    }

    private void readAttribute(int a_attributeType, DsMessage a_message, int dataType) throws IOException {
        DsAttribute attr = new DsAttribute(a_attributeType);
        switch (dataType) {
            case 1: 
            case 2: {
                attr.setValue(this.m_is.readInt());
                break;
            }
            case 3: {
                attr.setValue(this.readString());
                break;
            }
            case 4: {
                attr.setValue(this.readVoid());
                break;
            }
            case 5: {
                attr.setValue(this.readShortArray());
                break;
            }
            case 6: 
            case 8: {
                attr.setValue(this.readIntArray());
                break;
            }
            case 11: {
                attr.setValue(this.m_is.readShort());
                break;
            }
            case 10: {
                attr.setValue(this.m_is.readUnsignedByte());
                break;
            }
            default: {
                throw new IOException("Illegal attribute type: " + attr.getDataType() + "for attribute: " + a_attributeType);
            }
        }
        a_message.addAttribute(attr);
    }

    private String readString() throws IOException {
        try {
            String retStr = this.m_is.readUTF();
            return retStr;
        }
        catch (UTFDataFormatException e) {
            throw new IOException("UTF-8 String format error");
        }
    }

    private byte[] readVoid() throws IOException {
        int totalRead = 0;
        int length = this.m_is.readInt();
        if (length < 0) {
            length = 0;
        }
        byte[] buffer = new byte[length];
        while (totalRead < length) {
            int part = this.m_is.read(buffer, totalRead, length - totalRead);
            if (part < 0) {
                throw new IOException("unexpected EOF read");
            }
            totalRead += part;
        }
        return buffer;
    }

    private short[] readShortArray() throws IOException {
        int length = this.m_is.readInt();
        short[] buffer = new short[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.m_is.readShort();
        }
        return buffer;
    }

    private int[] readIntArray() throws IOException {
        int length = this.m_is.readInt();
        int[] buffer = new int[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.m_is.readInt();
        }
        return buffer;
    }
}

