/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.Listener;
import com.infor.erpln.protocol.MessageServer;
import com.infor.erpln.protocol.SockConnector;
import com.infor.erpln.protocol.SockMessageServer;
import com.infor.erpln.protocol.SockNetReader;
import com.infor.erpln.util.XmlUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class SockListener
extends Thread
implements Listener {
    BDEConsumer mBDEConsumer;
    byte[] mConsumerMetaData;
    ServerSocket mServerSocket;
    boolean mRunning;
    Vector<SockMessageServer> mMessageServers;
    private static final Logger LOG = ESAPI.getLogger(SockListener.class);

    public void activateListener(int iPort, BDEConsumer iConsumer, byte[] iConsumerMetaData) throws BaanConnectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "activateListener(), port: " + Integer.toString(iPort));
        }
        if (this.mRunning) {
            throw new BaanConnectionException("Listener already active", 7);
        }
        this.mBDEConsumer = iConsumer;
        this.doActivateListener(iPort, iConsumerMetaData);
    }

    @Override
    public byte[] getMetaData() {
        return this.mConsumerMetaData;
    }

    private void doActivateListener(int iPort, byte[] iConsumerMetaData) throws BaanConnectionException {
        this.mConsumerMetaData = iConsumerMetaData;
        this.mMessageServers = new Vector();
        try {
            this.mServerSocket = new ServerSocket(iPort);
        }
        catch (IOException e) {
            throw new BaanConnectionException("Creation of listener socket failed", 5);
        }
        this.mRunning = true;
        this.start();
    }

    public void endListener() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "endListener()");
        this.mRunning = false;
        try {
            this.mServerSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration<SockMessageServer> e = this.mMessageServers.elements();
        while (e.hasMoreElements()) {
            SockMessageServer mesServer = e.nextElement();
            mesServer.stopServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.mRunning) {
            try {
                Socket acceptSocket = this.mServerSocket.accept();
                acceptSocket.setTcpNoDelay(true);
                DataInputStream is = new DataInputStream(acceptSocket.getInputStream());
                DataOutputStream os = new DataOutputStream(acceptSocket.getOutputStream());
                SockMessageServer mesServer = new SockMessageServer(acceptSocket, new SockNetReader(is), null);
                mesServer.setConnectorObject(new SockConnector(os));
                mesServer.setListener(this);
                SockListener sockListener = this;
                synchronized (sockListener) {
                    this.mMessageServers.add(mesServer);
                }
                mesServer.start();
            }
            catch (IOException e) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Socket closed event");
            }
        }
    }

    @Override
    public synchronized void removeMessageServer(MessageServer a_messageServer) {
        if (this.mMessageServers != null) {
            this.mMessageServers.remove(a_messageServer);
        }
    }

    @Override
    public synchronized int onBDEMessage(byte[] a_bdeMessage) {
        if (this.mBDEConsumer != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Received BDE Event:\n" + XmlUtil.getPrettyXml(a_bdeMessage));
            }
            return this.mBDEConsumer.onBDEMessage(a_bdeMessage);
        }
        return -1;
    }
}

