/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class SSLStoreParameters {
    private String m_keyStore;
    private String m_keyStorePassword;
    private String m_trustStore;
    private String m_trustStorePassword;
    private static final Map<String, String> s_typeMap = SSLStoreParameters.createTypeMap();

    public String getKeyStore() {
        return this.m_keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.m_keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.m_keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.m_keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.pathToStoreType(this.m_keyStore);
    }

    public String getTrustStore() {
        return this.m_trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.m_trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.m_trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.m_trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.pathToStoreType(this.m_trustStore);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSLStoreParameters)) {
            return false;
        }
        SSLStoreParameters other = (SSLStoreParameters)obj;
        if (this.m_keyStore != null && !this.m_keyStore.equals(other.m_keyStore)) {
            return false;
        }
        return this.m_trustStore == null || this.m_trustStore.equals(other.m_trustStore);
    }

    public int hashCode() {
        int result = 17;
        if (this.m_keyStore != null) {
            result = 31 * result + this.m_keyStore.hashCode();
        }
        if (this.m_trustStore != null) {
            result = 31 * result + this.m_trustStore.hashCode();
        }
        return result;
    }

    private static Map<String, String> createTypeMap() {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put(".jks", "JKS");
        typeMap.put(".p12", "PKCS12");
        typeMap.put(".pfx", "PKCS12");
        typeMap.put(".bcfks", "BCFKS");
        return typeMap;
    }

    private String pathToStoreType(String storePath) {
        int index;
        String storeType = null;
        if (storePath != null && (index = storePath.lastIndexOf(46)) >= 0) {
            String extension = storePath.substring(index).toLowerCase();
            storeType = s_typeMap.get(extension);
        }
        return storeType == null ? KeyStore.getDefaultType() : storeType;
    }
}

