/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    private String m_charBuf;
    private String m_delimeters = "\t ";
    private final int m_numTokens;
    private int m_curToken = 0;
    private final CharIterator m_iterator;

    public QuotedStringTokenizer(String s) {
        if (null == s) {
            throw new IllegalArgumentException("null param");
        }
        this.m_charBuf = s;
        this.m_numTokens = this.countTokens();
        this.m_iterator = new CharIterator(this.m_charBuf);
    }

    public boolean hasMoreTokens() {
        return this.m_curToken < this.m_numTokens;
    }

    public String nextToken() {
        char c;
        if (this.m_curToken == this.m_numTokens) {
            throw new NoSuchElementException();
        }
        StringBuffer sb = new StringBuffer();
        boolean bQuote = false;
        while ((c = this.m_iterator.next()) != '\uffff') {
            boolean isDelimiter = this.isDelimiter(c);
            if (!isDelimiter) {
                char next;
                if (c == '\"') {
                    bQuote = !bQuote;
                } else {
                    sb.append(c);
                }
                if ((next = this.m_iterator.peekNext()) != '\uffff' && (!this.isDelimiter(next) || bQuote)) continue;
                break;
            }
            if (!bQuote) continue;
            sb.append(c);
        }
        ++this.m_curToken;
        return sb.toString();
    }

    private boolean isDelimiter(char c) {
        return this.m_delimeters.indexOf(c) >= 0;
    }

    private int countTokens() {
        char c;
        int tokens = 0;
        boolean bQuote = false;
        CharIterator it = new CharIterator(this.m_charBuf);
        while ((c = it.next()) != '\uffff') {
            char next = it.peekNext();
            if (!this.isDelimiter(c)) {
                if (c == '\"') {
                    boolean bl = bQuote = !bQuote;
                }
                if (next != '\uffff' && (!this.isDelimiter(next) || bQuote)) continue;
                ++tokens;
                continue;
            }
            if (next != '\uffff' || !bQuote) continue;
            ++tokens;
        }
        return tokens;
    }

    private static final class CharIterator {
        static final char EOF = '\uffff';
        private final String m_buf;
        private int m_index = 0;

        private CharIterator(String a_buf) {
            this.m_buf = a_buf;
        }

        char next() {
            if (this.m_index >= this.m_buf.length()) {
                return '\uffff';
            }
            char c = this.m_buf.charAt(this.m_index);
            ++this.m_index;
            return c;
        }

        char peekNext() {
            if (this.m_index >= this.m_buf.length()) {
                return '\uffff';
            }
            return this.m_buf.charAt(this.m_index);
        }
    }
}

