/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.EISMetaData;
import com.infor.erpln.protocol.HttpClient;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.SSLStoreParameters;
import com.infor.erpln.protocol.SessionLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpSessionLayer
implements SessionLayer {
    private HttpClient m_httpClient;
    private JcaHandler m_jcaHandler;
    private boolean m_valid;
    private final SSLStoreParameters m_storeParameters;

    public HttpSessionLayer(SSLStoreParameters storeParameters) {
        this.m_storeParameters = storeParameters;
    }

    @Override
    public void connect(ConnectionConfig a_connectData) throws BaanConnectionException {
        if (this.m_httpClient != null) {
            throw new IllegalStateException("HttpSession already connected");
        }
        this.m_httpClient = new HttpClient(a_connectData, this.m_storeParameters);
        this.m_jcaHandler = this.m_httpClient.connect();
        this.m_valid = true;
    }

    @Override
    public void validate(ConnectionConfig a_connectData) throws BaanConnectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.m_httpClient != null) {
            try {
                this.m_httpClient.close("");
            }
            catch (BaanConnectionException baanConnectionException) {
                // empty catch block
            }
        }
        this.m_httpClient = null;
        this.m_valid = false;
    }

    @Override
    public JcaHandler getBdeManager(int iCompany) throws BaanConnectionException {
        JcaHandler jcaHandler;
        if (this.m_jcaHandler != null) {
            jcaHandler = this.m_jcaHandler;
            this.m_jcaHandler = null;
        } else {
            jcaHandler = this.m_httpClient.share(iCompany);
        }
        return jcaHandler;
    }

    @Override
    public InputStream openForRead(String a_serverFile, boolean a_textMode, boolean a_polling) throws IOException, BaanConnectionException {
        return this.m_httpClient.openForRead(a_serverFile, a_textMode);
    }

    @Override
    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        return this.m_httpClient.openForWrite(a_serverFile, a_textMode);
    }

    @Override
    public EISMetaData getMetaData() {
        return this.m_httpClient.getEISMetaData();
    }

    @Override
    public String getStartupMessages() {
        return "";
    }

    @Override
    public void activateListener(BDEConsumer iConsumer, byte[] iConsumerMetaData) throws BaanConnectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        return this.m_valid;
    }
}

