/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.DispatchBdeResult;
import com.infor.erpln.protocol.DispatchBdeResultImpl;
import com.infor.erpln.protocol.EISMetaData;
import com.infor.erpln.protocol.EISMetaDataImpl;
import com.infor.erpln.protocol.HttpHandlerImpl;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.LogUtil;
import com.infor.erpln.protocol.SSLFactoryCache;
import com.infor.erpln.protocol.SSLStoreParameters;
import com.infor.erpln.util.StringUtils;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpClient {
    private static final Logger LOG = ESAPI.getLogger(HttpClient.class);
    private final ConnectionConfig m_connectData;
    private final SSLStoreParameters m_storeParameters;
    private final Set<String> m_openHandlers = new HashSet<String>();
    private EISMetaData m_EISMetaData;
    private Map<String, String> m_cookies;
    private Timer m_idleTimer;
    private static final SAXParserFactory s_saxParserFactory = XmlUtil.createSAXParserFactory();

    public HttpClient(ConnectionConfig connectData, SSLStoreParameters storeParameters) {
        this.m_connectData = connectData;
        this.m_storeParameters = storeParameters;
    }

    public JcaHandler connect() throws BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            StringBuffer logmess = new StringBuffer();
            logmess.append("Setup connection: URL='").append(this.m_connectData.getBackend()).append("', TYPE='").append(this.m_connectData.getConnectionMethodString()).append("',ENVIRONMENT='").append(this.m_connectData.getBSE()).append("'");
            StringUtils.addToBuf(logmess, "APPLICATION", this.m_connectData.getApplication());
            StringUtils.addToBuf(logmess, "CLIENTHOST", this.m_connectData.getClientLocationHost());
            StringUtils.addToBuf(logmess, "CLIENTIP", this.m_connectData.getClientLocationIP());
            LOG.info(Logger.EVENT_UNSPECIFIED, logmess.toString());
        }
        HttpHandlerImpl jcaHandler = null;
        if (StringUtils.isEmpty(this.m_connectData.getApplication())) {
            throw new BaanConnectionException("Missing Application name", 2);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "connect");
        if (StringUtils.isNotEmpty(this.m_connectData.getBSE())) {
            params.put("environment", this.m_connectData.getBSE());
        }
        if (this.m_connectData.getCompany() != -1) {
            params.put("company", String.valueOf(this.m_connectData.getCompany()));
        }
        if (StringUtils.isNotEmpty(this.m_connectData.getCommand())) {
            params.put("command", this.m_connectData.getCommand());
        }
        if (StringUtils.isNotEmpty(this.m_connectData.getClientLocationHost())) {
            params.put("clientHost", this.m_connectData.getClientLocationHost());
        }
        if (StringUtils.isNotEmpty(this.m_connectData.getClientLocationIP())) {
            params.put("clientIp", this.m_connectData.getClientLocationIP());
        }
        HttpURLConnection urlConnection = this.openUrl(params, null);
        try {
            this.sendRequest(urlConnection);
            jcaHandler = this.handleConnectResponse(urlConnection.getInputStream());
            this.m_cookies = this.getCookies(urlConnection);
            this.m_openHandlers.add(jcaHandler.getConid());
        }
        catch (IOException e) {
            throw new BaanConnectionException("Error opening input stream", 1, e);
        }
        return jcaHandler;
    }

    public void close(String conid) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: close() : " + conid);
        boolean hasConid = StringUtils.isNotEmpty(conid);
        if (this.m_openHandlers.isEmpty() || hasConid && !this.m_openHandlers.contains(conid)) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Nothing to be closed");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "disconnect");
        if (hasConid) {
            params.put("conid", conid);
        }
        HttpURLConnection urlConnection = this.openUrl(params, null);
        try {
            this.sendRequest(urlConnection);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (hasConid) {
            this.m_openHandlers.remove(conid);
        } else {
            this.m_openHandlers.clear();
        }
        if (this.m_openHandlers.isEmpty()) {
            this.stopIdleTimer();
            this.m_cookies = null;
        }
    }

    public JcaHandler share(int company) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: share() : " + company);
        HttpHandlerImpl jcaHandler = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "share");
        if (company >= 0) {
            params.put("company", String.valueOf(company));
        }
        HttpURLConnection urlConnection = this.openUrl(params, null);
        try {
            this.sendRequest(urlConnection);
            jcaHandler = this.handleShareResponse(urlConnection.getInputStream());
            this.m_openHandlers.add(jcaHandler.getConid());
        }
        catch (IOException e) {
            throw new BaanConnectionException("Error opening input stream", 1, e);
        }
        return jcaHandler;
    }

    public DispatchBdeResult dispatchBDE(String conid, String bdename, String bdemethod, byte[] request) throws BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "dispatchBDE BdeName='" + bdename + "' Method='" + bdemethod + "'\n" + XmlUtil.getPrettyXml(request));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "bdecall");
        params.put("bdename", bdename);
        params.put("bdemethod", bdemethod);
        params.put("conid", conid);
        HttpURLConnection urlConnection = this.openUrl(params, request);
        try {
            this.sendRequest(urlConnection);
            int length = urlConnection.getContentLength();
            byte[] responseBuffer = this.getResponseBuffer(urlConnection.getInputStream(), length);
            int returnValue = urlConnection.getHeaderFieldInt("X-Infor-BDEException", 0);
            if (LOG.isInfoEnabled()) {
                LOG.info(Logger.EVENT_SUCCESS, "BDE return value:'" + Integer.toString(returnValue) + "'\n" + XmlUtil.getPrettyXml(responseBuffer));
            }
            return new DispatchBdeResultImpl(returnValue, responseBuffer);
        }
        catch (IOException e) {
            throw new BaanConnectionException("Error reading input stream", 1, e);
        }
    }

    public byte[] executeBaanDll(String conid, byte[] request, Vector<String> errors, Set<MessageOption> options) throws BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            StringBuilder logMessage = new StringBuilder("executeBaanDll() request");
            LogUtil.appendXml(logMessage, options.contains((Object)MessageOption.HIDE_REQUEST_LOG), request);
            LOG.info(Logger.EVENT_UNSPECIFIED, logMessage.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "dllcall");
        params.put("conid", conid);
        HttpURLConnection urlConnection = this.openUrl(params, request);
        try {
            this.sendRequest(urlConnection);
            int length = urlConnection.getContentLength();
            byte[] responseBuffer = this.getResponseBuffer(urlConnection.getInputStream(), length);
            if (LOG.isInfoEnabled()) {
                StringBuilder logMessage = new StringBuilder("executeBaanDll() response");
                LogUtil.appendXml(logMessage, options.contains((Object)MessageOption.HIDE_RESPONSE_LOG), responseBuffer);
                LOG.info(Logger.EVENT_SUCCESS, logMessage.toString());
            }
            return responseBuffer;
        }
        catch (IOException e) {
            throw new BaanConnectionException("Error reading input stream", 1, e);
        }
    }

    public InputStream openForRead(String a_serverFile, boolean a_textMode) throws BaanConnectionException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "file_download");
        params.put("filename", a_serverFile);
        if (a_textMode) {
            params.put("mode", "text");
        }
        HttpURLConnection urlConnection = this.openUrl(params, null);
        this.sendRequest(urlConnection);
        return urlConnection.getInputStream();
    }

    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws BaanConnectionException, IOException {
        HttpURLConnection connection;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "file_upload");
        params.put("filename", a_serverFile);
        if (a_textMode) {
            params.put("mode", "text");
        }
        URL url = this.getUrl(params);
        try {
            connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(this.getSSLSocketFactory());
            }
            this.setRequestHeaders(connection);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setChunkedStreamingMode(0);
        }
        catch (IOException e) {
            throw new BaanConnectionException("URL open failed", 1, e);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        ServerOutputStream outputStream = new ServerOutputStream(connection.getOutputStream(), new CloseHandler(){

            @Override
            public void onClosed() throws IOException {
                try {
                    HttpClient.this.sendRequest(connection);
                }
                catch (BaanConnectionException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
        });
        return outputStream;
    }

    private <T> T doUnmarshall(Class<T> clazz, InputStream inputStream) throws JAXBException {
        try {
            Unmarshaller jaxbUnmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
            SAXSource xmlSource = new SAXSource(s_saxParserFactory.newSAXParser().getXMLReader(), new InputSource(inputStream));
            return (T)jaxbUnmarshaller.unmarshal((Source)xmlSource);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private void sendRequest(HttpURLConnection urlConnection) throws BaanConnectionException, IOException {
        int httpStatus;
        try {
            urlConnection.connect();
            httpStatus = urlConnection.getResponseCode();
        }
        catch (IOException e) {
            throw new BaanConnectionException("LN UI Host cannot be reached", 1, e);
        }
        switch (httpStatus) {
            case 200: {
                break;
            }
            case 404: {
                throw new BaanConnectionException("URL not found:" + this.m_connectData.getBackend(), 1);
            }
            case 401: {
                throw new BaanConnectionException("Authentication failure", 2);
            }
            case 500: {
                this.handleServerError(urlConnection.getErrorStream());
                break;
            }
            default: {
                throw new BaanConnectionException("HTTP error code:" + httpStatus, 6);
            }
        }
    }

    private void sendPing() {
        boolean keepRunning = false;
        if (!this.m_openHandlers.isEmpty()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("method", "ping");
            try {
                HttpURLConnection urlConnection = this.openUrl(params, null);
                this.sendRequest(urlConnection);
                keepRunning = true;
            }
            catch (BaanConnectionException | IOException exception) {
                // empty catch block
            }
        }
        if (!keepRunning) {
            this.stopIdleTimer();
        }
    }

    private void startIdleTimer(long idleTime) {
        this.m_idleTimer = new Timer();
        this.m_idleTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                HttpClient.this.sendPing();
            }
        }, idleTime, idleTime);
    }

    private void stopIdleTimer() {
        if (this.m_idleTimer != null) {
            this.m_idleTimer.cancel();
            this.m_idleTimer = null;
        }
    }

    private HttpURLConnection openUrl(Map<String, String> params, byte[] postData) throws BaanConnectionException {
        URL url = this.getUrl(params);
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(this.getSSLSocketFactory());
            }
            this.setRequestHeaders(connection);
            if (postData == null) {
                connection.setRequestMethod("GET");
            } else {
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/xml;charset=utf-8");
                connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(postData.length);
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(postData);
                outputStream.flush();
                outputStream.close();
            }
            return connection;
        }
        catch (IOException e) {
            throw new BaanConnectionException("URL open failed", 1, e);
        }
    }

    private void setRequestHeaders(HttpURLConnection connection) throws BaanConnectionException {
        switch (this.m_connectData.getConnectionMethod()) {
            case 10: {
                this.handleBasicAuthentication(connection);
                break;
            }
            case 11: {
                this.handleOAuth2Authentication(connection);
                break;
            }
            default: {
                throw new BaanConnectionException("Wrong connection method", 2);
            }
        }
        connection.setUseCaches(false);
        connection.setRequestProperty("user-agent", "JCAWebClient (" + this.m_connectData.getApplication() + ")");
        connection.setRequestProperty("Accept", "application/xml");
        if (this.m_cookies != null && !this.m_cookies.isEmpty()) {
            this.setCookies(connection, this.m_cookies);
        }
    }

    private void handleOAuth2Authentication(HttpURLConnection connection) throws BaanConnectionException {
        if (this.m_connectData.getOAuth2Callback() == null) {
            throw new BaanConnectionException("Missing OAuth2Callback", 2);
        }
        String token = this.m_connectData.getOAuth2Callback().getBearerToken();
        if (StringUtils.isEmpty(token)) {
            throw new BaanConnectionException("Missing OAuth2 token", 2);
        }
        connection.setRequestProperty("Authorization", "Bearer " + token);
    }

    private void handleBasicAuthentication(HttpURLConnection connection) throws BaanConnectionException {
        if (StringUtils.isEmpty(this.m_connectData.getUser())) {
            throw new BaanConnectionException("Missing user name", 2);
        }
        if (StringUtils.isEmpty(this.m_connectData.getPassword())) {
            throw new BaanConnectionException("Missing password", 2);
        }
        String userpassword = this.m_connectData.getUser() + ":" + this.m_connectData.getPassword();
        String base64 = DatatypeConverter.printBase64Binary((byte[])userpassword.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + base64);
    }

    private URL getUrl(Map<String, String> a_params) throws BaanConnectionException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_connectData.getBackend());
        boolean first = true;
        try {
            for (Map.Entry<String, String> entry : a_params.entrySet()) {
                if (first) {
                    builder.append("?");
                    first = false;
                } else {
                    builder.append("&");
                }
                String value = URLEncoder.encode(entry.getValue(), "UTF-8");
                builder.append(entry.getKey()).append("=").append(value);
            }
            return new URL(builder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new BaanConnectionException("Error in URL", 1, e);
        }
    }

    private HttpHandlerImpl handleConnectResponse(InputStream inputStream) throws BaanConnectionException {
        try {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "handleConnectResponse");
            ConnectResponse response = this.doUnmarshall(ConnectResponse.class, inputStream);
            String conId = response.getConid();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Protocol Version: " + response.getVersion());
                if (response.getLnuser() != null) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "LN User: " + response.getLnuser());
                }
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Timeout: " + response.getTimeout());
                if (conId != null) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "Conid: " + conId);
                }
            }
            if (response.getVersion() < 1) {
                throw new BaanConnectionException("LN UI version too old", 1);
            }
            this.m_EISMetaData = new EISMetaDataImpl(response.getLnuser(), "ERP LN", "8", 6);
            long idleTime = response.getTimeout() * 1000 / 2;
            if (idleTime > 2000L) {
                this.startIdleTimer(idleTime);
            } else {
                LOG.error(Logger.EVENT_FAILURE, "Session timeout too small: " + response.getTimeout());
            }
            HttpHandlerImpl httpHandlerImpl = new HttpHandlerImpl(this, conId);
            return httpHandlerImpl;
        }
        catch (JAXBException e) {
            throw new BaanConnectionException("XML parsing error", 7, (Exception)((Object)e));
        }
        finally {
            this.closeQuietly(inputStream);
        }
    }

    private HttpHandlerImpl handleShareResponse(InputStream inputStream) throws BaanConnectionException {
        try {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "handleShareResponse");
            ConnectResponse response = this.doUnmarshall(ConnectResponse.class, inputStream);
            String conId = response.getConid();
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Conid: " + conId);
            HttpHandlerImpl httpHandlerImpl = new HttpHandlerImpl(this, conId);
            return httpHandlerImpl;
        }
        catch (JAXBException e) {
            throw new BaanConnectionException("XML parsing error", 7, (Exception)((Object)e));
        }
        finally {
            this.closeQuietly(inputStream);
        }
    }

    private byte[] getResponseBuffer(InputStream inputStream, int length) throws IOException {
        int c;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(length > 0 ? length : 4096);
        while ((c = inputStream.read()) >= 0) {
            outputStream.write(c);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    private void handleServerError(InputStream errorStream) throws BaanConnectionException, IOException {
        try {
            try {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "handleServerError");
                ErrorResponse error = this.doUnmarshall(ErrorResponse.class, errorStream);
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "Error message: " + error.getMessage());
                    if (error.getInfo() != null) {
                        LOG.info(Logger.EVENT_UNSPECIFIED, "Error Info: " + error.getInfo());
                    }
                    if (error.getStacktrace() != null) {
                        LOG.info(Logger.EVENT_UNSPECIFIED, error.getStacktrace());
                    }
                }
                if (error.getReason() >= 0) {
                    int reason = error.getReason();
                    if (reason == 0) {
                        reason = 5;
                    }
                    throw new BaanConnectionException(error.getMessage(), reason);
                }
                throw new IOException(error.getMessage());
            }
            catch (JAXBException e) {
                throw new BaanConnectionException("XML parsing error", 7, (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(errorStream);
            throw throwable;
        }
    }

    private Map<String, String> getCookies(HttpURLConnection urlConnection) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
        ArrayList cookieList = new ArrayList();
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            if (!"Set-Cookie".equalsIgnoreCase(header.getKey())) continue;
            cookieList.addAll(header.getValue());
        }
        for (String cookieHeader : cookieList) {
            String[] parts;
            String[] fields = cookieHeader.split(";\\s*");
            if (fields == null || fields.length <= 0 || (parts = fields[0].split("=")) == null || parts.length <= 1) continue;
            cookies.put(parts[0], parts[1]);
        }
        return cookies;
    }

    private void setCookies(HttpURLConnection urlConnection, Map<String, String> cookies) {
        StringBuilder value = new StringBuilder();
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            if (value.length() > 0) {
                value.append("; ");
            }
            value.append(entry.getKey()).append("=").append(entry.getValue());
        }
        urlConnection.setRequestProperty("Cookie", value.toString());
    }

    public EISMetaData getEISMetaData() {
        return this.m_EISMetaData;
    }

    private SSLSocketFactory getSSLSocketFactory() throws BaanConnectionException {
        SSLFactoryCache factoryCache = SSLFactoryCache.getInstance();
        return factoryCache.getSSLSocketFactory(this.m_storeParameters);
    }

    private void closeQuietly(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ServerOutputStream
    extends OutputStream {
        private final OutputStream m_stream;
        private final CloseHandler m_closeHandler;

        public ServerOutputStream(OutputStream stream, CloseHandler closeHandler) {
            this.m_stream = stream;
            this.m_closeHandler = closeHandler;
        }

        @Override
        public void write(int b) throws IOException {
            this.m_stream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.m_stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.m_stream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.m_stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.m_stream.close();
            this.m_closeHandler.onClosed();
        }
    }

    private static interface CloseHandler {
        public void onClosed() throws IOException;
    }

    @XmlRootElement(name="ConnectResponse")
    public static class ConnectResponse {
        private int m_company;
        private String m_companyDesc;
        private String m_currentPack;
        private int m_firstdayofweek;
        private String m_lnuser;
        private int m_timeout;
        private String m_conid;
        private int m_version;

        public int getCompany() {
            return this.m_company;
        }

        public void setCompany(int company) {
            this.m_company = company;
        }

        public String getCompanyDesc() {
            return this.m_companyDesc;
        }

        public void setCompanyDesc(String companyDesc) {
            this.m_companyDesc = companyDesc;
        }

        public String getCurrentPack() {
            return this.m_currentPack;
        }

        public void setCurrentPack(String currentPack) {
            this.m_currentPack = currentPack;
        }

        public int getFirstdayofweek() {
            return this.m_firstdayofweek;
        }

        public void setFirstdayofweek(int firstdayofweek) {
            this.m_firstdayofweek = firstdayofweek;
        }

        public String getLnuser() {
            return this.m_lnuser;
        }

        public void setLnuser(String lnuser) {
            this.m_lnuser = lnuser;
        }

        public int getTimeout() {
            return this.m_timeout;
        }

        public void setTimeout(int timeout) {
            this.m_timeout = timeout;
        }

        public String getConid() {
            return this.m_conid;
        }

        public void setConid(String conid) {
            this.m_conid = conid;
        }

        public int getVersion() {
            return this.m_version;
        }

        public void setVersion(int version) {
            this.m_version = version;
        }
    }

    @XmlRootElement(name="error")
    public static class ErrorResponse {
        private String m_message;
        private String m_info;
        private String m_stackTrace;
        private boolean m_disconnected;
        private int m_reason;

        public String getMessage() {
            return this.m_message;
        }

        public void setMessage(String message) {
            this.m_message = message;
        }

        public String getInfo() {
            return this.m_info;
        }

        public void setInfo(String info) {
            this.m_info = info;
        }

        public String getStacktrace() {
            return this.m_stackTrace;
        }

        public void setStacktrace(String stacktrace) {
            this.m_stackTrace = stacktrace;
        }

        public boolean isDisconnected() {
            return this.m_disconnected;
        }

        public void setDisconnected(boolean disconnected) {
            this.m_disconnected = disconnected;
        }

        public int getReason() {
            return this.m_reason;
        }

        public void setReason(int reason) {
            this.m_reason = reason;
        }
    }
}

