/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsBdeManager;
import com.infor.erpln.protocol.DsCWindow;
import com.infor.erpln.protocol.DsConnector;
import com.infor.erpln.protocol.DsDummy;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.DsMessageServer;
import com.infor.erpln.protocol.DsObject;
import com.infor.erpln.protocol.ThreeGLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public final class DsProcess {
    private DsMessageServer m_messageServer = null;
    private int m_processId = 0;
    private String m_name = null;
    private boolean m_charmode = false;
    private Stack<DsCWindow> m_windows = new Stack();
    private Hashtable<Integer, DsObject> m_objectTable = new Hashtable();

    public DsProcess(DsMessageServer msgServer, int pid, String name) {
        this.m_messageServer = msgServer;
        this.m_processId = pid;
        this.m_name = name;
    }

    public void dispose() {
        while (!this.m_objectTable.isEmpty()) {
            Enumeration<DsObject> e = this.m_objectTable.elements();
            DsObject object = e.nextElement();
            this.destroyObject(object);
        }
    }

    public DsObject getObject(int oid) {
        return this.m_objectTable.get(new Integer(oid));
    }

    public int getPid() {
        return this.m_processId;
    }

    public String getName() {
        return this.m_name;
    }

    public DsMessageServer getMessageServer() {
        return this.m_messageServer;
    }

    public DsMessage handleIncomingMessage(DsMessage request) throws ThreeGLException {
        DsMessage reply = null;
        switch (request.getType()) {
            case 2: 
            case 23: {
                this.createObject(request);
                break;
            }
            case 27: {
                this.destroyObject(request);
                break;
            }
            case 9: {
                this.linkObject(request);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                reply = this.dispatchToParentObject(request);
                break;
            }
            case 25: {
                if (request.getAttribute(44) != null) {
                    reply = this.getTopWindow().getObject(request);
                    break;
                }
            }
            default: {
                reply = this.dispatchToObject(request);
            }
        }
        return reply;
    }

    private void createObject(DsMessage request) throws ThreeGLException {
        String objectName;
        int objectType;
        int oid = request.getOid();
        if (request.getType() == 2) {
            objectType = 3;
        } else {
            DsAttribute attrType = request.getAttribute(67);
            if (attrType == null) {
                throw new ThreeGLException("Unknown type for object " + oid);
            }
            objectType = attrType.getValueInt();
            request.removeAttribute(67);
        }
        DsAttribute attrName = request.getAttribute(251);
        if (attrName != null) {
            objectName = attrName.getValueString();
            request.removeAttribute(251);
        } else {
            objectName = DsObject.getTypeName(objectType);
        }
        DsObject newObject = null;
        switch (objectType) {
            case 61: {
                newObject = new DsConnector(this.m_messageServer, oid, objectName);
                ((DsConnector)newObject).setPid(request.getPid());
                break;
            }
            case 62: {
                newObject = new DsBdeManager(this.m_messageServer, oid, objectName);
                ((DsBdeManager)newObject).setPid(request.getPid());
                break;
            }
            case 3: {
                newObject = new DsCWindow(this.m_messageServer, oid, objectName, this);
                this.m_windows.push((DsCWindow)newObject);
                break;
            }
            default: {
                newObject = new DsDummy(this.m_messageServer, oid, objectName, objectType);
            }
        }
        newObject.handleIncomingMessage(request);
        this.m_objectTable.put(new Integer(oid), newObject);
    }

    private void destroyObject(DsMessage request) throws ThreeGLException {
        int oid = request.getOid();
        DsObject object = this.getObject(oid);
        if (object == null) {
            throw new ThreeGLException("Object " + oid + " not found in process " + this);
        }
        this.destroyObject(object);
    }

    private void destroyObject(DsObject object) {
        if (this.m_messageServer.objectReferenceCount(object.getOid()) <= 1) {
            object.dispose();
        }
        this.removeObject(object);
    }

    public void removeObject(DsObject object) {
        this.m_objectTable.remove(new Integer(object.getOid()));
        if (object instanceof DsCWindow) {
            this.m_windows.remove(object);
        }
    }

    private void linkObject(DsMessage request) throws ThreeGLException {
        int oid = request.getOid();
        DsAttribute attrPid = request.getAttribute(8);
        if (attrPid == null) {
            throw new ThreeGLException("Unknown process for link object of " + oid);
        }
        int fromPid = attrPid.getValueInt();
        DsProcess fromProcess = this.m_messageServer.getProcess(fromPid);
        if (fromProcess == null) {
            throw new ThreeGLException("Process " + fromPid + " does not exist");
        }
        DsObject object = fromProcess.getObject(oid);
        if (object == null) {
            throw new ThreeGLException("Object " + oid + " not found in process " + fromProcess);
        }
        this.m_objectTable.put(new Integer(oid), object);
    }

    private DsMessage dispatchToObject(DsMessage request) throws ThreeGLException {
        int oid = request.getOid();
        if (oid == 0) {
            return null;
        }
        DsObject object = this.getObject(oid);
        if (object == null) {
            throw new ThreeGLException("Object " + oid + " not found in process " + this);
        }
        return object.handleIncomingMessage(request);
    }

    private DsMessage dispatchToParentObject(DsMessage request) throws ThreeGLException {
        DsAttribute attrParent = request.getAttribute(7);
        if (attrParent == null) {
            throw new ThreeGLException("Unknown parent for subobject");
        }
        int parentOid = attrParent.getValueInt();
        request.removeAttribute(7);
        DsObject parent = this.getObject(parentOid);
        if (parent == null) {
            throw new ThreeGLException("Object " + parentOid + " not found in process " + this);
        }
        return parent.handleIncomingMessage(request);
    }

    public DsCWindow getTopWindow() {
        return this.m_windows.peek();
    }

    public String toString() {
        return this.m_name + " (pid = " + this.m_processId + ")";
    }

    public boolean isCharmode() {
        return this.m_charmode;
    }

    public void setCharmode(boolean m_charmode) {
        this.m_charmode = m_charmode;
    }
}

