/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsConnector;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.DsMessageServer;
import com.infor.erpln.protocol.DsProcess;
import com.infor.erpln.protocol.ThreeGLException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DsObject {
    protected DsMessageServer m_msgServer = null;
    protected int m_objectId = 0;
    protected String m_name = null;
    protected int m_type = 0;
    protected int m_eventMask = -1;
    protected static final int AA_CREATE = 1;
    protected static final int AA_SET = 2;
    protected static final int AA_GET = 4;
    protected static final int AA_QUERY = 8;
    public static final int DsCshellWindow = 1;
    public static final int DsCmwindow = 2;
    public static final int DsCcwindow = 3;
    public static final int DsCgwindow = 4;
    public static final int DsCpwindow = 5;
    public static final int DsCbarMenu = 6;
    public static final int DsCpopupMenu = 7;
    public static final int DsCpulldownMenu = 8;
    public static final int DsCcascadeButton = 9;
    public static final int DsCseparator = 10;
    public static final int DsCcolormap = 11;
    public static final int DsCpushButton = 12;
    public static final int DsCgpart = 13;
    public static final int DsCmenuButton = 14;
    public static final int DsClabel = 15;
    public static final int DsCrowColumn = 16;
    public static final int DsCbarButton = 17;
    public static final int DsCfield = 18;
    public static final int DsCscrollbar = 19;
    public static final int DsCframe = 20;
    public static final int DsCarrowButton = 21;
    public static final int DsCgc = 22;
    public static final int DsCacceleratorTable = 23;
    public static final int DsCscrollWindow = 24;
    public static final int DsCspeedBar = 25;
    public static final int DsCspeedBarButton = 26;
    public static final int DsCcheckBox = 27;
    public static final int DsCfont = 28;
    public static final int DsCradioBox = 29;
    public static final int DsCradioButton = 30;
    public static final int DsCpixmap = 31;
    public static final int DsClistBox = 32;
    public static final int DsCcomBox = 33;
    public static final int DsCdDComBox = 34;
    public static final int DsCdDListBox = 35;
    public static final int DsCmenuCheckBox = 36;
    public static final int DsCpasswordField = 37;
    public static final int DsCtemplate = 38;
    public static final int DsCdrawnButton = 39;
    public static final int DsCtext = 40;
    public static final int DsCslider = 41;
    public static final int DsCtoolBar = 42;
    public static final int DsCcolorCell = 43;
    public static final int DsColeClassFactory = 44;
    public static final int DsColeServer = 45;
    public static final int DsColeAutomation = 46;
    public static final int DsCtabButton = 47;
    public static final int DsCapplication = 48;
    public static final int DsCfile = 49;
    public static final int DsChelpViewer = 50;
    public static final int DsCgrid = 51;
    public static final int DsCtabFrame = 52;
    public static final int DsCstatusBar = 53;
    public static final int DsCtrackbar = 54;
    public static final int DsCgraph = 55;
    public static final int DsCclipboard = 56;
    public static final int DsCtree = 57;
    public static final int DsCurl = 58;
    public static final int DsCmessageBox = 59;
    public static final int DsCbrowseButton = 60;
    public static final int DsCconnector = 61;
    public static final int DsCbdeManager = 62;
    public static final int DsCxmaClient = 63;
    public static final int DsCdateTime = 64;
    private static final int NumObjectTypes = 64;
    private static final String[] s_ObjectNames = new String[]{"<unknown object>", "<DsCshellWindow>", "<DsCmwindow>", "<DsCcwindow>", "<DsCgwindow>", "<DsCpwindow>", "<DsCbarMenu>", "<DsCpopupMenu>", "<DsCpulldownMenu>", "<DsCcascadeButton>", "<DsCseparator>", "<DsCcolormap>", "<DsCpushButton>", "<DsCgpart>", "<DsCmenuButton>", "<DsClabel>", "<DsCrowColumn>", "<DsCbarButton>", "<DsCfield>", "<DsCscrollbar>", "<DsCframe>", "<DsCarrowButton>", "<DsCgc>", "<DsCacceleratorTable>", "<DsCscrollWindow>", "<DsCspeedBar>", "<DsCspeedBarButton>", "<DsCcheckBox>", "<DsCfont>", "<DsCradioBox>", "<DsCradioButton>", "<DsCpixmap>", "<DsClistBox>", "<DsCcomBox>", "<DsCdDComBox>", "<DsCdDListBox>", "<DsCmenuCheckBox>", "<DsCpasswordField>", "<DsCtemplate>", "<DsCdrawnButton>", "<DsCtext>", "<DsCslider>", "<DsCtoolBar>", "<DsCcolorCell>", "<DsColeClassFactory>", "<DsColeServer>", "<DsColeAutomation>", "<DsCtabButton>", "<DsCapplication>", "<DsCfile>", "<DsChelpViewer>", "<DsCgrid>", "<DsCtabFrame>", "<DsCstatusBar>", "<DsCtrackbar>", "<DsCgraph>", "<DsCclipboard>", "<DsCtree>", "<DsCurl>", "<DsCmessageBox>", "<DsCbrowseButton>", "<DsCconnector>", "<DsCbdeManager>", "<DsCxmaClient>", "<DsCdateTime>"};

    public DsObject(DsMessageServer msgServer, int oid, String name) {
        this.m_msgServer = msgServer;
        this.m_objectId = oid;
        this.m_name = name;
    }

    public void dispose() {
    }

    protected void removeObject() {
        this.m_msgServer.removeObject(this);
    }

    public static String getTypeName(int objectType) {
        if (objectType < 1 || objectType > 64) {
            StringBuffer sb = new StringBuffer();
            sb.append(objectType);
            return new String(sb);
        }
        return s_ObjectNames[objectType];
    }

    public static DsMessage getObjectClassList(DsMessage request) {
        int i;
        int count = 0;
        for (i = 0; i <= 64; ++i) {
            if (s_ObjectNames[i].startsWith("<")) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (i = 0; i <= 64; ++i) {
            if (s_ObjectNames[i].startsWith("<")) continue;
            list[count++] = i;
        }
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        DsAttribute numClasses = new DsAttribute(193);
        numClasses.setValue(count);
        reply.addAttribute(numClasses);
        DsAttribute classList = new DsAttribute(196);
        classList.setValue(list);
        reply.addAttribute(classList);
        return reply;
    }

    public static DsMessage getObjectClass(DsMessage request) throws ThreeGLException {
        int[][] attrList;
        int objectType = request.getOid();
        int[] evtList = DsMessage.getEventList();
        int[] subObjectList = new int[]{};
        switch (objectType) {
            case 61: {
                attrList = DsConnector.getAttributeList();
                break;
            }
            default: {
                throw new ThreeGLException("Object type " + objectType + " not supported");
            }
        }
        int size = attrList.length;
        int[] resList = new int[size];
        int[] accList = new int[size];
        for (int i = 0; i < size; ++i) {
            resList[i] = attrList[i][0];
            accList[i] = attrList[i][1];
        }
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        DsAttribute className = new DsAttribute(197);
        className.setValue(s_ObjectNames[objectType]);
        reply.addAttribute(className);
        DsAttribute numResources = new DsAttribute(194);
        numResources.setValue(size);
        reply.addAttribute(numResources);
        DsAttribute resourceList = new DsAttribute(199);
        resourceList.setValue(resList);
        reply.addAttribute(resourceList);
        DsAttribute resourceAccessList = new DsAttribute(198);
        resourceAccessList.setValue(accList);
        reply.addAttribute(resourceAccessList);
        DsAttribute numSubObjectClasses = new DsAttribute(195);
        numSubObjectClasses.setValue(subObjectList.length);
        reply.addAttribute(numSubObjectClasses);
        DsAttribute subObjectClassList = new DsAttribute(203);
        subObjectClassList.setValue(subObjectList);
        reply.addAttribute(subObjectClassList);
        DsAttribute numEvents = new DsAttribute(205);
        numEvents.setValue(evtList.length);
        reply.addAttribute(numEvents);
        DsAttribute eventList = new DsAttribute(206);
        eventList.setValue(evtList);
        reply.addAttribute(eventList);
        return reply;
    }

    public static DsMessage getSubObjectClass(DsMessage request) throws ThreeGLException {
        throw new ThreeGLException("Subobjects are only supported for DsCgwindow objects");
    }

    public final int getOid() {
        return this.m_objectId;
    }

    protected static Hashtable createAttributeHashTable(int[][] attributeList) {
        Hashtable<Integer, Integer> attributeTable = null;
        if (attributeList != null) {
            int size = attributeList.length;
            attributeTable = new Hashtable<Integer, Integer>(size);
            for (int i = 0; i < size; ++i) {
                attributeTable.put(new Integer(attributeList[i][0]), new Integer(attributeList[i][1]));
            }
        }
        return attributeTable;
    }

    protected abstract Hashtable getAttributeTable();

    public final void checkAttributeTable(DsMessage request, int attributeCheck) throws ThreeGLException {
        Hashtable attributes = request.getAttributes();
        Hashtable attributeTable = this.getAttributeTable();
        if (attributeTable != null) {
            Enumeration e = attributes.elements();
            while (e.hasMoreElements()) {
                DsAttribute attribute = (DsAttribute)e.nextElement();
                int attributeType = attribute.getType();
                Integer value = (Integer)attributeTable.get(new Integer(attributeType));
                if (value != null && (value & attributeCheck) != 0) continue;
                throw new ThreeGLException("attribute " + attribute + " not supported in object " + this);
            }
        }
    }

    public final DsMessage handleIncomingMessage(DsMessage request) throws ThreeGLException {
        DsMessage reply = null;
        switch (request.getType()) {
            case 2: 
            case 23: {
                this.checkAttributeTable(request, 1);
                this.initObject(request);
                this.changeObject(request);
                break;
            }
            case 14: 
            case 24: {
                this.checkAttributeTable(request, 2);
                this.changeObject(request);
                break;
            }
            case 18: 
            case 25: {
                this.checkAttributeTable(request, 4);
                reply = this.getObject(request);
                break;
            }
            case 26: {
                this.checkAttributeTable(request, 8);
                reply = this.queryObject(request);
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                break;
            }
            default: {
                throw new ThreeGLException("Unknown message type " + request.getType());
            }
        }
        return reply;
    }

    protected abstract void initObject(DsMessage var1) throws ThreeGLException;

    protected abstract int getProcessGroup();

    protected void changeObject(DsMessage request) throws ThreeGLException {
        Hashtable attributes = request.getAttributes();
        Enumeration e = attributes.elements();
        while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            int attributeType = attribute.getType();
            switch (attributeType) {
                case 128: {
                    this.m_eventMask = attribute.getValueInt();
                    break;
                }
                default: {
                    throw new ThreeGLException("Attribute " + attribute + " not implemented in object " + this);
                }
            }
            attributes.remove(new Integer(attributeType));
        }
    }

    protected DsMessage getObject(DsMessage request) {
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        Hashtable attributes = request.getAttributes();
        Enumeration e = attributes.elements();
        block5: while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            int attributeType = attribute.getType();
            switch (attributeType) {
                case 128: {
                    attribute.setValue(this.m_eventMask);
                    break;
                }
                case 67: {
                    attribute.setValue(this.m_type);
                    break;
                }
                case 7: {
                    attribute.setValue(0);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            reply.addAttribute(attribute);
        }
        return reply;
    }

    protected DsMessage queryObject(DsMessage request) throws ThreeGLException {
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        return reply;
    }

    public String toString() {
        return this.m_name + " (oid = " + this.m_objectId + ")";
    }

    protected final void sendEvent(DsMessage event, boolean flush) {
        if (event.inEventMask(this.m_eventMask)) {
            event.setOid(this.m_objectId);
            event.setPid(this.getProcessGroup());
            event.setFlush(flush);
            this.m_msgServer.sendEvent(event);
        }
    }

    public final DsObject getObject(int pid, int oid) {
        DsProcess process = this.m_msgServer.getProcess(pid);
        DsObject object = null;
        if (process != null) {
            object = process.getObject(oid);
        }
        return object;
    }
}

