/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsConfig;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.NetReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public final class DsNetReader
implements NetReader {
    public static final int DS_INTERNAL = 1;
    private static final Logger LOG = ESAPI.getLogger(DsNetReader.class);
    private DataInputStream m_is;

    public DsNetReader(DataInputStream is) {
        this.m_is = is;
    }

    @Override
    public DsMessage readMessage() throws IOException {
        DsMessage dsMes = null;
        this.readMessNumber();
        int family = this.m_is.readUnsignedShort();
        switch (family) {
            case 1: {
                int type = this.m_is.readUnsignedShort();
                int pid = this.m_is.readInt();
                int oid = this.m_is.readInt();
                int numAttrib = this.m_is.readInt();
                Hashtable<Integer, DsAttribute> attributes = new Hashtable<Integer, DsAttribute>(numAttrib + 1);
                for (int i = 0; i < numAttrib; ++i) {
                    DsAttribute dsAttribute = this.readAttribute();
                    attributes.put(new Integer(dsAttribute.getType()), dsAttribute);
                }
                dsMes = new DsMessage(family, type, pid, oid, attributes);
                break;
            }
            case 7: {
                dsMes = new DsMessage(family, 0, 0, 0, null);
                break;
            }
            default: {
                throw new IOException("Unexpected message family: " + family);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, dsMes.toString());
        }
        return dsMes;
    }

    private void readMessNumber() throws IOException {
        int mess1 = 0;
        int mess2 = 0;
        mess2 = this.m_is.readUnsignedByte();
        while (mess1 != 154 && mess2 != 234) {
            mess1 = mess2;
            mess2 = this.m_is.readUnsignedByte();
        }
    }

    private DsAttribute readAttribute() throws IOException {
        DsAttribute attr;
        int attributeType = this.m_is.readUnsignedShort();
        try {
            attr = new DsAttribute(attributeType);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Illegal attribute Id: " + attributeType);
        }
        int datatype = attr.getDataType();
        switch (datatype) {
            case 1: 
            case 2: {
                attr.setValue(this.m_is.readInt());
                break;
            }
            case 3: {
                attr.setValue(this.readString());
                break;
            }
            case 4: {
                byte[] value = this.readVoid();
                attr.setValue(value);
                if (value.length <= DsConfig.LOG_REPLY_SIZE) break;
                String logStr = attr.toString();
                LOG.error(Logger.EVENT_FAILURE, logStr);
                break;
            }
            case 5: {
                attr.setValue(this.readShortArray());
                break;
            }
            case 6: 
            case 8: {
                attr.setValue(this.readIntArray());
                break;
            }
            default: {
                throw new IOException("Illegal attribute type: " + datatype + "for attribute: " + attributeType);
            }
        }
        return attr;
    }

    private String readString() throws IOException {
        try {
            String retStr = this.m_is.readUTF();
            return retStr;
        }
        catch (UTFDataFormatException e) {
            throw new IOException("UTF-8 String format error");
        }
    }

    private byte[] readVoid() throws IOException {
        int totalRead = 0;
        int length = this.m_is.readInt();
        if (length < 0) {
            length = 0;
        }
        if (length > DsConfig.LOG_REPLY_SIZE) {
            LOG.error(Logger.EVENT_FAILURE, "Received reply from backend too large: " + length + " bytes");
        }
        byte[] buffer = new byte[length];
        while (totalRead < length) {
            int part = this.m_is.read(buffer, totalRead, length - totalRead);
            if (part < 0) {
                throw new IOException("unexpected EOF read");
            }
            totalRead += part;
        }
        return buffer;
    }

    private short[] readShortArray() throws IOException {
        int length = this.m_is.readInt();
        short[] buffer = new short[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.m_is.readShort();
        }
        return buffer;
    }

    private int[] readIntArray() throws IOException {
        int length = this.m_is.readInt();
        int[] buffer = new int[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.m_is.readInt();
        }
        return buffer;
    }
}

