/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.ThreeGLException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DsMessage
implements Cloneable {
    private int m_family;
    private int m_type;
    private int m_processId;
    private int m_objectId;
    private Hashtable m_attributes;
    private boolean m_flush;
    public static final short DS_MESSNO1 = 154;
    public static final short DS_MESSNO2 = 234;
    public static final int DS_REQUEST = 1;
    public static final int DS_INQUIRY = 2;
    public static final int DS_REPLY = 3;
    public static final int DS_EVENT = 4;
    public static final int DS_REPLY_ERROR = 5;
    public static final int DS_SIGNAL = 6;
    public static final int DS_SYNC_SIGNAL = 7;
    public static final int DS_MUL_FATAL_ERROR = 8;
    public static final int DS_DLL = 9;
    public static final int DS_EXT_EVENT = 10;
    public static final int DsNinitServer = 0;
    public static final int DsNcreateProcess = 1;
    public static final int DsNcreateCWindow = 2;
    public static final int DsNchangeProcess = 3;
    public static final int DsNchangeWindow = 4;
    public static final int DsNdestroyWindow = 5;
    public static final int DsNcreateMainWindow = 6;
    public static final int DsNdrawCPrim = 7;
    public static final int DsNdestroyProcess = 8;
    public static final int DsNlinkObject = 9;
    public static final int DsNcloseServer = 10;
    public static final int DsNsetStatusField = 11;
    public static final int DsNgetServer = 12;
    public static final int DsNprintString = 13;
    public static final int DsNchangeCWindow = 14;
    public static final int DsNprintPrimitive = 15;
    public static final int DsNchangeMainWindow = 16;
    public static final int DsNgetMainWindow = 17;
    public static final int DsNgetCWindow = 18;
    public static final int DsNchangeServer = 19;
    public static final int DsNsendMessage = 20;
    public static final int DsNgetWindow = 21;
    public static final int DsNprintAux = 22;
    public static final int DsNcreateObject = 23;
    public static final int DsNchangeObject = 24;
    public static final int DsNgetObject = 25;
    public static final int DsNqueryObject = 26;
    public static final int DsNdestroyObject = 27;
    public static final int DsNcreateSubObject = 28;
    public static final int DsNchangeSubObject = 29;
    public static final int DsNgetSubObject = 30;
    public static final int DsNquerySubObject = 31;
    public static final int DsNdestroySubObject = 32;
    public static final int DsNfieldInput = 33;
    public static final int DsNgetObjectClassList = 34;
    public static final int DsNgetObjectClass = 35;
    public static final int DsNgetSubObjectClass = 36;
    public static final int DsNgetResource = 37;
    public static final int DsNsendEvent = 38;
    public static final int DsNgetEventClass = 39;
    public static final int DsNDLLsend = 40;
    public static final int DsNDLLrecv = 41;
    private static final int NumRequestTypes = 42;
    public static final int DsNunknownEvent = 0;
    public static final int DsNbuttonPress = 1;
    public static final int DsNbuttonRelease = 2;
    public static final int DsNmotionNotify = 3;
    public static final int DsNkeyPress = 4;
    public static final int DsNmoveWindow = 5;
    public static final int DsNresizeWindow = 6;
    public static final int DsNmenuSelect = 7;
    public static final int DsNfieldSelect = 8;
    public static final int DsNscrollbarSelect = 9;
    public static final int DsNenterNotify = 10;
    public static final int DsNleaveNotify = 11;
    public static final int DsNsetFocus = 12;
    public static final int DsNoptionSelect = 13;
    public static final int DsNbuttonDPress = 14;
    public static final int DsNclientMessage = 15;
    public static final int DsNtimerEvent = 16;
    public static final int DsNbuttonSelect = 17;
    public static final int DsNbucketMessage = 18;
    public static final int DsNprocessEvent = 19;
    public static final int DsNchangeFocus = 20;
    public static final int DsNsliderSelect = 21;
    public static final int DsNcheckBoxSelect = 22;
    public static final int DsNlistBoxSelect = 23;
    public static final int DsNradioBoxSelect = 24;
    public static final int DsNarmButton = 25;
    public static final int DsNdisarmButton = 26;
    public static final int DsNoleEvent = 27;
    public static final int DsNtermination = 28;
    public static final int DsNgridEvent = 29;
    public static final int DsNDLLEvent = 30;
    public static final int DsNtabSelect = 31;
    public static final int DsNhelpEvent = 32;
    public static final int DsNtreeSelect = 33;
    private static final int NumEventTypes = 34;
    public static final int DsNmess = 0;
    public static final int DsNkillProcess = 1;
    public static final int DsNkillProcessGroup = 2;
    public static final int DsNdebugProcess = 3;
    public static final int DsNsync = 4;
    public static final int DsNabort = 5;
    public static final int DsNshell = 6;
    public static final int DsNrestart = 7;
    public static final int DsNtimerSignal = 8;
    public static final int DsNchildExit = 9;
    public static final int DsNuserSignal = 10;
    private static final int NumSignalTypes = 11;
    private static final int[] s_eventMask = new int[]{0, 1, 2, 4, 8, 0, 32, 64, 128, 256, 0, 0, 2048, 0, 8192, 0, 0, 32768, 0, 0, 4096, 0, 0, 0x100000, 0, 0, 0, 0x1000000, 0x2000000, 0x4000000, 0, 0x10000000, 0x20000000, 0x40000000};
    private static final String[] s_requestNames = new String[]{"DsNinitServer", "DsNcreateProcess", "DsNcreateCWindow", "DsNchangeProcess", "DsNchangeWindow", "DsNdestroyWindow", "DsNcreateMainWindow", "DsNdrawCPrim", "DsNdestroyProcess", "DsNlinkObject", "DsNcloseServer", "DsNsetStatusField", "DsNgetServer", "DsNprintString", "DsNchangeCWindow", "DsNprintPrimitive", "DsNchangeMainWindow", "DsNgetMainWindow", "DsNgetCWindow", "DsNchangeServer", "DsNsendMessage", "DsNgetWindow", "DsNprintAux", "DsNcreateObject", "DsNchangeObject", "DsNgetObject", "DsNqueryObject", "DsNdestroyObject", "DsNcreateSubObject", "DsNchangeSubObject", "DsNgetSubObject", "DsNquerySubObject", "DsNdestroySubObject", "DsNfieldInput", "DsNgetObjectClassList", "DsNgetObjectClass", "DsNgetSubObjectClass", "DsNgetResource", "DsNsendEvent", "DsNgetEventClass", "DsNDLLsend", "DsNDLLrecv"};
    private static final String[] s_eventNames = new String[]{"unknown event", "DsNbuttonPress", "DsNbuttonRelease", "DsNmotionNotify", "DsNkeyPress", "DsNmoveWindow", "DsNresizeWindow", "DsNmenuSelect", "DsNfieldSelect", "DsNscrollbarSelect", "DsNenterNotify", "DsNleaveNotify", "DsNsetFocus", "DsNoptionSelect", "DsNbuttonDPress", "DsNclientMessage", "DsNtimerEvent", "DsNbuttonSelect", "DsNbucketMessage", "DsNprocessEvent", "DsNchangeFocus", "DsNsliderSelect", "DsNcheckBoxSelect", "DsNlistBoxSelect", "DsNradioBoxSelect", "DsNarmButton", "DsNdisarmButton", "DsNoleEvent", "DsNtermination", "DsNgridEvent", "DsNDLLEvent", "DsNtabSelect", "DsNhelpEvent", "DsNtreeSelect"};
    private static final String[] s_signalNames = new String[]{"DsNmess", "DsNkillProcess", "DsNkillProcessGroup", "DsNdebugProcess", "DsNsync", "DsNabort", "DsNshell", "DsNrestart", "DsNtimerSignal", "DsNchildExit", "DsNuserSignal"};

    public DsMessage() {
        this.m_family = 0;
        this.m_type = 0;
        this.m_processId = 0;
        this.m_objectId = 0;
        this.m_attributes = new Hashtable();
        this.m_flush = true;
    }

    public DsMessage(int family, int type, int processId, int objectId, Hashtable attributes) {
        this.m_family = family;
        this.m_type = type;
        this.m_processId = processId;
        this.m_objectId = objectId;
        this.m_attributes = attributes != null ? attributes : new Hashtable();
        this.m_flush = true;
    }

    public static DsMessage getEventClass(DsMessage request) throws ThreeGLException {
        int eventType = request.getOid();
        if (eventType <= 0 || eventType >= 34) {
            throw new ThreeGLException("Event type " + eventType + " not supported");
        }
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        DsAttribute eventName = new DsAttribute(207);
        eventName.setValue(s_eventNames[eventType]);
        reply.addAttribute(eventName);
        DsAttribute eventMask = new DsAttribute(128);
        eventMask.setValue(s_eventMask[eventType]);
        reply.addAttribute(eventMask);
        DsAttribute eventMaskName = new DsAttribute(208);
        eventMaskName.setValue(s_eventNames[eventType] + "Mask");
        reply.addAttribute(eventMaskName);
        return reply;
    }

    public static int[] getEventList() {
        int i;
        int count = 0;
        for (i = 0; i < 34; ++i) {
            if (s_eventMask[i] == 0) continue;
            ++count;
        }
        int[] eventList = new int[count];
        count = 0;
        for (i = 0; i < 34; ++i) {
            if (s_eventMask[i] == 0) continue;
            eventList[count] = i;
            ++count;
        }
        return eventList;
    }

    public void setFamily(int family) {
        this.m_family = family;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setPid(int processId) {
        this.m_processId = processId;
    }

    public void setOid(int objectId) {
        this.m_objectId = objectId;
    }

    public void setAttributes(Hashtable attributes) {
        this.m_attributes = attributes != null ? attributes : new Hashtable();
    }

    public int getFamily() {
        return this.m_family;
    }

    public int getType() {
        return this.m_type;
    }

    public int getPid() {
        return this.m_processId;
    }

    public int getOid() {
        return this.m_objectId;
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public DsAttribute getAttribute(int attributeType) {
        return (DsAttribute)this.m_attributes.get(new Integer(attributeType));
    }

    public void addAttribute(DsAttribute Attribute) {
        this.m_attributes.put(new Integer(Attribute.getType()), Attribute);
    }

    public DsAttribute removeAttribute(int attributeType) {
        return (DsAttribute)this.m_attributes.remove(new Integer(attributeType));
    }

    public void addAttributes(DsMessage message) {
        Hashtable attributes = message.getAttributes();
        Enumeration e = attributes.elements();
        while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            this.addAttribute(attribute);
        }
    }

    public String getName() {
        String name = "?";
        switch (this.m_family) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.m_type < 0 || this.m_type >= 42) break;
                name = s_requestNames[this.m_type];
                break;
            }
            case 4: 
            case 10: {
                if (this.m_type < 0 || this.m_type >= 34) break;
                name = s_eventNames[this.m_type];
                break;
            }
            case 6: {
                if (this.m_type < 0 || this.m_type >= 11) break;
                name = s_signalNames[this.m_type];
            }
        }
        return name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.m_family) {
            case 1: {
                sb.append("Request ");
                sb.append(this.getName());
                break;
            }
            case 2: {
                sb.append("Inquiry ");
                sb.append(this.getName());
                break;
            }
            case 3: {
                sb.append("Reply ");
                sb.append(this.getName());
                break;
            }
            case 4: {
                sb.append("Event ");
                sb.append(this.getName());
                break;
            }
            case 10: {
                sb.append("Extended Event " + this.getName());
                break;
            }
            case 5: {
                sb.append("Reply Error ");
                sb.append(this.getName());
                break;
            }
            case 8: {
                sb.append("Fatal Error ");
                break;
            }
            case 6: {
                sb.append("Signal ");
                sb.append(this.getName());
                break;
            }
            case 7: {
                sb.append("Synchronization");
                break;
            }
            default: {
                sb.append("unknown message family");
            }
        }
        sb.append(" process = ").append(this.m_processId);
        sb.append("; object = ").append(this.m_objectId);
        if (this.m_attributes != null) {
            Enumeration e = this.m_attributes.elements();
            while (e.hasMoreElements()) {
                DsAttribute attribute = (DsAttribute)e.nextElement();
                sb.append("\n").append(attribute.toString());
            }
        }
        if ((this.m_family == 4 || this.m_family == 10) && this.m_flush) {
            sb.append("\n*** Flush ***");
        }
        return sb.toString();
    }

    public boolean expectReply() {
        return this.m_family == 1 && (this.m_type == 0 || this.m_type == 12 || this.m_type == 25 || this.m_type == 26 || this.m_type == 30 || this.m_type == 31 || this.m_type == 34 || this.m_type == 35 || this.m_type == 36 || this.m_type == 37 || this.m_type == 39);
    }

    public void setReply(DsMessage request) {
        this.m_family = 3;
        this.m_type = request.getType();
        this.m_processId = request.getPid();
        this.m_objectId = request.getOid();
    }

    public void setErrorReply(DsMessage request) {
        this.m_family = 5;
        this.m_type = request.getType();
        this.m_processId = request.getPid();
        this.m_objectId = request.getOid();
    }

    public void setFlush(boolean flush) {
        this.m_flush = flush;
    }

    public boolean getFlush() {
        return this.m_flush;
    }

    public void setSignal(int type, int pid, int value) {
        this.m_family = 6;
        this.m_type = type;
        this.m_processId = pid;
        this.m_objectId = value;
    }

    public void setOleEvent() {
        this.setExtEvent(27);
    }

    private void setExtEvent(int type) {
        this.m_family = 10;
        this.m_type = type;
    }

    public boolean inEventMask(int mask) {
        return (this.m_family == 4 || this.m_family == 10) && (s_eventMask[this.m_type] & mask) != 0;
    }

    public DsMessage clone() {
        try {
            DsMessage dsMsg = (DsMessage)super.clone();
            dsMsg.m_attributes = (Hashtable)this.m_attributes.clone();
            return dsMsg;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

