/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.DsObject;
import com.infor.erpln.protocol.ThreeGLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class DsAttribute {
    private int m_attributeType;
    private int m_valueInt;
    private String m_valueString;
    private byte[] m_valueByteArray;
    private short[] m_valueShortArray;
    private int[] m_valueIntArray;
    public static final int DS_INT = 1;
    public static final int DS_LONG = 2;
    public static final int DS_STRING = 3;
    public static final int DS_VOID = 4;
    public static final int DS_SARRAY = 5;
    public static final int DS_LARRAY = 6;
    public static final int DS_STRARRAY = 7;
    public static final int DS_2DLARRAY = 8;
    public static final int DS_ARGLIST = 9;
    public static final int DS_BYTE = 10;
    public static final int DS_SHORT = 11;
    public static final int DsNforeground = 1;
    public static final int DsNbackground = 2;
    public static final int DsNx = 3;
    public static final int DsNy = 4;
    public static final int DsNwidth = 5;
    public static final int DsNheight = 6;
    public static final int DsNparent = 7;
    public static final int DsNprocess = 8;
    public static final int DsNobject = 9;
    public static final int DsNinputMask = 10;
    public static final int DsNstring = 11;
    public static final int DsNcontext = 12;
    public static final int DsNmapped = 13;
    public static final int DsNname = 14;
    public static final int DsNtitle = 15;
    public static final int DsNborderWidth = 16;
    public static final int DsNrow = 17;
    public static final int DsNcolumn = 18;
    public static final int DsNrows = 19;
    public static final int DsNcolumns = 20;
    public static final int DsNacceleratorTable = 21;
    public static final int DsNmnemonic = 22;
    public static final int DsNshowAsDefault = 23;
    public static final int DsNcodeFeature = 24;
    public static final int DsNsubObject = 25;
    public static final int DsNstackingOrder = 26;
    public static final int DsNfieldNumber = 27;
    public static final int DsNproperties = 28;
    public static final int DsNfont = 29;
    public static final int DsNbackgroundMode = 30;
    public static final int DsNattribute = 31;
    public static final int DsNrefresh = 32;
    public static final int DsNdata = 33;
    public static final int DsNdataType = 34;
    public static final int DsNframeBackground = 35;
    public static final int DsNtype = 36;
    public static final int DsNchildren = 37;
    public static final int DsNmode = 38;
    public static final int DsNsize = 39;
    public static final int DsNpointArray = 40;
    public static final int DsNiconic = 41;
    public static final int DsNshortArray = 42;
    public static final int DsNgc = 43;
    public static final int DsNwindow = 44;
    public static final int DsNpart = 45;
    public static final int DsNgeometry = 46;
    public static final int DsNlongArray = 47;
    public static final int DsNgcMask = 48;
    public static final int DsNpartType = 49;
    public static final int DsNflags = 50;
    public static final int DsNdevice = 51;
    public static final int DsNreturnValue = 52;
    public static final int DsNmenu = 53;
    public static final int DsNmenuItem = 54;
    public static final int DsNprocessGroup = 55;
    public static final int DsNtimerId = 56;
    public static final int DsNinterval = 57;
    public static final int DsNcontrolType = 58;
    public static final int DsNdisplay = 59;
    public static final int DsNsubMenu = 60;
    public static final int DsNserverType = 61;
    public static final int DsNserverVersion = 62;
    public static final int DsNbarMenu = 63;
    public static final int DsNframeForeground = 64;
    public static final int DsNborderColor = 65;
    public static final int DsNfocusColor = 66;
    public static final int DsNobjectType = 67;
    public static final int DsNargList = 68;
    public static final int DsNsetState = 69;
    public static final int DsNgridX = 70;
    public static final int DsNgridY = 71;
    public static final int DsNgridWidth = 72;
    public static final int DsNgridHeight = 73;
    public static final int DsNgridStyle = 74;
    public static final int DsNgridColor = 75;
    public static final int DsNnumRows = 76;
    public static final int DsNnumColumns = 77;
    public static final int DsNshadowThickness = 78;
    public static final int DsNshadowType = 79;
    public static final int DsNvspace = 80;
    public static final int DsNhspace = 81;
    public static final int DsNfixedDimension = 82;
    public static final int DsNpacking = 83;
    public static final int DsNeditable = 84;
    public static final int DsNmaxLength = 85;
    public static final int DsNcursorPosition = 86;
    public static final int DsNitemId = 87;
    public static final int DsNitemAction = 88;
    public static final int DsNspace = 89;
    public static final int DsNitemAttr = 90;
    public static final int DsNprevItemId = 91;
    public static final int DsNretValue = 92;
    public static final int DsNshowArrows = 93;
    public static final int DsNfontSet = 94;
    public static final int DsNarrowType = 95;
    public static final int DsNset = 96;
    public static final int DsNorientation = 97;
    public static final int DsNsliderSize = 98;
    public static final int DsNsliderLength = 99;
    public static final int DsNsliderValue = 100;
    public static final int DsNmaximum = 101;
    public static final int DsNincrement = 102;
    public static final int DsNpageIncrement = 103;
    public static final int DsNminimum = 104;
    public static final int DsNmirror = 105;
    public static final int DsNjustify = 106;
    public static final int DsNminColumns = 107;
    public static final int DsNmaxColumns = 108;
    public static final int DsNminRows = 109;
    public static final int DsNmaxRows = 110;
    public static final int DsNminWidth = 111;
    public static final int DsNmaxWidth = 112;
    public static final int DsNminHeight = 113;
    public static final int DsNmaxHeight = 114;
    public static final int DsNrootX = 115;
    public static final int DsNrootY = 116;
    public static final int DsNcolorTable = 117;
    public static final int DsNcolormap = 118;
    public static final int DsNpixmap = 119;
    public static final int DsNnumColors = 120;
    public static final int DsNscrollBarPlacement = 121;
    public static final int DsNvpBorderWidth = 122;
    public static final int DsNtopItem = 123;
    public static final int DsNmaxWindowSize = 124;
    public static final int DsNnumPixels = 125;
    public static final int DsNpointerCursor = 126;
    public static final int DsNinferiorPointerCursor = 126;
    public static final int DsNpopupChild = 127;
    public static final int DsNeventMask = 128;
    public static final int DsNselectedId = 129;
    public static final int DsNtoggleBehavior = 130;
    public static final int DsNinsensitiveImage = 131;
    public static final int DsNinvertImage = 132;
    public static final int DsNchildPosX = 133;
    public static final int DsNchildPosY = 134;
    public static final int DsNeditMode = 135;
    public static final int DsNwordWrap = 136;
    public static final int DsNselectionCount = 137;
    public static final int DsNselected = 138;
    public static final int DsNselectionArray = 139;
    public static final int DsNsubObjectArray = 140;
    public static final int DsNitemCount = 141;
    public static final int DsNallowMultiSelection = 142;
    public static final int DsNgcFunction = 143;
    public static final int DsNgcForeground = 144;
    public static final int DsNgcBackground = 145;
    public static final int DsNgcFillColor = 146;
    public static final int DsNgcLineWidth = 147;
    public static final int DsNgcLineStyle = 148;
    public static final int DsNgcFillStyle = 149;
    public static final int DsNgcFontSet = 150;
    public static final int DsNgcFont = 150;
    public static final int DsNgcTextStyle = 151;
    public static final int DsNgcCapStyle = 152;
    public static final int DsNgcJoinStyle = 153;
    public static final int DsNfsTypeface = 154;
    public static final int DsNfsWeight = 155;
    public static final int DsNfsSlant = 156;
    public static final int DsNfsHeight = 157;
    public static final int DsNfsPoints = 158;
    public static final int DsNfsSpacing = 159;
    public static final int DsNfsWidth = 160;
    public static final int DsNfsBaseline = 161;
    public static final int DsNfsMaWidth = 162;
    public static final int DsNkeyboardLang = 163;
    public static final int DsNfirstSubObject = 164;
    public static final int DsNlastSubObject = 165;
    public static final int DsNnextSubObject = 166;
    public static final int DsNprevSubObject = 167;
    public static final int DsNrefSubObject = 168;
    public static final int DsNxo = 169;
    public static final int DsNyo = 170;
    public static final int DsNxn = 171;
    public static final int DsNyn = 172;
    public static final int DsNboxX = 173;
    public static final int DsNboxY = 174;
    public static final int DsNboxWidth = 175;
    public static final int DsNboxHeight = 176;
    public static final int DsNangle = 177;
    public static final int DsNrotation = 178;
    public static final int DsNstatusArray = 179;
    public static final int DsNsequence = 180;
    public static final int DsNcursorRow = 181;
    public static final int DsNcursorColumn = 182;
    public static final int DsNmarginLeft = 183;
    public static final int DsNmarginRight = 184;
    public static final int DsNmarginTop = 185;
    public static final int DsNmarginBottom = 186;
    public static final int DsNevents = 187;
    public static final int DsNoinp = 188;
    public static final int DsNoptions = 189;
    public static final int DsNminl = 190;
    public static final int DsNmaxl = 191;
    public static final int DsNmaxbytes = 192;
    public static final int DsNnumObjectClasses = 193;
    public static final int DsNnumResources = 194;
    public static final int DsNnumSubObjectClasses = 195;
    public static final int DsNobjectClassList = 196;
    public static final int DsNobjectClassName = 197;
    public static final int DsNresourceAccessList = 198;
    public static final int DsNresourceList = 199;
    public static final int DsNresourceName = 200;
    public static final int DsNresourceType = 201;
    public static final int DsNsubObjectClass = 202;
    public static final int DsNsubObjectClassList = 203;
    public static final int DsNsubObjectClassName = 204;
    public static final int DsNnumEvents = 205;
    public static final int DsNeventList = 206;
    public static final int DsNeventName = 207;
    public static final int DsNeventMaskName = 208;
    public static final int DsNclassId = 209;
    public static final int DsNprogId = 210;
    public static final int DsNmultiInstance = 211;
    public static final int DsNappName = 212;
    public static final int DsNdocName = 213;
    public static final int DsNoleNotify = 214;
    public static final int DsNnativeData = 215;
    public static final int DsNobjectList = 216;
    public static final int DsNmodified = 217;
    public static final int DsNverb = 218;
    public static final int DsNerror = 219;
    public static final int DsNdllName = 220;
    public static final int DsNfunctionCall = 221;
    public static final int DsNreturnString = 222;
    public static final int DsNformat = 223;
    public static final int DsNdialog = 224;
    public static final int DsNresizeable = 225;
    public static final int DsNmodal = 226;
    public static final int DsNinsideParent = 227;
    public static final int DsNoverlapHeight = 228;
    public static final int DsNtabSelected = 229;
    public static final int DsNclose = 230;
    public static final int DsNsuperiorPointerCursor = 231;
    public static final int DsNmenuData = 232;
    public static final int DsNcommandList = 233;
    public static final int DsNrefCommand = 234;
    public static final int DsNfunction = 235;
    public static final int DsNtemplate = 236;
    public static final int DsNimageList = 237;
    public static final int DsNstateList = 238;
    public static final int DsNcommandLine = 239;
    public static final int DsNdirectory = 240;
    public static final int DsNstdin = 241;
    public static final int DsNstdout = 242;
    public static final int DsNstderr = 243;
    public static final int DsNstatus = 244;
    public static final int DsNexitCode = 245;
    public static final int DsNfileName = 246;
    public static final int DsNcreateMode = 247;
    public static final int DsNaccessMode = 248;
    public static final int DsNreadSize = 249;
    public static final int DsNenabled = 250;
    public static final int DsNwindowName = 251;
    public static final int DsNreason = 252;
    public static final int DsNfreezeColumns = 253;
    public static final int DsNrowHeader = 254;
    public static final int DsNcolHeader = 255;
    public static final int DsNrange = 256;
    public static final int DsNcolWidth = 257;
    public static final int DsNcontrol = 258;
    public static final int DsNenum = 259;
    public static final int DsNrowHeight = 260;
    public static final int DsNmultiLine = 261;
    public static final int DsNpasswordField = 262;
    public static final int DsNzoom = 263;
    public static final int DsNfixedWidth = 264;
    public static final int DsNfixedHeight = 265;
    public static final int DsNcommandStrings = 266;
    public static final int DsNdockable = 267;
    public static final int DsNgravity = 268;
    public static final int DsNtypeList = 269;
    public static final int DsNbuttonState = 270;
    public static final int DsNbutton = 271;
    public static final int DsNstatusIndicator = 272;
    public static final int DsNstatusLength = 273;
    public static final int DsNstatusText = 274;
    public static final int DsNstatusPane = 275;
    public static final int DsNtickStyle = 276;
    public static final int DsNtickFrequency = 277;
    public static final int DsNblockMode = 278;
    public static final int DsNgridType = 279;
    public static final int DsNreturnCall = 280;
    public static final int DsNappendMode = 281;
    public static final int DsNhelpType = 282;
    public static final int DsNgridEnableSelection = 283;
    public static final int DsNtoolTip = 284;
    public static final int DsNgridSetState = 285;
    public static final int DsNstartHelpMode = 286;
    public static final int DsNminWindowSize = 287;
    public static final int DsNbinaryMode = 288;
    public static final int DsNnumSets = 289;
    public static final int DsNthisSet = 290;
    public static final int DsNnumPoints = 291;
    public static final int DsNthisPoint = 292;
    public static final int DsNgraphData = 293;
    public static final int DsNextraData = 294;
    public static final int DsNgraphType = 295;
    public static final int DsNgraphStyle = 296;
    public static final int DsNdrawMode = 297;
    public static final int DsNgridLineStyle = 298;
    public static final int DsNgraphTitle = 299;
    public static final int DsNleftTitle = 300;
    public static final int DsNleftTitleStyle = 301;
    public static final int DsNrightTitle = 302;
    public static final int DsNrightTitleStyle = 303;
    public static final int DsNbottomTitle = 304;
    public static final int DsNlabels = 305;
    public static final int DsNlabelStyle = 306;
    public static final int DsNlabelEvery = 307;
    public static final int DsNlabelText = 308;
    public static final int DsNyLabelText = 309;
    public static final int DsNzLabelText = 310;
    public static final int DsNlegendPos = 311;
    public static final int DsNlegendSize = 312;
    public static final int DsNlegendStyle = 313;
    public static final int DsNlegendText = 314;
    public static final int DsNlineStats = 315;
    public static final int DsNbackgroundStyle = 316;
    public static final int DsNbackgroundColor = 317;
    public static final int DsNbackgroundUse = 318;
    public static final int DsNforegroundColor = 319;
    public static final int DsNforegroundUse = 320;
    public static final int DsNelevation = 321;
    public static final int DsNtrue3D = 322;
    public static final int DsNperspective = 323;
    public static final int DsNgridFooter = 324;
    public static final int DsNcmdStateList = 325;
    public static final int DsNclipDataType = 326;
    public static final int DsNfieldData = 327;
    public static final int DsNstringArray = 328;
    public static final int DsNhelpButton = 329;
    public static final int DsNtreeData = 330;
    public static final int DsNoffset = 331;
    public static final int DsNconvertSoftReturn = 332;
    public static final int DsNeventReasonMask = 333;
    public static final int DsNlevelMode = 334;
    public static final int DsNvisible = 335;
    public static final int DsNpageMode = 336;
    public static final int DsNsynchronized = 337;
    public static final int DsNextendedEvents = 338;
    public static final int DsNpopupMenu = 339;
    public static final int DsNbuttons = 340;
    public static final int DsNdefaultButton = 341;
    public static final int DsNbuttonNames = 342;
    public static final int DsNcompany = 343;
    public static final int DsNtable = 344;
    public static final int DsNdragNames = 345;
    public static final int DsNdefaultFileExtension = 346;
    public static final int DsNdialogType = 347;
    public static final int DsNfileFilter = 348;
    public static final int DsNfileIndex = 349;
    public static final int DsNfileNameArray = 350;
    public static final int DsNsession = 351;
    public static final int DsNquery = 352;
    public static final int DsNaction = 353;
    public static final int DsNindexBased = 354;
    public static final int DsNfunctionCallVoid = 355;
    public static final int DsNanchor = 356;
    public static final int DsNdialogTitle = 357;
    public static final int DsNfileCount = 358;
    public static final int DsNfileFilterIndex = 359;
    public static final int DsNurlDetection = 360;
    public static final int DsNdateTimeStyle = 361;
    public static final int DsNdateTimeOptions = 362;
    public static final int DsNdateTimeFormat = 363;
    public static final int DsNtoday = 364;
    public static final int DsNenumArray = 365;
    public static final int DsNdbFieldType = 366;
    public static final int DsNdbFieldValue = 367;
    private static final int NumAttributeTypes = 367;
    private static final int[] s_attributeDataTypes = new int[]{0, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 3, 2, 1, 3, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 2, 1, 1, 6, 2, 1, 1, 1, 4, 1, 2, 1, 6, 1, 1, 8, 1, 5, 2, 2, 2, 5, 6, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 3, 2, 2, 2, 2, 1, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 6, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 6, 3, 6, 6, 3, 1, 1, 6, 3, 1, 6, 3, 3, 3, 3, 1, 3, 3, 1, 4, 6, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 6, 2, 2, 2, 6, 6, 3, 3, 3, 3, 3, 2, 2, 3, 2, 2, 2, 2, 3, 2, 2, 2, 2, 6, 6, 2, 3, 6, 2, 2, 2, 2, 2, 4, 2, 2, 6, 2, 2, 2, 6, 3, 2, 2, 2, 2, 2, 4, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 6, 6, 2, 2, 2, 2, 3, 3, 2, 3, 2, 3, 2, 2, 2, 4, 4, 4, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 4, 4, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 3, 2, 3, 3, 3, 2, 3, 2, 4, 3, 3, 2, 2, 4, 2, 3, 2, 2, 2, 2, 2, 3, 3, 4, 6, 6};
    private static final String[] s_attributeNames = new String[]{"unknown attribute", "DsNforeground", "DsNbackground", "DsNx", "DsNy", "DsNwidth", "DsNheight", "DsNparent", "DsNprocess", "DsNobject", "DsNinputMask", "DsNstring", "DsNcontext", "DsNmapped", "DsNname", "DsNtitle", "DsNborderWidth", "DsNrow", "DsNcolumn", "DsNrows", "DsNcolumns", "DsNacceleratorTable", "DsNmnemonic", "DsNshowAsDefault", "DsNcodeFeature", "DsNsubObject", "DsNstackingOrder", "DsNfieldNumber", "DsNproperties", "DsNfont", "DsNbackgroundMode", "DsNattribute", "DsNrefresh", "DsNdata", "DsNdataType", "DsNframeBackground", "DsNtype", "DsNchildren", "DsNmode", "DsNsize", "DsNpointArray", "DsNiconic", "DsNshortArray", "DsNgc", "DsNwindow", "DsNpart", "DsNgeometry", "DsNlongArray", "DsNgcMask", "DsNpartType", "DsNflags", "DsNdevice", "DsNreturnValue", "DsNmenu", "DsNmenuItem", "DsNprocessGroup", "DsNtimerId", "DsNinterval", "DsNcontrolType", "DsNdisplay", "DsNsubMenu", "DsNserverType", "DsNserverVersion", "DsNbarMenu", "DsNframeForeground", "DsNborderColor", "DsNfocusColor", "DsNobjectType", "DsNargList", "DsNsetState", "DsNgridX", "DsNgridY", "DsNgridWidth", "DsNgridHeight", "DsNgridStyle", "DsNgridColor", "DsNnumRows", "DsNnumColumns", "DsNshadowThickness", "DsNshadowType", "DsNvspace", "DsNhspace", "DsNfixedDimension", "DsNpacking", "DsNeditable", "DsNmaxLength", "DsNcursorPosition", "DsNitemId", "DsNitemAction", "DsNspace", "DsNitemAttr", "DsNprevItemId", "DsNretValue", "DsNshowArrows", "DsNfontSet", "DsNarrowType", "DsNset", "DsNorientation", "DsNsliderSize", "DsNsliderLength", "DsNsliderValue", "DsNmaximum", "DsNincrement", "DsNpageIncrement", "DsNminimum", "DsNmirror", "DsNjustify", "DsNminColumns", "DsNmaxColumns", "DsNminRows", "DsNmaxRows", "DsNminWidth", "DsNmaxWidth", "DsNminHeight", "DsNmaxHeight", "DsNrootX", "DsNrootY", "DsNcolorTable", "DsNcolormap", "DsNpixmap", "DsNnumColors", "DsNscrollBarPlacement", "DsNvpBorderWidth", "DsNtopItem", "DsNmaxWindowSize", "DsNnumPixels", "DsNinferiorPointerCursor", "DsNpopupChild", "DsNeventMask", "DsNselectedId", "DsNtoggleBehavior", "DsNinsensitiveImage", "DsNinvertImage", "DsNchildPosX", "DsNchildPosY", "DsNeditMode", "DsNwordWrap", "DsNselectionCount", "DsNselected", "DsNselectionArray", "DsNsubObjectArray", "DsNitemCount", "DsNallowMultiSelection", "DsNgcFunction", "DsNgcForeground", "DsNgcBackground", "DsNgcFillColor", "DsNgcLineWidth", "DsNgcLineStyle", "DsNgcFillStyle", "DsNgcFontSet", "DsNgcTextStyle", "DsNgcCapStyle", "DsNgcJoinStyle", "DsNfsTypeface", "DsNfsWeight", "DsNfsSlant", "DsNfsHeight", "DsNfsPoints", "DsNfsSpacing", "DsNfsWidth", "DsNfsBaseline", "DsNfsMaWidth", "DsNkeyboardLang", "DsNfirstSubObject", "DsNlastSubObject", "DsNnextSubObject", "DsNprevSubObject", "DsNrefSubObject", "DsNxo", "DsNyo", "DsNxn", "DsNyn", "DsNboxX", "DsNboxY", "DsNboxWidth", "DsNboxHeight", "DsNangle", "DsNrotation", "DsNstatusArray", "DsNsequence", "DsNcursorRow", "DsNcursorColumn", "DsNmarginLeft", "DsNmarginRight", "DsNmarginTop", "DsNmarginBottom", "DsNevents", "DsNoinp", "DsNoptions", "DsNminl", "DsNmaxl", "DsNmaxbytes", "DsNnumObjectClasses", "DsNnumResources", "DsNnumSubObjectClasses", "DsNobjectClassList", "DsNobjectClassName", "DsNresourceAccessList", "DsNresourceList", "DsNresourceName", "DsNresourceType", "DsNsubObjectClass", "DsNsubObjectClassList", "DsNsubObjectClassName", "DsNnumEvents", "DsNeventList", "DsNeventName", "DsNeventMaskName", "DsNclassId", "DsNprogId", "DsNmultiInstance", "DsNappName", "DsNdocName", "DsNoleNotify", "DsNnativeData", "DsNobjectList", "DsNmodified", "DsNverb", "DsNerror", "DsNdllName", "DsNfunctionCall", "DsNreturnString", "DsNformat", "DsNdialog", "DsNresizeable", "DsNmodal", "DsNinsideParent", "DsNoverlapHeight", "DsNtabSelected", "DsNclose", "DsNsuperiorPointerCursor", "DsNmenuData", "DsNcommandList", "DsNrefCommand", "DsNfunction", "DsNtemplate", "DsNimageList", "DsNstateList", "DsNcommandLine", "DsNdirectory", "DsNstdin", "DsNstdout", "DsNstderr", "DsNstatus", "DsNexitCode", "DsNfileName", "DsNcreateMode", "DsNaccessMode", "DsNreadSize", "DsNenabled", "DsNwindowName", "DsNreason", "DsNfreezeColumns", "DsNrowHeader", "DsNcolHeader", "DsNrange", "DsNcolWidth", "DsNcontrol", "DsNenum", "DsNrowHeight", "DsNmultiLine", "DsNpasswordField", "DsNzoom", "DsNfixedWidth", "DsNfixedHeight", "DsNcommandStrings", "DsNdockable", "DsNgravity", "DsNtypeList", "DsNbuttonState", "DsNbutton", "DsNstatusInd", "DsNstatusLength", "DsNstatusText", "DsNstatusPane", "DsNtickStyle", "DsNtickFrequency", "DsNblockMode", "DsNgridType", "DsNreturnCall", "DsNappendMode", "DsNhelpType", "DsNgridEnableSelection", "DsNtoolTip", "DsNgridSetState", "DsNstartHelpMode", "DsNminWindowSize", "DsNbinaryMode", "DsNnumSets", "DsNthisSet", "DsNnumPoints", "DsNthisPoint", "DsNgraphData", "DsNextraData", "DsNgraphType", "DsNgraphStyle", "DsNdrawMode", "DsNgridLineStyle", "DsNgraphTitle", "DsNleftTitle", "DsNleftTitleStyle", "DsNrightTitle", "DsNrightTitleStyle", "DsNbottomTitle", "DsNlabels", "DsNlabelStyle", "DsNlabelEvery", "DsNlabelText", "DsNyLabelText", "DsNzLabelText", "DsNlegendPos", "DsNlegendSize", "DsNlegendStyle", "DsNlegendText", "DsNlineStats", "DsNbackgroundStyle", "DsNbackgroundColor", "DsNbackgroundUse", "DsNforegroundColor", "DsNforegroundUse", "DsNelevation", "DsNtrue3D", "DsNperspective", "DsNgridFooter", "DsNcmdStateList", "DsNclipDataType", "DsNfieldData", "DsNstringArray", "DsNhelpButton", "DsNtreeData", "DsNoffset", "DsNconvertSoftReturn", "DsNeventReasonMask", "DsNlevelMode", "DsNvisible", "DsNpageMode", "DsNsynchronized", "DsNextendedEvents", "DsNpopupMenu", "DsNbuttons", "DsNdefaultButton", "DsNbuttonNames", "DsNcompany", "DsNtable", "DsNdragNames", "DsNdefaultFileExtension", "DsNdialogType", "DsNfileFilter", "DsNfileIndex", "DsNfileNameArray", "DsNsession", "DsNquery", "DsNaction", "DsNindexBased", "DsNfunctionCallVoid", "DsNanchor", "DsNdialogTitle", "DsNfileCount", "DsNfileFilterIndex", "DsNurlDetection", "DsNdateTimeStyle", "DsNdateTimeOptions", "DsNdateTimeFormat", "DsNtoday", "DsNenumArray", "DsNdbFieldType", "DsNdbFieldValue"};

    public DsAttribute(int attributeType) throws IllegalArgumentException {
        if (attributeType <= 0 || attributeType > 367) {
            throw new IllegalArgumentException("Invalid attributeType");
        }
        this.m_attributeType = attributeType;
        switch (s_attributeDataTypes[attributeType]) {
            case 1: 
            case 2: {
                this.m_valueInt = 0;
                break;
            }
            case 3: {
                this.m_valueString = new String("");
                break;
            }
            case 4: {
                this.m_valueByteArray = new byte[0];
                break;
            }
            case 5: {
                this.m_valueShortArray = new short[0];
                break;
            }
            case 6: 
            case 8: {
                this.m_valueIntArray = new int[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute has unsupported data type");
            }
        }
    }

    public static DsMessage getResource(DsMessage request) throws ThreeGLException {
        int attributeType = request.getOid();
        if (attributeType <= 0 || attributeType > 367) {
            throw new ThreeGLException("Attribute type " + attributeType + " does not exist");
        }
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        DsAttribute resourceName = new DsAttribute(200);
        resourceName.setValue(s_attributeNames[attributeType]);
        reply.addAttribute(resourceName);
        DsAttribute resourceType = new DsAttribute(201);
        resourceType.setValue(s_attributeDataTypes[attributeType]);
        reply.addAttribute(resourceType);
        return reply;
    }

    public int getType() {
        return this.m_attributeType;
    }

    public int getDataType() {
        return s_attributeDataTypes[this.m_attributeType];
    }

    public int getValueInt() {
        if (s_attributeDataTypes[this.m_attributeType] != 2 && s_attributeDataTypes[this.m_attributeType] != 1) {
            throw new ClassCastException();
        }
        return this.m_valueInt;
    }

    public boolean getValueBool() {
        if (s_attributeDataTypes[this.m_attributeType] != 2 && s_attributeDataTypes[this.m_attributeType] != 1) {
            throw new ClassCastException();
        }
        return this.m_valueInt != 0;
    }

    public String getValueString() throws ThreeGLException {
        String result = null;
        switch (s_attributeDataTypes[this.m_attributeType]) {
            case 3: {
                result = this.m_valueString;
                break;
            }
            case 4: {
                ByteArrayInputStream ba = new ByteArrayInputStream(this.m_valueByteArray);
                DataInputStream da = new DataInputStream(ba);
                int count = this.m_valueByteArray.length / 2;
                StringBuffer buffer = new StringBuffer(count);
                try {
                    for (int i = 0; i < count; ++i) {
                        char c = da.readChar();
                        buffer.append(c);
                    }
                }
                catch (IOException e) {
                    throw new ThreeGLException("UNICODE data string format error");
                }
                result = new String(buffer);
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        return result;
    }

    public String[] getValueStringArray(String delimiters) throws ThreeGLException {
        String[] stringArray = null;
        switch (s_attributeDataTypes[this.m_attributeType]) {
            case 4: {
                ByteArrayInputStream ba = new ByteArrayInputStream(this.m_valueByteArray);
                DataInputStream da = new DataInputStream(ba);
                try {
                    int count = da.readUnsignedShort();
                    stringArray = new String[count];
                    for (int i = 0; i < count; ++i) {
                        stringArray[i] = da.readUTF();
                    }
                    break;
                }
                catch (IOException e) {
                    throw new ThreeGLException("UTF-8 String format error");
                }
            }
            case 3: {
                String valueString = this.m_valueString;
                StringTokenizer tok = new StringTokenizer(valueString, delimiters);
                int count = tok.countTokens();
                int i = 0;
                stringArray = new String[count];
                while (tok.hasMoreTokens() && i < count) {
                    stringArray[i++] = new String(tok.nextToken());
                }
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        return stringArray;
    }

    public String[] getValueStringArray() throws ThreeGLException {
        return this.getValueStringArray("\u0000");
    }

    public byte[] getValueVoid() {
        if (s_attributeDataTypes[this.m_attributeType] != 4) {
            throw new ClassCastException();
        }
        return this.m_valueByteArray;
    }

    public short[] getValueShortArray() {
        if (s_attributeDataTypes[this.m_attributeType] != 5) {
            throw new ClassCastException();
        }
        return this.m_valueShortArray;
    }

    public int[] getValueIntArray() {
        if (s_attributeDataTypes[this.m_attributeType] != 6 && s_attributeDataTypes[this.m_attributeType] != 8) {
            throw new ClassCastException();
        }
        return this.m_valueIntArray;
    }

    public void setValue(int value) {
        if (s_attributeDataTypes[this.m_attributeType] != 2 && s_attributeDataTypes[this.m_attributeType] != 1) {
            throw new ClassCastException();
        }
        this.m_valueInt = value;
    }

    public void setValue(boolean value) {
        if (s_attributeDataTypes[this.m_attributeType] != 2 && s_attributeDataTypes[this.m_attributeType] != 1) {
            throw new ClassCastException();
        }
        this.m_valueInt = value ? 1 : 0;
    }

    public void setValue(String value) {
        switch (s_attributeDataTypes[this.m_attributeType]) {
            case 3: {
                this.m_valueString = value != null ? value : new String("");
                break;
            }
            case 4: {
                ByteArrayOutputStream valueBytes = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(valueBytes);
                try {
                    dos.writeChars(value);
                    this.m_valueByteArray = valueBytes.toByteArray();
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
    }

    public void setValue(String[] value, char delimiter) throws ThreeGLException {
        switch (s_attributeDataTypes[this.m_attributeType]) {
            case 4: {
                ByteArrayOutputStream valueBytes = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(valueBytes);
                try {
                    dos.writeShort(value.length);
                    for (int i = 0; i < value.length; ++i) {
                        dos.writeUTF(value[i]);
                    }
                    this.m_valueByteArray = valueBytes.toByteArray();
                    break;
                }
                catch (IOException e) {
                    throw new ThreeGLException("Conversion from String[] to byte[] failed");
                }
            }
            case 3: {
                int i;
                int totalLength = 0;
                for (i = 0; i < value.length; ++i) {
                    totalLength += value[i].length() + 1;
                }
                StringBuffer buffer = new StringBuffer(totalLength);
                for (i = 0; i < value.length; ++i) {
                    buffer.append(value[i]);
                    buffer.append(delimiter);
                }
                this.m_valueString = new String(buffer);
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
    }

    public void setValue(String[] value) throws ThreeGLException {
        this.setValue(value, '\u0000');
    }

    public void setValue(byte[] value) {
        if (s_attributeDataTypes[this.m_attributeType] != 4) {
            throw new ClassCastException();
        }
        this.m_valueByteArray = value != null ? value : new byte[]{};
    }

    public void setValue(short[] value) {
        if (s_attributeDataTypes[this.m_attributeType] != 5) {
            throw new ClassCastException();
        }
        this.m_valueShortArray = value != null ? value : new short[]{};
    }

    public void setValue(int[] value) {
        if (s_attributeDataTypes[this.m_attributeType] != 6 && s_attributeDataTypes[this.m_attributeType] != 8) {
            throw new ClassCastException();
        }
        this.m_valueIntArray = value != null ? value : new int[]{};
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(s_attributeNames[this.m_attributeType]);
        switch (s_attributeDataTypes[this.m_attributeType]) {
            case 2: {
                sb.append(" (int) = ");
                sb.append(this.m_valueInt);
                break;
            }
            case 1: {
                sb.append(" (int) = ");
                if (this.m_attributeType == 67) {
                    sb.append(DsObject.getTypeName(this.m_valueInt));
                    break;
                }
                sb.append(this.m_valueInt);
                break;
            }
            case 3: {
                sb.append(" (string)[");
                sb.append(this.m_valueString.length()).append("] = \"");
                sb.append(this.m_valueString).append("\"");
                break;
            }
            case 4: {
                sb.append(" (byte array)[");
                sb.append(this.m_valueByteArray.length).append("] = ");
                int size = Math.min(this.m_valueByteArray.length, 2000);
                for (int i = 0; i < size; ++i) {
                    int b = this.m_valueByteArray[i] & 0xFF;
                    if (b >= 32 && b <= 127) {
                        char c = (char)b;
                        sb.append(c);
                        continue;
                    }
                    sb.append("<").append(this.m_valueByteArray[i]).append(">");
                }
                if (this.m_valueByteArray.length <= 2000) break;
                sb.append("...");
                break;
            }
            case 5: {
                sb.append(" (short array)[");
                sb.append(this.m_valueShortArray.length).append("] = ");
                int size = Math.min(this.m_valueShortArray.length, 1000);
                for (int i = 0; i < size; ++i) {
                    sb.append("<").append(this.m_valueShortArray[i]).append(">");
                }
                if (this.m_valueShortArray.length <= 1000) break;
                sb.append("...");
                break;
            }
            case 6: 
            case 8: {
                sb.append(" (int array)[");
                sb.append(this.m_valueIntArray.length).append("] = ");
                int size = Math.min(this.m_valueIntArray.length, 1000);
                for (int i = 0; i < size; ++i) {
                    sb.append("<").append(this.m_valueIntArray[i]).append(">");
                }
                if (this.m_valueIntArray.length <= 1000) break;
                sb.append("...");
                break;
            }
            default: {
                sb.append(" (?) = <not supported>");
            }
        }
        return sb.toString();
    }
}

