/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

public class BaanCrypt {
    private static final int BPASSWD_LEN = 31;
    private static final int BCRYPT_LEN = 32;
    private static final char UPPER = '~';
    private static final char LOWER = '!';
    private static final char FILLER = '\\';
    private static final char ENCAPS_FIRST = '>';
    private static final char ENCAPS_SECOND = '<';
    private static final char ENCAPS_LAST = '}';
    private static final long[] seed_tab = new long[]{3184281573L, 1420731485L, 3960338521L, 3666109307L, 3368471375L, 894913281L, 673581949L, 218627519L, 2678779568L, 1631441257L, 1558370328L, 2243553030L, 2871290331L, 3657609436L, 1170607470L, 4293172496L, 1915027107L, 4184362953L, 4236173428L, 845998378L, 913118133L, 397059889L, 3951273589L, 2004994866L, 1321716013L, 2132309281L, 754140852L, 2903716111L, 3097296683L, 303451617L, 2825197197L, 850750687L};
    private static final int LC_A = 66049;
    private static final long LC_C = 3907864577L;
    private static long[] Fib = new long[55];
    private static int Fib_ind;
    private static long Xrnd_var;
    private static long[] auxtab;
    private static long[] prmtab;

    static String crypt(String in) {
        int i;
        StringBuffer buffer = new StringBuffer(31);
        StringBuffer cryptBuffer = new StringBuffer(32);
        int length = in.length();
        for (i = 0; i < length; ++i) {
            char in_c = in.charAt(i);
            if (in_c < '!' || in_c > '~' || i == length - 1 && in_c == '\\') {
                Integer intval = new Integer(in_c);
                buffer.append('>');
                buffer.append('<');
                buffer.append(intval.toString());
                buffer.append('}');
                continue;
            }
            buffer.append(in_c);
        }
        if (buffer.length() > 31) {
            return null;
        }
        for (i = buffer.length(); i < 31; ++i) {
            buffer.append('\\');
        }
        long seed = System.currentTimeMillis() % 91L;
        BaanCrypt.rnd_init(seed);
        cryptBuffer.append((char)(seed + 33L));
        for (i = 0; i < 31; ++i) {
            char in_c;
            int shift = BaanCrypt.rnd_ri(93);
            if (shift + (in_c = buffer.charAt(i)) > 126) {
                cryptBuffer.append((char)(33 + shift - (126 - in_c) - 1));
                continue;
            }
            cryptBuffer.append((char)(in_c + shift));
        }
        return cryptBuffer.toString();
    }

    private static void rnd_init(long seed) {
        int i;
        long u = seed < 32L ? seed_tab[(int)seed] : seed ^ seed_tab[(int)(seed & 0x1FL)];
        for (i = 54; i >= 0; --i) {
            BaanCrypt.Fib[i] = u = BaanCrypt.Xrnd(u);
        }
        for (i = 255; i >= 0; --i) {
            BaanCrypt.auxtab[i] = u = BaanCrypt.Xrnd(u);
        }
        Fib_ind = (int)(u % 55L);
        Xrnd_var = u;
    }

    private static int rnd_ri(int rng) {
        long a;
        long r;
        do {
            r = BaanCrypt.rnd_i();
            a = r / (long)rng + 1L;
        } while ((a *= (long)rng) >= 0x7FFFFFFL);
        return (int)(--a - r);
    }

    private static int rnd_i() {
        long[] t = Fib;
        int i = Fib_ind;
        long j = t[i];
        t[i] = j -= i >= 24 ? t[i - 24] : t[i + 21];
        if (++i >= 55) {
            i = 0;
        }
        Fib_ind = i;
        int k = (int)(j >> 24 & 0xFFL);
        long m = auxtab[k];
        BaanCrypt.auxtab[k] = Xrnd_var = BaanCrypt.Xrnd(Xrnd_var);
        k = (int)(j & 0x3CL);
        j = prmtab[k++] & m;
        j |= prmtab[k++] & (m << 24 | m >> 8 & 0xFFFFFFL);
        j |= prmtab[k++] & (m << 16 | m >> 16 & 0xFFFFL);
        return (int)((j |= prmtab[k] & (m << 8 | m >> 24 & 0xFFL)) & 0x7FFFFFL);
    }

    private static long Xrnd(long x) {
        long retVal = x * 66049L + 3907864577L & 0xFFFFFFFFL;
        return retVal;
    }

    static {
        auxtab = new long[256];
        prmtab = new long[]{0xFFFFFFFFL, 0L, 0L, 0L, 65535L, 0xFF0000L, 0L, 0xFF000000L, 0xFF0000FFL, 65280L, 0L, 0xFF0000L, 0xFF00FFL, 0L, 0xFF00FF00L, 0L, 0xFFFF0000L, 255L, 0L, 65280L, 0L, 0xFF00FFL, 0L, 0xFF00FF00L, 0xFF000000L, 0L, 255L, 0xFFFF00L, 0L, 0L, 0L, 0xFFFFFFFFL, 0xFF00FF00L, 0L, 0xFF00FFL, 0L, 65280L, 0L, 0xFF0000L, 0xFF0000FFL, 0L, 0L, 0xFFFFFFFFL, 0L, 0L, 65280L, 0xFFFF0000L, 255L, 0L, 0xFFFFFFFFL, 0L, 0L, 0xFFFF00L, 0xFF000000L, 0L, 255L, 0L, 0xFF000000L, 65535L, 0xFF0000L, 0L, 0xFF00FF00L, 0L, 0xFF00FFL};
    }
}

