/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.dllclient;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.sqlclient.BaanSQLQuery;
import com.infor.erpln.jca.sqlclient.BaanSQLQueryException;
import com.infor.erpln.util.DomSerializer;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.resource.ResourceException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryByDLLCall
extends BaanDLLCall {
    private Vector<Element> mDataset;
    private static final Logger LOG = ESAPI.getLogger(QueryByDLLCall.class);
    private int mFetchSize = BaanSQLQuery.getDefaultIteratorSize();

    public void setFetchSize(int fetchSize) {
        this.mFetchSize = fetchSize;
    }

    public Vector<Element> executeQueryByDLL() throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Calling 'executeQueryByDLL' on BaanDLLCall " + this.mDllName + "::" + this.mFunctionName);
        if (this.mConnection == null) {
            throw new BaanDLLCallException("No connection with backend");
        }
        this.mErrors.clear();
        boolean moreToFetch = true;
        Node receivedConstructor = null;
        this.mDataset = new Vector();
        while (moreToFetch) {
            DomSerializer serializer = null;
            try {
                ConnectionImpl connection;
                byte[] result;
                ByteArrayInputStream response;
                Document doc;
                if (receivedConstructor == null) {
                    receivedConstructor = this.createRequestElement();
                    Element createChildElement = XmlUtil.createChildElement(receivedConstructor, "cursor");
                    createChildElement.setAttribute("numRows", "" + this.mFetchSize);
                }
                Document ownerDocument = receivedConstructor.getOwnerDocument();
                Element newConstructor = ownerDocument.createElement("constructor");
                newConstructor.setAttribute("scope", "in");
                newConstructor.setAttribute("ct", "elements");
                Node cloneConstructor = receivedConstructor.cloneNode(true);
                newConstructor.appendChild(cloneConstructor);
                Element lParameters = null;
                NodeList elementsByTagName = receivedConstructor.getElementsByTagName("parameters");
                lParameters = elementsByTagName.getLength() > 0 ? (Element)elementsByTagName.item(0) : XmlUtil.createChildElement(receivedConstructor, "parameters");
                Node fc = lParameters.getFirstChild();
                if (fc == null) {
                    lParameters.appendChild(newConstructor);
                } else {
                    lParameters.insertBefore(newConstructor, fc);
                }
                if ((receivedConstructor = this.handleQueryByDLLResponse((doc = this.mDocBuilder.parse(response = new ByteArrayInputStream(result = (connection = (ConnectionImpl)this.mConnection).executeBaanDll((serializer = new DomSerializer(receivedConstructor)).getBytes(), this.mErrors)))).getDocumentElement())) != null) continue;
                moreToFetch = false;
            }
            catch (ResourceException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("ResourceException during execute", e, true);
            }
            catch (SAXException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("SAXException during execute", e, false);
            }
            catch (IOException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("IOException during execute", e, false);
            }
            finally {
                if (serializer == null) continue;
                serializer.close();
            }
        }
        return this.mDataset;
    }

    private Element handleQueryByDLLResponse(Element iResponse) throws BaanDLLCallException {
        if (iResponse.getNodeName().equals("reply")) {
            return this.handleQueryByDLLReply(iResponse);
        }
        if (iResponse.getNodeName().equals("error")) {
            throw this.handleErrorResponse(iResponse);
        }
        throw new BaanSQLQueryException("Unexpected toplevel tag: " + iResponse.getNodeName());
    }

    private Element handleQueryByDLLReply(Element iReply) throws BaanDLLCallException {
        Element receivedCursor;
        LOG.info(Logger.EVENT_UNSPECIFIED, "handle QueryByDLL Reply");
        Element eConstructor = null;
        HashMap<String, Element> refMap = new HashMap<String, Element>();
        NodeList elementsByTagName = iReply.getElementsByTagName("dataset");
        iReply = (Element)elementsByTagName.item(0);
        NodeList tupleNodes = iReply.getChildNodes();
        for (int i = 0; i < tupleNodes.getLength(); ++i) {
            Node tuple = tupleNodes.item(i);
            String nodeName = tuple.getNodeName();
            if (nodeName.equals("tuple")) {
                Node idAttr;
                Node old = tuple.getFirstChild();
                Node data = old.getFirstChild();
                Element bo = (Element)data;
                NamedNodeMap attributes = tuple.getAttributes();
                if (attributes != null && (idAttr = attributes.getNamedItem("id")) != null) {
                    String id = idAttr.getNodeValue();
                    refMap.put(id, bo);
                    continue;
                }
                this.mDataset.add(bo);
                continue;
            }
            if (nodeName.equals("constructor")) {
                eConstructor = (Element)tuple;
                continue;
            }
            if (!nodeName.equals("error")) continue;
            throw this.handleErrorResponse((Element)tuple);
        }
        if (refMap.size() > 0) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "found associated data, make this aggregated");
            for (Element bo : this.mDataset) {
                this.aggregateData(bo, refMap);
            }
        }
        if (eConstructor != null && ((receivedCursor = (Element)eConstructor.getElementsByTagName("cursor").item(0)) == null || "".equals(receivedCursor.getAttribute("position")))) {
            return null;
        }
        return eConstructor;
    }

    private void aggregateData(Node parent, HashMap<String, Element> refMap) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node hrefAttr;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            NamedNodeMap attributes = child.getAttributes();
            if (attributes != null && (hrefAttr = attributes.getNamedItem("href")) != null) {
                String href = hrefAttr.getNodeValue();
                String id = href.substring(1);
                Element association = refMap.get(id);
                if (association != null) {
                    Node newChild = association.cloneNode(true);
                    parent.replaceChild(newChild, child);
                    child = newChild;
                } else {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "Reference to undefined association with href=" + href);
                    parent.removeChild(child);
                    child = null;
                }
            }
            if (child == null) continue;
            this.aggregateData(child, refMap);
        }
    }
}

