/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.BdeReply;
import com.infor.erpln.jca.bdeclient.BdeRequest;
import com.infor.erpln.util.XmlUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Element;

public class SpecificControlAttributes {
    private static final Logger LOG = ESAPI.getLogger(SpecificControlAttributes.class);
    private static final String SCOPE_IN = "in";
    private static final String SCOPE_OUT = "out";
    private static final String SCOPE_INOUT = "inout";
    private static final String MANDATORY_TRUE = "true";
    private String[] saMethods = null;
    private String[] saAttributes = null;
    private Hashtable m_methodCA = new Hashtable();

    public SpecificControlAttributes(String sMeta) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Initialize SpecificControlAttributes with string '" + sMeta + "'");
        if (sMeta.trim().length() == 0) {
            return;
        }
        try {
            String[] sCAs = sMeta.split(":;:");
            this.saMethods = new String[sCAs.length];
            this.saAttributes = new String[sCAs.length];
            for (int i = 0; i < sCAs.length; ++i) {
                Hashtable hMethod;
                String[] sCA = sCAs[i].split(";");
                String sMethod = sCA[0];
                String sAttribute = sCA[1];
                String sScope = sCA[2];
                String sMandatory = sCA[3];
                boolean bScopeIn = false;
                boolean bScopeOut = false;
                boolean bMandatory = false;
                if (SCOPE_IN.equals(sScope)) {
                    bScopeIn = true;
                    bScopeOut = false;
                } else if (SCOPE_OUT.equals(sScope)) {
                    bScopeIn = false;
                    bScopeOut = true;
                } else if (SCOPE_INOUT.equals(sScope)) {
                    bScopeIn = true;
                    bScopeOut = true;
                }
                if (MANDATORY_TRUE.equals(sMandatory)) {
                    bMandatory = true;
                }
                if (this.m_methodCA.containsKey(sMethod)) {
                    hMethod = (Hashtable)this.m_methodCA.get(sMethod);
                } else {
                    hMethod = new Hashtable();
                    this.m_methodCA.put(sMethod, hMethod);
                }
                hMethod.put(sAttribute, new ControlAttribute(bMandatory, bScopeIn, bScopeOut));
                this.saMethods[i] = sMethod;
                this.saAttributes[i] = sAttribute;
                LOG.info(Logger.EVENT_SUCCESS, "Stored metaData for method '" + sMethod + "', attribute '" + sAttribute + "', mandatory=" + bMandatory + ", scopeIn=" + bScopeIn + ", scopeOut=" + bScopeOut);
            }
        }
        catch (Exception ex) {
            LOG.error(Logger.EVENT_FAILURE, "Error parsing metadata for controlling attributes, ignoring controlling attributes", (Throwable)ex);
            this.m_methodCA = new Hashtable();
        }
    }

    public String getControlAttribute(int iMetaIndex) throws BdeException {
        return this.getControlAttribute(this.saMethods[iMetaIndex], this.saAttributes[iMetaIndex]);
    }

    private String getControlAttribute(String sMethod, String sAttribute) throws BdeException {
        if (this.m_methodCA.containsKey(sMethod)) {
            Hashtable hMethod = (Hashtable)this.m_methodCA.get(sMethod);
            if (hMethod.containsKey(sAttribute)) {
                ControlAttribute ca = (ControlAttribute)hMethod.get(sAttribute);
                String sValue = ca.m_value;
                if (sValue == null) {
                    String sError = "Cannot get control attribute, value not set for ControlAttribute '" + sAttribute + "', method '" + sMethod + "'";
                    LOG.error(Logger.EVENT_FAILURE, sError);
                    throw new BdeException(sError);
                }
                LOG.info(Logger.EVENT_SUCCESS, "Get value for method '" + sMethod + "', attribute '" + sAttribute + ", value='" + sValue + "'");
                return sValue;
            }
            String sError = "Cannot get control attribute, invalid attribute metadata for ControlAttribute '" + sAttribute + "', method '" + sMethod + "'";
            LOG.error(Logger.EVENT_FAILURE, sError);
            throw new BdeException(sError);
        }
        String sError = "Cannot get control attribute, invalid method metadata for ControlAttribute '" + sAttribute + "', method '" + sMethod + "'";
        LOG.error(Logger.EVENT_FAILURE, sError);
        throw new BdeException(sError);
    }

    public void setAttributesForMethodInRequest(String sMethod, BdeRequest bdeRequest) throws BdeException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Set (if available) specific attributes in request for method '" + sMethod + "'");
        if (this.m_methodCA.containsKey(sMethod)) {
            Hashtable hMethod = (Hashtable)this.m_methodCA.get(sMethod);
            Enumeration _enum = hMethod.keys();
            while (_enum.hasMoreElements()) {
                String sAttribute = (String)_enum.nextElement();
                ControlAttribute ca = (ControlAttribute)hMethod.get(sAttribute);
                if (!ca.m_scope_in) continue;
                if (ca.m_value == null) {
                    if (!ca.m_mandatory) continue;
                    String sError = "Mandatory input controlling attribute/parameter '" + sAttribute + "' not set, cannot execute method '" + sMethod + "'";
                    LOG.error(Logger.EVENT_FAILURE, sError);
                    throw new BdeException(sError);
                }
                LOG.info(Logger.EVENT_SUCCESS, "Setting attribute '" + sAttribute + "' with value '" + ca.m_value + "' into request ControlArea");
                bdeRequest.setControlAreaTag(sAttribute, ca.m_value);
            }
        }
    }

    private void setControlAreaTag(Element pControlArea, String pTagName, String pValue) {
        boolean deepSearch = false;
        Element e = XmlUtil.getFirstChildElementNamed(pControlArea, pTagName, deepSearch);
        if (e != null) {
            pControlArea.removeChild(e);
        }
        XmlUtil.createChildElementWithText(pControlArea, pTagName, pValue);
    }

    private String getControlAreaTagValue(Element pControlArea, String pTagName) {
        boolean deepSearch = false;
        Element e = XmlUtil.getFirstChildElementNamed(pControlArea, pTagName, deepSearch);
        if (e != null) {
            return XmlUtil.getTextForNode(e);
        }
        return null;
    }

    public void retrieveAttributesFromReply(String sMethod, BdeReply bdeReply) throws BdeException {
        if (this.m_methodCA.containsKey(sMethod)) {
            Hashtable hMethod = (Hashtable)this.m_methodCA.get(sMethod);
            Enumeration _enum = hMethod.keys();
            while (_enum.hasMoreElements()) {
                String sAttribute = (String)_enum.nextElement();
                ControlAttribute ca = (ControlAttribute)hMethod.get(sAttribute);
                if (!ca.m_scope_out) continue;
                Element carea = bdeReply.getControlArea();
                String sValue = null;
                if (carea != null) {
                    sValue = this.getControlAreaTagValue(carea, sAttribute);
                }
                if (sValue == null) {
                    if (!ca.m_mandatory) continue;
                    String sError = "Mandatory output controlling attribute/parameter '" + sAttribute + "' not found in reply message, while executing method '" + sMethod + "'";
                    LOG.error(Logger.EVENT_FAILURE, sError);
                    throw new BdeException(sError);
                }
                LOG.info(Logger.EVENT_SUCCESS, "Storing attribute '" + sAttribute + "' with value '" + sValue + "'");
                ca.m_value = sValue;
            }
        }
    }

    public void setControlAttribute(int iMetaIndex, String sValue) throws BdeException {
        this.setControlAttribute(this.saMethods[iMetaIndex], this.saAttributes[iMetaIndex], sValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setControlAttribute(String sMethod, String sAttribute, String sValue) throws BdeException {
        if (!this.m_methodCA.containsKey(sMethod)) {
            String sError = "Cannot set control attribute, invalid method metadata for ControlAttribute '" + sAttribute + "' for method '" + sMethod + "'";
            LOG.error(Logger.EVENT_FAILURE, sError);
            throw new BdeException(sError);
        }
        Hashtable hMethod = (Hashtable)this.m_methodCA.get(sMethod);
        if (!hMethod.containsKey(sAttribute)) {
            String sError = "Cannot set control attribute, invalid attribute metadata for ControlAttribute '" + sAttribute + "' for method '" + sMethod + "'";
            LOG.error(Logger.EVENT_FAILURE, sError);
            throw new BdeException(sError);
        }
        ControlAttribute ca = (ControlAttribute)hMethod.get(sAttribute);
        if (!ca.m_scope_in) {
            String sError = "Cannot set control attribute, ControlAttribute '" + sAttribute + "' for method '" + sMethod + "', is defined as output only";
            LOG.error(Logger.EVENT_FAILURE, sError);
            throw new BdeException(sError);
        }
        LOG.info(Logger.EVENT_SUCCESS, "Set value for method '" + sMethod + "', attribute '" + sAttribute + ", value='" + sValue + "'");
        ca.m_value = sValue;
    }

    public void unSetSpecificControlAttribute(int iMetaIndex) {
        this.unSetSpecificControlAttribute(this.saMethods[iMetaIndex], this.saAttributes[iMetaIndex]);
    }

    private void unSetSpecificControlAttribute(String sMethod, String sAttribute) {
        Hashtable hMethod;
        if (this.m_methodCA.containsKey(sMethod) && (hMethod = (Hashtable)this.m_methodCA.get(sMethod)).containsKey(sAttribute)) {
            ControlAttribute ca = (ControlAttribute)hMethod.get(sAttribute);
            LOG.info(Logger.EVENT_SUCCESS, "Unset value for method '" + sMethod + "', attribute '" + sAttribute + "'");
            ca.m_value = null;
            return;
        }
    }

    public boolean hasControlAttribute(int iMetaIndex) {
        return this.hasControlAttribute(this.saMethods[iMetaIndex], this.saAttributes[iMetaIndex]);
    }

    private boolean hasControlAttribute(String sMethod, String sAttribute) {
        try {
            this.getControlAttribute(sMethod, sAttribute);
            return true;
        }
        catch (BdeException ex) {
            return false;
        }
    }

    private class ControlAttribute {
        String m_value;
        boolean m_mandatory;
        boolean m_scope_in;
        boolean m_scope_out;

        ControlAttribute(boolean mandatory, boolean in, boolean out) {
            this.m_mandatory = mandatory;
            this.m_scope_in = in;
            this.m_scope_out = out;
        }
    }
}

