/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.BDEException;
import com.infor.erpln.jca.BDERequestRecord;
import com.infor.erpln.jca.BDEResponseRecord;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.InteractionSpecBde;
import com.infor.erpln.jca.bdeclient.BdeElementIterator;
import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.BdeFilter;
import com.infor.erpln.jca.bdeclient.BdeMessageIterator;
import com.infor.erpln.jca.bdeclient.BdeReply;
import com.infor.erpln.jca.bdeclient.BdeRequest;
import com.infor.erpln.jca.bdeclient.BdeSelection;
import com.infor.erpln.jca.bdeclient.JcaBdeResultException;
import com.infor.erpln.jca.bdeclient.SpecificControlAttributes;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.Parameter;
import com.infor.erpln.util.DomSerializer;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JcaBdeManager {
    private static final Logger LOG = ESAPI.getLogger(JcaBdeManager.class);
    private Connection mConnection;
    private DocumentBuilder mDocBuilder;
    private InteractionSpecBde mInteractionSpec;
    private BDERequestRecord mBdeRequest;
    private int mIteratorFetchSize;
    private int mProcessingScope = 0;
    private Element mInformation;
    private Element mAdditionalControlAreaElement = null;
    private SpecificControlAttributes mSpecificControlAttributes = null;
    private final boolean mNamespaceAware;
    private boolean mLocalTime = false;

    public JcaBdeManager() throws BdeException {
        this(null, false);
    }

    public JcaBdeManager(Connection iConnection) throws BdeException {
        this(iConnection, false);
    }

    public JcaBdeManager(Connection iConnection, boolean bNamespaceAware) throws BdeException {
        this.mNamespaceAware = bNamespaceAware;
        this.init();
        this.mConnection = iConnection;
    }

    private void init() throws BdeException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "init()");
        try {
            this.mDocBuilder = XmlUtil.newDocumentBuilder(this.mNamespaceAware);
            this.mInteractionSpec = new InteractionSpecBde();
            this.mBdeRequest = new BDERequestRecord();
            this.mIteratorFetchSize = 250;
        }
        catch (ParserConfigurationException e) {
            LOG.error(Logger.EVENT_FAILURE, "ParserConfigurationException, " + e.getMessage(), (Throwable)e);
            throw new BdeException("ParserConfigurationException", e, false);
        }
    }

    public void attachConnection(Connection iConnection) {
        this.mConnection = iConnection;
    }

    public Connection detachConnection() {
        Connection retVal = this.mConnection;
        this.mConnection = null;
        return retVal;
    }

    public boolean isTakenFromPool() {
        if (this.mConnection instanceof ConnectionImpl) {
            return ((ConnectionImpl)this.mConnection).isTakenFromPool();
        }
        return false;
    }

    public void closeConnection() throws BdeException {
        if (this.mConnection != null) {
            try {
                this.mConnection.close();
            }
            catch (ResourceException e) {
                LOG.error(Logger.EVENT_FAILURE, "Closing connection failed, " + e.getMessage(), (Throwable)e);
                throw new BdeException("Closing connection failed", e, false);
            }
        }
    }

    public void ping() throws BdeException {
        if (this.mConnection == null || !((ConnectionImpl)this.mConnection).isRunning()) {
            LOG.error(Logger.EVENT_FAILURE, "No connection");
            throw new BdeException("No connection");
        }
    }

    public BdeFilter createBdeFilter() {
        return new BdeFilter();
    }

    public BdeSelection createBdeSelection() {
        return new BdeSelection();
    }

    public BdeElementIterator executeList(String bdeName, String bdeMethod, BdeSelection iSelection, BdeFilter iFilter) throws BdeException, JcaBdeResultException {
        return this.executeList(bdeName, bdeMethod, iSelection, iFilter, -1);
    }

    public BdeElementIterator executeList(String bdeName, String bdeMethod, Element selection, Element filter) throws BdeException, JcaBdeResultException {
        return this.executeList(bdeName, bdeMethod, selection, filter, -1);
    }

    public BdeElementIterator executeList(String bdeName, String bdeMethod, BdeSelection iSelection, BdeFilter iFilter, int maxNrObjects) throws BdeException, JcaBdeResultException {
        Element selection = null;
        Element filter = null;
        if (iSelection != null) {
            selection = iSelection.getRoot();
        }
        if (iFilter != null) {
            filter = iFilter.getRoot();
        }
        return this.executeList(bdeName, bdeMethod, selection, filter, maxNrObjects);
    }

    public BdeElementIterator executeList(String bdeName, String bdeMethod, Element selection, Element filter, int maxNrObjects) throws BdeException, JcaBdeResultException {
        BdeElementIterator iterator = new BdeElementIterator(this, maxNrObjects, this.mIteratorFetchSize, bdeName, bdeMethod, selection, filter);
        return iterator;
    }

    public BdeElementIterator executeSpecialList(String bdeName, String bdeMethod, BdeSelection selection, Element bdeElement) throws BdeException, JcaBdeResultException {
        return new BdeElementIterator(this, this.mIteratorFetchSize, selection, bdeElement, bdeName, bdeMethod);
    }

    public Element executeMethod(Element bdeElement, String methodName) throws BdeException, JcaBdeResultException {
        return this.executeShow(bdeElement, methodName, (Element)null, (Element)null);
    }

    public Element executeShow(Element bdeElement, String methodName, BdeSelection iSelection, BdeFilter iFilter) throws BdeException, JcaBdeResultException {
        Element selection = null;
        Element filter = null;
        if (iSelection != null) {
            selection = iSelection.getRoot();
        }
        if (iFilter != null) {
            filter = iFilter.getRoot();
        }
        return this.executeShow(bdeElement, methodName, selection, filter);
    }

    public Element executeShow(Element bdeElement, String methodName, Element selection, Element filter) throws BdeException, JcaBdeResultException {
        BdeRequest requestWrapper = new BdeRequest(methodName);
        requestWrapper.setBdeElement(bdeElement);
        String bdeName = bdeElement.getNodeName();
        requestWrapper.setSelection(selection);
        requestWrapper.setFilter(filter);
        BdeReply replyWrapper = this.executeBdeCall(bdeName, methodName, requestWrapper);
        return replyWrapper.getBde();
    }

    public Element executeMethod(String bdeName, String methodName, Element selection, Element filter, Element extraControlAttributes) throws BdeException, JcaBdeResultException {
        BdeRequest requestWrapper = new BdeRequest(methodName);
        requestWrapper.setSelection(selection);
        requestWrapper.setFilter(filter);
        requestWrapper.setApplicationControlData(extraControlAttributes);
        BdeReply replyWrapper = this.executeBdeCall(bdeName, methodName, requestWrapper);
        return replyWrapper.getResponse();
    }

    BdeReply executeBdeCall(String bdeName, String bdeMethod, BdeRequest requestWrapper) throws BdeException, JcaBdeResultException {
        this.mInformation = null;
        if (this.mProcessingScope != 0) {
            requestWrapper.setProcessingScope(this.mProcessingScope);
        }
        requestWrapper.setLocalTime(this.mLocalTime);
        if (this.mSpecificControlAttributes != null) {
            this.mSpecificControlAttributes.setAttributesForMethodInRequest(bdeMethod, requestWrapper);
        }
        if (this.mAdditionalControlAreaElement != null) {
            requestWrapper.setApplicationControlData(this.mAdditionalControlAreaElement);
        }
        Element request = requestWrapper.createRequestElement();
        Element result = this.doBdeCall(bdeName, bdeMethod, request);
        BdeReply replyWrapper = new BdeReply(result);
        this.mInformation = replyWrapper.getInformationArea();
        if (this.mSpecificControlAttributes != null) {
            this.mSpecificControlAttributes.retrieveAttributesFromReply(bdeMethod, replyWrapper);
        }
        return replyWrapper;
    }

    public void clearInformation() {
        this.mInformation = null;
    }

    public boolean hasInformation() {
        if (this.mInformation != null) {
            return this.mInformation.hasChildNodes();
        }
        return false;
    }

    public BdeMessageIterator getInformation() throws BdeException {
        if (this.hasInformation()) {
            return new BdeMessageIterator(this.mInformation);
        }
        LOG.error(Logger.EVENT_FAILURE, "getInformation: No information available");
        throw new BdeException("No information available");
    }

    public Element doBdeCall(String bdeName, String bdeMethod, Element request) throws BdeException, JcaBdeResultException {
        if (this.mConnection != null) {
            try (DomSerializer serializer = null;){
                serializer = new DomSerializer(request);
                Interaction inter = this.mConnection.createInteraction();
                this.mBdeRequest.setData(serializer.getBytes());
                this.mInteractionSpec.setBdeName(bdeName);
                this.mInteractionSpec.setBdeMethod(bdeMethod);
                BDEResponseRecord bdeResponse = (BDEResponseRecord)inter.execute((InteractionSpec)this.mInteractionSpec, (Record)this.mBdeRequest);
                ByteArrayInputStream response = new ByteArrayInputStream(bdeResponse.getResponse());
                Document doc = this.mDocBuilder.parse(response);
                Element element = doc.getDocumentElement();
                return element;
            }
        }
        return null;
    }

    public int getIteratorFetchSize() {
        return this.mIteratorFetchSize;
    }

    public void setIteratorFetchSize(int iteratorSize) {
        this.mIteratorFetchSize = iteratorSize;
    }

    public void setProcessingScope(int iProcessingScope) throws BdeException {
        if (0 > iProcessingScope || iProcessingScope > 3) {
            String sError = "not a valid processing scope ( 0<" + iProcessingScope + "<3 )";
            LOG.error(Logger.EVENT_FAILURE, sError);
            throw new BdeException(sError);
        }
        this.mProcessingScope = iProcessingScope;
    }

    public void setLocalTime(boolean iSet) {
        this.mLocalTime = iSet;
    }

    public void setadditionalControlAreaElement(Element iAdditionalControlAreaElement) {
        this.mAdditionalControlAreaElement = iAdditionalControlAreaElement;
    }

    public void setSpecificControlAttributeMetaData(String sControlAttributeMetaData) {
        this.mSpecificControlAttributes = new SpecificControlAttributes(sControlAttributeMetaData);
    }

    public void setSpecificControlAttribute(int iMetaDataIndex, String sValue) throws BdeException {
        this.mSpecificControlAttributes.setControlAttribute(iMetaDataIndex, sValue);
    }

    public String getSpecificControlAttribute(int iMetaDataIndex) throws BdeException {
        return this.mSpecificControlAttributes.getControlAttribute(iMetaDataIndex);
    }

    public void unSetSpecificControlAttribute(int iMetaDataIndex) {
        this.mSpecificControlAttributes.unSetSpecificControlAttribute(iMetaDataIndex);
    }

    public boolean hasSpecificControlAttribute(int iMetaDataIndex) {
        return this.mSpecificControlAttributes.hasControlAttribute(iMetaDataIndex);
    }

    private JcaBdeResultException CreateBdeResultException(BDEException iException) throws BdeException {
        JcaBdeResultException retException;
        ByteArrayInputStream response = new ByteArrayInputStream(iException.getResult());
        try {
            Document doc = this.mDocBuilder.parse(response);
            retException = new JcaBdeResultException(doc.getDocumentElement());
        }
        catch (SAXException e) {
            LOG.error(Logger.EVENT_FAILURE, "Parsing error when creating BdeResultException, " + e.getMessage(), (Throwable)e);
            throw new BdeException("Parsing error when creating BdeResultException", e, false);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "IO error when creating BdeResultException, " + e.getMessage(), (Throwable)e);
            throw new BdeException("IO error when creating BdeResultException", e, false);
        }
        return retException;
    }

    public Parameter createParameter(String iName, String iScope) {
        return new Parameter(iName, iScope);
    }

    public BaanDLLCall createDLLCall() {
        return new BaanDLLCall(this.mConnection, this.mDocBuilder);
    }

    public BaanDLLCall createDLLCall(String iDllName, String iFunction, String iReturnType, Parameter[] iParameters) {
        BaanDLLCall call = new BaanDLLCall(this.mConnection, this.mDocBuilder);
        call.setDLL(iDllName);
        call.setFunction(iFunction);
        call.setReturnType(iReturnType);
        call.setParameters(iParameters);
        return call;
    }

    public InputStream openForRead(String iServerFile, boolean iTextMode) throws IOException, BdeException {
        return this.openForRead(iServerFile, iTextMode, false);
    }

    public InputStream openForRead(String iServerFile, boolean iTextMode, boolean iPolling) throws IOException, BdeException {
        ConnectionImpl conn = (ConnectionImpl)this.mConnection;
        try {
            return conn.openForRead(iServerFile, iTextMode, iPolling);
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "openForRead failed: " + e.getMessage(), (Throwable)e);
            throw new BdeException("openForRead failed", e, false);
        }
    }

    public OutputStream openForWrite(String iServerFile, boolean iTextMode) throws IOException, BdeException {
        ConnectionImpl conn = (ConnectionImpl)this.mConnection;
        try {
            return conn.openForWrite(iServerFile, iTextMode);
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "openForWrite failed: " + e.getMessage(), (Throwable)e);
            throw new BdeException("openForWrite failed", e, false);
        }
    }
}

